/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ByteArrayDataInput;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.RemoteOperationMessage;
import org.apache.geode.internal.cache.RemoteOperationMessageWithDirectReply;
import org.apache.geode.internal.cache.partitioned.RemoveAllPRMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public final class RemoteRemoveAllMessage
extends RemoteOperationMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData;
    private int removeAllDataCount = 0;
    ClientProxyMembershipID bridgeContext;
    private transient InternalDistributedSystem internalDs;
    private boolean posDup;
    protected static final short HAS_BRIDGE_CONTEXT = 64;
    private EventID eventId;
    private Object callbackArg;

    public void addEntry(DistributedRemoveAllOperation.RemoveAllEntryData entry) {
        this.removeAllData[this.removeAllDataCount++] = entry;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public int getSize() {
        return this.removeAllDataCount;
    }

    public static boolean distribute(EntryEventImpl event, DistributedRemoveAllOperation.RemoveAllEntryData[] data, int dataCount) {
        boolean successful = false;
        DistributedRegion r = (DistributedRegion)event.getRegion();
        Collection<InternalDistributedMember> replicates = r.getCacheDistributionAdvisor().adviseInitializedReplicates();
        if (replicates.isEmpty()) {
            return false;
        }
        if (replicates.size() > 1) {
            ArrayList<InternalDistributedMember> l = new ArrayList<InternalDistributedMember>(replicates);
            Collections.shuffle(l);
            replicates = l;
        }
        int attempts = 0;
        for (InternalDistributedMember replicate : replicates) {
            try {
                boolean posDup = ++attempts > 1;
                RemoveAllResponse response = RemoteRemoveAllMessage.send(replicate, event, data, dataCount, false, 74, posDup);
                response.waitForCacheException();
                VersionedObjectList result = response.getResponse();
                List successfulKeys = result.getKeys();
                List<VersionTag> versions = result.getVersionTags();
                for (DistributedRemoveAllOperation.RemoveAllEntryData removeAllEntry : data) {
                    Object key = removeAllEntry.getKey();
                    if (!successfulKeys.contains(key)) continue;
                    int index = successfulKeys.indexOf(key);
                    removeAllEntry.versionTag = versions.get(index);
                }
                return true;
            }
            catch (TransactionDataNotColocatedException enfe) {
                throw enfe;
            }
            catch (CancelException e) {
                event.getRegion().getCancelCriterion().checkCancelInProgress(e);
            }
            catch (CacheException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RemoteRemoveAllMessage caught CacheException during distribution", (Throwable)e);
                }
                successful = true;
            }
            catch (RemoteOperationException e) {
                if (!logger.isTraceEnabled(LogMarker.DM)) continue;
                logger.trace(LogMarker.DM, "RemoteRemoveAllMessage caught an unexpected exception during distribution", (Throwable)e);
            }
        }
        return successful;
    }

    RemoteRemoveAllMessage(EntryEventImpl event, Set recipients, DirectReplyProcessor p, DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData, int removeAllDataCount, boolean useOriginRemote, int processorType, boolean possibleDuplicate) {
        super(recipients, event.getRegion().getFullPath(), p);
        this.resetRecipients();
        if (recipients != null) {
            this.setRecipients(recipients);
        }
        this.processor = p;
        int n = this.processorId = p == null ? 0 : p.getProcessorId();
        if (p != null && this.isSevereAlertCompatible()) {
            p.enableSevereAlertProcessing();
        }
        this.removeAllData = removeAllData;
        this.removeAllDataCount = removeAllDataCount;
        this.posDup = possibleDuplicate;
        this.eventId = event.getEventId();
        this.callbackArg = event.getCallbackArgument();
    }

    public RemoteRemoveAllMessage() {
    }

    public static RemoveAllResponse send(DistributedMember recipient, EntryEventImpl event, DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData, int removeAllDataCount, boolean useOriginRemote, int processorType, boolean possibleDuplicate) throws RemoteOperationException {
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        RemoveAllResponse p = new RemoveAllResponse(event.getRegion().getSystem(), recipients);
        RemoteRemoveAllMessage msg = new RemoteRemoveAllMessage(event, recipients, p, removeAllData, removeAllDataCount, useOriginRemote, processorType, possibleDuplicate);
        msg.setTransactionDistributed(event.getRegion().getCache().getTxManager().isDistributed());
        Set failures = event.getRegion().getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            throw new RemoteOperationException(LocalizedStrings.RemotePutMessage_FAILED_SENDING_0.toLocalizedString(msg));
        }
        return p;
    }

    public void setBridgeContext(ClientProxyMembershipID contx) {
        Assert.assertTrue(contx != null);
        this.bridgeContext = contx;
    }

    @Override
    public int getDSFID() {
        return -6;
    }

    @Override
    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.eventId = (EventID)DataSerializer.readObject(in);
        this.callbackArg = DataSerializer.readObject(in);
        boolean bl = this.posDup = (this.flags & 8) != 0;
        if ((this.flags & 0x40) != 0) {
            this.bridgeContext = (ClientProxyMembershipID)DataSerializer.readObject(in);
        }
        this.removeAllDataCount = (int)InternalDataSerializer.readUnsignedVL(in);
        this.removeAllData = new DistributedRemoveAllOperation.RemoveAllEntryData[this.removeAllDataCount];
        if (this.removeAllDataCount > 0) {
            Version version = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            ByteArrayDataInput bytesIn = new ByteArrayDataInput();
            for (int i = 0; i < this.removeAllDataCount; ++i) {
                this.removeAllData[i] = new DistributedRemoveAllOperation.RemoveAllEntryData(in, this.eventId, i, version, bytesIn);
            }
            boolean hasTags = in.readBoolean();
            if (hasTags) {
                DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
                for (int i = 0; i < this.removeAllDataCount; ++i) {
                    this.removeAllData[i].versionTag = (VersionTag)versionTags.get(i);
                }
            }
        }
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.eventId, out);
        DataSerializer.writeObject(this.callbackArg, out);
        if (this.bridgeContext != null) {
            DataSerializer.writeObject(this.bridgeContext, out);
        }
        InternalDataSerializer.writeUnsignedVL(this.removeAllDataCount, out);
        if (this.removeAllDataCount > 0) {
            DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.removeAllDataCount);
            boolean hasTags = false;
            for (int i = 0; i < this.removeAllDataCount; ++i) {
                if (!hasTags && this.removeAllData[i].versionTag != null) {
                    hasTags = true;
                }
                VersionTag tag = this.removeAllData[i].versionTag;
                versionTags.add(tag);
                this.removeAllData[i].versionTag = null;
                this.removeAllData[i].toData(out);
                this.removeAllData[i].versionTag = tag;
            }
            out.writeBoolean(hasTags);
            if (hasTags) {
                InternalDataSerializer.invokeToData(versionTags, out);
            }
        }
    }

    @Override
    protected short computeCompressedShort() {
        short flags = super.computeCompressedShort();
        if (this.posDup) {
            flags = (short)(flags | 8);
        }
        if (this.bridgeContext != null) {
            flags = (short)(flags | 0x40);
        }
        return flags;
    }

    @Override
    public EventID getEventID() {
        return this.eventId;
    }

    @Override
    protected boolean operateOnRegion(DistributionManager dm, LocalRegion r, long startTime) throws RemoteOperationException {
        boolean sendReply;
        InternalDistributedMember eventSender = this.getSender();
        try {
            sendReply = this.doLocalRemoveAll(r, eventSender);
        }
        catch (RemoteOperationException e) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(e), r, startTime);
            return false;
        }
        if (sendReply) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, null, r, startTime);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doLocalRemoveAll(final LocalRegion r, final InternalDistributedMember eventSender) throws EntryExistsException, RemoteOperationException {
        final DistributedRegion dr = (DistributedRegion)r;
        EntryEventImpl baseEvent = EntryEventImpl.create(r, Operation.REMOVEALL_DESTROY, null, null, this.callbackArg, false, eventSender, true);
        try {
            baseEvent.setCausedByMessage(this);
            baseEvent.setEventId(this.eventId);
            if (this.bridgeContext != null) {
                baseEvent.setContext(this.bridgeContext);
            }
            baseEvent.setPossibleDuplicate(this.posDup);
            if (logger.isDebugEnabled()) {
                logger.debug("RemoteRemoveAllMessage.doLocalRemoveAll: eventSender is {}, baseEvent is {}, msg is {}", (Object)eventSender, (Object)baseEvent, (Object)this);
            }
            final DistributedRemoveAllOperation op = new DistributedRemoveAllOperation(baseEvent, this.removeAllDataCount, false);
            try {
                final VersionedObjectList versions = new VersionedObjectList(this.removeAllDataCount, true, dr.concurrencyChecksEnabled);
                dr.syncBulkOp(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        InternalDistributedMember myId = r.getDistributionManager().getDistributionManagerId();
                        for (int i = 0; i < RemoteRemoveAllMessage.this.removeAllDataCount; ++i) {
                            EntryEventImpl ev = RemoveAllPRMessage.getEventFromEntry(r, myId, eventSender, i, RemoteRemoveAllMessage.this.removeAllData, false, RemoteRemoveAllMessage.this.bridgeContext, RemoteRemoveAllMessage.this.posDup, false);
                            try {
                                ev.setRemoveAllOperation(op);
                                if (logger.isDebugEnabled()) {
                                    logger.debug("invoking basicDestroy with {}", (Object)ev);
                                }
                                try {
                                    dr.basicDestroy(ev, true, null);
                                }
                                catch (EntryNotFoundException entryNotFoundException) {
                                    // empty catch block
                                }
                                ((RemoteRemoveAllMessage)RemoteRemoveAllMessage.this).removeAllData[i].versionTag = ev.getVersionTag();
                                versions.addKeyAndVersion(((RemoteRemoveAllMessage)RemoteRemoveAllMessage.this).removeAllData[i].key, ev.getVersionTag());
                                continue;
                            }
                            finally {
                                ev.release();
                            }
                        }
                    }
                }, baseEvent.getEventId());
                if (this.getTXUniqId() != -1 || dr.getConcurrencyChecksEnabled()) {
                    dr.getDataView().postRemoveAll(op, versions, dr);
                }
                RemoveAllReplyMessage.send(this.getSender(), this.processorId, this.getReplySender(r.getDistributionManager()), versions, this.removeAllData, this.removeAllDataCount);
                boolean bl = false;
                op.freeOffHeapResources();
                return bl;
            }
            catch (Throwable throwable) {
                op.freeOffHeapResources();
                throw throwable;
            }
        }
        finally {
            baseEvent.release();
        }
    }

    RemoteOperationMessage.RemoteOperationResponse createReplyProcessor(LocalRegion r, Set recipients, Object key) {
        return new RemoveAllResponse(r.getSystem(), recipients);
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, LocalRegion r, long startTime) {
        ReplyMessage.send(member, procId, ex, this.getReplySender(dm), r != null && r.isInternalRegion());
    }

    @Override
    protected final void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; removeAllDataCount=").append(this.removeAllDataCount);
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        for (int i = 0; i < this.removeAllDataCount; ++i) {
            buff.append("; entry" + i + ":").append(this.removeAllData[i] == null ? "null" : this.removeAllData[i].getKey());
        }
    }

    public static class RemoveAllResponse
    extends RemoteOperationMessage.RemoteOperationResponse {
        private VersionedObjectList versions;

        public RemoveAllResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients, false);
        }

        public void setResponse(RemoveAllReplyMessage removeAllReplyMessage) {
            if (removeAllReplyMessage.versions != null) {
                this.versions = removeAllReplyMessage.versions;
                this.versions.replaceNullIDs(removeAllReplyMessage.getSender());
            }
        }

        public VersionedObjectList getResponse() {
            return this.versions;
        }
    }

    public static final class RemoveAllReplyMessage
    extends ReplyMessage {
        private VersionedObjectList versions;

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        private RemoveAllReplyMessage(int processorId, VersionedObjectList versionList, DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData, int removeAllCount) {
            this.versions = versionList;
            this.setProcessorId(processorId);
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender dm, VersionedObjectList versions, DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData, int removeAllDataCount) {
            Assert.assertTrue(recipient != null, "RemoveAllReplyMessage NULL reply message");
            RemoveAllReplyMessage m = new RemoveAllReplyMessage(processorId, versions, removeAllData, removeAllDataCount);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.debug("RemoveAllReplyMessage processor not found");
                }
                return;
            }
            if (rp instanceof RemoveAllResponse) {
                RemoveAllResponse processor = (RemoveAllResponse)rp;
                processor.setResponse(this);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} Processed {}", (Object)rp, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -5;
        }

        public RemoveAllReplyMessage() {
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.versions = (VersionedObjectList)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.versions, out);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("RemoveAllReplyMessage ").append(" processorid=").append(this.processorId).append(" returning versionTags=").append(this.versions);
            return sb.toString();
        }
    }
}

