/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.RemotePutMessage;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TransactionMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class RemoteOperationMessage
extends DistributionMessage
implements MessageWithReply,
TransactionMessage {
    private static final Logger logger = LogService.getLogger();
    static final ForceReattemptException UNHANDLED_EXCEPTION = (ForceReattemptException)new ForceReattemptException(LocalizedStrings.PartitionMessage_UNKNOWN_EXCEPTION.toLocalizedString()).fillInStackTrace();
    protected int processorId;
    protected int processorType;
    protected String regionPath;
    private int txUniqId = -1;
    private InternalDistributedMember txMemberId = null;
    protected transient short flags;
    protected boolean isTransactionDistributed = false;
    private static final String PN_TOKEN = ".cache.";

    public RemoteOperationMessage() {
    }

    public RemoteOperationMessage(InternalDistributedMember recipient, String regionPath, ReplyProcessor21 processor) {
        Assert.assertTrue(recipient != null, "RemoteMesssage recipient can not be null");
        this.setRecipient(recipient);
        this.regionPath = regionPath;
        int n = this.processorId = processor == null ? 0 : processor.getProcessorId();
        if (processor != null && this.isSevereAlertCompatible()) {
            processor.enableSevereAlertProcessing();
        }
        this.txUniqId = TXManagerImpl.getCurrentTXUniqueId();
        TXStateProxy txState = TXManagerImpl.getCurrentTXState();
        if (txState != null && txState.isMemberIdForwardingRequired()) {
            this.txMemberId = txState.getOriginatingMember();
        }
        this.setIfTransactionDistributed();
    }

    public RemoteOperationMessage(Set recipients, String regionPath, ReplyProcessor21 processor) {
        this.setRecipients(recipients);
        this.regionPath = regionPath;
        int n = this.processorId = processor == null ? 0 : processor.getProcessorId();
        if (processor != null && this.isSevereAlertCompatible()) {
            processor.enableSevereAlertProcessing();
        }
        this.txUniqId = TXManagerImpl.getCurrentTXUniqueId();
        TXStateProxy txState = TXManagerImpl.getCurrentTXState();
        if (txState != null && txState.isMemberIdForwardingRequired()) {
            this.txMemberId = txState.getOriginatingMember();
        }
        this.setIfTransactionDistributed();
    }

    public RemoteOperationMessage(RemoteOperationMessage other) {
        this.regionPath = other.regionPath;
        this.processorId = other.processorId;
        this.txUniqId = other.getTXUniqId();
        this.txMemberId = other.getTXMemberId();
        this.isTransactionDistributed = other.isTransactionDistributed;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    public int getProcessorType() {
        return 78;
    }

    public final String getRegionPath() {
        return this.regionPath;
    }

    @Override
    public final int getProcessorId() {
        return this.processorId;
    }

    public final void registerProcessor(int processorId1) {
        this.processorId = processorId1;
    }

    public void setCacheOpRecipients(Collection cacheOpRecipients) {
        assert (this instanceof RemotePutMessage);
    }

    public boolean checkCacheClosing(DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        return cache == null || cache.isClosed();
    }

    public boolean checkDSClosing(DistributionManager dm) {
        InternalDistributedSystem ds = dm.getSystem();
        return ds == null || ds.isDisconnecting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DistributionManager dm) {
        Throwable thr = null;
        boolean sendReply = true;
        LocalRegion r = null;
        long startTime = 0L;
        try {
            if (this.checkCacheClosing(dm) || this.checkDSClosing(dm)) {
                thr = new CacheClosedException(LocalizedStrings.PartitionMessage_REMOTE_CACHE_IS_CLOSED_0.toLocalizedString(dm.getId()));
                return;
            }
            GemFireCacheImpl gfc = this.getCache(dm);
            r = this.getRegionByPath(gfc);
            if (r == null && this.failIfRegionMissing()) {
                thr = new RegionDestroyedException(LocalizedStrings.RemoteOperationMessage_0_COULD_NOT_FIND_REGION_1.toLocalizedString(dm.getDistributionManagerId(), this.regionPath), this.regionPath);
                return;
            }
            thr = UNHANDLED_EXCEPTION;
            TXManagerImpl txMgr = this.getTXManager(gfc);
            TXStateProxy tx = txMgr.masqueradeAs(this);
            if (tx == null) {
                sendReply = this.operateOnRegion(dm, r, startTime);
            } else {
                try {
                    if (txMgr.isClosed()) {
                        sendReply = false;
                    } else if (tx.isInProgress()) {
                        sendReply = this.operateOnRegion(dm, r, startTime);
                        tx.updateProxyServer(this.getSender());
                    }
                }
                finally {
                    txMgr.unmasquerade(tx);
                }
            }
            thr = null;
        }
        catch (RemoteOperationException fre) {
            thr = fre;
        }
        catch (DistributedSystemDisconnectedException se) {
            thr = null;
            sendReply = false;
            if (logger.isDebugEnabled()) {
                logger.debug("shutdown caught, abandoning message: {}", (Object)se.getMessage(), (Object)se);
            }
        }
        catch (RegionDestroyedException rde) {
            thr = new ForceReattemptException(LocalizedStrings.PartitionMessage_REGION_IS_DESTROYED_IN_0.toLocalizedString(dm.getDistributionManagerId()), rde);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            thr = null;
            if (sendReply) {
                thr = !this.checkDSClosing(dm) ? t : new ForceReattemptException(LocalizedStrings.PartitionMessage_DISTRIBUTED_SYSTEM_IS_DISCONNECTING.toLocalizedString());
            }
            if (logger.isTraceEnabled(LogMarker.DM) && t instanceof RuntimeException) {
                logger.trace(LogMarker.DM, "Exception caught while processing message", t);
            }
        }
        finally {
            if (sendReply) {
                ReplyException rex = null;
                if (thr != null) {
                    rex = new ReplyException(thr);
                }
                this.sendReply(this.getSender(), this.processorId, dm, rex, r, startTime);
            }
        }
    }

    TXManagerImpl getTXManager(GemFireCacheImpl cache) {
        return cache.getTxManager();
    }

    LocalRegion getRegionByPath(GemFireCacheImpl gfc) {
        return gfc.getRegionByPathForProcessing(this.regionPath);
    }

    GemFireCacheImpl getCache(DistributionManager dm) {
        return (GemFireCacheImpl)CacheFactory.getInstance(dm.getSystem());
    }

    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, LocalRegion pr, long startTime) {
        ReplyMessage.send(member, procId, ex, this.getReplySender(dm), pr != null && pr.isInternalRegion());
    }

    protected boolean failIfRegionMissing() {
        return true;
    }

    RemoteOperationResponse createReplyProcessor(PartitionedRegion r, Set recipients) {
        return new RemoteOperationResponse(r.getSystem(), (Collection)recipients);
    }

    protected abstract boolean operateOnRegion(DistributionManager var1, LocalRegion var2, long var3) throws RemoteOperationException;

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.flags = in.readShort();
        this.setFlags(this.flags, in);
        this.regionPath = DataSerializer.readString(in);
        this.isTransactionDistributed = in.readBoolean();
    }

    @Override
    public InternalDistributedMember getTXOriginatorClient() {
        return this.txMemberId;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        short flags = this.computeCompressedShort();
        out.writeShort(flags);
        if (this.processorId != 0) {
            out.writeInt(this.processorId);
        }
        if (this.processorType != 0) {
            out.writeByte(this.processorType);
        }
        if (this.getTXUniqId() != -1) {
            out.writeInt(this.getTXUniqId());
        }
        if (this.getTXMemberId() != null) {
            DataSerializer.writeObject(this.getTXMemberId(), out);
        }
        DataSerializer.writeString(this.regionPath, out);
        out.writeBoolean(this.isTransactionDistributed);
    }

    protected short computeCompressedShort() {
        short flags = 0;
        if (this.processorId != 0) {
            flags = (short)(flags | 1);
        }
        if (this.processorType != 0) {
            flags = (short)(flags | 0x20);
        }
        if (this.getTXUniqId() != -1) {
            flags = (short)(flags | 4);
        }
        if (this.getTXMemberId() != null) {
            flags = (short)(flags | 2);
        }
        return flags;
    }

    protected void setFlags(short flags, DataInput in) throws IOException, ClassNotFoundException {
        if ((flags & 1) != 0) {
            this.processorId = in.readInt();
            ReplyProcessor21.setMessageRPId(this.processorId);
        }
        if ((flags & 0x20) != 0) {
            this.processorType = in.readByte();
        }
        if ((flags & 4) != 0) {
            this.txUniqId = in.readInt();
        }
        if ((flags & 2) != 0) {
            this.txMemberId = (InternalDistributedMember)DataSerializer.readObject(in);
        }
    }

    protected final InternalDistributedMember getTXMemberId() {
        return this.txMemberId;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        String className = this.getClass().getName();
        buff.append(className.substring(className.indexOf(PN_TOKEN) + PN_TOKEN.length()));
        buff.append("(regionPath=");
        buff.append(this.regionPath);
        this.appendFields(buff);
        buff.append(" ,distTx=");
        buff.append(this.isTransactionDistributed);
        buff.append(")");
        return buff.toString();
    }

    protected void appendFields(StringBuffer buff) {
        buff.append("; sender=").append(this.getSender()).append("; recipients=[");
        InternalDistributedMember[] recips = this.getRecipients();
        for (int i = 0; i < recips.length - 1; ++i) {
            buff.append(recips[i]).append(',');
        }
        if (recips.length > 0) {
            buff.append(recips[recips.length - 1]);
        }
        buff.append("]; processorId=").append(this.processorId);
    }

    public InternalDistributedMember getRecipient() {
        return this.getRecipients()[0];
    }

    public void setOperation(Operation op) {
    }

    public void setHasOldValue(boolean value) {
    }

    @Override
    public final int getTXUniqId() {
        return this.txUniqId;
    }

    @Override
    public final InternalDistributedMember getMemberToMasqueradeAs() {
        if (this.txMemberId == null) {
            return this.getSender();
        }
        return this.txMemberId;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    @Override
    public boolean canParticipateInTransaction() {
        return true;
    }

    @Override
    public boolean isTransactionDistributed() {
        return this.isTransactionDistributed;
    }

    public void setTransactionDistributed(boolean isDistTx) {
        this.isTransactionDistributed = isDistTx;
    }

    private void setIfTransactionDistributed() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && cache.getTxManager() != null) {
            this.isTransactionDistributed = cache.getTxManager().isDistributed();
        }
    }

    public static class RemoteOperationResponse
    extends DirectReplyProcessor {
        volatile ForceReattemptException prce;
        volatile boolean responseReceived;
        boolean responseRequired;

        public RemoteOperationResponse(InternalDistributedSystem dm, Collection initMembers) {
            this(dm, initMembers, true);
        }

        public RemoteOperationResponse(InternalDistributedSystem dm, Collection initMembers, boolean register) {
            super(dm, initMembers);
            if (register) {
                this.register();
            }
        }

        public RemoteOperationResponse(InternalDistributedSystem dm, InternalDistributedMember member) {
            this(dm, member, true);
        }

        public RemoteOperationResponse(InternalDistributedSystem dm, InternalDistributedMember member, boolean register) {
            super(dm, member);
            if (register) {
                this.register();
            }
        }

        public void requireResponse() {
            this.responseRequired = true;
        }

        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            if (id != null) {
                if (this.removeMember(id, true)) {
                    this.prce = new ForceReattemptException(LocalizedStrings.PartitionMessage_PARTITIONRESPONSE_GOT_MEMBERDEPARTED_EVENT_FOR_0_CRASHED_1.toLocalizedString(id, crashed));
                }
                this.checkIfDone();
            } else {
                Exception e = new Exception(LocalizedStrings.PartitionMessage_MEMBERDEPARTED_GOT_NULL_MEMBERID.toLocalizedString());
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.PartitionMessage_MEMBERDEPARTED_GOT_NULL_MEMBERID_CRASHED_0, crashed), (Throwable)e);
            }
        }

        public final void waitForCacheException() throws CacheException, RemoteOperationException, PrimaryBucketException {
            try {
                this.waitForRepliesUninterruptibly();
                if (this.prce != null || this.responseRequired && !this.responseReceived) {
                    throw new RemoteOperationException(LocalizedStrings.PartitionMessage_ATTEMPT_FAILED.toLocalizedString(), this.prce);
                }
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CacheException) {
                    throw (CacheException)t;
                }
                if (t instanceof RemoteOperationException) {
                    RemoteOperationException ft = (RemoteOperationException)t;
                    RemoteOperationException fre = new RemoteOperationException(LocalizedStrings.PartitionMessage_PEER_REQUESTS_REATTEMPT.toLocalizedString(), t);
                    if (ft.hasHash()) {
                        fre.setHash(ft.getHash());
                    }
                    throw fre;
                }
                if (t instanceof PrimaryBucketException) {
                    throw new PrimaryBucketException(LocalizedStrings.PartitionMessage_PEER_FAILED_PRIMARY_TEST.toLocalizedString(), t);
                }
                if (t instanceof RegionDestroyedException) {
                    RegionDestroyedException rde = (RegionDestroyedException)t;
                    throw rde;
                }
                if (t instanceof CancelException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("RemoteOperationResponse got CacheClosedException from {}, throwing ForceReattemptException", (Object)e.getSender(), (Object)t);
                    }
                    throw new RemoteOperationException(LocalizedStrings.PartitionMessage_PARTITIONRESPONSE_GOT_REMOTE_CACHECLOSEDEXCEPTION.toLocalizedString(), t);
                }
                if (t instanceof LowMemoryException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("RemoteOperationResponse re-throwing remote LowMemoryException from {}", (Object)e.getSender(), (Object)t);
                    }
                    throw (LowMemoryException)t;
                }
                e.handleAsUnexpected();
            }
        }

        @Override
        public void process(DistributionMessage msg) {
            this.responseReceived = true;
            super.process(msg);
        }
    }
}

