/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ByteArrayDataInput;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.InitialImageOperation;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.lru.NewLRUClockHand;
import org.apache.geode.internal.cache.versions.VersionSource;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class NonLocalRegionEntry
implements RegionEntry,
VersionStamp {
    private long lastModified;
    private boolean isRemoved;
    private Object key;
    private Object value;
    private VersionTag versionTag;

    public NonLocalRegionEntry(RegionEntry re, LocalRegion br, boolean allowTombstones) {
        this.key = re.getKey();
        this.value = allowTombstones && re.isTombstone() ? Token.TOMBSTONE : re.getValue(br);
        Assert.assertTrue(this.value != Token.NOT_AVAILABLE, "getEntry did not fault value in from disk");
        this.lastModified = re.getLastModified();
        this.isRemoved = re.isRemoved();
        VersionStamp stamp = re.getVersionStamp();
        if (stamp != null) {
            this.versionTag = stamp.asVersionTag();
        }
    }

    public NonLocalRegionEntry(LocalRegion br, Object key, Object value) {
        this.key = key;
        this.value = value;
        Assert.assertTrue(this.value != Token.NOT_AVAILABLE, "getEntry did not fault value in from disk");
    }

    public NonLocalRegionEntry(Region.Entry re, LocalRegion br) {
        this.key = re.getKey();
        this.value = re.getValue();
        if (this.value instanceof CachedDeserializable) {
            this.value = CachedDeserializableFactory.create((CachedDeserializable)this.value);
        }
        Assert.assertTrue(this.value != Token.NOT_AVAILABLE, "getEntry did not fault value in from disk");
        this.lastModified = 0L;
        this.isRemoved = Token.isRemoved(this.value);
        if (re instanceof EntrySnapshot) {
            this.versionTag = ((EntrySnapshot)re).getVersionTag();
        }
    }

    public String toString() {
        return "NonLocalRegionEntry(" + this.key + "; value=" + this.value + "; version=" + this.versionTag;
    }

    @Override
    public void makeTombstone(LocalRegion r, VersionTag isOperationRemote) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean dispatchListenerEvents(EntryEventImpl event) {
        throw new UnsupportedOperationException();
    }

    @Override
    public VersionStamp getVersionStamp() {
        return this;
    }

    @Override
    public boolean hasValidVersion() {
        return this.versionTag != null && this.versionTag.hasValidVersion();
    }

    @Override
    public void setVersionTimeStamp(long time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processVersionTag(EntryEvent ev) {
        throw new UnsupportedOperationException();
    }

    public NonLocalRegionEntry() {
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.key, out);
        DataSerializer.writeObject(this.value, out);
        out.writeLong(this.lastModified);
        out.writeBoolean(this.isRemoved);
        DataSerializer.writeObject(this.versionTag, out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.key = DataSerializer.readObject(in);
        this.value = DataSerializer.readObject(in);
        this.lastModified = in.readLong();
        this.isRemoved = in.readBoolean();
        this.versionTag = (VersionTag)DataSerializer.readObject(in);
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getLastAccessed() throws StatisticsDisabledException {
        return -1L;
    }

    @Override
    public long getHitCount() throws StatisticsDisabledException {
        return -1L;
    }

    @Override
    public long getMissCount() throws StatisticsDisabledException {
        return -1L;
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    @Override
    public boolean isRemovedPhase2() {
        return this.isRemoved;
    }

    @Override
    public boolean isTombstone() {
        return false;
    }

    @Override
    public boolean fillInValue(LocalRegion r, InitialImageOperation.Entry entry, ByteArrayDataInput in, DM mgr) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean isOverflowedToDisk(LocalRegion r, DistributedRegion.DiskPosition dp) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public final Object getValue(RegionEntryContext context) {
        return this.value;
    }

    @Override
    public final Object getValueRetain(RegionEntryContext context) {
        return this.value;
    }

    void setCachedValue(Object newValue) {
        this.value = newValue;
    }

    @Override
    public void updateStatsForPut(long lastModifiedTime, long lastAccessedTime) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public void setRecentlyUsed() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public void updateStatsForGet(boolean hit, long time) throws StatisticsDisabledException {
    }

    @Override
    public void txDidDestroy(long currTime) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public void resetCounts() throws StatisticsDisabledException {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public void removePhase1(LocalRegion r, boolean isClear) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public void removePhase2() {
        throw new UnsupportedOperationException("Not appropriate for PartitionedRegion.NonLocalRegionEntry");
    }

    @Override
    public void setValue(RegionEntryContext context, Object value) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public Object _getValue() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public Token getValueAsToken() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public Object _getValueRetain(RegionEntryContext context, boolean decompress) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public Object getTransformedValue() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public final Object getValueInVM(RegionEntryContext context) {
        return this.value;
    }

    @Override
    public Object getValueOnDisk(LocalRegion r) throws EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean initialImagePut(LocalRegion region, long lastModified1, Object newValue, boolean wasRecovered, boolean versionTagAccepted) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean initialImageInit(LocalRegion region, long lastModified1, Object newValue, boolean create, boolean wasRecovered, boolean versionTagAccepted) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean destroy(LocalRegion region, EntryEventImpl event, boolean inTokenMode, boolean cacheWrite, Object expectedOldValue, boolean forceDestroy, boolean removeRecoveredEntry) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean getValueWasResultOfSearch() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public void setValueResultOfSearch(boolean v) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public Object getValueOnDiskOrBuffer(LocalRegion r) throws EntryNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public Object getSerializedValueOnDisk(LocalRegion localRegion) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean hasStats() {
        return false;
    }

    @Override
    public final Object getValueInVMOrDiskWithoutFaultIn(LocalRegion owner) {
        return this.value;
    }

    @Override
    public Object getValueOffHeapOrDiskWithoutFaultIn(LocalRegion owner) {
        return this.value;
    }

    public void setKey(Object key2) {
        this.key = key2;
    }

    @Override
    public VersionTag generateVersionTag(VersionSource member, boolean withDelta, LocalRegion region, EntryEventImpl event) {
        throw new UnsupportedOperationException();
    }

    public void processVersionTag(LocalRegion r, VersionTag tag, InternalDistributedMember thisVM, InternalDistributedMember sender) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEntryVersion() {
        if (this.versionTag != null) {
            return this.versionTag.getEntryVersion();
        }
        return 0;
    }

    @Override
    public long getRegionVersion() {
        if (this.versionTag != null) {
            return this.versionTag.getRegionVersion();
        }
        return 0L;
    }

    @Override
    public VersionSource getMemberID() {
        if (this.versionTag != null) {
            return this.versionTag.getMemberID();
        }
        return null;
    }

    @Override
    public int getDistributedSystemId() {
        if (this.versionTag != null) {
            return this.versionTag.getDistributedSystemId();
        }
        return -1;
    }

    public void setVersions(VersionTag tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMemberID(VersionSource memberID) {
        throw new UnsupportedOperationException();
    }

    public void setPreviousMemberID(DistributedMember previousMemberID) {
        throw new UnsupportedOperationException();
    }

    public VersionTag asVersionTag() {
        return this.versionTag;
    }

    public void processVersionTag(LocalRegion r, VersionTag tag, boolean isTombstoneFromGII, boolean hasDelta, VersionSource thisVM, InternalDistributedMember sender, boolean checkForConflicts) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getVersionTimeStamp() {
        return this.versionTag != null ? this.versionTag.getVersionTimeStamp() : 0L;
    }

    @Override
    public short getRegionVersionHighBytes() {
        return this.versionTag != null ? this.versionTag.getRegionVersionHighBytes() : (short)0;
    }

    @Override
    public int getRegionVersionLowBytes() {
        return this.versionTag != null ? this.versionTag.getRegionVersionLowBytes() : 0;
    }

    @Override
    public boolean isUpdateInProgress() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public void setUpdateInProgress(boolean underUpdate) {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean isValueNull() {
        return null == this.getValueAsToken();
    }

    @Override
    public boolean isInvalid() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean isDestroyed() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public void setValueToNull() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean isInvalidOrRemoved() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean isDestroyedOrRemoved() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean isDestroyedOrRemovedButNotTombstone() {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public void returnToPool() {
    }

    @Override
    public void setValueWithTombstoneCheck(Object value, EntryEvent event) throws RegionClearedException {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean isCacheListenerInvocationInProgress() {
        return false;
    }

    @Override
    public void setCacheListenerInvocationInProgress(boolean isListenerInvoked) {
    }

    @Override
    public void setValue(RegionEntryContext context, Object value, EntryEventImpl event) throws RegionClearedException {
        throw new UnsupportedOperationException(LocalizedStrings.PartitionedRegion_NOT_APPROPRIATE_FOR_PARTITIONEDREGIONNONLOCALREGIONENTRY.toLocalizedString());
    }

    @Override
    public boolean isInUseByTransaction() {
        return false;
    }

    @Override
    public void setInUseByTransaction(boolean v) {
    }

    @Override
    public void incRefCount() {
    }

    @Override
    public void decRefCount(NewLRUClockHand lruList, LocalRegion lr) {
    }

    @Override
    public void resetRefCount(NewLRUClockHand lruList) {
    }

    @Override
    public Object prepareValueForCache(RegionEntryContext r, Object val, boolean isEntryUpdate) {
        throw new IllegalStateException("Should never be called");
    }

    @Override
    public Object prepareValueForCache(RegionEntryContext r, Object val, EntryEventImpl event, boolean isEntryUpdate) {
        throw new IllegalStateException("Should never be called");
    }
}

