/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Context;
import javax.transaction.TransactionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.ForcedDisconnectException;
import org.apache.geode.GemFireCacheException;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.LogWriter;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.internal.SystemMemberCacheEventProcessor;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheExistsException;
import org.apache.geode.cache.CacheTransactionManager;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.GatewayException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.ClientRegionFactoryImpl;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.CqServiceProvider;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.snapshot.CacheSnapshotService;
import org.apache.geode.cache.util.GatewayConflictResolver;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.CacheTime;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionAdvisee;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.PooledExecutorWithDMStats;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.distributed.internal.ResourceEventsListener;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.AddCacheServerProfileMessage;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.CacheLifecycleListener;
import org.apache.geode.internal.cache.CacheObserverHolder;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.CloseCacheMessage;
import org.apache.geode.internal.cache.ClusterConfigurationLoader;
import org.apache.geode.internal.cache.ColocationHelper;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.DiskStoreFactoryImpl;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DiskStoreMonitor;
import org.apache.geode.internal.cache.DiskStoreTask;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DynamicRegionFactoryImpl;
import org.apache.geode.internal.cache.EventTracker;
import org.apache.geode.internal.cache.ExpirationScheduler;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.GemfireCacheHelper;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.MinimumSystemRequirements;
import org.apache.geode.internal.cache.PRContainsValueFunction;
import org.apache.geode.internal.cache.PRHARedundancyProvider;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PoolFactoryImpl;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.RegionFactoryImpl;
import org.apache.geode.internal.cache.RegionListener;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.ReliableMessageQueueFactory;
import org.apache.geode.internal.cache.ReliableMessageQueueFactoryImpl;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXEntryStateFactory;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TombstoneService;
import org.apache.geode.internal.cache.UpdateAttributesProcessor;
import org.apache.geode.internal.cache.UserSpecifiedRegionAttributes;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.ResourceAdvisor;
import org.apache.geode.internal.cache.execute.util.FindRestEnabledServersFunction;
import org.apache.geode.internal.cache.extension.ExtensionPoint;
import org.apache.geode.internal.cache.extension.SimpleExtensionPoint;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.locks.TXLockService;
import org.apache.geode.internal.cache.lru.HeapEvictor;
import org.apache.geode.internal.cache.lru.OffHeapEvictor;
import org.apache.geode.internal.cache.persistence.BackupManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.query.TemporaryResultSetFactory;
import org.apache.geode.internal.cache.snapshot.CacheSnapshotServiceImpl;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.GatewaySenderAdvisor;
import org.apache.geode.internal.cache.wan.WANServiceProvider;
import org.apache.geode.internal.cache.xmlcache.CacheXmlParser;
import org.apache.geode.internal.cache.xmlcache.CacheXmlPropertyResolver;
import org.apache.geode.internal.cache.xmlcache.PropertyResolver;
import org.apache.geode.internal.concurrent.ConcurrentHashSet;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.internal.jta.TransactionManagerImpl;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.process.ClusterConfigurationNotAvailableException;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.sequencelog.SequenceLoggerImpl;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.internal.util.concurrent.FutureResult;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.internal.JmxManagerAdvisee;
import org.apache.geode.management.internal.JmxManagerAdvisor;
import org.apache.geode.management.internal.RestAgent;
import org.apache.geode.management.internal.beans.ManagementListener;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.messages.ConfigurationResponse;
import org.apache.geode.memcached.GemFireMemcachedServer;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxInstanceFactory;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.apache.geode.pdx.internal.AutoSerializableManager;
import org.apache.geode.pdx.internal.PdxInstanceFactoryImpl;
import org.apache.geode.pdx.internal.PdxInstanceImpl;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.geode.redis.GeodeRedisServer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class GemFireCacheImpl
implements InternalCache,
ClientCache,
HasCachePerfStats,
DistributionAdvisee,
CacheTime {
    private static final Logger logger = LogService.getLogger();
    public static final int DEFAULT_LOCK_TIMEOUT = Integer.getInteger("gemfire.Cache.defaultLockTimeout", 60);
    public static final int DEFAULT_LOCK_LEASE = Integer.getInteger("gemfire.Cache.defaultLockLease", 120);
    public static final boolean DEFAULT_COPY_ON_READ = false;
    private static volatile GemFireCacheImpl instance = null;
    private static volatile GemFireCacheImpl pdxInstance = null;
    public static final int DEFAULT_SEARCH_TIMEOUT = Integer.getInteger("gemfire.Cache.defaultSearchTimeout", 300);
    private static final Set<CacheLifecycleListener> cacheLifecycleListeners = new HashSet<CacheLifecycleListener>();
    private static final boolean ASYNC_EVENT_LISTENERS = Boolean.getBoolean("gemfire.Cache.ASYNC_EVENT_LISTENERS");
    public static boolean DELTAS_RECALCULATE_SIZE = Boolean.getBoolean("gemfire.DELTAS_RECALCULATE_SIZE");
    public static final int EVENT_QUEUE_LIMIT = Integer.getInteger("gemfire.Cache.EVENT_QUEUE_LIMIT", 4096);
    public static final int EVENT_THREAD_LIMIT = Integer.getInteger("gemfire.Cache.EVENT_THREAD_LIMIT", 16);
    public static final int MAX_QUERY_EXECUTION_TIME = Integer.getInteger("gemfire.Cache.MAX_QUERY_EXECUTION_TIME", -1);
    public final boolean QUERY_MONITOR_DISABLED_FOR_LOW_MEM = Boolean.getBoolean("gemfire.Cache.DISABLE_QUERY_MONITOR_FOR_LOW_MEMORY");
    public static Boolean QUERY_MONITOR_REQUIRED_FOR_RESOURCE_MANAGER = Boolean.FALSE;
    public static final String FIND_REST_ENABLED_SERVERS_FUNCTION_ID = FindRestEnabledServersFunction.class.getName();
    public static final boolean ALLOW_MEMORY_LOCK_WHEN_OVERCOMMITTED = Boolean.getBoolean("gemfire.Cache.ALLOW_MEMORY_OVERCOMMIT");
    private static final int FIVE_HOURS = 18000000;
    public int TEST_MAX_QUERY_EXECUTION_TIME = -1;
    public boolean TEST_MAX_QUERY_EXECUTION_TIME_OVERRIDE_EXCEPTION = false;
    private final InternalDistributedSystem system;
    private final DM dm;
    private final HashMap rootRegions;
    private final boolean isClient;
    private PoolFactory clientpf;
    private Pool defaultPool;
    private final ConcurrentMap pathToRegion = new ConcurrentHashMap();
    protected volatile boolean isInitialized = false;
    protected volatile boolean isClosing = false;
    protected volatile boolean closingGatewaySendersByShutdownAll = false;
    protected volatile boolean closingGatewayReceiversByShutdownAll = false;
    private int lockTimeout = DEFAULT_LOCK_TIMEOUT;
    private int lockLease = DEFAULT_LOCK_LEASE;
    private int searchTimeout = DEFAULT_SEARCH_TIMEOUT;
    private final CachePerfStats cachePerfStats;
    private final Date creationDate;
    private final ThreadPoolExecutor eventThreadPool;
    private volatile List allCacheServers = new CopyOnWriteArrayList();
    public final Object allGatewaySendersLock = new Object();
    private volatile Set<GatewaySender> allGatewaySenders = Collections.emptySet();
    private volatile Set<AsyncEventQueue> allVisibleAsyncEventQueues = new CopyOnWriteArraySet<AsyncEventQueue>();
    private volatile Set<AsyncEventQueue> allAsyncEventQueues = new CopyOnWriteArraySet<AsyncEventQueue>();
    public final Object allGatewayReceiversLock = new Object();
    private volatile Set<GatewayReceiver> allGatewayReceivers = Collections.emptySet();
    private final HashSet<PartitionedRegion> partitionedRegions = new HashSet();
    private final ConcurrentMap<String, DistributedRegion> regionsInDestroy = new ConcurrentHashMap<String, DistributedRegion>();
    public final Object allGatewayHubsLock = new Object();
    private GatewayConflictResolver gatewayConflictResolver;
    private boolean isServer = false;
    private final TXManagerImpl txMgr;
    private RestAgent restAgent;
    private boolean isRESTServiceRunning = false;
    private volatile boolean copyOnRead = false;
    private final Map namedRegionAttributes = Collections.synchronizedMap(new HashMap());
    private boolean forcedDisconnect;
    protected volatile Throwable disconnectCause = null;
    public Exception creationStack = null;
    private EventTracker.ExpiryTask recordedEventSweeper;
    private TombstoneService tombstoneService;
    private DistributedLockService prLockService;
    private final Object prLockServiceLock = new Object();
    private volatile DistributedLockService gatewayLockService;
    private final Object gatewayLockServiceLock = new Object();
    private final InternalResourceManager resourceManager;
    private final AtomicReference<BackupManager> backupManager = new AtomicReference();
    private HeapEvictor heapEvictor = null;
    private OffHeapEvictor offHeapEvictor = null;
    private final Object heapEvictorLock = new Object();
    private final Object offHeapEvictorLock = new Object();
    private ResourceEventsListener listener;
    private static final boolean DEBUG_CREATION_STACK = false;
    private volatile QueryMonitor queryMonitor;
    private final Object queryMonitorLock = new Object();
    private final PersistentMemberManager persistentMemberManager;
    private ClientMetadataService clientMetadatService = null;
    private final Object clientMetaDatServiceLock = new Object();
    private final AtomicBoolean isShutDownAll = new AtomicBoolean();
    private final CountDownLatch shutDownAllFinished = new CountDownLatch(1);
    private final ResourceAdvisor resourceAdvisor;
    private final JmxManagerAdvisor jmxAdvisor;
    private final int serialNumber;
    private final TXEntryStateFactory txEntryStateFactory;
    private final CacheConfig cacheConfig;
    private final DiskStoreMonitor diskMonitor;
    private final Map<Declarable, Properties> declarablePropertiesMap = new ConcurrentHashMap<Declarable, Properties>();
    protected static PropertyResolver resolver;
    protected static boolean xmlParameterizationEnabled;
    public static Runnable internalBeforeApplyChanges;
    public static Runnable internalBeforeNonTXBasicPut;
    private GemFireMemcachedServer memcachedServer;
    private GeodeRedisServer redisServer;
    private SimpleExtensionPoint<Cache> extensionPoint = new SimpleExtensionPoint<GemFireCacheImpl>(this, this);
    private final CqService cqService;
    private final Set<RegionListener> regionListeners = new ConcurrentHashSet<RegionListener>();
    private final Map<Class<? extends CacheService>, CacheService> services = new HashMap<Class<? extends CacheService>, CacheService>();
    public static final int DEFAULT_CLIENT_FUNCTION_TIMEOUT = 0;
    private static int clientFunctionTimeout;
    private static final Boolean DISABLE_AUTO_EVICTION;
    private static SecurityService securityService;
    private final ConcurrentMap reinitializingRegions = new ConcurrentHashMap();
    public static File testCacheXml;
    private final Stopper stopper = new Stopper();
    private boolean keepAlive;
    private static volatile boolean emergencyClassesLoaded;
    private static final int shutdownAllPoolSize;
    private final boolean DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE = Boolean.getBoolean("gemfire.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE");
    private final AtomicBoolean diskStoreTaskSync = new AtomicBoolean(false);
    private ThreadPoolExecutor diskStoreTaskPool = null;
    private final ConcurrentMap<String, DiskStoreImpl> diskStores = new ConcurrentHashMap<String, DiskStoreImpl>();
    private final ConcurrentMap<String, DiskStoreImpl> regionOwnedDiskStores = new ConcurrentHashMap<String, DiskStoreImpl>();
    public static String DEFAULT_DS_NAME;
    private SystemTimer ccpTimer;
    private final Object ccpTimerMutex = new Object();
    private final ExpirationScheduler expirationScheduler;
    private static final ThreadLocal xmlCache;
    private final ReliableMessageQueueFactory rmqFactory;
    private List<File> backupFiles = Collections.emptyList();
    private final AtomicInteger registerInterestsInProgress = new AtomicInteger();
    private final ArrayList<SimpleWaiter> riWaiters = new ArrayList();
    private TypeRegistry pdxRegistry;
    private Declarable initializer;
    private Properties initializerProps;
    private TemporaryResultSetFactory resultSetFactory;

    private static native int mlockall(int var0);

    public static void lockMemory() {
        int result = 0;
        try {
            Native.register((String)Platform.C_LIBRARY_NAME);
            result = GemFireCacheImpl.mlockall(1);
            if (result == 0) {
                return;
            }
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error trying to lock memory", t);
        }
        int errno = Native.getLastError();
        String msg = "mlockall failed: " + errno;
        if (errno == 1 || errno == 12) {
            msg = "Unable to lock memory due to insufficient free space or privileges.  Please check the RLIMIT_MEMLOCK soft resource limit (ulimit -l) and increase the available memory if needed";
        }
        throw new IllegalStateException(msg);
    }

    public String toString() {
        final StringBuffer sb = new StringBuffer();
        sb.append("GemFireCache[");
        sb.append("id = " + System.identityHashCode(this));
        sb.append("; isClosing = " + this.isClosing);
        sb.append("; isShutDownAll = " + this.isCacheAtShutdownAll());
        sb.append("; created = " + this.creationDate);
        sb.append("; server = " + this.isServer);
        sb.append("; copyOnRead = " + this.copyOnRead);
        sb.append("; lockLease = " + this.lockLease);
        sb.append("; lockTimeout = " + this.lockTimeout);
        if (this.creationStack != null) {
            sb.append("\nCreation context:\n");
            OutputStream os = new OutputStream(){

                @Override
                public void write(int i) {
                    sb.append((char)i);
                }
            };
            PrintStream ps = new PrintStream(os);
            this.creationStack.printStackTrace(ps);
        }
        sb.append("]");
        return sb.toString();
    }

    public static GemFireCacheImpl getInstance() {
        return instance;
    }

    public static GemFireCacheImpl setInstanceForTests(GemFireCacheImpl cache) {
        GemFireCacheImpl oldInstance = instance;
        instance = cache;
        return oldInstance;
    }

    public static final GemFireCacheImpl getExisting() {
        GemFireCacheImpl result = instance;
        if (result != null && !result.isClosing) {
            return result;
        }
        if (result != null) {
            throw result.getCacheClosedException(LocalizedStrings.CacheFactory_THE_CACHE_HAS_BEEN_CLOSED.toLocalizedString(), null);
        }
        throw new CacheClosedException(LocalizedStrings.CacheFactory_A_CACHE_HAS_NOT_YET_BEEN_CREATED.toLocalizedString());
    }

    public static GemFireCacheImpl getExisting(String reason) {
        GemFireCacheImpl result = GemFireCacheImpl.getInstance();
        if (result == null) {
            throw new CacheClosedException(reason);
        }
        return result;
    }

    public static GemFireCacheImpl getForPdx(String reason) {
        GemFireCacheImpl result = pdxInstance;
        if (result == null) {
            throw new CacheClosedException(reason);
        }
        return result;
    }

    public static GemFireCacheImpl createClient(DistributedSystem system, PoolFactory pf, CacheConfig cacheConfig) {
        return GemFireCacheImpl.basicCreate(system, true, cacheConfig, pf, true, ASYNC_EVENT_LISTENERS, null);
    }

    public static GemFireCacheImpl create(DistributedSystem system, CacheConfig cacheConfig) {
        return GemFireCacheImpl.basicCreate(system, true, cacheConfig, null, false, ASYNC_EVENT_LISTENERS, null);
    }

    public static GemFireCacheImpl createWithAsyncEventListeners(DistributedSystem system, CacheConfig cacheConfig, TypeRegistry typeRegistry) {
        return GemFireCacheImpl.basicCreate(system, true, cacheConfig, null, false, true, typeRegistry);
    }

    public static Cache create(DistributedSystem system, boolean existingOk, CacheConfig cacheConfig) {
        return GemFireCacheImpl.basicCreate(system, existingOk, cacheConfig, null, false, ASYNC_EVENT_LISTENERS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GemFireCacheImpl basicCreate(DistributedSystem system, boolean existingOk, CacheConfig cacheConfig, PoolFactory pf, boolean isClient, boolean asyncEventListeners, TypeRegistry typeRegistry) throws CacheExistsException, TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        try {
            Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
            synchronized (GemFireCacheImpl.class) {
                GemFireCacheImpl instance = GemFireCacheImpl.checkExistingCache(existingOk, cacheConfig);
                if (instance == null) {
                    instance = new GemFireCacheImpl(isClient, pf, system, cacheConfig, asyncEventListeners, typeRegistry);
                    instance.initialize();
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return instance;
            }
        }
        catch (IllegalArgumentException | CacheXmlException e) {
            logger.error(e.getLocalizedMessage());
            throw e;
        }
        catch (Error | RuntimeException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    private static GemFireCacheImpl checkExistingCache(boolean existingOk, CacheConfig cacheConfig) {
        GemFireCacheImpl instance = GemFireCacheImpl.getInstance();
        if (instance != null && !instance.isClosed()) {
            if (existingOk) {
                cacheConfig.validateCacheConfig(instance);
                return instance;
            }
            throw new CacheExistsException(instance, LocalizedStrings.CacheFactory_0_AN_OPEN_CACHE_ALREADY_EXISTS.toLocalizedString(instance), instance.creationStack);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GemFireCacheImpl(boolean isClient, PoolFactory pf, DistributedSystem system, CacheConfig cacheConfig, boolean asyncEventListeners, TypeRegistry typeRegistry) {
        this.isClient = isClient;
        this.clientpf = pf;
        this.cacheConfig = cacheConfig;
        this.pdxRegistry = typeRegistry;
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            DM dm;
            JNDIInvoker.mapTransactions(system);
            this.system = (InternalDistributedSystem)system;
            this.dm = this.system.getDistributionManager();
            if (!this.isClient && PoolManager.getAll().isEmpty()) {
                this.listener = new ManagementListener();
                this.system.addResourceListener(this.listener);
                if (this.system.isLoner()) {
                    this.system.getInternalLogWriter().info(LocalizedStrings.GemFireCacheImpl_RUNNING_IN_LOCAL_MODE);
                }
            } else {
                this.getLogger().info("Running in client mode");
                this.listener = null;
            }
            if ((dm = this.system.getDistributionManager()) instanceof DistributionManager && ((DistributionManager)dm).getDMType() == 12) {
                throw new IllegalStateException(LocalizedStrings.GemFireCache_CANNOT_CREATE_A_CACHE_IN_AN_ADMINONLY_VM.toLocalizedString());
            }
            this.rootRegions = new HashMap();
            this.cqService = CqServiceProvider.create(this);
            this.rmqFactory = new ReliableMessageQueueFactoryImpl();
            this.cachePerfStats = new CachePerfStats(system);
            CachePerfStats.enableClockStats = this.system.getConfig().getEnableTimeStatistics();
            this.txMgr = new TXManagerImpl(this.cachePerfStats, this);
            dm.addMembershipListener(this.txMgr);
            this.creationDate = new Date();
            this.persistentMemberManager = new PersistentMemberManager();
            if (asyncEventListeners) {
                final LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("Message Event Threads", logger);
                ThreadFactory tf = new ThreadFactory(){

                    @Override
                    public Thread newThread(final Runnable command) {
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                ConnectionTable.threadWantsSharedResources();
                                command.run();
                            }
                        };
                        Thread thread = new Thread(group, r, "Message Event Thread");
                        thread.setDaemon(true);
                        return thread;
                    }
                };
                ArrayBlockingQueue<Runnable> q = new ArrayBlockingQueue<Runnable>(EVENT_QUEUE_LIMIT);
                this.eventThreadPool = new PooledExecutorWithDMStats(q, EVENT_THREAD_LIMIT, this.cachePerfStats.getEventPoolHelper(), tf, 1000);
            } else {
                this.eventThreadPool = null;
            }
            this.resourceAdvisor = ResourceAdvisor.createResourceAdvisor(this);
            this.jmxAdvisor = JmxManagerAdvisor.createJmxManagerAdvisor(new JmxManagerAdvisee(this));
            this.resourceManager = InternalResourceManager.createResourceManager(this);
            this.serialNumber = DistributionAdvisor.createSerialNumber();
            this.getResourceManager().addResourceListener(InternalResourceManager.ResourceType.HEAP_MEMORY, this.getHeapEvictor());
            if (null != this.getOffHeapStore()) {
                this.getResourceManager().addResourceListener(InternalResourceManager.ResourceType.OFFHEAP_MEMORY, this.getOffHeapEvictor());
            }
            this.recordedEventSweeper = EventTracker.startTrackerServices(this);
            this.tombstoneService = TombstoneService.initialize(this);
            TypeRegistry.init();
            this.basicSetPdxSerializer(this.cacheConfig.getPdxSerializer());
            TypeRegistry.open();
            if (!this.isClient()) {
                HARegionQueue.setMessageSyncInterval(1);
            }
            FunctionService.registerFunction(new PRContainsValueFunction());
            this.expirationScheduler = new ExpirationScheduler(this.system);
            this.txEntryStateFactory = TXEntryState.getFactory();
            if (xmlParameterizationEnabled) {
                Properties userProps = this.system.getConfig().getUserDefinedProps();
                resolver = userProps != null && !userProps.isEmpty() ? new CacheXmlPropertyResolver(false, 1, userProps) : new CacheXmlPropertyResolver(false, 1, null);
            }
            SystemFailure.signalCacheCreate();
            this.diskMonitor = new DiskStoreMonitor();
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    public boolean isRESTServiceRunning() {
        return this.isRESTServiceRunning;
    }

    public void setRESTServiceRunning(boolean isRESTServiceRunning) {
        this.isRESTServiceRunning = isRESTServiceRunning;
    }

    public RestAgent getRestAgent() {
        return this.restAgent;
    }

    public ConfigurationResponse requestSharedConfiguration() {
        DistributionConfig config = this.system.getConfig();
        if (!(this.dm instanceof DistributionManager)) {
            return null;
        }
        if (((DistributionManager)this.dm).getDMType() == 11 || this.isClient || Locator.getLocator() != null) {
            return null;
        }
        Map<InternalDistributedMember, Collection<String>> scl = this.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration();
        if (scl.isEmpty()) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_NO_LOCATORS_FOUND_WITH_SHARED_CONFIGURATION));
            return null;
        }
        ConfigurationResponse response = null;
        List<String> locatorConnectionStrings = this.getSharedConfigLocatorConnectionStringList();
        try {
            Properties clusterSecProperties;
            response = ClusterConfigurationLoader.requestConfigurationFromLocators(this.system.getConfig(), locatorConnectionStrings);
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_RECEIVED_SHARED_CONFIGURATION_FROM_LOCATORS));
            logger.info(response.describeConfig());
            Configuration clusterConfig = response.getRequestedConfiguration().get("cluster");
            Properties properties = clusterSecProperties = clusterConfig == null ? new Properties() : clusterConfig.getGemfireProperties();
            if (!config.getUseSharedConfiguration()) {
                if (clusterSecProperties.containsKey("security-manager")) {
                    throw new GemFireConfigException(LocalizedStrings.GEMFIRE_CACHE_SECURITY_MISCONFIGURATION_2.toLocalizedString());
                }
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_NOT_USING_SHARED_CONFIGURATION));
                return null;
            }
            Properties serverSecProperties = config.getSecurityProps();
            if (GemFireCacheImpl.isMisConfigured(clusterSecProperties, serverSecProperties, "security-manager") || GemFireCacheImpl.isMisConfigured(clusterSecProperties, serverSecProperties, "security-post-processor")) {
                throw new GemFireConfigException(LocalizedStrings.GEMFIRE_CACHE_SECURITY_MISCONFIGURATION.toLocalizedString());
            }
            return response;
        }
        catch (ClusterConfigurationNotAvailableException e) {
            throw new GemFireConfigException(LocalizedStrings.GemFireCache_SHARED_CONFIGURATION_NOT_AVAILABLE.toLocalizedString(), e);
        }
        catch (UnknownHostException e) {
            throw new GemFireConfigException(e.getLocalizedMessage(), e);
        }
    }

    public void deployJarsRecevedFromClusterConfiguration(ConfigurationResponse response) {
        try {
            ClusterConfigurationLoader.deployJarsReceivedFromClusterConfiguration(this, response);
        }
        catch (IOException e) {
            throw new GemFireConfigException(LocalizedStrings.GemFireCache_EXCEPTION_OCCURED_WHILE_DEPLOYING_JARS_FROM_SHARED_CONDFIGURATION.toLocalizedString(), e);
        }
        catch (ClassNotFoundException e) {
            throw new GemFireConfigException(LocalizedStrings.GemFireCache_EXCEPTION_OCCURED_WHILE_DEPLOYING_JARS_FROM_SHARED_CONDFIGURATION.toLocalizedString(), e);
        }
    }

    public static boolean isMisConfigured(Properties clusterProps, Properties serverProps, String key) {
        String clusterPropValue = clusterProps.getProperty(key);
        String serverPropValue = serverProps.getProperty(key);
        if (StringUtils.isBlank((String)serverPropValue)) {
            return false;
        }
        if (StringUtils.isBlank((String)clusterPropValue)) {
            return true;
        }
        return !clusterPropValue.equals(serverPropValue);
    }

    public List<String> getSharedConfigLocatorConnectionStringList() {
        ArrayList<String> locatorConnectionStringList = new ArrayList<String>();
        Map<InternalDistributedMember, Collection<String>> scl = this.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration();
        if (!scl.isEmpty()) {
            Set<Map.Entry<InternalDistributedMember, Collection<String>>> locs = scl.entrySet();
            for (Map.Entry<InternalDistributedMember, Collection<String>> loc : locs) {
                Collection<String> locStrings = loc.getValue();
                Iterator<String> locStringIter = locStrings.iterator();
                while (locStringIter.hasNext()) {
                    locatorConnectionStringList.add(locStringIter.next());
                }
            }
        }
        return locatorConnectionStringList;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public boolean hasPool() {
        return this.isClient || !this.getAllPools().isEmpty();
    }

    private Collection<Pool> getAllPools() {
        Collection<Pool> pools = PoolManagerImpl.getPMI().getMap().values();
        Iterator<Pool> itr = pools.iterator();
        while (itr.hasNext()) {
            PoolImpl pool = (PoolImpl)itr.next();
            if (!pool.isUsedByGateway()) continue;
            itr.remove();
        }
        return pools;
    }

    @Override
    public Pool getDefaultPool() {
        return this.defaultPool;
    }

    private void setDefaultPool(Pool v) {
        this.defaultPool = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (instance != null) {
            Assert.assertTrue(instance == null, "Cache instance already in place: " + instance);
        }
        instance = this;
        pdxInstance = this;
        MinimumSystemRequirements.checkAndLog();
        for (CacheLifecycleListener listener : cacheLifecycleListeners) {
            listener.cacheCreated(this);
        }
        ClassPathLoader.setLatestToDefault();
        ConfigurationResponse configurationResponse = this.requestSharedConfiguration();
        this.deployJarsRecevedFromClusterConfiguration(configurationResponse);
        ClusterConfigurationLoader.applyClusterPropertiesConfiguration(this, configurationResponse, this.system.getConfig());
        securityService.initSecurity(this.system.getConfig().getSecurityProps());
        if (this.cacheConfig.getSecurityManager() != null) {
            securityService.setSecurityManager(this.cacheConfig.getSecurityManager());
        }
        if (this.cacheConfig.getPostProcessor() != null) {
            securityService.setPostProcessor(this.cacheConfig.getPostProcessor());
        }
        SystemMemberCacheEventProcessor.send(this, Operation.CACHE_CREATE);
        this.resourceAdvisor.initializationGate();
        FunctionService.registerFunction(new FindRestEnabledServersFunction());
        this.jmxAdvisor.initializationGate();
        this.system.handleResourceEvent(ResourceEvent.CACHE_CREATE, this);
        boolean completedCacheXml = false;
        this.initializeServices();
        try {
            new JarDeployer(this.system.getConfig().getDeployWorkingDir()).loadPreviouslyDeployedJars();
            ClusterConfigurationLoader.applyClusterXmlConfiguration(this, configurationResponse, this.system.getConfig());
            this.initializeDeclarativeCache();
            completedCacheXml = true;
        }
        finally {
            if (!completedCacheXml) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.clientpf = null;
        this.startColocatedJmxManagerLocator();
        this.startMemcachedServer();
        this.startRedisServer();
        this.startRestAgentServer(this);
        int time = Integer.getInteger("gemfire.CLIENT_FUNCTION_TIMEOUT", 0);
        clientFunctionTimeout = time >= 0 ? time : 0;
        this.isInitialized = true;
    }

    private void initializeServices() {
        ServiceLoader<CacheService> loader = ServiceLoader.load(CacheService.class);
        for (CacheService service : loader) {
            service.init(this);
            this.services.put(service.getInterface(), service);
            this.system.handleResourceEvent(ResourceEvent.CACHE_SERVICE_CREATE, service);
        }
    }

    private boolean isNotJmxManager() {
        return !this.system.getConfig().getJmxManagerStart();
    }

    private boolean isServerNode() {
        return this.system.getDistributedMember().getVmKind() != 11 && this.system.getDistributedMember().getVmKind() != 12 && !this.isClient();
    }

    private void startRestAgentServer(GemFireCacheImpl cache) {
        if (this.system.getConfig().getStartDevRestApi() && this.isNotJmxManager() && this.isServerNode()) {
            this.restAgent = new RestAgent(this.system.getConfig());
            this.restAgent.start(cache);
        } else {
            this.restAgent = null;
        }
    }

    private void startMemcachedServer() {
        int port = this.system.getConfig().getMemcachedPort();
        if (port != 0) {
            String protocol = this.system.getConfig().getMemcachedProtocol();
            assert (protocol != null);
            String bindAddress = this.system.getConfig().getMemcachedBindAddress();
            assert (bindAddress != null);
            if (bindAddress.equals("")) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCacheImpl_STARTING_GEMFIRE_MEMCACHED_SERVER_ON_PORT_0_FOR_1_PROTOCOL, new Object[]{port, protocol}));
            } else {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCacheImpl_STARTING_GEMFIRE_MEMCACHED_SERVER_ON_BIND_ADDRESS_0_PORT_1_FOR_2_PROTOCOL, new Object[]{bindAddress, port, protocol}));
            }
            this.memcachedServer = new GemFireMemcachedServer(bindAddress, port, GemFireMemcachedServer.Protocol.valueOf(protocol.toUpperCase()));
            this.memcachedServer.start();
        }
    }

    private void startRedisServer() {
        int port = this.system.getConfig().getRedisPort();
        if (port != 0) {
            String bindAddress = this.system.getConfig().getRedisBindAddress();
            assert (bindAddress != null);
            if (bindAddress.equals("")) {
                this.getLoggerI18n().info(LocalizedStrings.GemFireCacheImpl_STARTING_GEMFIRE_REDIS_SERVER_ON_PORT_0, new Object[]{port});
            } else {
                this.getLoggerI18n().info(LocalizedStrings.GemFireCacheImpl_STARTING_GEMFIRE_REDIS_SERVER_ON_BIND_ADDRESS_0_PORT_1, new Object[]{bindAddress, port});
            }
            this.redisServer = new GeodeRedisServer(bindAddress, port);
            this.redisServer.start();
        }
    }

    public URL getCacheXmlURL() {
        File defaultFile;
        if (this.getMyId().getVmKind() == 11) {
            return null;
        }
        File xmlFile = testCacheXml;
        if (xmlFile == null) {
            xmlFile = this.system.getConfig().getCacheXmlFile();
        }
        if ("".equals(xmlFile.getName())) {
            return null;
        }
        URL url = null;
        if (!xmlFile.exists() || !xmlFile.isFile()) {
            String resource = xmlFile.getPath();
            if ((resource = resource.replaceAll("\\\\", "/")).length() > 1 && resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            url = ClassPathLoader.getLatest().getResource(this.getClass(), resource);
        } else {
            try {
                url = xmlFile.toURL();
            }
            catch (IOException ex) {
                throw new CacheXmlException(LocalizedStrings.GemFireCache_COULD_NOT_CONVERT_XML_FILE_0_TO_AN_URL.toLocalizedString(xmlFile), ex);
            }
        }
        if (url == null && !xmlFile.equals(defaultFile = DistributionConfig.DEFAULT_CACHE_XML_FILE)) {
            if (!xmlFile.exists()) {
                throw new CacheXmlException(LocalizedStrings.GemFireCache_DECLARATIVE_CACHE_XML_FILERESOURCE_0_DOES_NOT_EXIST.toLocalizedString(xmlFile));
            }
            throw new CacheXmlException(LocalizedStrings.GemFireCache_DECLARATIVE_XML_FILE_0_IS_NOT_A_FILE.toLocalizedString(xmlFile));
        }
        return url;
    }

    private void initializeDeclarativeCache() throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        URL url = this.getCacheXmlURL();
        String cacheXmlDescription = this.cacheConfig.getCacheXMLDescription();
        if (url == null && cacheXmlDescription == null) {
            if (this.isClient()) {
                this.determineDefaultPool();
                GemFireCacheImpl.initializeClientRegionShortcuts(this);
            } else {
                GemFireCacheImpl.initializeRegionShortcuts(this);
            }
            this.initializePdxRegistry();
            this.readyDynamicRegionFactory();
            return;
        }
        try {
            this.logCacheXML(url, cacheXmlDescription);
            InputStream stream = null;
            if (cacheXmlDescription != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("initializing cache with generated XML: {}", (Object)cacheXmlDescription);
                }
                stream = new StringBufferInputStream(cacheXmlDescription);
            } else {
                stream = url.openStream();
            }
            this.loadCacheXml(stream);
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException ex) {
            throw new CacheXmlException(LocalizedStrings.GemFireCache_WHILE_OPENING_CACHE_XML_0_THE_FOLLOWING_ERROR_OCCURRED_1.toLocalizedString(url.toString(), ex));
        }
        catch (CacheXmlException ex) {
            CacheXmlException newEx = new CacheXmlException(LocalizedStrings.GemFireCache_WHILE_READING_CACHE_XML_0_1.toLocalizedString(url, ex.getMessage()));
            newEx.setStackTrace(ex.getStackTrace());
            newEx.initCause(ex.getCause());
            throw newEx;
        }
    }

    private void logCacheXML(URL url, String cacheXmlDescription) {
        if (cacheXmlDescription == null) {
            StringBuilder sb = new StringBuilder();
            try {
                String EOLN = System.getProperty("line.separator");
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                String l = br.readLine();
                while (l != null) {
                    if (!l.isEmpty()) {
                        sb.append(EOLN).append(l);
                    }
                    l = br.readLine();
                }
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_INITIALIZING_CACHE_USING__0__1, new Object[]{url.toString(), sb.toString()}));
        } else {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_INITIALIZING_CACHE_USING__0__1, new Object[]{"generated description from old cache", cacheXmlDescription}));
        }
    }

    public synchronized void initializePdxRegistry() {
        if (this.pdxRegistry == null) {
            this.pdxRegistry = this.getMyId().getVmKind() == 11 ? new TypeRegistry(this, true) : new TypeRegistry(this, false);
            this.pdxRegistry.initialize();
        }
    }

    public void readyDynamicRegionFactory() {
        try {
            ((DynamicRegionFactoryImpl)DynamicRegionFactory.get()).internalInit(this);
        }
        catch (CacheException ce) {
            throw new GemFireCacheException(LocalizedStrings.GemFireCache_DYNAMIC_REGION_INITIALIZATION_FAILED.toLocalizedString(), ce);
        }
    }

    @Override
    public DiskStoreFactory createDiskStoreFactory() {
        return new DiskStoreFactoryImpl(this);
    }

    public DiskStoreFactory createDiskStoreFactory(DiskStoreAttributes attrs) {
        return new DiskStoreFactoryImpl(this, attrs);
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    public boolean forcedDisconnect() {
        return this.forcedDisconnect || this.system.forcedDisconnect();
    }

    public CacheClosedException getCacheClosedException(String reason, Throwable cause) {
        CacheClosedException result = cause != null ? new CacheClosedException(reason, cause) : (this.disconnectCause != null ? new CacheClosedException(reason, this.disconnectCause) : new CacheClosedException(reason));
        return result;
    }

    public Throwable getDisconnectCause() {
        return this.disconnectCause;
    }

    public boolean keepDurableSubscriptionsAlive() {
        return this.keepAlive;
    }

    public static void loadEmergencyClasses() {
        if (emergencyClassesLoaded) {
            return;
        }
        emergencyClassesLoaded = true;
        InternalDistributedSystem.loadEmergencyClasses();
        AcceptorImpl.loadEmergencyClasses();
        PoolManagerImpl.loadEmergencyClasses();
    }

    public static void emergencyClose() {
        boolean DEBUG = false;
        GemFireCacheImpl inst = instance;
        if (inst == null) {
            return;
        }
        instance = null;
        pdxInstance = null;
        InternalDistributedSystem ids = inst.system;
        if (ids != null) {
            ids.emergencyClose();
        }
        inst.disconnectCause = SystemFailure.getFailure();
        inst.isClosing = true;
        for (CacheServerImpl bs : inst.allCacheServers) {
            AcceptorImpl ai = bs.getAcceptor();
            if (ai == null) continue;
            ai.emergencyClose();
        }
        PoolManagerImpl.emergencyClose();
        inst.rootRegions.clear();
        inst.partitionedRegions.clear();
    }

    public boolean isCacheAtShutdownAll() {
        return this.isShutDownAll.get();
    }

    void shutdownSubTreeGracefully(Map<String, PartitionedRegion> prSubMap) {
        for (PartitionedRegion pr : prSubMap.values()) {
            this.shutDownOnePRGracefully(pr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDownAll() {
        if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
            try {
                CacheObserverHolder.getInstance().beforeShutdownAll();
            }
            finally {
                LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
            }
        }
        if (!this.isShutDownAll.compareAndSet(false, true)) {
            try {
                this.shutDownAllFinished.await();
            }
            catch (InterruptedException e) {
                logger.debug("Shutdown all interrupted while waiting for another thread to do the shutDownAll");
                Thread.currentThread().interrupt();
            }
            return;
        }
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            try {
                boolean testIGE = Boolean.getBoolean("TestInternalGemFireError");
                if (testIGE) {
                    InternalGemFireError assErr = new InternalGemFireError(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString());
                    throw assErr;
                }
                TreeMap<String, Map<String, PartitionedRegion>> prTrees = this.getPRTrees();
                if (prTrees.size() > 1 && shutdownAllPoolSize != 1) {
                    ExecutorService es = this.getShutdownAllExecutorService(prTrees.size());
                    for (final Map<String, PartitionedRegion> prSubMap : prTrees.values()) {
                        es.execute(new Runnable(){

                            @Override
                            public void run() {
                                ConnectionTable.threadWantsSharedResources();
                                GemFireCacheImpl.this.shutdownSubTreeGracefully(prSubMap);
                            }
                        });
                    }
                    es.shutdown();
                    try {
                        es.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        logger.debug("Shutdown all interrupted while waiting for PRs to be shutdown gracefully.");
                    }
                } else {
                    for (Map<String, PartitionedRegion> prSubMap : prTrees.values()) {
                        this.shutdownSubTreeGracefully(prSubMap);
                    }
                }
                this.close("Shut down all members", null, false, true);
            }
            finally {
                this.shutDownAllFinished.countDown();
            }
            // ** MonitorExit[var1_3] (shouldn't be in output)
            return;
        }
    }

    private ExecutorService getShutdownAllExecutorService(int size) {
        final LoggingThreadGroup thrGrp = LoggingThreadGroup.createThreadGroup("ShutdownAllGroup", logger);
        ThreadFactory thrFactory = new ThreadFactory(){
            private final AtomicInteger threadCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(thrGrp, r, "ShutdownAll-" + this.threadCount.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        };
        ExecutorService es = Executors.newFixedThreadPool(shutdownAllPoolSize == -1 ? size : shutdownAllPoolSize, thrFactory);
        return es;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutDownOnePRGracefully(PartitionedRegion pr) {
        boolean acquiredLock = false;
        try {
            pr.acquireDestroyLock();
            acquiredLock = true;
            PRHARedundancyProvider pRHARedundancyProvider = pr.getRedundancyProvider();
            synchronized (pRHARedundancyProvider) {
                if (pr.isDataStore() && pr.getDataStore() != null && pr.getDataPolicy() == DataPolicy.PERSISTENT_PARTITION) {
                    int numBuckets = pr.getTotalNumberOfBuckets();
                    Map[] bucketMaps = new Map[numBuckets];
                    PartitionedRegionDataStore prds = pr.getDataStore();
                    Set<Map.Entry<Integer, BucketRegion>> bucketEntries = prds.getAllLocalBuckets();
                    for (Map.Entry<Integer, BucketRegion> e : bucketEntries) {
                        BucketRegion br = e.getValue();
                        if (br == null || br.isDestroyed) continue;
                        br.getBucketAdvisor().tryLockIfPrimary();
                        bucketMaps[br.getId()] = br.getBucketAdvisor().adviseInitializedPersistentMembers();
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("shutDownAll: PR {}: initialized persistent members for {}:{}", (Object)pr.getName(), (Object)br.getId(), (Object)bucketMaps[br.getId()]);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("shutDownAll: All buckets for PR {} are locked.", (Object)pr.getName());
                    }
                    pr.setShutDownAllStatus(1);
                    new UpdateAttributesProcessor(pr).distribute(false);
                    pr.getRegionAdvisor().waitForProfileStatus(1);
                    if (logger.isDebugEnabled()) {
                        logger.debug("shutDownAll: PR {}: all bucketlock profiles received.", (Object)pr.getName());
                    }
                    if (!pr.getAttributes().isDiskSynchronous()) {
                        pr.getDiskStore().forceFlush();
                        pr.setShutDownAllStatus(2);
                        new UpdateAttributesProcessor(pr).distribute(false);
                        pr.getRegionAdvisor().waitForProfileStatus(2);
                        if (logger.isDebugEnabled()) {
                            logger.debug("shutDownAll: PR {}: all flush profiles received.", (Object)pr.getName());
                        }
                    }
                    Set<InternalDistributedMember> membersToPersistOfflineEqual = pr.getRegionAdvisor().adviseDataStore();
                    for (Map.Entry<Integer, BucketRegion> e : bucketEntries) {
                        Map<InternalDistributedMember, PersistentMemberID> persistMap;
                        BucketRegion br = e.getValue();
                        if (br == null || br.isDestroyed || (persistMap = this.getSubMapForLiveMembers(pr, membersToPersistOfflineEqual, bucketMaps[br.getId()])) == null) continue;
                        br.getPersistenceAdvisor().persistMembersOfflineAndEqual(persistMap);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("shutDownAll: PR {}: pesisting bucket {}:{}", (Object)pr.getName(), (Object)br.getId(), persistMap);
                    }
                    pr.setShutDownAllStatus(3);
                    new UpdateAttributesProcessor(pr).distribute(false);
                    pr.getRegionAdvisor().waitForProfileStatus(3);
                    if (logger.isDebugEnabled()) {
                        logger.debug("shutDownAll: PR {}: all offline_equal profiles received.", (Object)pr.getName());
                    }
                }
                RegionEventImpl event = new RegionEventImpl((Region)pr, Operation.REGION_CLOSE, null, false, (DistributedMember)this.getMyId(), true);
                try {
                    pr.basicDestroyRegion(event, false, false, true);
                }
                catch (CacheWriterException e) {
                    throw new Error(LocalizedStrings.LocalRegion_CACHEWRITEREXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
                }
                catch (TimeoutException e) {
                    throw new Error(LocalizedStrings.LocalRegion_TIMEOUTEXCEPTION_SHOULD_NOT_BE_THROWN_IN_LOCALDESTROYREGION.toLocalizedString(), e);
                }
            }
        }
        catch (CacheClosedException cce) {
            logger.debug("Encounter CacheClosedException when shutDownAll is closing PR: {}:{}", (Object)pr.getFullPath(), (Object)cce.getMessage());
        }
        catch (CancelException ce) {
            logger.debug("Encounter CancelException when shutDownAll is closing PR: {}:{}", (Object)pr.getFullPath(), (Object)ce.getMessage());
        }
        catch (RegionDestroyedException rde) {
            logger.debug("Encounter CacheDestroyedException when shutDownAll is closing PR: {}:{}", (Object)pr.getFullPath(), (Object)rde.getMessage());
        }
        finally {
            if (acquiredLock) {
                pr.releaseDestroyLock();
            }
        }
    }

    private Map<InternalDistributedMember, PersistentMemberID> getSubMapForLiveMembers(PartitionedRegion pr, Set<InternalDistributedMember> membersToPersistOfflineEqual, Map<InternalDistributedMember, PersistentMemberID> bucketMap) {
        if (bucketMap == null) {
            return null;
        }
        HashMap<InternalDistributedMember, PersistentMemberID> persistMap = new HashMap<InternalDistributedMember, PersistentMemberID>();
        for (InternalDistributedMember idm : membersToPersistOfflineEqual) {
            if (!bucketMap.containsKey(idm)) continue;
            persistMap.put(idm, bucketMap.get(idm));
        }
        return persistMap;
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void close(boolean keepalive) {
        this.close("Normal disconnect", null, keepalive, false);
    }

    public void close(String reason, Throwable optionalCause) {
        this.close(reason, optionalCause, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DistributedLockService getPartitionedRegionLockService() {
        Object object = this.prLockServiceLock;
        synchronized (object) {
            block6: {
                this.stopper.checkCancelInProgress(null);
                if (this.prLockService == null) {
                    try {
                        this.prLockService = DLockService.create("__PRLS", this.getDistributedSystem(), true, true, true);
                    }
                    catch (IllegalArgumentException e) {
                        this.prLockService = DistributedLockService.getServiceNamed("__PRLS");
                        if (this.prLockService != null) break block6;
                        throw e;
                    }
                }
            }
            return this.prLockService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedLockService getGatewaySenderLockService() {
        if (this.gatewayLockService == null) {
            Object object = this.gatewayLockServiceLock;
            synchronized (object) {
                block7: {
                    this.stopper.checkCancelInProgress(null);
                    if (this.gatewayLockService == null) {
                        try {
                            this.gatewayLockService = DLockService.create("gatewayEventIdIndexMetaData_lockService", this.getDistributedSystem(), true, true, true);
                        }
                        catch (IllegalArgumentException e) {
                            this.gatewayLockService = DistributedLockService.getServiceNamed("gatewayEventIdIndexMetaData_lockService");
                            if (this.gatewayLockService != null) break block7;
                            throw e;
                        }
                    }
                }
            }
        }
        return this.gatewayLockService;
    }

    private void destroyPartitionedRegionLockService() {
        try {
            DistributedLockService.destroy("__PRLS");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void destroyGatewaySenderLockService() {
        if (DistributedLockService.getServiceNamed("gatewayEventIdIndexMetaData_lockService") != null) {
            try {
                DistributedLockService.destroy("gatewayEventIdIndexMetaData_lockService");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapEvictor getHeapEvictor() {
        Object object = this.heapEvictorLock;
        synchronized (object) {
            this.stopper.checkCancelInProgress(null);
            if (this.heapEvictor == null) {
                this.heapEvictor = new HeapEvictor(this);
            }
            return this.heapEvictor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapEvictor getOffHeapEvictor() {
        Object object = this.offHeapEvictorLock;
        synchronized (object) {
            this.stopper.checkCancelInProgress(null);
            if (this.offHeapEvictor == null) {
                this.offHeapEvictor = new OffHeapEvictor(this);
            }
            return this.offHeapEvictor;
        }
    }

    public PersistentMemberManager getPersistentMemberManager() {
        return this.persistentMemberManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientMetadataService getClientMetadataService() {
        Object object = this.clientMetaDatServiceLock;
        synchronized (object) {
            this.stopper.checkCancelInProgress(null);
            if (this.clientMetadatService == null) {
                this.clientMetadatService = new ClientMetadataService(this);
            }
            return this.clientMetadatService;
        }
    }

    public void close(String reason, Throwable systemFailureCause, boolean keepalive) {
        this.close(reason, systemFailureCause, keepalive, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, Throwable systemFailureCause, boolean keepalive, boolean keepDS) {
        securityService.close();
        if (this.isClosed()) {
            return;
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            if (this.isClosed()) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            this.system.handleResourceEvent(ResourceEvent.CACHE_REMOVE, this);
            if (this.listener != null) {
                this.system.removeResourceListener(this.listener);
                this.listener = null;
            }
            if (systemFailureCause != null) {
                this.forcedDisconnect = systemFailureCause instanceof ForcedDisconnectException;
                this.disconnectCause = this.forcedDisconnect ? new ForcedDisconnectException(reason) : systemFailureCause;
            }
            this.keepAlive = keepalive;
            this.isClosing = true;
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_0_NOW_CLOSING, this));
            if (instance == this) {
                instance = null;
            }
            if (systemFailureCause == null) {
                PartitionedRegion.clearPRIdMap();
            }
            TXStateProxy tx = null;
            try {
                if (this.txMgr != null) {
                    tx = this.txMgr.internalSuspend();
                }
                this.resourceManager.close();
                try {
                    this.resourceAdvisor.close();
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                try {
                    this.jmxAdvisor.close();
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                GatewaySenderAdvisor advisor = null;
                for (GatewaySender sender : this.getAllGatewaySenders()) {
                    try {
                        sender.stop();
                        advisor = ((AbstractGatewaySender)sender).getSenderAdvisor();
                        if (advisor == null) continue;
                        if (isDebugEnabled) {
                            logger.debug("Stopping the GatewaySender advisor");
                        }
                        advisor.close();
                    }
                    catch (CancelException cancelException) {}
                }
                this.destroyGatewaySenderLockService();
                if (this.eventThreadPool != null) {
                    if (isDebugEnabled) {
                        logger.debug("{}: stopping event thread pool...", (Object)this);
                    }
                    this.eventThreadPool.shutdown();
                }
                try {
                    HeapEvictor he;
                    ClientMetadataService cms;
                    block75: {
                        block74: {
                            this.stopServers();
                            this.stopMemcachedServer();
                            this.stopRedisServer();
                            if (this.partitionedRegions != null) {
                                if (isDebugEnabled) {
                                    logger.debug("{}: clearing partitioned regions...", (Object)this);
                                }
                                HashSet<PartitionedRegion> hashSet = this.partitionedRegions;
                                synchronized (hashSet) {
                                    int prSize = -this.partitionedRegions.size();
                                    this.partitionedRegions.clear();
                                    this.getCachePerfStats().incPartitionedRegions(prSize);
                                }
                            }
                            this.prepareDiskStoresForClose();
                            if (pdxInstance == this) {
                                pdxInstance = null;
                            }
                            ArrayList rootRegionValues = null;
                            HashMap prSize = this.rootRegions;
                            synchronized (prSize) {
                                rootRegionValues = new ArrayList(this.rootRegions.values());
                            }
                            Operation op = this.forcedDisconnect ? Operation.FORCED_DISCONNECT : (this.isReconnecting() ? Operation.CACHE_RECONNECT : Operation.CACHE_CLOSE);
                            LocalRegion prRoot = null;
                            for (LocalRegion lr : rootRegionValues) {
                                if (isDebugEnabled) {
                                    logger.debug("{}: processing region {}", (Object)this, (Object)lr.getFullPath());
                                }
                                if ("__PR".equals(lr.getName())) {
                                    prRoot = lr;
                                    continue;
                                }
                                if (lr.getName().contains("_PARALLEL_GATEWAY_SENDER_QUEUE")) continue;
                                if (isDebugEnabled) {
                                    logger.debug("{}: closing region {}...", (Object)this, (Object)lr.getFullPath());
                                }
                                try {
                                    lr.handleCacheClose(op);
                                }
                                catch (Exception e) {
                                    if (!isDebugEnabled && this.forcedDisconnect) continue;
                                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_0_ERROR_CLOSING_REGION_1, new Object[]{this, lr.getFullPath()}), (Throwable)e);
                                }
                            }
                            try {
                                if (isDebugEnabled) {
                                    logger.debug("{}: finishing partitioned region close...", (Object)this);
                                }
                                PartitionedRegion.afterRegionsClosedByCacheClose(this);
                                if (prRoot != null) {
                                    prRoot.handleCacheClose(op);
                                }
                            }
                            catch (CancelException e) {
                                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_0_ERROR_IN_LAST_STAGE_OF_PARTITIONEDREGION_CACHE_CLOSE, this), (Throwable)e);
                            }
                            this.destroyPartitionedRegionLockService();
                            this.closeDiskStores();
                            this.diskMonitor.close();
                            try {
                                if (isDebugEnabled) {
                                    logger.debug("{}: closing CQ service...", (Object)this);
                                }
                                this.cqService.close();
                            }
                            catch (Exception ex) {
                                logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_FAILED_TO_GET_THE_CQSERVICE_TO_CLOSE_DURING_CACHE_CLOSE_1));
                            }
                            PoolManager.close(keepalive);
                            if (isDebugEnabled) {
                                logger.debug("{}: closing reliable message queue...", (Object)this);
                            }
                            try {
                                this.getReliableMessageQueueFactory().close(true);
                            }
                            catch (CancelException e) {
                                if (!isDebugEnabled) break block74;
                                logger.debug("Ignored cancellation while closing reliable message queue", (Throwable)e);
                            }
                        }
                        if (isDebugEnabled) {
                            logger.debug("{}: notifying admins of close...", (Object)this);
                        }
                        try {
                            SystemMemberCacheEventProcessor.send(this, Operation.CACHE_CLOSE);
                        }
                        catch (CancelException e) {
                            if (!logger.isDebugEnabled()) break block75;
                            logger.debug("Ignored cancellation while notifying admins");
                        }
                    }
                    if (isDebugEnabled) {
                        logger.debug("{}: stopping destroyed entries processor...", (Object)this);
                    }
                    this.tombstoneService.stop();
                    DM dm = null;
                    try {
                        dm = this.system.getDistributionManager();
                        dm.removeMembershipListener(this.txMgr);
                    }
                    catch (CancelException prRoot) {
                        // empty catch block
                    }
                    if (dm != null) {
                        if (isDebugEnabled) {
                            logger.debug("{}: sending CloseCache to peers...", (Object)this);
                        }
                        Set otherMembers = dm.getOtherDistributionManagerIds();
                        ReplyProcessor21 processor = new ReplyProcessor21(this.system, (Collection)otherMembers);
                        CloseCacheMessage msg = new CloseCacheMessage();
                        msg.setRecipients(otherMembers);
                        msg.setProcessorId(processor.getProcessorId());
                        dm.putOutgoing(msg);
                        try {
                            processor.waitForReplies();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ReplyException replyException) {
                            // empty catch block
                        }
                    }
                    if ((cms = this.clientMetadatService) != null) {
                        cms.close();
                    }
                    if ((he = this.heapEvictor) != null) {
                        he.close();
                    }
                }
                catch (CancelException e) {
                    this.closeDiskStores();
                }
                try {
                    this.cqService.close();
                }
                catch (Exception ex) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCache_FAILED_TO_GET_THE_CQSERVICE_TO_CLOSE_DURING_CACHE_CLOSE_2));
                }
                this.cachePerfStats.close();
                TXLockService.destroyServices();
                EventTracker.stopTrackerServices(this);
                Object ex = this.ccpTimerMutex;
                synchronized (ex) {
                    if (this.ccpTimer != null) {
                        this.ccpTimer.cancel();
                    }
                }
                this.expirationScheduler.cancel();
                if (this.queryMonitor != null) {
                    this.queryMonitor.stopMonitoring();
                }
                this.stopDiskStoreTaskPool();
            }
            finally {
                if (this.txMgr != null) {
                    this.txMgr.close();
                }
                ((DynamicRegionFactoryImpl)DynamicRegionFactory.get()).close();
                if (this.txMgr != null) {
                    this.txMgr.resume(tx);
                }
                TXCommitMessage.getTracker().clearForCacheClose();
            }
            TransactionManagerImpl.refresh();
            if (!keepDS && !this.DISABLE_DISCONNECT_DS_ON_CACHE_CLOSE) {
                this.system.disconnect();
            }
            TypeRegistry.close();
            TypeRegistry.setPdxSerializer(null);
            for (CacheLifecycleListener listener : cacheLifecycleListeners) {
                listener.cacheClosed(this);
            }
            this.stopRestAgentServer();
            SequenceLoggerImpl.signalCacheClose();
            SystemFailure.signalCacheClose();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isReconnecting() {
        return this.system.isReconnecting();
    }

    @Override
    public boolean waitUntilReconnected(long time, TimeUnit units) throws InterruptedException {
        boolean systemReconnected = this.system.waitUntilReconnected(time, units);
        if (!systemReconnected) {
            return false;
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        return cache != null && cache.isInitialized();
    }

    @Override
    public void stopReconnecting() {
        this.system.stopReconnecting();
    }

    @Override
    public Cache getReconnectedCache() {
        GemFireCacheImpl c = GemFireCacheImpl.getInstance();
        if (c == null) {
            return null;
        }
        if (c == this || !c.isInitialized()) {
            c = null;
        }
        return c;
    }

    private void stopMemcachedServer() {
        if (this.memcachedServer != null) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCacheImpl_MEMCACHED_SERVER_ON_PORT_0_IS_SHUTTING_DOWN, new Object[]{this.system.getConfig().getMemcachedPort()}));
            this.memcachedServer.shutdown();
        }
    }

    private void stopRedisServer() {
        if (this.redisServer != null) {
            this.redisServer.shutdown();
        }
    }

    private void stopRestAgentServer() {
        if (this.restAgent != null) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.GemFireCacheImpl_REST_SERVER_ON_PORT_0_IS_SHUTTING_DOWN, new Object[]{this.system.getConfig().getHttpServicePort()}));
            this.restAgent.stop();
        }
    }

    private void prepareDiskStoresForClose() {
        String pdxDSName = TypeRegistry.getPdxDiskStoreName(this);
        DiskStoreImpl pdxdsi = null;
        for (DiskStoreImpl dsi : this.diskStores.values()) {
            if (dsi.getName().equals(pdxDSName)) {
                pdxdsi = dsi;
                continue;
            }
            dsi.prepareForClose();
        }
        if (pdxdsi != null) {
            pdxdsi.prepareForClose();
        }
    }

    private void createDiskStoreTaskPool() {
        int MAXT = DiskStoreImpl.MAX_CONCURRENT_COMPACTIONS;
        LoggingThreadGroup compactThreadGroup = LoggingThreadGroup.createThreadGroup("Oplog Compactor Thread Group", logger);
        ThreadFactory compactThreadFactory = GemfireCacheHelper.CreateThreadFactory(compactThreadGroup, "Idle OplogCompactor");
        this.diskStoreTaskPool = new ThreadPoolExecutor(MAXT, MAXT, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), compactThreadFactory);
    }

    public void addDiskStore(DiskStoreImpl dsi) {
        this.diskStores.put(dsi.getName(), dsi);
        if (!dsi.isOffline()) {
            this.getDiskStoreMonitor().addDiskStore(dsi);
        }
    }

    public void removeDiskStore(DiskStoreImpl dsi) {
        this.diskStores.remove(dsi.getName());
        this.regionOwnedDiskStores.remove(dsi.getName());
        if (!dsi.getOwnedByRegion()) {
            this.system.handleResourceEvent(ResourceEvent.DISKSTORE_REMOVE, dsi);
        }
    }

    public void addRegionOwnedDiskStore(DiskStoreImpl dsi) {
        this.regionOwnedDiskStores.put(dsi.getName(), dsi);
        if (!dsi.isOffline()) {
            this.getDiskStoreMonitor().addDiskStore(dsi);
        }
    }

    public void closeDiskStores() {
        Iterator it = this.diskStores.values().iterator();
        while (it.hasNext()) {
            try {
                DiskStoreImpl dsi = (DiskStoreImpl)it.next();
                if (logger.isDebugEnabled()) {
                    logger.debug("closing {}", (Object)dsi);
                }
                dsi.close();
                this.system.handleResourceEvent(ResourceEvent.DISKSTORE_REMOVE, dsi);
            }
            catch (Exception e) {
                logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.Disk_Store_Exception_During_Cache_Close), (Throwable)e);
            }
            it.remove();
        }
    }

    public static void setDefaultDiskStoreName(String dsName) {
        DEFAULT_DS_NAME = dsName;
    }

    public static void unsetDefaultDiskStoreName() {
        DEFAULT_DS_NAME = "DEFAULT";
    }

    public static String getDefaultDiskStoreName() {
        return DEFAULT_DS_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskStoreImpl getOrCreateDefaultDiskStore() {
        DiskStoreImpl result = (DiskStoreImpl)this.findDiskStore(null);
        if (result == null) {
            GemFireCacheImpl gemFireCacheImpl = this;
            synchronized (gemFireCacheImpl) {
                result = (DiskStoreImpl)this.findDiskStore(null);
                if (result == null) {
                    result = (DiskStoreImpl)this.createDiskStoreFactory().create(DEFAULT_DS_NAME);
                }
            }
        }
        return result;
    }

    @Override
    public DiskStore findDiskStore(String name) {
        if (name == null) {
            name = DEFAULT_DS_NAME;
        }
        return (DiskStore)this.diskStores.get(name);
    }

    @Override
    public Collection<DiskStoreImpl> listDiskStores() {
        return Collections.unmodifiableCollection(this.diskStores.values());
    }

    @Override
    public Collection<DiskStoreImpl> listDiskStoresIncludingDefault() {
        return Collections.unmodifiableCollection(this.listDiskStores());
    }

    @Override
    public Collection<DiskStoreImpl> listDiskStoresIncludingRegionOwned() {
        HashSet<DiskStoreImpl> allDiskStores = new HashSet<DiskStoreImpl>();
        allDiskStores.addAll(this.diskStores.values());
        allDiskStores.addAll(this.regionOwnedDiskStores.values());
        return allDiskStores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeDiskStoreTask(DiskStoreTask r) {
        AtomicBoolean atomicBoolean = this.diskStoreTaskSync;
        synchronized (atomicBoolean) {
            block7: {
                if (!this.diskStoreTaskSync.get()) {
                    if (this.diskStoreTaskPool == null) {
                        this.createDiskStoreTaskPool();
                    }
                    try {
                        this.diskStoreTaskPool.execute(r);
                        return true;
                    }
                    catch (RejectedExecutionException ex) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug("Ignored compact schedule during shutdown", (Throwable)ex);
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDiskStoreTaskPool() {
        AtomicBoolean atomicBoolean = this.diskStoreTaskSync;
        synchronized (atomicBoolean) {
            this.diskStoreTaskSync.set(true);
            if (this.diskStoreTaskPool != null) {
                List<Runnable> l = this.diskStoreTaskPool.shutdownNow();
                for (Runnable runnable : l) {
                    if (!(l instanceof DiskStoreTask)) continue;
                    ((DiskStoreTask)((Object)l)).taskCancelled();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopGatewaySenders(boolean byShutdownAll) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        int cnt = 0;
        this.closingGatewaySendersByShutdownAll = byShutdownAll;
        Object object = this.allGatewaySendersLock;
        synchronized (object) {
            GatewaySenderAdvisor advisor = null;
            for (GatewaySender sender : this.allGatewaySenders) {
                if (isDebugEnabled) {
                    logger.debug("{}: stopping gateway sender {}", (Object)this, (Object)sender);
                }
                try {
                    sender.stop();
                    advisor = ((AbstractGatewaySender)sender).getSenderAdvisor();
                    if (advisor != null) {
                        if (isDebugEnabled) {
                            logger.debug("Stopping the GatewaySender advisor");
                        }
                        advisor.close();
                    }
                    ++cnt;
                }
                catch (CancelException e) {
                    if (!isDebugEnabled) continue;
                    logger.debug("Ignored cache closure while closing sender {}", (Object)sender, (Object)e);
                }
            }
        }
        this.destroyGatewaySenderLockService();
        if (isDebugEnabled) {
            logger.debug("{}: finished stopping {} gateway sender(s), total is {}", (Object)this, (Object)cnt, (Object)this.allGatewaySenders.size());
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopGatewayReceivers(boolean byShutdownAll) {
        int cnt = 0;
        this.closingGatewayReceiversByShutdownAll = byShutdownAll;
        Object object = this.allGatewayReceiversLock;
        synchronized (object) {
            for (GatewayReceiver receiver : this.allGatewayReceivers) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: stopping gateway receiver {}", (Object)this, (Object)receiver);
                }
                try {
                    receiver.stop();
                    ++cnt;
                }
                catch (CancelException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Ignored cache closure while closing receiver {}", (Object)receiver, (Object)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: finished stopping {} gateway receiver(s), total is {}", (Object)this, (Object)cnt, (Object)this.allGatewayReceivers.size());
        }
        return cnt;
    }

    void stopServers() {
        block14: {
            boolean isDebugEnabled;
            block13: {
                isDebugEnabled = logger.isDebugEnabled();
                if (isDebugEnabled) {
                    logger.debug("{}: stopping cache servers...", (Object)this);
                }
                boolean stoppedCacheServer = false;
                for (CacheServerImpl bridge : this.allCacheServers) {
                    block12: {
                        if (isDebugEnabled) {
                            logger.debug("stopping bridge {}", (Object)bridge);
                        }
                        try {
                            bridge.stop();
                        }
                        catch (CancelException e) {
                            if (!isDebugEnabled) break block12;
                            logger.debug("Ignored cache closure while closing bridge {}", (Object)bridge, (Object)e);
                        }
                    }
                    this.allCacheServers.remove(bridge);
                    stoppedCacheServer = true;
                }
                if (stoppedCacheServer) {
                    ServerConnection.emptyCommBufferPool();
                }
                if (isDebugEnabled) {
                    logger.debug("{}: stopping HA services...", (Object)this);
                }
                try {
                    HARegionQueue.stopHAServices();
                }
                catch (CancelException e) {
                    if (!isDebugEnabled) break block13;
                    logger.debug("Ignored cache closure while closing HA services", (Throwable)e);
                }
            }
            if (isDebugEnabled) {
                logger.debug("{}: stopping client health monitor...", (Object)this);
            }
            try {
                ClientHealthMonitor.shutdownInstance();
            }
            catch (CancelException e) {
                if (!isDebugEnabled) break block14;
                logger.debug("Ignored cache closure while closing client health monitor", (Throwable)e);
            }
        }
        ClientProxyMembershipID.resetUniqueIdCounter();
    }

    @Override
    public InternalDistributedSystem getDistributedSystem() {
        return this.system;
    }

    @Override
    public InternalDistributedMember getMyId() {
        return this.system.getDistributedMember();
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return Collections.unmodifiableSet(this.dm.getOtherNormalDistributionManagerIds());
    }

    @Override
    public Set<DistributedMember> getAdminMembers() {
        return this.dm.getAdminMemberSet();
    }

    @Override
    public Set<DistributedMember> getMembers(Region r) {
        if (r instanceof DistributedRegion) {
            DistributedRegion d = (DistributedRegion)r;
            return d.getDistributionAdvisor().adviseCacheOp();
        }
        if (r instanceof PartitionedRegion) {
            PartitionedRegion p = (PartitionedRegion)r;
            return p.getRegionAdvisor().adviseAllPRNodes();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<InetSocketAddress> getCurrentServers() {
        Map<String, Pool> pools = PoolManager.getAll();
        HashSet<InetSocketAddress> result = null;
        for (Pool p : pools.values()) {
            PoolImpl pi = (PoolImpl)p;
            Iterator<ServerLocation> iterator = pi.getCurrentServers().iterator();
            while (iterator.hasNext()) {
                ServerLocation o;
                ServerLocation sl = o = iterator.next();
                if (result == null) {
                    result = new HashSet<InetSocketAddress>();
                }
                result.add(new InetSocketAddress(sl.getHostName(), sl.getPort()));
            }
        }
        if (result == null) {
            return Collections.EMPTY_SET;
        }
        return result;
    }

    @Override
    public LogWriter getLogger() {
        return this.system.getLogWriter();
    }

    @Override
    public LogWriter getSecurityLogger() {
        return this.system.getSecurityLogWriter();
    }

    @Override
    public LogWriterI18n getLoggerI18n() {
        return this.system.getInternalLogWriter();
    }

    @Override
    public LogWriterI18n getSecurityLoggerI18n() {
        return this.system.getSecurityInternalLogWriter();
    }

    public InternalLogWriter getInternalLogWriter() {
        return this.system.getInternalLogWriter();
    }

    public InternalLogWriter getSecurityInternalLogWriter() {
        return this.system.getSecurityInternalLogWriter();
    }

    protected EventTracker.ExpiryTask getEventTrackerTask() {
        return this.recordedEventSweeper;
    }

    @Override
    public CachePerfStats getCachePerfStats() {
        return this.cachePerfStats;
    }

    @Override
    public String getName() {
        return this.system.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Properties> getDeclarableProperties(String className) {
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        Map<Declarable, Properties> map = this.declarablePropertiesMap;
        synchronized (map) {
            for (Map.Entry<Declarable, Properties> entry : this.declarablePropertiesMap.entrySet()) {
                if (!entry.getKey().getClass().getName().equals(className)) continue;
                propertiesList.add(entry.getValue());
            }
        }
        return propertiesList;
    }

    public Properties getDeclarableProperties(Declarable declarable) {
        return this.declarablePropertiesMap.get(declarable);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public int getUpTime() {
        return (int)((System.currentTimeMillis() - this.creationDate.getTime()) / 1000L);
    }

    @Override
    public long cacheTimeMillis() {
        if (this.system != null) {
            return this.system.getClock().cacheTimeMillis();
        }
        return System.currentTimeMillis();
    }

    public Region createVMRegion(String name, RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        return this.createRegion(name, attrs);
    }

    private PoolFactory createDefaultPF() {
        PoolFactory defpf = PoolManager.createFactory();
        try {
            String localHostName = SocketCreator.getHostName(SocketCreator.getLocalHost());
            defpf.addServer(localHostName, 40404);
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException("Could not determine local host name");
        }
        return defpf;
    }

    public void determineDefaultPool() {
        Pool pool;
        block11: {
            block9: {
                Map<String, Pool> pools;
                block12: {
                    block10: {
                        if (!this.isClient()) {
                            throw new UnsupportedOperationException();
                        }
                        pool = null;
                        if (this.clientpf != null) break block9;
                        pools = PoolManager.getAll();
                        if (!pools.isEmpty()) break block10;
                        this.clientpf = this.createDefaultPF();
                        break block11;
                    }
                    if (pools.size() != 1) break block12;
                    pool = pools.values().iterator().next();
                    break block11;
                }
                if (pool != null) break block11;
                PoolFactoryImpl pfi = (PoolFactoryImpl)this.createDefaultPF();
                for (Pool p : pools.values()) {
                    if (!((PoolImpl)p).isCompatible(pfi.getPoolAttributes())) continue;
                    pool = p;
                    break;
                }
                if (pool == null) {
                    this.setDefaultPool(null);
                    return;
                }
                break block11;
            }
            PoolFactoryImpl pfi = (PoolFactoryImpl)this.clientpf;
            if (pfi.getPoolAttributes().locators.isEmpty() && pfi.getPoolAttributes().servers.isEmpty()) {
                try {
                    String localHostName = SocketCreator.getHostName(SocketCreator.getLocalHost());
                    pfi.addServer(localHostName, 40404);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalStateException("Could not determine local host name");
                }
            }
            Map<String, Pool> pools = PoolManager.getAll();
            for (Pool p : pools.values()) {
                if (!((PoolImpl)p).isCompatible(pfi.getPoolAttributes())) continue;
                pool = p;
                break;
            }
        }
        if (pool == null) {
            String poolName = "DEFAULT";
            int count = 1;
            Map<String, Pool> pools = PoolManager.getAll();
            while (pools.containsKey(poolName)) {
                poolName = "DEFAULT" + count;
                ++count;
            }
            pool = this.clientpf.create(poolName);
        }
        this.setDefaultPool(pool);
    }

    public Pool determineDefaultPool(PoolFactory pf) {
        Pool pool = null;
        if (pf == null) {
            Map<String, Pool> pools = PoolManager.getAll();
            if (pools.isEmpty()) {
                throw new IllegalStateException("Since a cache already existed a pool should also exist.");
            }
            if (pools.size() == 1) {
                pool = pools.values().iterator().next();
                if (this.getDefaultPool() != pool) {
                    throw new IllegalStateException("Existing cache's default pool was not the same as the only existing pool");
                }
            } else {
                pool = this.getDefaultPool();
                if (pool == null) {
                    PoolFactoryImpl pfi = (PoolFactoryImpl)this.createDefaultPF();
                    for (Pool p : pools.values()) {
                        if (!((PoolImpl)p).isCompatible(pfi.getPoolAttributes())) continue;
                        pool = p;
                        break;
                    }
                    if (pool == null) {
                        return null;
                    }
                }
            }
        } else {
            PoolImpl defPool;
            PoolFactoryImpl pfi = (PoolFactoryImpl)pf;
            if (pfi.getPoolAttributes().locators.isEmpty() && pfi.getPoolAttributes().servers.isEmpty()) {
                try {
                    String localHostName = SocketCreator.getHostName(SocketCreator.getLocalHost());
                    pfi.addServer(localHostName, 40404);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalStateException("Could not determine local host name");
                }
            }
            if ((defPool = (PoolImpl)this.getDefaultPool()) != null && defPool.isCompatible(pfi.getPoolAttributes())) {
                pool = defPool;
            } else {
                throw new IllegalStateException("Existing cache's default pool was not compatible");
            }
        }
        return pool;
    }

    public Region createRegion(String name, RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        return this.basicCreateRegion(name, attrs);
    }

    public Region basicCreateRegion(String name, RegionAttributes attrs) throws RegionExistsException, TimeoutException {
        try {
            InternalRegionArguments ira = new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null);
            if (attrs instanceof UserSpecifiedRegionAttributes) {
                ira.setIndexes(((UserSpecifiedRegionAttributes)attrs).getIndexes());
            }
            return this.createVMRegion(name, attrs, ira);
        }
        catch (IOException | ClassNotFoundException e) {
            InternalGemFireError assErr = new InternalGemFireError(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString());
            assErr.initCause(e);
            throw assErr;
        }
    }

    /*
     * Exception decompiling
     */
    public <K, V> Region<K, V> createVMRegion(String name, RegionAttributes<K, V> p_attrs, InternalRegionArguments internalRegionArgs) throws RegionExistsException, TimeoutException, IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RegionAttributes invokeRegionBefore(LocalRegion parent, String name, RegionAttributes attrs, InternalRegionArguments internalRegionArgs) {
        for (RegionListener listener : this.regionListeners) {
            attrs = listener.beforeCreate(parent, name, attrs, internalRegionArgs);
        }
        return attrs;
    }

    public void invokeRegionAfter(LocalRegion region) {
        for (RegionListener listener : this.regionListeners) {
            listener.afterCreate(region);
        }
    }

    public final Region getRegion(String path) {
        return this.getRegion(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LocalRegion> getAllRegions() {
        HashSet<LocalRegion> result = new HashSet<LocalRegion>();
        HashMap hashMap = this.rootRegions;
        synchronized (hashMap) {
            for (Object r : this.rootRegions.values()) {
                if (r instanceof PartitionedRegion) {
                    PartitionedRegion p = (PartitionedRegion)r;
                    PartitionedRegionDataStore prds = p.getDataStore();
                    if (prds == null) continue;
                    Set<Map.Entry<Integer, BucketRegion>> bucketEntries = p.getDataStore().getAllLocalBuckets();
                    for (Map.Entry<Integer, BucketRegion> e : bucketEntries) {
                        result.add(e.getValue());
                    }
                    continue;
                }
                if (!(r instanceof LocalRegion)) continue;
                LocalRegion l = (LocalRegion)r;
                result.add(l);
                result.addAll(l.basicSubregions(true));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LocalRegion> getApplicationRegions() {
        HashSet<LocalRegion> result = new HashSet<LocalRegion>();
        HashMap hashMap = this.rootRegions;
        synchronized (hashMap) {
            for (Object r : this.rootRegions.values()) {
                LocalRegion rgn = (LocalRegion)r;
                if (rgn.isSecret() || rgn.isUsedForMetaRegion() || rgn instanceof HARegion || rgn.isUsedForPartitionedRegionAdmin() || rgn.isInternalRegion()) continue;
                result.add(rgn);
                result.addAll(rgn.basicSubregions(true));
            }
        }
        return result;
    }

    void setRegionByPath(String path, LocalRegion r) {
        if (r == null) {
            this.pathToRegion.remove(path);
        } else {
            this.pathToRegion.put(path, r);
        }
    }

    private static void validatePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException(LocalizedStrings.GemFireCache_PATH_CANNOT_BE_NULL.toLocalizedString());
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(LocalizedStrings.GemFireCache_PATH_CANNOT_BE_EMPTY.toLocalizedString());
        }
        if (path.equals("/")) {
            throw new IllegalArgumentException(LocalizedStrings.GemFireCache_PATH_CANNOT_BE_0.toLocalizedString("/"));
        }
    }

    public LocalRegion getRegionByPath(String path) {
        GemFireCacheImpl.validatePath(path);
        LocalRegion result = this.getReinitializingRegion(path);
        if (result != null) {
            return result;
        }
        return (LocalRegion)this.pathToRegion.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public LocalRegion getRegionByPathForProcessing(String path) {
        LocalRegion result = this.getRegionByPath(path);
        if (result != null) return result;
        this.stopper.checkCancelInProgress(null);
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            String[] pathParts = GemFireCacheImpl.parsePath(path);
            HashMap hashMap = this.rootRegions;
            // MONITORENTER : hashMap
            LocalRegion root = (LocalRegion)this.rootRegions.get(pathParts[0]);
            if (root == null) {
                LocalRegion localRegion = null;
                // MONITOREXIT : hashMap
                return localRegion;
            }
            // MONITOREXIT : hashMap
            if (logger.isDebugEnabled()) {
                logger.debug("GemFireCache.getRegion, calling getSubregion on root({}): {}", (Object)pathParts[0], (Object)pathParts[1]);
            }
            result = (LocalRegion)root.getSubregion(pathParts[1], true);
            return result;
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region getRegion(String path, boolean returnDestroyedRegion) {
        LocalRegion root;
        this.stopper.checkCancelInProgress(null);
        LocalRegion result = this.getRegionByPath(path);
        if (result != null) {
            result.waitOnInitialization();
            if (!returnDestroyedRegion && result.isDestroyed()) {
                this.stopper.checkCancelInProgress(null);
                return null;
            }
            return result;
        }
        String[] pathParts = GemFireCacheImpl.parsePath(path);
        HashMap hashMap = this.rootRegions;
        synchronized (hashMap) {
            root = (LocalRegion)this.rootRegions.get(pathParts[0]);
            if (root == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("GemFireCache.getRegion, no region found for {}", (Object)pathParts[0]);
                }
                this.stopper.checkCancelInProgress(null);
                return null;
            }
            if (!returnDestroyedRegion && root.isDestroyed()) {
                this.stopper.checkCancelInProgress(null);
                return null;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("GemFireCache.getRegion, calling getSubregion on root({}): {}", (Object)pathParts[0], (Object)pathParts[1]);
        }
        return root.getSubregion(pathParts[1], returnDestroyedRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Region getPartitionedRegion(String path, boolean returnDestroyedRegion) {
        Region result;
        LocalRegion root;
        this.stopper.checkCancelInProgress(null);
        LocalRegion result2 = this.getRegionByPath(path);
        if (result2 != null) {
            if (!(result2 instanceof PartitionedRegion)) {
                return null;
            }
            return result2;
        }
        String[] pathParts = GemFireCacheImpl.parsePath(path);
        LogWriterI18n logger = this.getLoggerI18n();
        HashMap hashMap = this.rootRegions;
        synchronized (hashMap) {
            root = (LocalRegion)this.rootRegions.get(pathParts[0]);
            if (root == null) {
                if (logger.fineEnabled()) {
                    logger.fine("GemFireCache.getRegion, no region found for " + pathParts[0]);
                }
                this.stopper.checkCancelInProgress(null);
                return null;
            }
            if (!returnDestroyedRegion && root.isDestroyed()) {
                this.stopper.checkCancelInProgress(null);
                return null;
            }
        }
        if (logger.fineEnabled()) {
            logger.fine("GemFireCache.getPartitionedRegion, calling getSubregion on root(" + pathParts[0] + "): " + pathParts[1]);
        }
        if ((result = root.getSubregion(pathParts[1], returnDestroyedRegion)) != null && !(result instanceof PartitionedRegion)) {
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isGlobalRegionInitializing(String fullPath) {
        this.stopper.checkCancelInProgress(null);
        int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
        try {
            boolean bl = this.isGlobalRegionInitializing((LocalRegion)this.getRegion(fullPath));
            return bl;
        }
        finally {
            LocalRegion.setThreadInitLevelRequirement(oldLevel);
        }
    }

    boolean isGlobalRegionInitializing(LocalRegion region) {
        boolean result;
        boolean bl = result = region != null && region.scope.isGlobal() && !region.isInitialized();
        if (result && logger.isDebugEnabled()) {
            logger.debug("GemFireCache.isGlobalRegionInitializing ({})", (Object)region.getFullPath());
        }
        return result;
    }

    public Set rootRegions() {
        return this.rootRegions(false);
    }

    public final Set rootRegions(boolean includePRAdminRegions) {
        return this.rootRegions(includePRAdminRegions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set rootRegions(boolean includePRAdminRegions, boolean waitForInit) {
        this.stopper.checkCancelInProgress(null);
        HashSet<LocalRegion> regions = new HashSet<LocalRegion>();
        HashMap hashMap = this.rootRegions;
        synchronized (hashMap) {
            for (LocalRegion r : this.rootRegions.values()) {
                if (r.isSecret() || r.isUsedForMetaRegion() || r instanceof HARegion || !includePRAdminRegions && (r.isUsedForPartitionedRegionAdmin() || r.isUsedForPartitionedRegionBucket())) continue;
                regions.add(r);
            }
        }
        if (waitForInit) {
            Iterator r = regions.iterator();
            while (r.hasNext()) {
                LocalRegion lr = (LocalRegion)r.next();
                if (lr.checkForInitialization()) continue;
                r.remove();
            }
        }
        return Collections.unmodifiableSet(regions);
    }

    public void cleanupForClient(CacheClientNotifier ccn, ClientProxyMembershipID client) {
        try {
            if (this.isClosed()) {
                return;
            }
            for (LocalRegion lr : this.rootRegions(false, false)) {
                lr.cleanupForClient(ccn, client);
            }
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public boolean isClosed() {
        return this.isClosing;
    }

    @Override
    public int getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public void setLockTimeout(int seconds) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        this.lockTimeout = seconds;
    }

    @Override
    public int getLockLease() {
        return this.lockLease;
    }

    @Override
    public void setLockLease(int seconds) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        this.lockLease = seconds;
    }

    @Override
    public int getSearchTimeout() {
        return this.searchTimeout;
    }

    @Override
    public void setSearchTimeout(int seconds) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        this.searchTimeout = seconds;
    }

    @Override
    public int getMessageSyncInterval() {
        return HARegionQueue.getMessageSyncInterval();
    }

    @Override
    public void setMessageSyncInterval(int seconds) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        if (seconds < 0) {
            throw new IllegalArgumentException(LocalizedStrings.GemFireCache_THE_MESSAGESYNCINTERVAL_PROPERTY_FOR_CACHE_CANNOT_BE_NEGATIVE.toLocalizedString());
        }
        HARegionQueue.setMessageSyncInterval(seconds);
    }

    LocalRegion getReinitializingRegion(String fullPath) {
        Future future = (Future)this.reinitializingRegions.get(fullPath);
        if (future == null) {
            return null;
        }
        try {
            LocalRegion region = (LocalRegion)future.get();
            region.waitOnInitialization();
            if (logger.isDebugEnabled()) {
                logger.debug("Returning manifested future for: {}", (Object)fullPath);
            }
            return region;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            throw new Error(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString(), e);
        }
        catch (CancellationException e) {
            logger.debug("future cancelled, returning null");
            return null;
        }
    }

    void regionReinitializing(String fullPath) {
        FutureResult old = this.reinitializingRegions.putIfAbsent(fullPath, new FutureResult(this.stopper));
        if (old != null) {
            throw new IllegalStateException(LocalizedStrings.GemFireCache_FOUND_AN_EXISTING_REINITALIZING_REGION_NAMED_0.toLocalizedString(fullPath));
        }
    }

    void regionReinitialized(Region region) {
        String regionName = region.getFullPath();
        FutureResult future = (FutureResult)this.reinitializingRegions.get(regionName);
        if (future == null) {
            throw new IllegalStateException(LocalizedStrings.GemFireCache_COULD_NOT_FIND_A_REINITIALIZING_REGION_NAMED_0.toLocalizedString(regionName));
        }
        future.set(region);
        this.unregisterReinitializingRegion(regionName);
    }

    void unregisterReinitializingRegion(String fullPath) {
        this.reinitializingRegions.remove(fullPath);
    }

    final boolean isCopyOnRead() {
        return this.copyOnRead;
    }

    @Override
    public void setCopyOnRead(boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    @Override
    public final boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeRoot(LocalRegion rootRgn) {
        HashMap hashMap = this.rootRegions;
        synchronized (hashMap) {
            String rgnName = rootRgn.getName();
            LocalRegion found = (LocalRegion)this.rootRegions.get(rgnName);
            if (found == rootRgn) {
                LocalRegion previous = (LocalRegion)this.rootRegions.remove(rgnName);
                Assert.assertTrue(previous == rootRgn);
                return true;
            }
            return false;
        }
    }

    static String[] parsePath(String p_path) {
        String path = p_path;
        GemFireCacheImpl.validatePath(path);
        String[] result = new String[2];
        result[1] = "";
        int slashIndex = path.indexOf(47);
        if (slashIndex == 0) {
            path = path.substring(1);
            slashIndex = path.indexOf(47);
        }
        result[0] = path;
        if (slashIndex > 0) {
            result[0] = path.substring(0, slashIndex);
            result[1] = path.substring(slashIndex + 1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCacheLifecycleListener(CacheLifecycleListener l) {
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            cacheLifecycleListeners.add(l);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeCacheLifecycleListener(CacheLifecycleListener l) {
        Class<GemFireCacheImpl> clazz = GemFireCacheImpl.class;
        synchronized (GemFireCacheImpl.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cacheLifecycleListeners.remove(l);
        }
    }

    public void addRegionListener(RegionListener l) {
        this.regionListeners.add(l);
    }

    public void removeRegionListener(RegionListener l) {
        this.regionListeners.remove(l);
    }

    @Override
    public <T extends CacheService> T getService(Class<T> clazz) {
        return (T)this.services.get(clazz);
    }

    @Override
    public CacheTransactionManager getCacheTransactionManager() {
        return this.txMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemTimer getCCPTimer() {
        Object object = this.ccpTimerMutex;
        synchronized (object) {
            if (this.ccpTimer != null) {
                return this.ccpTimer;
            }
            this.ccpTimer = new SystemTimer(this.getDistributedSystem(), true);
            if (this.isClosing) {
                this.ccpTimer.cancel();
            }
            return this.ccpTimer;
        }
    }

    public ExpirationScheduler getExpirationScheduler() {
        return this.expirationScheduler;
    }

    TXManagerImpl getTXMgr() {
        return this.txMgr;
    }

    Executor getEventThreadPool() {
        return this.eventThreadPool;
    }

    @Override
    public CacheServer addCacheServer() {
        return this.addCacheServer(false);
    }

    public CacheServer addCacheServer(boolean isGatewayReceiver) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        CacheServerImpl bridge = new CacheServerImpl(this, isGatewayReceiver);
        this.allCacheServers.add(bridge);
        this.sendAddCacheServerProfileMessage();
        return bridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGatewaySender(GatewaySender sender) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        Object object = this.allGatewaySendersLock;
        synchronized (object) {
            HashSet<GatewaySender> tmp;
            if (!this.allGatewaySenders.contains(sender)) {
                new UpdateAttributesProcessor((AbstractGatewaySender)sender).distribute(true);
                tmp = new HashSet<GatewaySender>(this.allGatewaySenders.size() + 1);
                if (!this.allGatewaySenders.isEmpty()) {
                    tmp.addAll(this.allGatewaySenders);
                }
            } else {
                throw new IllegalStateException(LocalizedStrings.GemFireCache_A_GATEWAYSENDER_WITH_ID_0_IS_ALREADY_DEFINED_IN_THIS_CACHE.toLocalizedString(sender.getId()));
            }
            tmp.add(sender);
            this.allGatewaySenders = Collections.unmodifiableSet(tmp);
        }
        object = this.rootRegions;
        synchronized (object) {
            Set<LocalRegion> appRegions = this.getApplicationRegions();
            for (LocalRegion r : appRegions) {
                Set<String> senders = r.getAllGatewaySenderIds();
                if (!senders.contains(sender.getId()) || sender.isParallel()) continue;
                r.senderCreated();
            }
        }
        if (!sender.isParallel()) {
            Region dynamicMetaRegion = this.getRegion("__DynamicRegions");
            if (dynamicMetaRegion == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(" The dynamic region is null. ");
                }
            } else {
                dynamicMetaRegion.getAttributesMutator().addGatewaySenderId(sender.getId());
            }
        }
        if (sender.getRemoteDSId() >= 0) {
            this.system.handleResourceEvent(ResourceEvent.GATEWAYSENDER_CREATE, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGatewaySender(GatewaySender sender) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        Object object = this.allGatewaySendersLock;
        synchronized (object) {
            if (this.allGatewaySenders.contains(sender)) {
                new UpdateAttributesProcessor((AbstractGatewaySender)sender, true).distribute(true);
                HashSet<GatewaySender> tmp = new HashSet<GatewaySender>(this.allGatewaySenders.size() - 1);
                if (!this.allGatewaySenders.isEmpty()) {
                    tmp.addAll(this.allGatewaySenders);
                }
                tmp.remove(sender);
                this.allGatewaySenders = Collections.unmodifiableSet(tmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGatewayReceiver(GatewayReceiver recv) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        Object object = this.allGatewayReceiversLock;
        synchronized (object) {
            HashSet<GatewayReceiver> tmp = new HashSet<GatewayReceiver>(this.allGatewayReceivers.size() + 1);
            if (!this.allGatewayReceivers.isEmpty()) {
                tmp.addAll(this.allGatewayReceivers);
            }
            tmp.add(recv);
            this.allGatewayReceivers = Collections.unmodifiableSet(tmp);
        }
    }

    public void addAsyncEventQueue(AsyncEventQueueImpl asyncQueue) {
        this.allAsyncEventQueues.add(asyncQueue);
        if (!asyncQueue.isMetaQueue()) {
            this.allVisibleAsyncEventQueues.add(asyncQueue);
        }
        this.system.handleResourceEvent(ResourceEvent.ASYNCEVENTQUEUE_CREATE, asyncQueue);
    }

    @Override
    public Set<GatewaySender> getGatewaySenders() {
        HashSet<GatewaySender> tempSet = new HashSet<GatewaySender>();
        for (GatewaySender sender : this.allGatewaySenders) {
            if (((AbstractGatewaySender)sender).isForInternalUse()) continue;
            tempSet.add(sender);
        }
        return tempSet;
    }

    public Set<GatewaySender> getAllGatewaySenders() {
        return this.allGatewaySenders;
    }

    @Override
    public GatewaySender getGatewaySender(String Id) {
        for (GatewaySender sender : this.allGatewaySenders) {
            if (!sender.getId().equals(Id)) continue;
            return sender;
        }
        return null;
    }

    @Override
    public Set<GatewayReceiver> getGatewayReceivers() {
        return this.allGatewayReceivers;
    }

    @Override
    public Set<AsyncEventQueue> getAsyncEventQueues() {
        return this.allVisibleAsyncEventQueues;
    }

    @Override
    public AsyncEventQueue getAsyncEventQueue(String id) {
        for (AsyncEventQueue asyncEventQueue : this.allAsyncEventQueues) {
            if (!asyncEventQueue.getId().equals(id)) continue;
            return asyncEventQueue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAsyncEventQueue(AsyncEventQueue asyncQueue) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        if (asyncQueue instanceof AsyncEventQueueImpl) {
            this.removeGatewaySender(((AsyncEventQueueImpl)asyncQueue).getSender());
        }
        Object object = this.allGatewaySendersLock;
        synchronized (object) {
            this.allAsyncEventQueues.remove(asyncQueue);
            this.allVisibleAsyncEventQueues.remove(asyncQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayConflictResolver getGatewayConflictResolver() {
        Object object = this.allGatewayHubsLock;
        synchronized (object) {
            return this.gatewayConflictResolver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGatewayConflictResolver(GatewayConflictResolver resolver) {
        Object object = this.allGatewayHubsLock;
        synchronized (object) {
            this.gatewayConflictResolver = resolver;
        }
    }

    @Override
    public List<CacheServer> getCacheServers() {
        List<CacheServer> cacheServersWithoutReceiver = null;
        if (!this.allCacheServers.isEmpty()) {
            for (CacheServerImpl cacheServer : this.allCacheServers) {
                if (cacheServer.isGatewayReceiver()) continue;
                if (cacheServersWithoutReceiver == null) {
                    cacheServersWithoutReceiver = new ArrayList<CacheServer>();
                }
                cacheServersWithoutReceiver.add(cacheServer);
            }
        }
        if (cacheServersWithoutReceiver == null) {
            cacheServersWithoutReceiver = Collections.emptyList();
        }
        return cacheServersWithoutReceiver;
    }

    public List getCacheServersAndGatewayReceiver() {
        return this.allCacheServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requiresPREvents() {
        HashSet<PartitionedRegion> hashSet = this.partitionedRegions;
        synchronized (hashSet) {
            Iterator<PartitionedRegion> it = this.partitionedRegions.iterator();
            while (it.hasNext()) {
                it.next().cacheRequiresNotification();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartitionedRegion(PartitionedRegion r) {
        HashSet<PartitionedRegion> hashSet = this.partitionedRegions;
        synchronized (hashSet) {
            if (r.isDestroyed()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("GemFireCache#addPartitionedRegion did not add destroyed {}", (Object)r);
                }
                return;
            }
            if (this.partitionedRegions.add(r)) {
                this.getCachePerfStats().incPartitionedRegions(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PartitionedRegion> getPartitionedRegions() {
        HashSet<PartitionedRegion> hashSet = this.partitionedRegions;
        synchronized (hashSet) {
            return new HashSet<PartitionedRegion>(this.partitionedRegions);
        }
    }

    private TreeMap<String, Map<String, PartitionedRegion>> getPRTrees() {
        TreeMap<String, Map<String, PartitionedRegion>> prTrees = new TreeMap<String, Map<String, PartitionedRegion>>();
        TreeMap<String, PartitionedRegion> prMap = this.getPartitionedRegionMap();
        boolean hasColocatedRegion = false;
        for (PartitionedRegion pr : prMap.values()) {
            List<PartitionedRegion> childlist = ColocationHelper.getColocatedChildRegions(pr);
            if (childlist == null || childlist.size() <= 0) continue;
            hasColocatedRegion = true;
            break;
        }
        if (hasColocatedRegion) {
            LinkedHashMap<String, PartitionedRegion> orderedPrMap = this.orderByColocation(prMap);
            prTrees.put("ROOT", orderedPrMap);
        } else {
            for (PartitionedRegion pr : prMap.values()) {
                String rootName = pr.getRoot().getName();
                TreeMap<String, PartitionedRegion> prSubMap = (TreeMap<String, PartitionedRegion>)prTrees.get(rootName);
                if (prSubMap == null) {
                    prSubMap = new TreeMap<String, PartitionedRegion>();
                    prTrees.put(rootName, prSubMap);
                }
                prSubMap.put(pr.getFullPath(), pr);
            }
        }
        return prTrees;
    }

    private TreeMap<String, PartitionedRegion> getPartitionedRegionMap() {
        TreeMap<String, PartitionedRegion> prMap = new TreeMap<String, PartitionedRegion>();
        for (Map.Entry entry : this.pathToRegion.entrySet()) {
            String regionName = (String)entry.getKey();
            Region region = (Region)entry.getValue();
            if (!(region instanceof PartitionedRegion)) continue;
            try {
                Region pr = this.getRegion(regionName);
                if (!(pr instanceof PartitionedRegion)) continue;
                prMap.put(regionName, (PartitionedRegion)pr);
            }
            catch (CancelException cancelException) {}
        }
        return prMap;
    }

    private LinkedHashMap<String, PartitionedRegion> orderByColocation(TreeMap<String, PartitionedRegion> prMap) {
        LinkedHashMap<String, PartitionedRegion> orderedPrMap = new LinkedHashMap<String, PartitionedRegion>();
        for (PartitionedRegion pr : prMap.values()) {
            this.addColocatedChildRecursively(orderedPrMap, pr);
        }
        return orderedPrMap;
    }

    private void addColocatedChildRecursively(LinkedHashMap<String, PartitionedRegion> prMap, PartitionedRegion pr) {
        for (PartitionedRegion colocatedRegion : ColocationHelper.getColocatedChildRegions(pr)) {
            this.addColocatedChildRecursively(prMap, colocatedRegion);
        }
        prMap.put(pr.getFullPath(), pr);
    }

    protected boolean requiresNotificationFromPR(PartitionedRegion r) {
        boolean hasSerialSenders = this.hasSerialSenders(r);
        boolean result = hasSerialSenders;
        if (!result) {
            for (CacheServerImpl server : this.allCacheServers) {
                if (server.getNotifyBySubscription()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean hasSerialSenders(PartitionedRegion r) {
        boolean hasSenders = false;
        Set<String> senders = r.getAllGatewaySenderIds();
        for (String sender : senders) {
            GatewaySender gs = this.getGatewaySender(sender);
            if (gs == null || gs.isParallel()) continue;
            hasSenders = true;
            break;
        }
        return hasSenders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartitionedRegion(PartitionedRegion r) {
        HashSet<PartitionedRegion> hashSet = this.partitionedRegions;
        synchronized (hashSet) {
            if (this.partitionedRegions.remove(r)) {
                this.getCachePerfStats().incPartitionedRegions(-1);
            }
        }
    }

    @Override
    public void setIsServer(boolean isServer) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        this.stopper.checkCancelInProgress(null);
        this.isServer = isServer;
    }

    @Override
    public boolean isServer() {
        if (this.isClient()) {
            return false;
        }
        this.stopper.checkCancelInProgress(null);
        if (!this.isServer) {
            return this.allCacheServers.size() > 0;
        }
        return true;
    }

    @Override
    public QueryService getQueryService() {
        if (this.isClient()) {
            Pool p = this.getDefaultPool();
            if (p == null) {
                throw new IllegalStateException("Client cache does not have a default pool. Use getQueryService(String poolName) instead.");
            }
            return p.getQueryService();
        }
        return new DefaultQueryService(this);
    }

    @Override
    public QueryService getLocalQueryService() {
        return new DefaultQueryService(this);
    }

    @Override
    public Context getJNDIContext() {
        return JNDIInvoker.getJNDIContext();
    }

    public TransactionManager getJTATransactionManager() {
        return JNDIInvoker.getTransactionManager();
    }

    public FilterProfile getFilterProfile(String regionName) {
        LocalRegion r = (LocalRegion)this.getRegion(regionName, true);
        if (r != null) {
            return r.getFilterProfile();
        }
        return null;
    }

    public RegionAttributes getRegionAttributes(String id) {
        return (RegionAttributes)this.namedRegionAttributes.get(id);
    }

    public void setRegionAttributes(String id, RegionAttributes attrs) {
        if (attrs == null) {
            this.namedRegionAttributes.remove(id);
        } else {
            this.namedRegionAttributes.put(id, attrs);
        }
    }

    public Map listRegionAttributes() {
        return Collections.unmodifiableMap(this.namedRegionAttributes);
    }

    public static GemFireCacheImpl getXmlCache() {
        return (GemFireCacheImpl)xmlCache.get();
    }

    @Override
    public void loadCacheXml(InputStream stream) throws TimeoutException, CacheWriterException, GatewayException, RegionExistsException {
        Object oldValue = xmlCache.get();
        xmlCache.set(this);
        try {
            CacheXmlParser xml;
            if (xmlParameterizationEnabled) {
                char[] buffer = new char[1024];
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "ISO-8859-1"));
                StringWriter stringWriter = new StringWriter();
                int n = -1;
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)stringWriter).write(buffer, 0, n);
                }
                String replacedXmlString = resolver.processUnresolvableString(((Object)stringWriter).toString());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "ISO-8859-1");
                writer.write(replacedXmlString);
                writer.flush();
                xml = CacheXmlParser.parse(new ByteArrayInputStream(baos.toByteArray()));
            } else {
                xml = CacheXmlParser.parse(stream);
            }
            xml.create(this);
        }
        catch (IOException e) {
            throw new CacheXmlException("Input Stream could not be read for system property substitutions.");
        }
        finally {
            xmlCache.set(oldValue);
        }
    }

    @Override
    public void readyForEvents() {
        PoolManagerImpl.readyForEvents(this.system, false);
    }

    public ReliableMessageQueueFactory getReliableMessageQueueFactory() {
        return this.rmqFactory;
    }

    @Override
    public InternalResourceManager getResourceManager() {
        return this.getResourceManager(true);
    }

    public InternalResourceManager getResourceManager(boolean checkCancellationInProgress) {
        if (checkCancellationInProgress) {
            this.stopper.checkCancelInProgress(null);
        }
        return this.resourceManager;
    }

    public void setBackupFiles(List<File> backups) {
        this.backupFiles = backups;
    }

    public List<File> getBackupFiles() {
        return Collections.unmodifiableList(this.backupFiles);
    }

    public BackupManager startBackup(InternalDistributedMember sender) throws IOException {
        BackupManager manager = new BackupManager(sender, this);
        if (!this.backupManager.compareAndSet(null, manager)) {
            throw new IOException("Backup already in progress");
        }
        manager.start();
        return manager;
    }

    public void clearBackupManager() {
        this.backupManager.set(null);
    }

    public BackupManager getBackupManager() {
        return this.backupManager.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterestCompleted() {
        if (this.isClosing) {
            return;
        }
        int cv = this.registerInterestsInProgress.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("registerInterestCompleted: new value = {}", (Object)cv);
        }
        if (cv == 0) {
            ArrayList<SimpleWaiter> arrayList = this.riWaiters;
            synchronized (arrayList) {
                cv = this.registerInterestsInProgress.get();
                if (cv == 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("registerInterestCompleted: Signalling end of register-interest");
                    }
                    for (SimpleWaiter sw : this.riWaiters) {
                        sw.doNotify();
                    }
                    this.riWaiters.clear();
                }
            }
        }
    }

    public void registerInterestStarted() {
        int newVal = this.registerInterestsInProgress.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("registerInterestsStarted: new count = {}", (Object)newVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRegisterInterestsInProgress() {
        this.getCancelCriterion().checkCancelInProgress(null);
        int count = this.registerInterestsInProgress.get();
        SimpleWaiter sw = null;
        if (count > 0) {
            ArrayList<SimpleWaiter> arrayList = this.riWaiters;
            synchronized (arrayList) {
                count = this.registerInterestsInProgress.get();
                if (count > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("waitForRegisterInterestsInProgress: count ={}", (Object)count);
                    }
                    sw = new SimpleWaiter();
                    this.riWaiters.add(sw);
                }
            }
            if (sw != null) {
                sw.doWait();
            }
        }
    }

    public int waitForSenderQueueFlush(String id, boolean isAsyncListener, int maxWaitTime) {
        RegionQueue rq;
        this.getCancelCriterion().checkCancelInProgress(null);
        AbstractGatewaySender gatewaySender = null;
        if (isAsyncListener) {
            AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)this.getAsyncEventQueue(id);
            if (asyncQueue != null) {
                gatewaySender = (AbstractGatewaySender)asyncQueue.getSender();
            }
        } else {
            gatewaySender = (AbstractGatewaySender)this.getGatewaySender(id);
        }
        long startTime = System.currentTimeMillis();
        if (maxWaitTime <= 0) {
            maxWaitTime = Integer.MAX_VALUE;
        }
        while (gatewaySender != null && gatewaySender.isRunning() && (rq = gatewaySender.getQueue()) != null) {
            if (rq.size() == 0) {
                return 0;
            }
            try {
                Thread.sleep(500L);
                this.getCancelCriterion().checkCancelInProgress(null);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                this.getCancelCriterion().checkCancelInProgress(ie);
            }
            Thread.interrupted();
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (elapsedTime < (long)maxWaitTime * 1000L) continue;
            return (int)(elapsedTime / 1000L);
        }
        return -1;
    }

    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void setQueryMonitorRequiredForResourceManager(boolean required) {
        QUERY_MONITOR_REQUIRED_FOR_RESOURCE_MANAGER = required;
    }

    public boolean isQueryMonitorDisabledForLowMemory() {
        return this.QUERY_MONITOR_DISABLED_FOR_LOW_MEM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryMonitor getQueryMonitor() {
        boolean monitorRequired = !this.QUERY_MONITOR_DISABLED_FOR_LOW_MEM && QUERY_MONITOR_REQUIRED_FOR_RESOURCE_MANAGER != false;
        if (MAX_QUERY_EXECUTION_TIME <= 0 && this.TEST_MAX_QUERY_EXECUTION_TIME <= 0 && !monitorRequired) {
            return null;
        }
        if ((MAX_QUERY_EXECUTION_TIME > 0 || this.TEST_MAX_QUERY_EXECUTION_TIME > 0 || monitorRequired) && this.queryMonitor == null) {
            Object object = this.queryMonitorLock;
            synchronized (object) {
                if (this.queryMonitor == null) {
                    int maxTime;
                    int n = maxTime = MAX_QUERY_EXECUTION_TIME > this.TEST_MAX_QUERY_EXECUTION_TIME ? MAX_QUERY_EXECUTION_TIME : this.TEST_MAX_QUERY_EXECUTION_TIME;
                    if (monitorRequired && maxTime < 0) {
                        maxTime = 18000000;
                    }
                    this.queryMonitor = new QueryMonitor(maxTime);
                    LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("QueryMonitor Thread Group", logger);
                    Thread qmThread = new Thread(group, this.queryMonitor, "QueryMonitor Thread");
                    qmThread.setDaemon(true);
                    qmThread.start();
                    if (logger.isDebugEnabled()) {
                        logger.debug("QueryMonitor thread started.");
                    }
                }
            }
        }
        return this.queryMonitor;
    }

    private void sendAddCacheServerProfileMessage() {
        DM dm = this.getDistributedSystem().getDistributionManager();
        Set otherMembers = dm.getOtherDistributionManagerIds();
        AddCacheServerProfileMessage msg = new AddCacheServerProfileMessage();
        msg.operateOnLocalCache(this);
        if (!otherMembers.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sending add cache server profile message to other members.");
            }
            ReplyProcessor21 rp = new ReplyProcessor21(dm, (Collection)otherMembers);
            msg.setRecipients(otherMembers);
            msg.processorId = rp.getProcessorId();
            dm.putOutgoing(msg);
            try {
                rp.waitForReplies();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public TXManagerImpl getTxManager() {
        return this.txMgr;
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionShortcut atts) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        return new RegionFactoryImpl(this, atts);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory() {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        return new RegionFactoryImpl(this);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(String regionAttributesId) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        return new RegionFactoryImpl(this, regionAttributesId);
    }

    @Override
    public <K, V> RegionFactory<K, V> createRegionFactory(RegionAttributes<K, V> regionAttributes) {
        if (this.isClient()) {
            throw new UnsupportedOperationException("operation is not supported on a client cache");
        }
        return new RegionFactoryImpl(this, regionAttributes);
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(ClientRegionShortcut atts) {
        return new ClientRegionFactoryImpl(this, atts);
    }

    @Override
    public <K, V> ClientRegionFactory<K, V> createClientRegionFactory(String refid) {
        return new ClientRegionFactoryImpl(this, refid);
    }

    @Override
    public QueryService getQueryService(String poolName) {
        Pool p = PoolManager.find(poolName);
        if (p == null) {
            throw new IllegalStateException("Could not find a pool named " + poolName);
        }
        return p.getQueryService();
    }

    @Override
    public RegionService createAuthenticatedView(Properties properties) {
        Pool pool = this.getDefaultPool();
        if (pool == null) {
            throw new IllegalStateException("This cache does not have a default pool");
        }
        return this.createAuthenticatedCacheView(pool, properties);
    }

    @Override
    public RegionService createAuthenticatedView(Properties properties, String poolName) {
        Pool pool = PoolManager.find(poolName);
        if (pool == null) {
            throw new IllegalStateException("Pool " + poolName + " does not exist");
        }
        return this.createAuthenticatedCacheView(pool, properties);
    }

    public RegionService createAuthenticatedCacheView(Pool pool, Properties properties) {
        if (pool.getMultiuserAuthentication()) {
            return ((PoolImpl)pool).createAuthenticatedCacheView(properties);
        }
        throw new IllegalStateException("The pool " + pool.getName() + " did not have multiuser-authentication set to true");
    }

    public static void initializeRegionShortcuts(Cache c) {
        block25: for (RegionShortcut pra : RegionShortcut.values()) {
            switch (pra) {
                case PARTITION: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_REDUNDANT_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case LOCAL: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setScope(Scope.LOCAL);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case LOCAL_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.LOCAL);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case LOCAL_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setScope(Scope.LOCAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case LOCAL_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setScope(Scope.LOCAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case LOCAL_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setScope(Scope.LOCAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setLocalMaxMemory(0);
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case PARTITION_PROXY_REDUNDANT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PARTITION);
                    PartitionAttributesFactory paf = new PartitionAttributesFactory();
                    paf.setLocalMaxMemory(0);
                    paf.setRedundantCopies(1);
                    af.setPartitionAttributes(paf.create());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                case REPLICATE_PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.EMPTY);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block25;
                }
                default: {
                    throw new IllegalStateException("unhandled enum " + (Object)((Object)pra));
                }
            }
        }
    }

    public static void initializeClientRegionShortcuts(Cache c) {
        block11: for (ClientRegionShortcut pra : ClientRegionShortcut.values()) {
            switch (pra) {
                case LOCAL: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block11;
                }
                case LOCAL_PERSISTENT: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block11;
                }
                case LOCAL_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block11;
                }
                case LOCAL_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block11;
                }
                case LOCAL_PERSISTENT_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    c.setRegionAttributes(pra.toString(), af.create());
                    continue block11;
                }
                case PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.EMPTY);
                    UserSpecifiedRegionAttributes ra = (UserSpecifiedRegionAttributes)af.create();
                    ra.requiresPoolName = true;
                    c.setRegionAttributes(pra.toString(), ra);
                    continue block11;
                }
                case CACHING_PROXY: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    UserSpecifiedRegionAttributes ra = (UserSpecifiedRegionAttributes)af.create();
                    ra.requiresPoolName = true;
                    c.setRegionAttributes(pra.toString(), ra);
                    continue block11;
                }
                case CACHING_PROXY_HEAP_LRU: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes());
                    UserSpecifiedRegionAttributes ra = (UserSpecifiedRegionAttributes)af.create();
                    ra.requiresPoolName = true;
                    c.setRegionAttributes(pra.toString(), ra);
                    continue block11;
                }
                case CACHING_PROXY_OVERFLOW: {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.NORMAL);
                    af.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes(null, EvictionAction.OVERFLOW_TO_DISK));
                    UserSpecifiedRegionAttributes ra = (UserSpecifiedRegionAttributes)af.create();
                    ra.requiresPoolName = true;
                    c.setRegionAttributes(pra.toString(), ra);
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("unhandled enum " + (Object)((Object)pra));
                }
            }
        }
    }

    public void beginDestroy(String path, DistributedRegion region) {
        this.regionsInDestroy.putIfAbsent(path, region);
    }

    public void endDestroy(String path, DistributedRegion region) {
        this.regionsInDestroy.remove(path, region);
    }

    public DistributedRegion getRegionInDestroy(String path) {
        return (DistributedRegion)this.regionsInDestroy.get(path);
    }

    public TombstoneService getTombstoneService() {
        return this.tombstoneService;
    }

    public TypeRegistry getPdxRegistry() {
        return this.pdxRegistry;
    }

    @Override
    public boolean getPdxReadSerialized() {
        return this.cacheConfig.pdxReadSerialized;
    }

    @Override
    public PdxSerializer getPdxSerializer() {
        return this.cacheConfig.pdxSerializer;
    }

    @Override
    public String getPdxDiskStore() {
        return this.cacheConfig.pdxDiskStore;
    }

    @Override
    public boolean getPdxPersistent() {
        return this.cacheConfig.pdxPersistent;
    }

    @Override
    public boolean getPdxIgnoreUnreadFields() {
        return this.cacheConfig.pdxIgnoreUnreadFields;
    }

    public boolean getPdxReadSerializedByAnyGemFireServices() {
        return (this.getPdxReadSerialized() || DefaultQuery.getPdxReadSerialized()) && PdxInstanceImpl.getPdxReadSerialized();
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    @Override
    public DM getDistributionManager() {
        return this.dm;
    }

    @Override
    public GatewaySenderFactory createGatewaySenderFactory() {
        return WANServiceProvider.createGatewaySenderFactory(this);
    }

    @Override
    public GatewayReceiverFactory createGatewayReceiverFactory() {
        return WANServiceProvider.createGatewayReceiverFactory(this);
    }

    @Override
    public AsyncEventQueueFactory createAsyncEventQueueFactory() {
        return new AsyncEventQueueFactoryImpl(this);
    }

    @Override
    public DistributionAdvisor getDistributionAdvisor() {
        return this.getResourceAdvisor();
    }

    public ResourceAdvisor getResourceAdvisor() {
        return this.resourceAdvisor;
    }

    @Override
    public DistributionAdvisor.Profile getProfile() {
        return this.resourceAdvisor.createProfile();
    }

    @Override
    public DistributionAdvisee getParentAdvisee() {
        return null;
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.system;
    }

    @Override
    public String getFullPath() {
        return "ResourceManager";
    }

    @Override
    public void fillInProfile(DistributionAdvisor.Profile profile) {
        this.resourceManager.fillInProfile(profile);
    }

    @Override
    public int getSerialNumber() {
        return this.serialNumber;
    }

    public TXEntryStateFactory getTXEntryStateFactory() {
        return this.txEntryStateFactory;
    }

    public void setPdxSerializer(PdxSerializer v) {
        this.cacheConfig.setPdxSerializer(v);
        this.basicSetPdxSerializer(v);
    }

    private void basicSetPdxSerializer(PdxSerializer v) {
        AutoSerializableManager asm;
        TypeRegistry.setPdxSerializer(v);
        if (v instanceof ReflectionBasedAutoSerializer && (asm = (AutoSerializableManager)((ReflectionBasedAutoSerializer)v).getManager()) != null) {
            asm.setRegionService(this);
        }
    }

    public void setReadSerialized(boolean v) {
        this.cacheConfig.setPdxReadSerialized(v);
    }

    public void setDeclarativeCacheConfig(CacheConfig cacheConfig) {
        this.cacheConfig.setDeclarativeConfig(cacheConfig);
        this.basicSetPdxSerializer(this.cacheConfig.getPdxSerializer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeclarableProperties(Map<Declarable, Properties> mapOfNewDeclarableProps) {
        Map<Declarable, Properties> map = this.declarablePropertiesMap;
        synchronized (map) {
            for (Map.Entry<Declarable, Properties> newEntry : mapOfNewDeclarableProps.entrySet()) {
                Class<?> clazz = newEntry.getKey().getClass();
                Declarable matchingDeclarable = null;
                for (Map.Entry<Declarable, Properties> oldEntry : this.declarablePropertiesMap.entrySet()) {
                    if (!clazz.getName().equals(oldEntry.getKey().getClass().getName()) || !newEntry.getValue().equals(oldEntry.getValue()) && (!(newEntry.getKey() instanceof Identifiable) || !((Identifiable)((Object)oldEntry.getKey())).getId().equals(((Identifiable)((Object)newEntry.getKey())).getId()))) continue;
                    matchingDeclarable = oldEntry.getKey();
                    break;
                }
                if (matchingDeclarable != null) {
                    this.declarablePropertiesMap.remove(matchingDeclarable);
                }
                this.declarablePropertiesMap.put(newEntry.getKey(), newEntry.getValue());
            }
        }
    }

    public static boolean isXmlParameterizationEnabled() {
        return xmlParameterizationEnabled;
    }

    public static void setXmlParameterizationEnabled(boolean isXmlParameterizationEnabled) {
        xmlParameterizationEnabled = isXmlParameterizationEnabled;
    }

    @Override
    public Declarable getInitializer() {
        return this.initializer;
    }

    @Override
    public Properties getInitializerProps() {
        return this.initializerProps;
    }

    public void setInitializer(Declarable initializer, Properties initializerProps) {
        this.initializer = initializer;
        this.initializerProps = initializerProps;
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className) {
        return PdxInstanceFactoryImpl.newCreator(className, true);
    }

    public PdxInstanceFactory createPdxInstanceFactory(String className, boolean b) {
        return PdxInstanceFactoryImpl.newCreator(className, b);
    }

    @Override
    public PdxInstance createPdxEnum(String className, String enumName, int enumOrdinal) {
        return PdxInstanceFactoryImpl.createPdxEnum(className, enumName, enumOrdinal, this);
    }

    public JmxManagerAdvisor getJmxManagerAdvisor() {
        return this.jmxAdvisor;
    }

    @Override
    public CacheSnapshotService getSnapshotService() {
        return new CacheSnapshotServiceImpl(this);
    }

    private void startColocatedJmxManagerLocator() {
        InternalLocator loc = InternalLocator.getLocator();
        if (loc != null) {
            loc.startJmxManagerLocationService(this);
        }
    }

    public TemporaryResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    public MemoryAllocator getOffHeapStore() {
        return this.getSystem().getOffHeapStore();
    }

    public DiskStoreMonitor getDiskStoreMonitor() {
        return this.diskMonitor;
    }

    @Override
    public ExtensionPoint<Cache> getExtensionPoint() {
        return this.extensionPoint;
    }

    public static int getClientFunctionTimeout() {
        return clientFunctionTimeout;
    }

    @Override
    public CqService getCqService() {
        return this.cqService;
    }

    static {
        xmlParameterizationEnabled = !Boolean.getBoolean("gemfire.xml.parameterization.disabled");
        DISABLE_AUTO_EVICTION = Boolean.getBoolean("gemfire.disableAutoEviction");
        securityService = SecurityService.getSecurityService();
        String propertyName = "sun.nio.ch.bugLevel";
        String value = System.getProperty(propertyName);
        if (value == null) {
            System.setProperty(propertyName, "");
        }
        testCacheXml = null;
        emergencyClassesLoaded = false;
        shutdownAllPoolSize = Integer.getInteger("gemfire.SHUTDOWN_ALL_POOL_SIZE", -1);
        DEFAULT_DS_NAME = "DEFAULT";
        xmlCache = new ThreadLocal();
    }

    private class SimpleWaiter {
        private boolean notified = false;

        SimpleWaiter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doWait() {
            SimpleWaiter simpleWaiter = this;
            synchronized (simpleWaiter) {
                while (!this.notified) {
                    GemFireCacheImpl.this.getCancelCriterion().checkCancelInProgress(null);
                    boolean interrupted = Thread.interrupted();
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doNotify() {
            SimpleWaiter simpleWaiter = this;
            synchronized (simpleWaiter) {
                this.notified = true;
                this.notifyAll();
            }
        }
    }

    protected class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            String reason = GemFireCacheImpl.this.getDistributedSystem().getCancelCriterion().cancelInProgress();
            if (reason != null) {
                return reason;
            }
            if (GemFireCacheImpl.this.disconnectCause != null) {
                return GemFireCacheImpl.this.disconnectCause.getMessage();
            }
            if (GemFireCacheImpl.this.isClosing) {
                return "The cache is closed.";
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            RuntimeException result = GemFireCacheImpl.this.getDistributedSystem().getCancelCriterion().generateCancelledException(e);
            if (result != null) {
                return result;
            }
            if (GemFireCacheImpl.this.disconnectCause == null) {
                return new CacheClosedException(reason, e);
            }
            if (e == null) {
                return new CacheClosedException(reason, GemFireCacheImpl.this.disconnectCause);
            }
            Throwable nt = e;
            while (nt.getCause() != null) {
                nt = nt.getCause();
            }
            try {
                nt.initCause(GemFireCacheImpl.this.disconnectCause);
                return new CacheClosedException(reason, e);
            }
            catch (IllegalStateException e2) {
                return new CacheClosedException(reason, GemFireCacheImpl.this.disconnectCause);
            }
        }
    }
}

