/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Function;
import org.apache.geode.CopyHelper;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.DeltaSerializationException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.SerializationException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.EntryOperation;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.SerializedCacheValue;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.query.IndexMaintenanceException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexUtils;
import org.apache.geode.cache.util.TimestampedEntryEvent;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ByteArrayDataInput;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Sendable;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.BytesAndBitsForCompactor;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.OffHeapRegionEntry;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RemoteOperationMessage;
import org.apache.geode.internal.cache.RemotePutMessage;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TimestampedEntryEventImpl;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.WrappedCallbackArgument;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PutMessage;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tx.DistTxKeyInfo;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.GatewaySenderEventCallbackArgument;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.Releasable;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.util.ArrayUtils;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class EntryEventImpl
implements EntryEvent,
InternalCacheEvent,
DataSerializableFixedID,
EntryOperation,
Releasable {
    private static final Logger logger = LogService.getLogger();
    public transient LocalRegion region;
    private transient RegionEntry re;
    protected KeyInfo keyInfo;
    protected EventID eventID;
    private Object newValue = null;
    private byte[] cachedSerializedNewValue = null;
    private Object oldValue = null;
    protected short eventFlags = 0;
    protected TXId txId = null;
    protected Operation op;
    private transient EnumListenerEvent eventType;
    protected transient DistributedPutAllOperation putAllOp;
    protected transient DistributedRemoveAllOperation removeAllOp;
    protected DistributedMember distributedMember;
    transient DistributionMessage causedByMessage;
    protected ClientProxyMembershipID context = null;
    private byte[] deltaBytes = null;
    private FilterRoutingInfo.FilterInfo filterInfo;
    protected byte[] newValueBytes;
    private byte[] oldValueBytes;
    protected VersionTag versionTag;
    private transient boolean isEvicted = false;
    private transient boolean isPendingSecondaryExpireDestroy = false;
    public static final Object SUSPECT_TOKEN = new Object();
    private final Object offHeapLock = new Object();
    private static final boolean EVENT_OLD_VALUE = !Boolean.getBoolean("gemfire.disable-event-old-value");
    private transient int newValueBucketSize;
    protected Long tailKey = -1L;
    protected transient long nextRegionVersion = -1L;
    private Thread invokeCallbacksThread;
    transient boolean offHeapOk = true;

    public EntryEventImpl() {
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.eventID = (EventID)DataSerializer.readObject(in);
        Object key = DataSerializer.readObject(in);
        Object value = DataSerializer.readObject(in);
        this.keyInfo = new KeyInfo(key, value, null);
        this.op = Operation.fromOrdinal(in.readByte());
        this.eventFlags = in.readShort();
        this.keyInfo.setCallbackArg(DataSerializer.readObject(in));
        this.txId = (TXId)DataSerializer.readObject(in);
        if (in.readBoolean()) {
            assert (false) : "isDelta should never be true";
        } else if (in.readBoolean()) {
            this.newValueBytes = DataSerializer.readByteArray(in);
            this.cachedSerializedNewValue = this.newValueBytes;
            this.newValue = CachedDeserializableFactory.create(this.newValueBytes);
        } else {
            this.newValue = DataSerializer.readObject(in);
        }
        if (in.readBoolean()) {
            this.oldValueBytes = DataSerializer.readByteArray(in);
            this.oldValue = CachedDeserializableFactory.create(this.oldValueBytes);
        } else {
            this.oldValue = DataSerializer.readObject(in);
        }
        this.distributedMember = DSFIDFactory.readInternalDistributedMember(in);
        this.context = ClientProxyMembershipID.readCanonicalized(in);
        this.tailKey = DataSerializer.readLong(in);
    }

    protected EntryEventImpl(LocalRegion region, Operation op, Object key, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, boolean fromRILocalDestroy) {
        this.region = region;
        this.op = op;
        this.keyInfo = this.region.getKeyInfo(key);
        this.setOriginRemote(originRemote);
        this.setGenerateCallbacks(generateCallbacks);
        this.distributedMember = distributedMember;
        this.setFromRILocalDestroy(fromRILocalDestroy);
    }

    protected EntryEventImpl(LocalRegion region, Operation op, Object key, Object newVal, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, boolean initializeId) {
        this.region = region;
        this.op = op;
        this.keyInfo = this.region.getKeyInfo(key, newVal, callbackArgument);
        if (!Token.isInvalid(newVal)) {
            this.basicSetNewValue(newVal);
        }
        this.txId = this.region.getTXId();
        if (newVal == Token.LOCAL_INVALID) {
            this.setLocalInvalid(true);
        }
        this.setOriginRemote(originRemote);
        this.setGenerateCallbacks(generateCallbacks);
        this.distributedMember = distributedMember;
    }

    protected EntryEventImpl(LocalRegion region, Operation op, Object key, Object newValue, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, EventID eventID) {
        this(region, op, key, newValue, callbackArgument, originRemote, distributedMember, generateCallbacks, true);
        Assert.assertTrue(eventID != null || !(region instanceof PartitionedRegion));
        this.setEventId(eventID);
    }

    public EntryEventImpl(EntryEventImpl other) {
        this(other, true);
    }

    public EntryEventImpl(EntryEventImpl other, boolean setOldValue) {
        this.region = other.region;
        this.eventID = other.eventID;
        this.basicSetNewValue(other.basicGetNewValue());
        this.newValueBytes = other.newValueBytes;
        this.cachedSerializedNewValue = other.cachedSerializedNewValue;
        this.re = other.re;
        if (setOldValue) {
            this.retainAndSetOldValue(other.basicGetOldValue());
            this.oldValueBytes = other.oldValueBytes;
        }
        this.eventFlags = other.eventFlags;
        this.setEventFlag((short)128, false);
        this.txId = other.txId;
        this.op = other.op;
        this.distributedMember = other.distributedMember;
        this.filterInfo = other.filterInfo;
        KeyInfo keyInfo = this.keyInfo = other.keyInfo.isDistKeyInfo() ? new DistTxKeyInfo((DistTxKeyInfo)other.keyInfo) : new KeyInfo(other.keyInfo);
        if (other.getRawCallbackArgument() instanceof GatewaySenderEventCallbackArgument) {
            this.keyInfo.setCallbackArg(new GatewaySenderEventCallbackArgument((GatewaySenderEventCallbackArgument)other.getRawCallbackArgument()));
        }
        this.context = other.context;
        this.deltaBytes = other.deltaBytes;
        this.tailKey = other.tailKey;
        this.versionTag = other.versionTag;
        this.setPossibleDuplicate(other.isPossibleDuplicate());
    }

    public EntryEventImpl(Object key2) {
        this.keyInfo = new KeyInfo(key2, null, null);
    }

    public static EntryEventImpl create(LocalRegion region, Operation op, Object key, Object newValue, Object callbackArgument, boolean originRemote, DistributedMember distributedMember) {
        return EntryEventImpl.create(region, op, key, newValue, callbackArgument, originRemote, distributedMember, true, true);
    }

    public static EntryEventImpl create(LocalRegion region, Operation op, Object key, Object newValue, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks) {
        return EntryEventImpl.create(region, op, key, newValue, callbackArgument, originRemote, distributedMember, generateCallbacks, true);
    }

    public static EntryEventImpl create(LocalRegion region, Operation op, Object key, Object newValue, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, EventID eventID) {
        EntryEventImpl entryEvent = new EntryEventImpl(region, op, key, newValue, callbackArgument, originRemote, distributedMember, generateCallbacks, eventID);
        return entryEvent;
    }

    public static EntryEventImpl create(LocalRegion region, Operation op, Object key, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, boolean fromRILocalDestroy) {
        EntryEventImpl entryEvent = new EntryEventImpl(region, op, key, originRemote, distributedMember, generateCallbacks, fromRILocalDestroy);
        return entryEvent;
    }

    public static EntryEventImpl create(LocalRegion region, Operation op, Object key, Object newVal, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, boolean initializeId) {
        EntryEventImpl entryEvent = new EntryEventImpl(region, op, key, newVal, callbackArgument, originRemote, distributedMember, generateCallbacks, initializeId);
        return entryEvent;
    }

    static EntryEventImpl createPutAllEvent(DistributedPutAllOperation putAllOp, LocalRegion region, Operation entryOp, Object entryKey, Object entryNewValue) {
        EntryEventImpl e;
        if (putAllOp != null) {
            EntryEventImpl event = putAllOp.getBaseEvent();
            if (event.isBridgeEvent()) {
                e = EntryEventImpl.create(region, entryOp, entryKey, entryNewValue, event.getRawCallbackArgument(), false, event.distributedMember, event.isGenerateCallbacks());
                e.setContext(event.getContext());
            } else {
                e = EntryEventImpl.create(region, entryOp, entryKey, entryNewValue, event.getCallbackArgument(), false, region.getMyId(), event.isGenerateCallbacks());
            }
        } else {
            e = EntryEventImpl.create(region, entryOp, entryKey, entryNewValue, null, false, region.getMyId(), true);
        }
        e.putAllOp = putAllOp;
        return e;
    }

    protected static EntryEventImpl createRemoveAllEvent(DistributedRemoveAllOperation op, LocalRegion region, Object entryKey) {
        EntryEventImpl e;
        Operation entryOp = Operation.REMOVEALL_DESTROY;
        if (op != null) {
            EntryEventImpl event = op.getBaseEvent();
            if (event.isBridgeEvent()) {
                e = EntryEventImpl.create(region, entryOp, entryKey, null, event.getRawCallbackArgument(), false, event.distributedMember, event.isGenerateCallbacks());
                e.setContext(event.getContext());
            } else {
                e = EntryEventImpl.create(region, entryOp, entryKey, null, event.getCallbackArgument(), false, region.getMyId(), event.isGenerateCallbacks());
            }
        } else {
            e = EntryEventImpl.create(region, entryOp, entryKey, null, null, false, region.getMyId(), true);
        }
        e.removeAllOp = op;
        return e;
    }

    public boolean isBulkOpInProgress() {
        return this.getPutAllOperation() != null || this.getRemoveAllOperation() != null;
    }

    public DistributedPutAllOperation getPutAllOperation() {
        return this.putAllOp;
    }

    public DistributedPutAllOperation setPutAllOperation(DistributedPutAllOperation nv) {
        DistributedPutAllOperation result = this.putAllOp;
        if (nv != null && nv.getBaseEvent() != null) {
            this.setCallbackArgument(nv.getBaseEvent().getCallbackArgument());
        }
        this.putAllOp = nv;
        return result;
    }

    public DistributedRemoveAllOperation getRemoveAllOperation() {
        return this.removeAllOp;
    }

    public DistributedRemoveAllOperation setRemoveAllOperation(DistributedRemoveAllOperation nv) {
        DistributedRemoveAllOperation result = this.removeAllOp;
        if (nv != null && nv.getBaseEvent() != null) {
            this.setCallbackArgument(nv.getBaseEvent().getCallbackArgument());
        }
        this.removeAllOp = nv;
        return result;
    }

    private final boolean testEventFlag(short mask) {
        return EventFlags.isSet(this.eventFlags, mask);
    }

    private final void setEventFlag(short mask, boolean on) {
        this.eventFlags = EventFlags.set(this.eventFlags, mask, on);
    }

    @Override
    public DistributedMember getDistributedMember() {
        return this.distributedMember;
    }

    public void setOriginRemote(boolean b) {
        this.setEventFlag((short)1, b);
    }

    public void setLocalInvalid(boolean b) {
        this.setEventFlag((short)2, b);
    }

    void setGenerateCallbacks(boolean b) {
        this.setEventFlag((short)4, b);
    }

    public void setInvokePRCallbacks(boolean b) {
        this.setEventFlag((short)16, b);
    }

    public boolean getInvokePRCallbacks() {
        return this.testEventFlag((short)16);
    }

    public boolean getInhibitDistribution() {
        return this.testEventFlag((short)4096);
    }

    public void setInhibitDistribution(boolean b) {
        this.setEventFlag((short)4096, b);
    }

    public boolean getIsRedestroyedEntry() {
        return this.testEventFlag((short)8192);
    }

    public void setIsRedestroyedEntry(boolean b) {
        this.setEventFlag((short)8192, b);
    }

    public void isConcurrencyConflict(boolean b) {
        this.setEventFlag((short)32, b);
    }

    public boolean isConcurrencyConflict() {
        return this.testEventFlag((short)32);
    }

    public void setCausedByMessage(DistributionMessage msg) {
        this.causedByMessage = msg;
    }

    public PartitionMessage getPartitionMessage() {
        if (this.causedByMessage != null && this.causedByMessage instanceof PartitionMessage) {
            return (PartitionMessage)this.causedByMessage;
        }
        return null;
    }

    public RemoteOperationMessage getRemoteOperationMessage() {
        if (this.causedByMessage != null && this.causedByMessage instanceof RemoteOperationMessage) {
            return (RemoteOperationMessage)this.causedByMessage;
        }
        return null;
    }

    @Override
    public boolean isLocalLoad() {
        return this.op.isLocalLoad();
    }

    @Override
    public boolean isNetSearch() {
        return this.op.isNetSearch();
    }

    @Override
    public boolean isNetLoad() {
        return this.op.isNetLoad();
    }

    @Override
    public boolean isDistributed() {
        return this.op.isDistributed();
    }

    @Override
    public boolean isExpiration() {
        return this.op.isExpiration();
    }

    public boolean isEviction() {
        return this.op.isEviction();
    }

    public final void setEvicted() {
        this.isEvicted = true;
    }

    public final boolean isEvicted() {
        return this.isEvicted;
    }

    public final boolean isPendingSecondaryExpireDestroy() {
        return this.isPendingSecondaryExpireDestroy;
    }

    public final void setPendingSecondaryExpireDestroy(boolean value) {
        this.isPendingSecondaryExpireDestroy = value;
    }

    @Override
    public boolean isOriginRemote() {
        return this.testEventFlag((short)1);
    }

    public boolean isFromWANAndVersioned() {
        return this.versionTag != null && this.versionTag.isGatewayTag();
    }

    public boolean isFromBridgeAndVersioned() {
        return this.context != null && this.versionTag != null;
    }

    @Override
    public boolean isGenerateCallbacks() {
        return this.testEventFlag((short)4);
    }

    public void setNewEventId(DistributedSystem sys) {
        Assert.assertTrue(this.eventID == null, "Double setting event id");
        EventID newID = new EventID(sys);
        if (this.eventID != null && logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
            logger.trace(LogMarker.BRIDGE_SERVER, "Replacing event ID with {} in event {}", (Object)newID, (Object)this);
        }
        this.eventID = newID;
    }

    public void reserveNewEventId(DistributedSystem sys, int count) {
        Assert.assertTrue(this.eventID == null, "Double setting event id");
        this.eventID = new EventID(sys);
        if (count > 1) {
            this.eventID.reserveSequenceId(count - 1);
        }
    }

    public void setEventId(EventID id) {
        this.eventID = id;
    }

    @Override
    public final EventID getEventId() {
        return this.eventID;
    }

    @Override
    public boolean isBridgeEvent() {
        return this.hasClientOrigin();
    }

    @Override
    public boolean hasClientOrigin() {
        return this.getContext() != null;
    }

    public void setContext(ClientProxyMembershipID contx) {
        Assert.assertTrue(contx != null);
        this.context = contx;
    }

    @Override
    public ClientProxyMembershipID getContext() {
        return this.context;
    }

    boolean isLocalInvalid() {
        return this.testEventFlag((short)2);
    }

    public Object getKey() {
        return this.keyInfo.getKey();
    }

    public final Object getOldValue() {
        try {
            if (this.isOriginRemote() && this.region.isProxy()) {
                return null;
            }
            Object ov = this.basicGetOldValue();
            if (ov == null) {
                return null;
            }
            if (ov == Token.NOT_AVAILABLE) {
                return AbstractRegion.handleNotAvailable(ov);
            }
            boolean doCopyOnRead = this.getRegion().isCopyOnRead();
            if (ov != null) {
                if (ov instanceof CachedDeserializable) {
                    return this.callWithOffHeapLock((CachedDeserializable)ov, oldValueCD -> {
                        if (doCopyOnRead) {
                            return oldValueCD.getDeserializedWritableCopy(this.region, this.re);
                        }
                        return oldValueCD.getDeserializedValue(this.region, this.re);
                    });
                }
                if (doCopyOnRead) {
                    return CopyHelper.copy(ov);
                }
                return ov;
            }
            return null;
        }
        catch (IllegalArgumentException i) {
            IllegalArgumentException iae = new IllegalArgumentException(LocalizedStrings.DONT_RELEASE.toLocalizedString("Error while deserializing value for key=" + this.getKey()));
            iae.initCause(i);
            throw iae;
        }
    }

    public final Object getRawNewValueAsHeapObject() {
        Object result = this.basicGetNewValue();
        if (this.mayHaveOffHeapReferences()) {
            result = OffHeapHelper.copyIfNeeded(result);
        }
        return result;
    }

    public final Object getRawNewValue() {
        return this.basicGetNewValue();
    }

    public Object getValue() {
        return this.basicGetNewValue();
    }

    protected void basicSetNewValue(Object v) {
        if (v == this.newValue) {
            return;
        }
        if (this.mayHaveOffHeapReferences()) {
            if (this.offHeapOk) {
                OffHeapHelper.releaseAndTrackOwner(this.newValue, this);
            }
            if (StoredObject.isOffHeapReference(v)) {
                ReferenceCountHelper.setReferenceCountOwner(this);
                if (!((StoredObject)v).retain()) {
                    ReferenceCountHelper.setReferenceCountOwner(null);
                    this.newValue = null;
                    return;
                }
                ReferenceCountHelper.setReferenceCountOwner(null);
            }
        }
        this.newValue = v;
        this.cachedSerializedNewValue = null;
    }

    protected final Object basicGetNewValue() {
        Object result = this.newValue;
        if (!this.offHeapOk && this.isOffHeapReference(result)) {
            throw new IllegalStateException("Attempt to access off heap value after the EntryEvent was released.");
        }
        return result;
    }

    private boolean isOffHeapReference(Object ref) {
        return this.mayHaveOffHeapReferences() && StoredObject.isOffHeapReference(ref);
    }

    private void basicSetOldValue(Object v) {
        Object curOldValue = this.oldValue;
        if (v == curOldValue) {
            return;
        }
        if (this.offHeapOk && this.mayHaveOffHeapReferences()) {
            if (ReferenceCountHelper.trackReferenceCounts()) {
                OffHeapHelper.releaseAndTrackOwner(curOldValue, new OldValueOwner());
            } else {
                OffHeapHelper.release(curOldValue);
            }
        }
        this.oldValue = v;
    }

    private void retainAndSetOldValue(Object v) {
        if (v == this.oldValue) {
            return;
        }
        if (this.isOffHeapReference(v)) {
            StoredObject so = (StoredObject)v;
            if (ReferenceCountHelper.trackReferenceCounts()) {
                ReferenceCountHelper.setReferenceCountOwner(new OldValueOwner());
                boolean couldNotRetain = !so.retain();
                ReferenceCountHelper.setReferenceCountOwner(null);
                if (couldNotRetain) {
                    this.oldValue = null;
                    return;
                }
            } else if (!so.retain()) {
                this.oldValue = null;
                return;
            }
        }
        this.basicSetOldValue(v);
    }

    private Object basicGetOldValue() {
        Object result = this.oldValue;
        if (!this.offHeapOk && this.isOffHeapReference(result)) {
            throw new IllegalStateException("Attempt to access off heap value after the EntryEvent was released.");
        }
        return result;
    }

    public final Object getRawOldValueAsHeapObject() {
        Object result = this.basicGetOldValue();
        if (this.mayHaveOffHeapReferences()) {
            result = OffHeapHelper.copyIfNeeded(result);
        }
        return result;
    }

    public final Object getRawOldValue() {
        return this.basicGetOldValue();
    }

    public final Object getOldValueAsOffHeapDeserializedOrRaw() {
        Object result = this.basicGetOldValue();
        if (this.mayHaveOffHeapReferences() && result instanceof StoredObject) {
            result = ((StoredObject)result).getDeserializedForReading();
        }
        return AbstractRegion.handleNotAvailable(result);
    }

    protected boolean isRegionCopyOnRead() {
        return this.getRegion().isCopyOnRead();
    }

    public final Object getNewValue() {
        boolean doCopyOnRead = this.getRegion().isCopyOnRead();
        Object nv = this.basicGetNewValue();
        if (nv != null) {
            if (nv == Token.NOT_AVAILABLE) {
                return AbstractRegion.handleNotAvailable(nv);
            }
            if (nv instanceof CachedDeserializable) {
                return this.callWithOffHeapLock((CachedDeserializable)nv, newValueCD -> {
                    Object v = null;
                    v = doCopyOnRead ? newValueCD.getDeserializedWritableCopy(this.region, this.re) : newValueCD.getDeserializedValue(this.region, this.re);
                    assert (!(v instanceof CachedDeserializable)) : "for key " + this.getKey() + " found nested CachedDeserializable";
                    return v;
                });
            }
            if (doCopyOnRead) {
                return CopyHelper.copy(nv);
            }
            return nv;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R> R callWithOffHeapLock(T value, Function<T, R> function) {
        if (this.isOffHeapReference(value)) {
            Object object = this.offHeapLock;
            synchronized (object) {
                if (!this.offHeapOk) {
                    throw new IllegalStateException("Attempt to access off heap value after the EntryEvent was released.");
                }
                return function.apply(value);
            }
        }
        return function.apply(value);
    }

    public final String getNewValueStringForm() {
        return StringUtils.forceToString(this.basicGetNewValue());
    }

    public final String getOldValueStringForm() {
        return StringUtils.forceToString(this.basicGetOldValue());
    }

    public final void setNewValue(Object obj) {
        this.basicSetNewValue(obj);
    }

    @Override
    public TransactionId getTransactionId() {
        return this.txId;
    }

    public void setTransactionId(TransactionId txId) {
        this.txId = (TXId)txId;
    }

    @Override
    public boolean isLoad() {
        return this.op.isLoad();
    }

    public void setRegion(LocalRegion r) {
        this.region = r;
    }

    public final LocalRegion getRegion() {
        return this.region;
    }

    @Override
    public Operation getOperation() {
        return this.op;
    }

    public void setOperation(Operation op) {
        this.op = op;
        PartitionMessage prm = this.getPartitionMessage();
        if (prm != null) {
            prm.setOperation(this.op);
        }
    }

    @Override
    public Object getCallbackArgument() {
        Object result = this.keyInfo.getCallbackArg();
        while (result instanceof WrappedCallbackArgument) {
            WrappedCallbackArgument wca = (WrappedCallbackArgument)result;
            result = wca.getOriginalCallbackArg();
        }
        if (result == Token.NOT_AVAILABLE) {
            result = AbstractRegion.handleNotAvailable(result);
        }
        return result;
    }

    @Override
    public boolean isCallbackArgumentAvailable() {
        return this.getRawCallbackArgument() != Token.NOT_AVAILABLE;
    }

    public Object getRawCallbackArgument() {
        return this.keyInfo.getCallbackArg();
    }

    public void setRawCallbackArgument(Object newCallbackArgument) {
        this.keyInfo.setCallbackArg(newCallbackArgument);
    }

    public void setCallbackArgument(Object newCallbackArgument) {
        if (this.keyInfo.getCallbackArg() instanceof WrappedCallbackArgument) {
            ((WrappedCallbackArgument)this.keyInfo.getCallbackArg()).setOriginalCallbackArgument(newCallbackArgument);
        } else {
            this.keyInfo.setCallbackArg(newCallbackArgument);
        }
    }

    public SerializedCacheValue<?> getSerializedNewValue() {
        Object tmp = this.basicGetNewValue();
        if (tmp instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)tmp;
            if (!cd.isSerialized()) {
                return null;
            }
            byte[] bytes = this.newValueBytes;
            if (bytes == null) {
                bytes = this.cachedSerializedNewValue;
            }
            return new SerializedCacheValueImpl(this, this.getRegion(), this.re, cd, bytes);
        }
        return null;
    }

    public final void exportNewValue(NewValueImporter importer) {
        Object nv;
        boolean prefersSerialized = importer.prefersNewSerialized();
        if (prefersSerialized) {
            if (this.getCachedSerializedNewValue() != null) {
                importer.importNewBytes(this.getCachedSerializedNewValue(), true);
                return;
            }
            if (this.newValueBytes != null && this.newValue instanceof CachedDeserializable) {
                importer.importNewBytes(this.newValueBytes, true);
                return;
            }
        }
        if ((nv = this.getRawNewValue()) instanceof StoredObject) {
            StoredObject so = (StoredObject)nv;
            boolean isSerialized = so.isSerialized();
            if (importer.isUnretainedNewReferenceOk()) {
                importer.importNewObject(nv, isSerialized);
            } else if (!isSerialized || prefersSerialized) {
                byte[] bytes = so.getValueAsHeapByteArray();
                importer.importNewBytes(bytes, isSerialized);
                if (isSerialized) {
                    this.setCachedSerializedNewValue(bytes);
                }
            } else {
                importer.importNewObject(so.getValueAsDeserializedHeapObject(), true);
            }
        } else if (nv instanceof byte[]) {
            importer.importNewBytes((byte[])nv, false);
        } else if (nv instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)nv;
            Object cdV = cd.getValue();
            if (cdV instanceof byte[]) {
                importer.importNewBytes((byte[])cdV, true);
                this.setCachedSerializedNewValue((byte[])cdV);
            } else {
                importer.importNewObject(cdV, true);
            }
        } else {
            importer.importNewObject(nv, true);
        }
    }

    public final void exportOldValue(OldValueImporter importer) {
        boolean prefersSerialized = importer.prefersOldSerialized();
        if (prefersSerialized && this.oldValueBytes != null && this.oldValue instanceof CachedDeserializable) {
            importer.importOldBytes(this.oldValueBytes, true);
            return;
        }
        Object ov = this.getRawOldValue();
        if (ov instanceof StoredObject) {
            StoredObject so = (StoredObject)ov;
            boolean isSerialized = so.isSerialized();
            if (importer.isUnretainedOldReferenceOk()) {
                importer.importOldObject(ov, isSerialized);
            } else if (!isSerialized || prefersSerialized) {
                importer.importOldBytes(so.getValueAsHeapByteArray(), isSerialized);
            } else {
                importer.importOldObject(so.getValueAsDeserializedHeapObject(), true);
            }
        } else if (ov instanceof byte[]) {
            importer.importOldBytes((byte[])ov, false);
        } else if (!importer.isCachedDeserializableValueOk() && ov instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)ov;
            Object cdV = cd.getValue();
            if (cdV instanceof byte[]) {
                importer.importOldBytes((byte[])cdV, true);
            } else {
                importer.importOldObject(cdV, true);
            }
        } else {
            importer.importOldObject(AbstractRegion.handleNotAvailable(ov), true);
        }
    }

    public final Object getNewValueAsOffHeapDeserializedOrRaw() {
        Object result = this.getRawNewValue();
        if (this.mayHaveOffHeapReferences() && result instanceof StoredObject) {
            result = ((StoredObject)result).getDeserializedForReading();
        }
        return AbstractRegion.handleNotAvailable(result);
    }

    public StoredObject getOffHeapNewValue() {
        return this.convertToStoredObject(this.basicGetNewValue());
    }

    public StoredObject getOffHeapOldValue() {
        return this.convertToStoredObject(this.basicGetOldValue());
    }

    private StoredObject convertToStoredObject(Object tmp) {
        if (!this.mayHaveOffHeapReferences()) {
            return null;
        }
        if (!(tmp instanceof StoredObject)) {
            return null;
        }
        StoredObject result = (StoredObject)tmp;
        if (!result.retain()) {
            return null;
        }
        return result;
    }

    public final Object getDeserializedValue() {
        Object val = this.basicGetNewValue();
        if (val instanceof CachedDeserializable) {
            return ((CachedDeserializable)val).getDeserializedForReading();
        }
        return val;
    }

    public final byte[] getSerializedValue() {
        if (this.newValueBytes == null) {
            Object val = this.basicGetNewValue();
            if (val instanceof byte[]) {
                return (byte[])val;
            }
            if (val instanceof CachedDeserializable) {
                return ((CachedDeserializable)val).getSerializedValue();
            }
            try {
                return CacheServerHelper.serialize(val);
            }
            catch (IOException ioe) {
                throw new GemFireIOException("unexpected exception", ioe);
            }
        }
        return this.newValueBytes;
    }

    public void makeSerializedNewValue() {
        this.makeSerializedNewValue(false);
    }

    private final void makeSerializedNewValue(boolean isSynced) {
        Object obj = this.basicGetNewValue();
        if (isSynced) {
            this.setSerializationDeferred(false);
        }
        this.basicSetNewValue(EntryEventImpl.getCachedDeserializable(obj, this));
    }

    public static Object getCachedDeserializable(Object obj) {
        return EntryEventImpl.getCachedDeserializable(obj, null);
    }

    public static Object getCachedDeserializable(Object obj, EntryEventImpl ev) {
        CachedDeserializable cd;
        if (obj instanceof byte[] || obj == null || obj instanceof CachedDeserializable || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj) || obj instanceof Delta) {
            return obj;
        }
        if (obj instanceof byte[][]) {
            int objSize = 12;
            for (byte[] bytes : (byte[][])obj) {
                if (bytes != null) {
                    objSize += CachedDeserializableFactory.getByteSize(bytes);
                    continue;
                }
                objSize += 8;
            }
            cd = CachedDeserializableFactory.create(obj, objSize);
        } else {
            byte[] b = EntryEventImpl.serialize(obj);
            cd = CachedDeserializableFactory.create(b);
            if (ev != null) {
                ev.newValueBytes = b;
                ev.cachedSerializedNewValue = b;
            }
        }
        return cd;
    }

    public void setCachedSerializedNewValue(byte[] v) {
        this.cachedSerializedNewValue = v;
    }

    public byte[] getCachedSerializedNewValue() {
        return this.cachedSerializedNewValue;
    }

    public final void setSerializedNewValue(byte[] serializedValue) {
        CachedDeserializable newVal = null;
        if (serializedValue != null) {
            newVal = CachedDeserializableFactory.create(serializedValue);
        }
        this.newValueBytes = serializedValue;
        this.basicSetNewValue(newVal);
        this.cachedSerializedNewValue = serializedValue;
    }

    public void setSerializedOldValue(byte[] serializedOldValue) {
        this.oldValueBytes = serializedOldValue;
        CachedDeserializable ov = serializedOldValue != null ? CachedDeserializableFactory.create(serializedOldValue) : null;
        this.retainAndSetOldValue(ov);
    }

    void putExistingEntry(LocalRegion owner, RegionEntry entry) throws RegionClearedException {
        this.putExistingEntry(owner, entry, false, null);
    }

    void putExistingEntry(LocalRegion owner, RegionEntry reentry, boolean requireOldValue, Object oldValueForDelta) throws RegionClearedException {
        this.makeUpdate();
        if (this.oldValue == null && !reentry.isInvalidOrRemoved()) {
            if (requireOldValue || EVENT_OLD_VALUE || this.region instanceof HARegion) {
                Object ov;
                if (ReferenceCountHelper.trackReferenceCounts()) {
                    ReferenceCountHelper.setReferenceCountOwner(new OldValueOwner());
                    ov = reentry._getValueRetain(owner, true);
                    ReferenceCountHelper.setReferenceCountOwner(null);
                } else {
                    ov = reentry._getValueRetain(owner, true);
                }
                if (ov == null) {
                    ov = Token.NOT_AVAILABLE;
                }
                this.basicSetOldValue(ov);
            } else {
                this.basicSetOldValue(Token.NOT_AVAILABLE);
            }
        }
        if (this.oldValue == Token.NOT_AVAILABLE) {
            FilterProfile fp = this.region.getFilterProfile();
            if (this.op.guaranteesOldValue() || fp != null && fp.entryRequiresOldValue(this.getKey())) {
                this.setOldValueForQueryProcessing();
            }
        }
        this.setNewValueInRegion(owner, reentry, oldValueForDelta);
    }

    void makeUpdate() {
        this.setOperation(this.op.getCorrespondingUpdateOp());
    }

    void makeCreate() {
        this.setOperation(this.op.getCorrespondingCreateOp());
    }

    void putNewEntry(LocalRegion owner, RegionEntry reentry) throws RegionClearedException {
        if (!this.op.guaranteesOldValue()) {
            this.basicSetOldValue(null);
        }
        this.makeCreate();
        this.setNewValueInRegion(owner, reentry, null);
    }

    void setRegionEntry(RegionEntry re) {
        this.re = re;
    }

    RegionEntry getRegionEntry() {
        return this.re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewValueInRegion(LocalRegion owner, RegionEntry reentry, Object oldValueForDelta) throws RegionClearedException {
        Object preparedV;
        boolean wasTombstone = reentry.isTombstone();
        if (this.deltaBytes != null && this.newValue == null) {
            this.processDeltaBytes(oldValueForDelta);
        }
        if (owner != null) {
            owner.generateAndSetVersionTag(this, reentry);
        } else {
            this.region.generateAndSetVersionTag(this, reentry);
        }
        Object v = this.newValue;
        if (v == null) {
            v = this.isLocalInvalid() ? Token.LOCAL_INVALID : Token.INVALID;
        } else {
            this.region.regionInvalid = false;
        }
        reentry.setValueResultOfSearch(this.op.isNetSearch());
        if (v instanceof Delta && this.region.isUsedForPartitionedRegionBucket()) {
            Object ov = this.basicGetOldValue();
            int vSize = ov instanceof CachedDeserializable && !GemFireCacheImpl.DELTAS_RECALCULATE_SIZE ? ((CachedDeserializable)ov).getValueSizeInBytes() : CachedDeserializableFactory.calcMemSize(v, this.region.getObjectSizer(), false);
            v = CachedDeserializableFactory.create(v, vSize);
            this.basicSetNewValue(v);
        }
        if ((preparedV = reentry.prepareValueForCache(this.region, v, this, false)) != v && (v = preparedV) instanceof StoredObject && !((StoredObject)v).isCompressed()) {
            this.basicSetNewValue(v);
        }
        boolean isTombstone = v == Token.TOMBSTONE;
        boolean success = false;
        boolean calledSetValue = false;
        try {
            IndexManager idxManager;
            this.setNewValueBucketSize(owner, v);
            if ((this.op.isUpdate() && !reentry.isInvalid() || this.op.isInvalidate()) && (idxManager = IndexUtils.getIndexManager(this.region, false)) != null) {
                try {
                    idxManager.updateIndexes(reentry, 3, this.op.isUpdate() ? 1 : 0);
                }
                catch (QueryException e) {
                    throw new IndexMaintenanceException(e);
                }
            }
            calledSetValue = true;
            reentry.setValueWithTombstoneCheck(v, this);
            success = true;
        }
        finally {
            if (!success && reentry instanceof OffHeapRegionEntry && v instanceof StoredObject) {
                OffHeapRegionEntryHelper.releaseEntry((OffHeapRegionEntry)reentry, (StoredObject)v);
            }
        }
        if (logger.isTraceEnabled()) {
            if (v instanceof CachedDeserializable) {
                logger.trace("EntryEventImpl.setNewValueInRegion: put CachedDeserializable({},{})", this.getKey(), (Object)((CachedDeserializable)v).getStringForm());
            } else {
                logger.trace("EntryEventImpl.setNewValueInRegion: put({},{})", this.getKey(), (Object)StringUtils.forceToString(v));
            }
        }
        if (!isTombstone && wasTombstone) {
            owner.unscheduleTombstone(reentry);
        }
    }

    public int getNewValueBucketSize() {
        return this.newValueBucketSize;
    }

    private void setNewValueBucketSize(LocalRegion lr, Object v) {
        if (lr == null) {
            lr = this.region;
        }
        this.newValueBucketSize = lr.calculateValueSize(v);
    }

    private void processDeltaBytes(Object oldValueInVM) {
        if (!this.region.hasSeenEvent(this)) {
            if (oldValueInVM == null || Token.isInvalidOrRemoved(oldValueInVM)) {
                this.region.getCachePerfStats().incDeltaFailedUpdates();
                throw new InvalidDeltaException("Old value not found for key " + this.keyInfo.getKey());
            }
            FilterProfile fp = this.region.getFilterProfile();
            boolean copy = this.region.getCompressor() == null && (this.region.isCopyOnRead() || this.region.getCloningEnabled() || fp != null && fp.getCqCount() > 0);
            Object value = oldValueInVM;
            boolean wasCD = false;
            if (value instanceof CachedDeserializable) {
                wasCD = true;
                value = copy ? ((CachedDeserializable)value).getDeserializedWritableCopy(this.region, this.re) : ((CachedDeserializable)value).getDeserializedValue(this.region, this.re);
            } else if (copy) {
                value = CopyHelper.copy(value);
            }
            boolean deltaBytesApplied = false;
            try {
                long start = CachePerfStats.getStatTime();
                ((Delta)value).fromDelta(new DataInputStream(new ByteArrayInputStream(this.getDeltaBytes())));
                this.region.getCachePerfStats().endDeltaUpdate(start);
                deltaBytesApplied = true;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                throw new DeltaSerializationException("Exception while deserializing delta bytes.", t);
            }
            finally {
                if (!deltaBytesApplied) {
                    this.region.getCachePerfStats().incDeltaFailedUpdates();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Delta has been applied for key {}", this.getKey());
            }
            if (wasCD) {
                CachedDeserializable old = (CachedDeserializable)oldValueInVM;
                int valueSize = GemFireCacheImpl.DELTAS_RECALCULATE_SIZE ? CachedDeserializableFactory.calcMemSize(value, this.region.getObjectSizer(), false) : old.getValueSizeInBytes();
                value = CachedDeserializableFactory.create(value, valueSize);
            }
            this.setNewValue(value);
            if (this.causedByMessage != null && this.causedByMessage instanceof PutMessage) {
                ((PutMessage)this.causedByMessage).setDeltaValObj(value);
            }
        } else {
            this.region.getCachePerfStats().incDeltaFailedUpdates();
            throw new InvalidDeltaException("Cache encountered replay of event containing delta bytes for key " + this.keyInfo.getKey());
        }
    }

    void setTXEntryOldValue(Object oldVal, boolean mustBeAvailable) {
        if (Token.isInvalidOrRemoved(oldVal)) {
            oldVal = null;
        } else if (!mustBeAvailable && oldVal != null && !EVENT_OLD_VALUE) {
            oldVal = Token.NOT_AVAILABLE;
        }
        this.retainAndSetOldValue(oldVal);
    }

    void putValueTXEntry(TXEntryState tx) {
        Object v = this.basicGetNewValue();
        if (v == null) {
            if (this.deltaBytes != null) {
                this.processDeltaBytes(tx.getNearSidePendingValue());
                v = this.basicGetNewValue();
            } else {
                Object object = v = this.isLocalInvalid() ? Token.LOCAL_INVALID : Token.INVALID;
            }
        }
        if (this.op != Operation.LOCAL_INVALIDATE && this.op != Operation.LOCAL_DESTROY) {
            Object pv = v;
            if (this.mayHaveOffHeapReferences()) {
                pv = OffHeapHelper.copyIfNeeded(v);
            }
            tx.setPendingValue(pv);
        }
        tx.setCallbackArgument(this.getCallbackArgument());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setOldValueFromRegion() {
        boolean bl;
        block7: {
            RegionEntry re = this.region.getRegionEntry(this.getKey());
            if (re == null) {
                return false;
            }
            ReferenceCountHelper.skipRefCountTracking();
            Object v = re._getValueRetain(this.region, true);
            ReferenceCountHelper.unskipRefCountTracking();
            try {
                bl = this.setOldValue(v);
                if (!this.mayHaveOffHeapReferences()) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (this.mayHaveOffHeapReferences()) {
                        OffHeapHelper.releaseWithNoTracking(v);
                    }
                    throw throwable;
                }
                catch (EntryNotFoundException ex) {
                    return false;
                }
            }
            OffHeapHelper.releaseWithNoTracking(v);
        }
        return bl;
    }

    boolean oldValueIsDestroyedToken() {
        return this.oldValue == Token.DESTROYED || this.oldValue == Token.TOMBSTONE;
    }

    void setOldValueDestroyedToken() {
        this.basicSetOldValue(Token.DESTROYED);
    }

    public boolean setOldValue(Object v) {
        return this.setOldValue(v, false);
    }

    public boolean setOldValue(Object v, boolean force) {
        if (v == null || Token.isRemoved(v)) {
            return false;
        }
        if (Token.isInvalid(v)) {
            v = null;
        } else if (!(force || this.region instanceof HARegion || EVENT_OLD_VALUE)) {
            v = Token.NOT_AVAILABLE;
        }
        this.retainAndSetOldValue(v);
        return true;
    }

    public void setConcurrentMapOldValue(Object v) {
        if (Token.isRemoved(v)) {
            return;
        }
        if (Token.isInvalid(v)) {
            v = null;
        }
        this.retainAndSetOldValue(v);
    }

    public boolean hasNewValue() {
        Object tmp = this.newValue;
        return tmp != null && tmp != Token.NOT_AVAILABLE;
    }

    public final boolean hasOldValue() {
        return this.oldValue != null && this.oldValue != Token.NOT_AVAILABLE;
    }

    public final boolean isOldValueAToken() {
        return this.oldValue instanceof Token;
    }

    @Override
    public boolean isOldValueAvailable() {
        if (this.isOriginRemote() && this.region.isProxy()) {
            return false;
        }
        return this.basicGetOldValue() != Token.NOT_AVAILABLE;
    }

    public void oldValueNotAvailable() {
        this.basicSetOldValue(Token.NOT_AVAILABLE);
    }

    public static Object deserialize(byte[] bytes) {
        return EntryEventImpl.deserialize(bytes, null, null);
    }

    public static Object deserialize(byte[] bytes, Version version, ByteArrayDataInput in) {
        if (bytes == null) {
            return null;
        }
        try {
            return BlobHelper.deserializeBlob(bytes, version, in);
        }
        catch (IOException e) {
            throw new SerializationException(LocalizedStrings.EntryEventImpl_AN_IOEXCEPTION_WAS_THROWN_WHILE_DESERIALIZING.toLocalizedString(), e);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(LocalizedStrings.EntryEventImpl_A_CLASSNOTFOUNDEXCEPTION_WAS_THROWN_WHILE_TRYING_TO_DESERIALIZE_CACHED_VALUE.toLocalizedString(), e);
        }
    }

    public static Object deserializeOffHeap(StoredObject bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return BlobHelper.deserializeOffHeapBlob(bytes);
        }
        catch (IOException e) {
            throw new SerializationException(LocalizedStrings.EntryEventImpl_AN_IOEXCEPTION_WAS_THROWN_WHILE_DESERIALIZING.toLocalizedString(), e);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(LocalizedStrings.EntryEventImpl_A_CLASSNOTFOUNDEXCEPTION_WAS_THROWN_WHILE_TRYING_TO_DESERIALIZE_CACHED_VALUE.toLocalizedString(), e);
        }
    }

    public static byte[] serialize(Object obj) {
        return EntryEventImpl.serialize(obj, null);
    }

    public static byte[] serialize(Object obj, Version version) {
        if (obj == null || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj)) {
            throw new IllegalArgumentException(LocalizedStrings.EntryEventImpl_MUST_NOT_SERIALIZE_0_IN_THIS_CONTEXT.toLocalizedString(obj));
        }
        try {
            return BlobHelper.serializeToBlob(obj, version);
        }
        catch (IOException e) {
            throw new SerializationException(LocalizedStrings.EntryEventImpl_AN_IOEXCEPTION_WAS_THROWN_WHILE_SERIALIZING.toLocalizedString(), e);
        }
    }

    public static void fillSerializedValue(BytesAndBitsForCompactor wrapper, Object obj, byte userBits) {
        if (obj == null || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj)) {
            throw new IllegalArgumentException(LocalizedStrings.EntryEvents_MUST_NOT_SERIALIZE_0_IN_THIS_CONTEXT.toLocalizedString(obj));
        }
        try {
            HeapDataOutputStream hdos = null;
            hdos = wrapper.getBytes().length < 32 ? new HeapDataOutputStream(Version.CURRENT) : new HeapDataOutputStream(wrapper.getBytes());
            DataSerializer.writeObject(obj, hdos);
            hdos.sendTo(wrapper, userBits);
        }
        catch (IOException e) {
            IllegalArgumentException e2 = new IllegalArgumentException(LocalizedStrings.EntryEventImpl_AN_IOEXCEPTION_WAS_THROWN_WHILE_SERIALIZING.toLocalizedString());
            e2.initCause(e);
            throw e2;
        }
    }

    protected String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getShortClassName());
        buf.append("[");
        buf.append("op=");
        buf.append(this.getOperation());
        buf.append(";region=");
        buf.append(this.getRegion().getFullPath());
        buf.append(";key=");
        buf.append(this.getKey());
        buf.append(";oldValue=");
        try {
            Object object = this.offHeapLock;
            synchronized (object) {
                ArrayUtils.objectStringNonRecursive(this.basicGetOldValue(), buf);
            }
        }
        catch (IllegalStateException ex) {
            buf.append("OFFHEAP_VALUE_FREED");
        }
        buf.append(";newValue=");
        try {
            Object ex = this.offHeapLock;
            synchronized (ex) {
                ArrayUtils.objectStringNonRecursive(this.basicGetNewValue(), buf);
            }
        }
        catch (IllegalStateException ex) {
            buf.append("OFFHEAP_VALUE_FREED");
        }
        buf.append(";callbackArg=");
        buf.append(this.getRawCallbackArgument());
        buf.append(";originRemote=");
        buf.append(this.isOriginRemote());
        buf.append(";originMember=");
        buf.append(this.getDistributedMember());
        if (this.isPossibleDuplicate()) {
            buf.append(";posDup");
        }
        if (this.callbacksInvoked()) {
            buf.append(";callbacksInvoked");
        }
        if (this.inhibitCacheListenerNotification()) {
            buf.append(";inhibitCacheListenerNotification");
        }
        if (this.versionTag != null) {
            buf.append(";version=").append(this.versionTag);
        }
        if (this.getContext() != null) {
            buf.append(";context=");
            buf.append(this.getContext());
        }
        if (this.eventID != null) {
            buf.append(";id=");
            buf.append(this.eventID);
        }
        if (this.deltaBytes != null) {
            buf.append(";[" + this.deltaBytes.length + " deltaBytes]");
        }
        if (this.filterInfo != null) {
            buf.append(";routing=");
            buf.append(this.filterInfo);
        }
        if (this.isFromServer()) {
            buf.append(";isFromServer");
        }
        if (this.isConcurrencyConflict()) {
            buf.append(";isInConflict");
        }
        if (this.getInhibitDistribution()) {
            buf.append(";inhibitDistribution");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public int getDSFID() {
        return 105;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        CachedDeserializable cd;
        DataSerializer.writeObject(this.eventID, out);
        DataSerializer.writeObject(this.getKey(), out);
        DataSerializer.writeObject(this.keyInfo.getValue(), out);
        out.writeByte(this.op.ordinal);
        out.writeShort(this.eventFlags & 0xFFFFC03F);
        DataSerializer.writeObject(this.getRawCallbackArgument(), out);
        DataSerializer.writeObject(this.txId, out);
        out.writeBoolean(false);
        Object nv = this.basicGetNewValue();
        boolean newValueSerialized = nv instanceof CachedDeserializable;
        if (newValueSerialized) {
            newValueSerialized = ((CachedDeserializable)nv).isSerialized();
        }
        out.writeBoolean(newValueSerialized);
        if (newValueSerialized) {
            if (this.newValueBytes != null) {
                DataSerializer.writeByteArray(this.newValueBytes, out);
            } else if (this.cachedSerializedNewValue != null) {
                DataSerializer.writeByteArray(this.cachedSerializedNewValue, out);
            } else {
                cd = (CachedDeserializable)nv;
                DataSerializer.writeObjectAsByteArray(cd.getValue(), out);
            }
        } else {
            DataSerializer.writeObject(nv, out);
        }
        Object ov = this.basicGetOldValue();
        boolean oldValueSerialized = ov instanceof CachedDeserializable;
        if (oldValueSerialized) {
            oldValueSerialized = ((CachedDeserializable)ov).isSerialized();
        }
        out.writeBoolean(oldValueSerialized);
        if (oldValueSerialized) {
            if (this.oldValueBytes != null) {
                DataSerializer.writeByteArray(this.oldValueBytes, out);
            } else {
                cd = (CachedDeserializable)ov;
                DataSerializer.writeObjectAsByteArray(cd.getValue(), out);
            }
        } else {
            DataSerializer.writeObject(ov, out);
        }
        InternalDataSerializer.invokeToData((InternalDistributedMember)this.distributedMember, out);
        DataSerializer.writeObject(this.getContext(), out);
        DataSerializer.writeLong(this.tailKey, out);
    }

    public final SerializedCacheValue<?> getSerializedOldValue() {
        Object tmp = this.basicGetOldValue();
        if (tmp instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)tmp;
            if (!cd.isSerialized()) {
                return null;
            }
            return new SerializedCacheValueImpl(this, this.region, this.re, cd, this.oldValueBytes);
        }
        return null;
    }

    public int getNewValSizeForPR() {
        int newSize = 0;
        Object v = this.basicGetNewValue();
        if (v != null) {
            try {
                newSize = CachedDeserializableFactory.calcSerializedSize(v) + CachedDeserializableFactory.overhead();
            }
            catch (IllegalArgumentException iae) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.EntryEventImpl_DATASTORE_FAILED_TO_CALCULATE_SIZE_OF_NEW_VALUE), (Throwable)iae);
                newSize = 0;
            }
        }
        return newSize;
    }

    public int getOldValSize() {
        int oldSize = 0;
        if (this.hasOldValue()) {
            try {
                oldSize = CachedDeserializableFactory.calcMemSize(this.basicGetOldValue());
            }
            catch (IllegalArgumentException iae) {
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.EntryEventImpl_DATASTORE_FAILED_TO_CALCULATE_SIZE_OF_OLD_VALUE), (Throwable)iae);
                oldSize = 0;
            }
        }
        return oldSize;
    }

    @Override
    public EnumListenerEvent getEventType() {
        return this.eventType;
    }

    @Override
    public void setEventType(EnumListenerEvent eventType) {
        this.eventType = eventType;
    }

    public void callbacksInvoked(boolean dispatched) {
        this.setEventFlag((short)128, dispatched);
    }

    public boolean callbacksInvoked() {
        return this.testEventFlag((short)128);
    }

    public void inhibitCacheListenerNotification(boolean inhibit) {
        this.setEventFlag((short)64, inhibit);
    }

    public boolean inhibitCacheListenerNotification() {
        return this.testEventFlag((short)64);
    }

    void invokeCallbacks(LocalRegion rgn, boolean skipListeners, boolean notifyGateways) {
        if (!this.callbacksInvoked()) {
            this.callbacksInvoked(true);
            if (this.op.isUpdate()) {
                rgn.invokePutCallbacks(EnumListenerEvent.AFTER_UPDATE, this, !skipListeners, notifyGateways);
            } else if (this.op.isCreate()) {
                rgn.invokePutCallbacks(EnumListenerEvent.AFTER_CREATE, this, !skipListeners, notifyGateways);
            } else if (this.op.isDestroy()) {
                rgn.invokeDestroyCallbacks(EnumListenerEvent.AFTER_DESTROY, this, !skipListeners, notifyGateways);
            } else if (this.op.isInvalidate()) {
                rgn.invokeInvalidateCallbacks(EnumListenerEvent.AFTER_INVALIDATE, this, !skipListeners);
            }
        }
    }

    private void setFromRILocalDestroy(boolean on) {
        this.setEventFlag((short)2048, on);
    }

    public boolean isFromRILocalDestroy() {
        return this.testEventFlag((short)2048);
    }

    public void setNextRegionVersion(long regionVersion) {
        this.nextRegionVersion = regionVersion;
    }

    public long getNextRegionVersion() {
        return this.nextRegionVersion;
    }

    public boolean isFromServer() {
        return this.testEventFlag((short)1024);
    }

    public void setFromServer(boolean v) {
        this.setEventFlag((short)1024, v);
    }

    public boolean isPossibleDuplicate() {
        return this.testEventFlag((short)8);
    }

    public void setPossibleDuplicate(boolean possibleDuplicate) {
        this.setEventFlag((short)8, possibleDuplicate);
    }

    public boolean inhibitAllNotifications() {
        return this.testEventFlag((short)16384);
    }

    public void setInhibitAllNotifications(boolean inhibit) {
        this.setEventFlag((short)16384, inhibit);
    }

    @Override
    public void setLocalFilterInfo(FilterRoutingInfo.FilterInfo info) {
        this.filterInfo = info;
    }

    @Override
    public FilterRoutingInfo.FilterInfo getLocalFilterInfo() {
        return this.filterInfo;
    }

    public LocalRegion getLocalRegion() {
        return this.region;
    }

    public byte[] getDeltaBytes() {
        return this.deltaBytes;
    }

    public void setDeltaBytes(byte[] deltaBytes) {
        this.deltaBytes = deltaBytes;
    }

    public boolean isCreate() {
        return this.testEventFlag((short)256);
    }

    public EntryEventImpl setCreate(boolean isCreate) {
        this.setEventFlag((short)256, isCreate);
        return this;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    public void setOldValueForQueryProcessing() {
        Object v;
        RegionEntry reentry = this.region.entries.getEntry(this.getKey());
        if (reentry != null && !((v = reentry.getValueOffHeapOrDiskWithoutFaultIn(this.region)) instanceof Token)) {
            this.basicSetOldValue(v);
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    public void setVersionTag(VersionTag versionTag) {
        this.versionTag = versionTag;
    }

    @Override
    public VersionTag getVersionTag() {
        return this.versionTag;
    }

    public boolean hasValidVersionTag() {
        return this.versionTag != null && this.versionTag.hasValidVersion();
    }

    public long getEventTime(long suggestedTime) {
        long result = suggestedTime;
        if (this.versionTag != null) {
            if (suggestedTime != 0L) {
                this.versionTag.setVersionTimeStamp(suggestedTime);
            } else {
                result = this.versionTag.getVersionTimeStamp();
            }
        }
        if (result <= 0L) {
            LocalRegion region = this.getLocalRegion();
            result = region != null ? region.cacheTimeMillis() : System.currentTimeMillis();
        }
        return result;
    }

    public void setTailKey(Long tailKey) {
        this.tailKey = tailKey;
    }

    public Long getTailKey() {
        return this.tailKey;
    }

    public void setCallbacksInvokedByCurrentThread() {
        this.invokeCallbacksThread = Thread.currentThread();
    }

    public boolean getCallbacksInvokedByCurrentThread() {
        if (this.invokeCallbacksThread == null) {
            return false;
        }
        return Thread.currentThread().equals(this.invokeCallbacksThread);
    }

    public boolean isOnPdxTypeRegion() {
        return "/PdxTypes".equals(this.region.getFullPath());
    }

    public boolean noVersionReceivedFromServer() {
        return this.versionTag == null && this.region.concurrencyChecksEnabled && this.region.getServerProxy() != null && !this.op.isLocal() && !this.isOriginRemote();
    }

    public TimestampedEntryEvent getTimestampedEvent(int newDSID, int oldDSID, long newTimestamp, long oldTimestamp) {
        return new TimestampedEntryEventImpl(this, newDSID, oldDSID, newTimestamp, oldTimestamp);
    }

    private void setSerializationDeferred(boolean serializationDeferred) {
        this.setEventFlag((short)512, serializationDeferred);
    }

    private boolean isSerializationDeferred() {
        return this.testEventFlag((short)512);
    }

    public boolean isSingleHop() {
        return this.causedByMessage != null && this.causedByMessage instanceof RemoteOperationMessage;
    }

    public boolean isSingleHopPutOp() {
        return this.causedByMessage != null && this.causedByMessage instanceof RemotePutMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (!this.offHeapOk) {
            return;
        }
        if (!this.mayHaveOffHeapReferences()) {
            return;
        }
        Object object = this.offHeapLock;
        synchronized (object) {
            this.testHookReleaseInProgress();
            Object ov = this.basicGetOldValue();
            Object nv = this.basicGetNewValue();
            this.offHeapOk = false;
            if (ov instanceof StoredObject) {
                if (ReferenceCountHelper.trackReferenceCounts()) {
                    ReferenceCountHelper.setReferenceCountOwner(new OldValueOwner());
                    ((StoredObject)ov).release();
                    ReferenceCountHelper.setReferenceCountOwner(null);
                } else {
                    ((StoredObject)ov).release();
                }
            }
            OffHeapHelper.releaseAndTrackOwner(nv, this);
        }
    }

    private boolean mayHaveOffHeapReferences() {
        LocalRegion lr = this.region;
        if (lr != null) {
            return lr.getOffHeap();
        }
        return true;
    }

    void testHookReleaseInProgress() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disallowOffHeapValues() {
        if (this.isOffHeapReference(this.newValue) || this.isOffHeapReference(this.oldValue)) {
            throw new IllegalStateException("This event already has off-heap values");
        }
        Object object = this.offHeapLock;
        synchronized (object) {
            this.offHeapOk = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyOffHeapToHeap() {
        if (!this.mayHaveOffHeapReferences()) {
            this.offHeapOk = false;
            return;
        }
        Object object = this.offHeapLock;
        synchronized (object) {
            Object nv;
            Object ov = this.basicGetOldValue();
            if (StoredObject.isOffHeapReference(ov)) {
                if (ReferenceCountHelper.trackReferenceCounts()) {
                    ReferenceCountHelper.setReferenceCountOwner(new OldValueOwner());
                    this.oldValue = OffHeapHelper.copyAndReleaseIfNeeded(ov);
                    ReferenceCountHelper.setReferenceCountOwner(null);
                } else {
                    this.oldValue = OffHeapHelper.copyAndReleaseIfNeeded(ov);
                }
            }
            if (StoredObject.isOffHeapReference(nv = this.basicGetNewValue())) {
                ReferenceCountHelper.setReferenceCountOwner(this);
                this.newValue = OffHeapHelper.copyAndReleaseIfNeeded(nv);
                ReferenceCountHelper.setReferenceCountOwner(null);
            }
            if (StoredObject.isOffHeapReference(this.newValue) || StoredObject.isOffHeapReference(this.oldValue)) {
                throw new IllegalStateException("event's old/new value still off-heap after calling copyOffHeapToHeap");
            }
            this.offHeapOk = false;
        }
    }

    public boolean isOldValueOffHeap() {
        return this.isOffHeapReference(this.oldValue);
    }

    public static final class SerializedCacheValueImpl
    implements SerializedCacheValue,
    CachedDeserializable,
    Sendable {
        private final EntryEventImpl event;
        private final CachedDeserializable cd;
        private final Region r;
        private final RegionEntry re;
        private final byte[] serializedValue;

        SerializedCacheValueImpl(EntryEventImpl event, Region r, RegionEntry re, CachedDeserializable cd, byte[] serializedBytes) {
            this.event = event.isOffHeapReference(cd) ? event : null;
            this.r = r;
            this.re = re;
            this.cd = cd;
            this.serializedValue = serializedBytes;
        }

        @Override
        public byte[] getSerializedValue() {
            if (this.serializedValue != null) {
                return this.serializedValue;
            }
            return this.callWithOffHeapLock(cd -> cd.getSerializedValue());
        }

        private CachedDeserializable getCd() {
            if (this.event != null && !this.event.offHeapOk) {
                throw new IllegalStateException("Attempt to access off heap value after the EntryEvent was released.");
            }
            return this.cd;
        }

        private <R> R callWithOffHeapLock(Function<CachedDeserializable, R> function) {
            if (this.event != null) {
                return (R)this.event.callWithOffHeapLock(this.cd, function);
            }
            return function.apply(this.getCd());
        }

        public Object getDeserializedValue() {
            return this.getDeserializedValue(this.r, this.re);
        }

        @Override
        public Object getDeserializedForReading() {
            return this.getCd().getDeserializedForReading();
        }

        @Override
        public Object getDeserializedWritableCopy(Region rgn, RegionEntry entry) {
            return this.getCd().getDeserializedWritableCopy(rgn, entry);
        }

        @Override
        public Object getDeserializedValue(Region rgn, RegionEntry reentry) {
            return this.callWithOffHeapLock(cd -> cd.getDeserializedValue(rgn, reentry));
        }

        @Override
        public Object getValue() {
            if (this.serializedValue != null) {
                return this.serializedValue;
            }
            return this.getCd().getValue();
        }

        @Override
        public void writeValueAsByteArray(DataOutput out) throws IOException {
            if (this.serializedValue != null) {
                DataSerializer.writeByteArray(this.serializedValue, out);
            } else {
                this.getCd().writeValueAsByteArray(out);
            }
        }

        @Override
        public void fillSerializedValue(BytesAndBitsForCompactor wrapper, byte userBits) {
            if (this.serializedValue != null) {
                wrapper.setData(this.serializedValue, userBits, this.serializedValue.length, false);
            } else {
                this.getCd().fillSerializedValue(wrapper, userBits);
            }
        }

        @Override
        public int getValueSizeInBytes() {
            return this.getCd().getValueSizeInBytes();
        }

        @Override
        public int getSizeInBytes() {
            return this.getCd().getSizeInBytes();
        }

        @Override
        public String getStringForm() {
            return this.getCd().getStringForm();
        }

        @Override
        public void sendTo(DataOutput out) throws IOException {
            DataSerializer.writeObject(this.getCd(), out);
        }

        @Override
        public boolean isSerialized() {
            return this.getCd().isSerialized();
        }

        @Override
        public boolean usesHeapForStorage() {
            return this.getCd().usesHeapForStorage();
        }
    }

    private static abstract class EventFlags {
        private static final short FLAG_ORIGIN_REMOTE = 1;
        private static final short FLAG_LOCAL_INVALID = 2;
        private static final short FLAG_GENERATE_CALLBACKS = 4;
        private static final short FLAG_POSSIBLE_DUPLICATE = 8;
        private static final short FLAG_INVOKE_PR_CALLBACKS = 16;
        private static final short FLAG_CONCURRENCY_CONFLICT = 32;
        private static final short FLAG_INHIBIT_LISTENER_NOTIFICATION = 64;
        private static final short FLAG_CALLBACKS_INVOKED = 128;
        private static final short FLAG_ISCREATE = 256;
        private static final short FLAG_SERIALIZATION_DEFERRED = 512;
        private static final short FLAG_FROM_SERVER = 1024;
        private static final short FLAG_FROM_RI_LOCAL_DESTROY = 2048;
        private static final short FLAG_INHIBIT_DISTRIBUTION = 4096;
        private static final short FLAG_REDESTROYED_TOMBSTONE = 8192;
        private static final short FLAG_INHIBIT_ALL_NOTIFICATIONS = 16384;
        private static final short FLAG_TRANSIENT_MASK = -16321;

        private EventFlags() {
        }

        protected static final boolean isSet(short flags, short mask) {
            return (flags & mask) != 0;
        }

        protected static final short set(short flags, short mask, boolean on) {
            return (short)(on ? flags | mask : flags & ~mask);
        }
    }

    public static interface OldValueImporter {
        public boolean prefersOldSerialized();

        public boolean isUnretainedOldReferenceOk();

        public boolean isCachedDeserializableValueOk();

        public void importOldObject(Object var1, boolean var2);

        public void importOldBytes(byte[] var1, boolean var2);
    }

    public static interface NewValueImporter {
        public boolean prefersNewSerialized();

        public boolean isUnretainedNewReferenceOk();

        public void importNewObject(Object var1, boolean var2);

        public void importNewBytes(byte[] var1, boolean var2);
    }

    private class OldValueOwner {
        private OldValueOwner() {
        }

        private EntryEventImpl getEvent() {
            return EntryEventImpl.this;
        }

        public int hashCode() {
            return this.getEvent().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof OldValueOwner) {
                return this.getEvent().equals(((OldValueOwner)obj).getEvent());
            }
            return false;
        }

        public String toString() {
            return "OldValueOwner " + this.getEvent().toString();
        }
    }
}

