/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;

class CacheStatisticsImpl
implements CacheStatistics {
    private final LocalRegion region;
    private final RegionEntry regionEntry;

    CacheStatisticsImpl(RegionEntry regionEntry, LocalRegion region) {
        this.region = region;
        this.regionEntry = regionEntry;
    }

    @Override
    public long getHitCount() throws StatisticsDisabledException {
        this.checkEntryDestroyed();
        try {
            return this.regionEntry.getHitCount();
        }
        catch (InternalStatisticsDisabledException e) {
            throw new StatisticsDisabledException(e);
        }
    }

    @Override
    public float getHitRatio() throws StatisticsDisabledException {
        this.checkEntryDestroyed();
        RegionEntry entry = this.regionEntry;
        try {
            long hitCount = entry.getHitCount();
            long total = hitCount + entry.getMissCount();
            return total == 0L ? 0.0f : (float)hitCount / (float)total;
        }
        catch (InternalStatisticsDisabledException e) {
            throw new StatisticsDisabledException(e);
        }
    }

    @Override
    public long getLastAccessedTime() throws StatisticsDisabledException {
        this.checkEntryDestroyed();
        try {
            return this.regionEntry.getLastAccessed();
        }
        catch (InternalStatisticsDisabledException e) {
            throw new StatisticsDisabledException(e);
        }
    }

    @Override
    public long getLastModifiedTime() {
        this.checkEntryDestroyed();
        return this.regionEntry.getLastModified();
    }

    @Override
    public long getMissCount() throws StatisticsDisabledException {
        this.checkEntryDestroyed();
        try {
            return this.regionEntry.getMissCount();
        }
        catch (InternalStatisticsDisabledException e) {
            throw new StatisticsDisabledException(e);
        }
    }

    @Override
    public void resetCounts() throws StatisticsDisabledException {
        this.checkEntryDestroyed();
        try {
            this.regionEntry.resetCounts();
        }
        catch (InternalStatisticsDisabledException e) {
            throw new StatisticsDisabledException(e);
        }
    }

    private void checkEntryDestroyed() {
        this.region.getCancelCriterion().checkCancelInProgress(null);
        if (this.regionEntry.isRemoved()) {
            throw new EntryDestroyedException(this.regionEntry.getKey().toString());
        }
    }
}

