/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.statalerts;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.admin.StatAlert;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.statalerts.BaseDecoratorImpl;

public final class GaugeThresholdDecoratorImpl
extends BaseDecoratorImpl
implements DataSerializableFixedID {
    private static final long serialVersionUID = -8555077820685711783L;
    protected Number lowerLimit;
    protected Number upperLimit;
    public static final String ID = "GaugeThreshold";

    public GaugeThresholdDecoratorImpl() {
    }

    public GaugeThresholdDecoratorImpl(StatAlertDefinition definition, Number lowerLimit, Number upperLimit) {
        super(definition);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    @Override
    public int getDSFID() {
        return 1074;
    }

    public Number getThresholdLowerLimit() {
        return this.lowerLimit;
    }

    public Number getThresholdUpperLimit() {
        return this.upperLimit;
    }

    public boolean isGauge() {
        return true;
    }

    @Override
    public boolean verify(StatisticsFactory factory) {
        return super.verify(factory) && this.lowerLimit != null && this.upperLimit != null;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append("Threshold Limit: " + this.lowerLimit + " to " + this.upperLimit + "\n");
        return buffer.toString();
    }

    @Override
    public boolean evaluate(Number[] params) {
        return super.evaluate(params) && (GaugeThresholdDecoratorImpl.isGreaterThan(params[0], this.upperLimit) || GaugeThresholdDecoratorImpl.isLessThan(params[0], this.lowerLimit));
    }

    @Override
    public boolean evaluate() {
        return this.evaluate(this.getValue());
    }

    @Override
    public StatAlert evaluateAndAlert(Number[] params) {
        return this.evaluate(params) ? super.evaluateAndAlert(params) : null;
    }

    @Override
    public StatAlert evaluateAndAlert() {
        return this.evaluate() ? super.evaluateAndAlert() : null;
    }

    @Override
    public Number[] getValue() {
        return super.getValue();
    }

    @Override
    public Number[] getValue(Number[] vals) {
        return super.getValue(vals);
    }

    @Override
    public boolean hasDecorator(String decoratorID) {
        return ID.equalsIgnoreCase(decoratorID) || super.hasDecorator(decoratorID);
    }

    @Override
    public StatAlertDefinition getDecorator(String decoratorID) {
        return ID.equalsIgnoreCase(decoratorID) ? this : super.getDecorator(decoratorID);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.lowerLimit, out);
        DataSerializer.writeObject(this.upperLimit, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.lowerLimit = (Number)DataSerializer.readObject(in);
        this.upperLimit = (Number)DataSerializer.readObject(in);
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

