/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminRegion;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CacheDisplay;

public final class SubRegionResponse
extends AdminResponse {
    String[] subRegionNames;
    String[] userAttributes;

    public static SubRegionResponse create(DistributionManager dm, InternalDistributedMember recipient, Region r) {
        SubRegionResponse m = new SubRegionResponse();
        m.setRecipient(recipient);
        Set<Region<?, ?>> subregions = r.subregions(false);
        ArrayList<String> subNames = new ArrayList<String>();
        ArrayList<Object> userAttrs = new ArrayList<Object>();
        for (Region<?, ?> reg : subregions) {
            subNames.add(reg.getName());
            userAttrs.add(CacheDisplay.getCachedObjectDisplay(reg.getUserAttribute(), 100));
        }
        String[] temp = new String[]{};
        m.subRegionNames = subNames.toArray(temp);
        m.userAttributes = userAttrs.toArray(temp);
        return m;
    }

    public Set getRegionSet(AdminRegion parent) {
        HashSet<AdminRegion> result = new HashSet<AdminRegion>(this.subRegionNames.length);
        for (int i = 0; i < this.subRegionNames.length; ++i) {
            result.add(new AdminRegion(this.subRegionNames[i], parent, this.userAttributes[i]));
        }
        return new HashSet(result);
    }

    @Override
    public int getDSFID() {
        return 1060;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.subRegionNames, out);
        DataSerializer.writeObject(this.userAttributes, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.subRegionNames = (String[])DataSerializer.readObject(in);
        this.userAttributes = (String[])DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "SubRegionResponse from " + this.getRecipient();
    }
}

