/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.cache.persistence.RevokeFailedException;
import org.apache.geode.distributed.internal.DM;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.admin.remote.AdminMultipleReplyProcessor;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CliLegacyMessage;
import org.apache.geode.internal.admin.remote.RevokePersistentIDResponse;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.persistence.PersistentMemberManager;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class PrepareRevokePersistentIDRequest
extends CliLegacyMessage {
    PersistentMemberPattern pattern;
    private boolean cancel;

    public PrepareRevokePersistentIDRequest() {
    }

    public PrepareRevokePersistentIDRequest(PersistentMemberPattern pattern, boolean cancel) {
        this.pattern = pattern;
        this.cancel = cancel;
    }

    public static void cancel(DM dm, PersistentMemberPattern pattern) {
        PrepareRevokePersistentIDRequest.send(dm, pattern, true);
    }

    public static void send(DM dm, PersistentMemberPattern pattern) {
        PrepareRevokePersistentIDRequest.send(dm, pattern, false);
    }

    private static void send(DM dm, PersistentMemberPattern pattern, boolean cancel) {
        Set recipients = dm.getOtherDistributionManagerIds();
        recipients.remove(dm.getId());
        PrepareRevokePersistentIDRequest request = new PrepareRevokePersistentIDRequest(pattern, cancel);
        request.setRecipients(recipients);
        AdminMultipleReplyProcessor replyProcessor = new AdminMultipleReplyProcessor(dm, (Collection)recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (e.getCause() instanceof CancelException) {
                return;
            }
            throw e;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        request.setSender(dm.getId());
        request.createResponse((DistributionManager)dm);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && !cache.isClosed()) {
            PersistentMemberManager mm = cache.getPersistentMemberManager();
            if (this.cancel) {
                mm.cancelRevoke(this.pattern);
            } else if (!mm.prepareRevoke(this.pattern, dm, this.getSender())) {
                throw new RevokeFailedException(LocalizedStrings.RevokeFailedException_Member_0_is_already_running_1.toLocalizedString(dm.getId(), this.pattern));
            }
        }
        return new RevokePersistentIDResponse(this.getSender());
    }

    @Override
    public int getDSFID() {
        return 2129;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.pattern = new PersistentMemberPattern();
        InternalDataSerializer.invokeFromData(this.pattern, in);
        this.cancel = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        InternalDataSerializer.invokeToData(this.pattern, out);
        out.writeBoolean(this.cancel);
    }
}

