/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin;

import java.util.Properties;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.internal.SSLUtil;

public class SSLConfig {
    private boolean enabled = false;
    private String protocols = "any";
    private String ciphers = "any";
    private boolean requireAuth = true;
    private String keystore = "";
    private String keystoreType = "";
    private String keystorePassword = "";
    private String truststore = "";
    private String truststorePassword = "";
    private String truststoreType = "";
    private String alias = null;
    private SecurableCommunicationChannel securableCommunicationChannel = null;
    private Properties properties = new Properties();

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getProtocols() {
        return this.protocols;
    }

    public String[] getProtocolsAsStringArray() {
        return SSLUtil.readArray(this.protocols);
    }

    public void setProtocols(String protocols) {
        this.protocols = protocols;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public String[] getCiphersAsStringArray() {
        return SSLUtil.readArray(this.ciphers);
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public boolean isRequireAuth() {
        return this.requireAuth;
    }

    public void setRequireAuth(boolean requireAuth) {
        this.requireAuth = requireAuth;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties newProps) {
        this.properties = new Properties();
        for (String string : newProps.keySet()) {
            this.properties.setProperty(string, newProps.getProperty(string));
        }
    }

    public SecurableCommunicationChannel getSecuredCommunicationChannel() {
        return this.securableCommunicationChannel;
    }

    public void setSecurableCommunicationChannel(SecurableCommunicationChannel securableCommunicationChannel) {
        this.securableCommunicationChannel = securableCommunicationChannel;
    }

    public String toString() {
        return "SSLConfig{enabled=" + this.enabled + ", protocols='" + this.protocols + '\'' + ", ciphers='" + this.ciphers + '\'' + ", requireAuth=" + this.requireAuth + ", keystore='" + this.keystore + '\'' + ", keystoreType='" + this.keystoreType + '\'' + ", keystorePassword='" + this.keystorePassword + '\'' + ", truststore='" + this.truststore + '\'' + ", truststorePassword='" + this.truststorePassword + '\'' + ", truststoreType='" + this.truststoreType + '\'' + ", alias='" + this.alias + '\'' + ", securableCommunicationChannel=" + (Object)((Object)this.securableCommunicationChannel) + ", properties=" + this.properties + '}';
    }

    public void toDSProperties(Properties props) {
        props.setProperty("cluster-ssl-enabled", String.valueOf(this.enabled));
        if (this.enabled) {
            props.setProperty("cluster-ssl-protocols", this.protocols);
            props.setProperty("cluster-ssl-ciphers", this.ciphers);
            props.setProperty("cluster-ssl-require-authentication", String.valueOf(this.requireAuth));
        }
    }
}

