/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.net.InetAddress;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.GemFireIOException;
import org.apache.geode.SystemIsRunningException;
import org.apache.geode.UncreatedSystemException;
import org.apache.geode.UnstartedSystemException;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.PureJavaMode;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class ManagerInfo
implements DataSerializable {
    private static final long serialVersionUID = 5792809580026325378L;
    private static final String LOCATOR_INFO_FILE_NAME = ".locator";
    public static final int STOPPED_STATUS_CODE = 0;
    public static final int STOPPING_STATUS_CODE = 1;
    public static final int KILLED_STATUS_CODE = 2;
    public static final int STARTING_STATUS_CODE = 3;
    public static final int STARTED_STATUS_CODE = 4;
    static final String[] statusNames = new String[]{LocalizedStrings.ManagerInfo_STOPPED.toLocalizedString(), LocalizedStrings.ManagerInfo_STOPPING.toLocalizedString(), LocalizedStrings.ManagerInfo_KILLED.toLocalizedString(), LocalizedStrings.ManagerInfo_STARTING.toLocalizedString(), LocalizedStrings.ManagerInfo_RUNNING.toLocalizedString()};
    private int managerPid;
    private int managerStatus;
    private int port;
    private InetAddress bindAddress;

    public static void setLocatorStarted(File directory, int port, InetAddress bindAddress) {
        ManagerInfo.saveManagerInfo(OSProcess.getId(), 4, directory, port, bindAddress);
    }

    public static File setLocatorStarting(File directory, int port, InetAddress bindAddress) {
        if (ManagerInfo.isManagerRunning(directory, true)) {
            throw new SystemIsRunningException(LocalizedStrings.ManagerInfo_0_1_IS_ALREADY_RUNNING.toLocalizedString("Locator", directory.getPath()));
        }
        File result = ManagerInfo.getManagerInfoFile(directory, true);
        ManagerInfo.saveManagerInfo(OSProcess.getId(), 3, directory, port, bindAddress);
        return result;
    }

    public static void setLocatorStopping(File directory, int port, InetAddress bindAddress) {
        ManagerInfo.saveManagerInfo(OSProcess.getId(), 1, directory, port, bindAddress);
    }

    private static void saveManagerInfo(int pid, int status, File directory, int port, InetAddress bindAddress) {
        ManagerInfo info = new ManagerInfo(pid, status, port, bindAddress);
        File infoFile = ManagerInfo.getManagerInfoFile(directory, true);
        try {
            FileOutputStream ostream = new FileOutputStream(infoFile);
            DataOutputStream dos = new DataOutputStream(ostream);
            DataSerializer.writeObject(info, dos);
            ostream.close();
        }
        catch (IOException io) {
            throw new GemFireIOException(LocalizedStrings.ManagerInfo_COULD_NOT_WRITE_FILE_0.toLocalizedString(infoFile), io);
        }
    }

    public int getManagerProcessId() {
        return this.managerPid;
    }

    public int getManagerStatus() {
        return this.managerStatus;
    }

    public int getManagerPort() {
        return this.port;
    }

    public InetAddress getManagerAddress() {
        return this.bindAddress;
    }

    public static String statusToString(int status) {
        return statusNames[status];
    }

    public static int statusNameToCode(String statusName) {
        for (int i = 0; i <= 4; ++i) {
            if (!statusNames[i].equalsIgnoreCase(statusName)) continue;
            return i;
        }
        throw new IllegalArgumentException(LocalizedStrings.ManagerInfo_UNKNOWN_STATUSNAME_0.toLocalizedString(statusName));
    }

    public static ManagerInfo loadLocatorInfo(File directory) {
        return ManagerInfo.loadManagerInfo(directory, true);
    }

    private static ManagerInfo loadManagerInfo(File directory, boolean locator) {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new UncreatedSystemException(LocalizedStrings.ManagerInfo__0_DOES_NOT_EXIST_OR_IS_NOT_A_DIRECTORY.toLocalizedString(directory.getPath()));
        }
        File infoFile = ManagerInfo.getManagerInfoFile(directory, locator);
        if (!infoFile.exists()) {
            throw new UnstartedSystemException(LocalizedStrings.ManagerInfo_THE_INFO_FILE_0_DOES_NOT_EXIST.toLocalizedString(infoFile.getPath()));
        }
        try {
            FileInputStream fis = new FileInputStream(infoFile);
            if (fis.available() == 0) {
                throw new GemFireIOException(LocalizedStrings.ManagerInfo_COULD_NOT_LOAD_FILE_0_BECAUSE_THE_FILE_IS_EMPTY_WAIT_FOR_THE_1_TO_FINISH_STARTING.toLocalizedString(infoFile, locator ? "locator" : "system"), null);
            }
            DataInputStream dis = new DataInputStream(fis);
            ManagerInfo result = (ManagerInfo)DataSerializer.readObject(dis);
            fis.close();
            return result;
        }
        catch (IOException io) {
            throw new GemFireIOException(LocalizedStrings.ManagerInfo_COULD_NOT_LOAD_FILE_0.toLocalizedString(infoFile), io);
        }
        catch (ClassNotFoundException ex) {
            throw new GemFireIOException(LocalizedStrings.ManagerInfo_COULD_NOT_LOAD_FILE_0_BECAUSE_A_CLASS_COULD_NOT_BE_FOUND.toLocalizedString(infoFile), ex);
        }
    }

    public static File getLocatorInfoFile(File directory) {
        return ManagerInfo.getManagerInfoFile(directory, true);
    }

    private static File getManagerInfoFile(File directory, boolean locator) {
        if (!locator) {
            throw new IllegalArgumentException(LocalizedStrings.ManagerInfo_ONLY_LOCATORS_ARE_SUPPORTED.toLocalizedString());
        }
        File res = new File(directory, LOCATOR_INFO_FILE_NAME);
        try {
            res = res.getCanonicalFile();
        }
        catch (IOException ex) {
            res = res.getAbsoluteFile();
        }
        return res;
    }

    public static String getLocatorStatusCodeString(File directory) {
        return ManagerInfo.statusToString(ManagerInfo.getLocatorStatusCode(directory));
    }

    public static int getLocatorStatusCode(File directory) {
        return ManagerInfo.getManagerStatusCode(directory, true);
    }

    private static int getManagerStatusCode(File directory, boolean locator) {
        boolean interrupted = false;
        try {
            ManagerInfo mi = ManagerInfo.loadManagerInfo(directory, locator);
            if (!PureJavaMode.isPure() && !OSProcess.exists(mi.getManagerProcessId())) {
                int n = 2;
                return n;
            }
            int n = mi.getManagerStatus();
            return n;
        }
        catch (UnstartedSystemException ex) {
            int n = 0;
            return n;
        }
        catch (GemFireIOException ex) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {
                interrupted = true;
            }
            try {
                ManagerInfo.loadManagerInfo(directory, locator);
                int ignore = ManagerInfo.getManagerStatusCode(directory, locator);
                return ignore;
            }
            catch (UnstartedSystemException ignore) {
                int n = 0;
                return n;
            }
            catch (GemFireIOException ex2) {
                throw ex2;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean isLocatorStarted(File directory) {
        return ManagerInfo.isManagerStarted(directory, true);
    }

    private static boolean isManagerStarted(File directory, boolean locator) {
        try {
            ManagerInfo mi = ManagerInfo.loadManagerInfo(directory, locator);
            int status = mi.getManagerStatus();
            if (status != 4) {
                return false;
            }
            return PureJavaMode.isPure() || OSProcess.exists(mi.getManagerProcessId());
        }
        catch (UnstartedSystemException ignore) {
            return false;
        }
        catch (GemFireIOException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                return false;
            }
            if (cause instanceof InvalidClassException) {
                throw ex;
            }
            return false;
        }
    }

    public static boolean isLocatorRunning(File directory) {
        return ManagerInfo.isManagerRunning(directory, true);
    }

    private static boolean isManagerRunning(File directory, boolean locator) {
        try {
            ManagerInfo mi = ManagerInfo.loadManagerInfo(directory, locator);
            int status = mi.getManagerStatus();
            if (status != 4 && status != 3 && status != 1) {
                return false;
            }
            return PureJavaMode.isPure() || OSProcess.exists(mi.getManagerProcessId());
        }
        catch (UnstartedSystemException ignore) {
            return false;
        }
        catch (GemFireIOException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                return true;
            }
            if (cause instanceof InvalidClassException) {
                throw ex;
            }
            return true;
        }
    }

    public static boolean isLocatorStopped(File directory) {
        return ManagerInfo.isManagerStopped(directory, true);
    }

    private static boolean isManagerStopped(File directory, boolean locator) {
        try {
            ManagerInfo mi = ManagerInfo.loadManagerInfo(directory, locator);
            return !OSProcess.exists(mi.getManagerProcessId());
        }
        catch (UnstartedSystemException ignore) {
            return true;
        }
        catch (GemFireIOException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                return false;
            }
            if (cause instanceof InvalidClassException) {
                throw ex;
            }
            return false;
        }
    }

    private ManagerInfo(int pid, int status, int port, InetAddress bindAddress) {
        this.managerPid = pid;
        this.managerStatus = status;
        this.port = port;
        this.bindAddress = bindAddress;
    }

    public ManagerInfo() {
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.managerPid);
        out.writeInt(this.managerStatus);
        out.writeInt(this.port);
        if (this.bindAddress == null) {
            out.writeByte(0);
        } else {
            byte[] address = this.bindAddress.getAddress();
            out.writeByte(address.length);
            out.write(address, 0, address.length);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.managerPid = in.readInt();
        this.managerStatus = in.readInt();
        this.port = in.readInt();
        byte len = in.readByte();
        if (len > 0) {
            byte[] addr = new byte[len];
            in.readFully(addr);
            this.bindAddress = InetAddress.getByAddress(addr);
        }
    }
}

