/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer buffer;
    private static final int DEFAULT_SIZE = 1024;

    public ByteBufferOutputStream() {
        this.buffer = ByteBuffer.allocate(1024);
    }

    public ByteBufferOutputStream(int initialSize) {
        this.buffer = ByteBuffer.allocate(initialSize);
    }

    @Override
    public final void write(int b) {
        try {
            this.buffer.put((byte)(b & 0xFF));
        }
        catch (BufferOverflowException e) {
            this.expand(1);
            this.buffer.put((byte)(b & 0xFF));
        }
        catch (BufferUnderflowException e) {
            this.expand(1);
            this.buffer.put((byte)(b & 0xFF));
        }
    }

    private void expand(int amount) {
        int oldcap = this.buffer.capacity();
        int newcap = oldcap + amount + 1024;
        ByteBuffer tmp = ByteBuffer.allocate(newcap);
        this.buffer.flip();
        tmp.put(this.buffer);
        this.buffer = tmp;
    }

    @Override
    public final void write(byte[] source, int offset, int len) {
        try {
            this.buffer.put(source, offset, len);
        }
        catch (BufferOverflowException e) {
            this.expand(len - (this.buffer.capacity() - this.buffer.position()));
            this.buffer.put(source, offset, len);
        }
        catch (BufferUnderflowException e) {
            this.expand(len - (this.buffer.capacity() - this.buffer.position()));
            this.buffer.put(source, offset, len);
        }
    }

    public final int size() {
        return this.buffer.position();
    }

    public final void reset() {
        this.buffer.clear();
    }

    public final ByteBuffer getContentBuffer() {
        this.buffer.flip();
        return this.buffer;
    }

    public final ByteBuffer getDuplicateBuffer() {
        return this.buffer.duplicate();
    }
}

