/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.gms.messages.HasMemberID;
import org.apache.geode.internal.Version;

public class RemoveMemberMessage
extends HighPriorityDistributionMessage
implements HasMemberID {
    private InternalDistributedMember memberID;
    private String reason;

    public RemoveMemberMessage(InternalDistributedMember recipient, InternalDistributedMember id, String reason) {
        this.setRecipient(recipient);
        this.memberID = id;
        this.reason = reason;
    }

    public RemoveMemberMessage(List<InternalDistributedMember> recipients, InternalDistributedMember id, String reason) {
        this.setRecipients(recipients);
        this.memberID = id;
        this.reason = reason;
    }

    public RemoveMemberMessage() {
    }

    @Override
    public int getDSFID() {
        return -153;
    }

    @Override
    public void process(DistributionManager dm) {
        throw new IllegalStateException("this message is not intended to execute in a thread pool");
    }

    @Override
    public InternalDistributedMember getMemberID() {
        return this.memberID;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public String toString() {
        return this.getShortClassName() + "(" + this.memberID + "; reason=" + this.reason + ")";
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.memberID, out);
        DataSerializer.writeString(this.reason, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberID = (InternalDistributedMember)DataSerializer.readObject(in);
        this.reason = DataSerializer.readString(in);
    }
}

