/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.NetView;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Version;

public class FindCoordinatorResponse
extends HighPriorityDistributionMessage
implements DataSerializableFixedID {
    private InternalDistributedMember coordinator;
    private InternalDistributedMember senderId;
    private boolean fromView;
    private NetView view;
    private Set<InternalDistributedMember> registrants;
    private boolean networkPartitionDetectionEnabled;
    private boolean usePreferredCoordinators;
    private boolean isShortForm;
    private byte[] coordinatorPublicKey;
    private String rejectionMessage;
    private int requestId;

    public FindCoordinatorResponse(InternalDistributedMember coordinator, InternalDistributedMember senderId, boolean fromView, NetView view, HashSet<InternalDistributedMember> registrants, boolean networkPartitionDectionEnabled, boolean usePreferredCoordinators, byte[] pk) {
        this.coordinator = coordinator;
        this.senderId = senderId;
        this.fromView = fromView;
        this.view = view;
        this.registrants = registrants;
        this.networkPartitionDetectionEnabled = networkPartitionDectionEnabled;
        this.usePreferredCoordinators = usePreferredCoordinators;
        this.isShortForm = false;
        this.coordinatorPublicKey = pk;
    }

    public FindCoordinatorResponse(InternalDistributedMember coordinator, InternalDistributedMember senderId, byte[] pk, int requestId) {
        this.coordinator = coordinator;
        this.senderId = senderId;
        this.isShortForm = true;
        this.coordinatorPublicKey = pk;
        this.requestId = requestId;
    }

    public FindCoordinatorResponse(String m) {
        this.rejectionMessage = m;
    }

    public FindCoordinatorResponse() {
    }

    public byte[] getCoordinatorPublicKey() {
        return this.coordinatorPublicKey;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public String getRejectionMessage() {
        return this.rejectionMessage;
    }

    public boolean isNetworkPartitionDetectionEnabled() {
        return this.networkPartitionDetectionEnabled;
    }

    public boolean isUsePreferredCoordinators() {
        return this.usePreferredCoordinators;
    }

    public InternalDistributedMember getCoordinator() {
        return this.coordinator;
    }

    public InternalDistributedMember getSenderId() {
        return this.senderId;
    }

    public boolean isFromView() {
        return this.fromView;
    }

    public NetView getView() {
        return this.view;
    }

    public Set<InternalDistributedMember> getRegistrants() {
        return this.registrants;
    }

    @Override
    public String toString() {
        if (this.isShortForm) {
            return "FindCoordinatorResponse(coordinator=" + this.coordinator + ")";
        }
        return "FindCoordinatorResponse(coordinator=" + this.coordinator + ", fromView=" + this.fromView + ", viewId=" + (this.view == null ? "null" : Integer.valueOf(this.view.getViewId())) + ", registrants=" + (this.registrants == null ? 0 : this.registrants.size()) + ", senderId=" + this.senderId + ", network partition detection enabled=" + this.networkPartitionDetectionEnabled + ", locators preferred as coordinators=" + this.usePreferredCoordinators + ")";
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return -144;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.coordinator, out);
        DataSerializer.writeObject(this.senderId, out);
        InternalDataSerializer.writeByteArray(this.coordinatorPublicKey, out);
        InternalDataSerializer.writeString(this.rejectionMessage, out);
        out.writeBoolean(this.isShortForm);
        out.writeBoolean(this.fromView);
        out.writeBoolean(this.networkPartitionDetectionEnabled);
        out.writeBoolean(this.usePreferredCoordinators);
        DataSerializer.writeObject(this.view, out);
        InternalDataSerializer.writeSet(this.registrants, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.coordinator = (InternalDistributedMember)DataSerializer.readObject(in);
        this.senderId = (InternalDistributedMember)DataSerializer.readObject(in);
        this.coordinatorPublicKey = InternalDataSerializer.readByteArray(in);
        this.rejectionMessage = InternalDataSerializer.readString(in);
        this.isShortForm = in.readBoolean();
        if (!this.isShortForm) {
            this.fromView = in.readBoolean();
            this.networkPartitionDetectionEnabled = in.readBoolean();
            this.usePreferredCoordinators = in.readBoolean();
            this.view = (NetView)DataSerializer.readObject(in);
            this.registrants = InternalDataSerializer.readHashSet(in);
        }
    }

    @Override
    protected void process(DistributionManager dm) {
        throw new IllegalStateException("this message should not be executed");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FindCoordinatorResponse other = (FindCoordinatorResponse)obj;
        if (this.coordinator == null ? other.coordinator != null : !this.coordinator.equals(other.coordinator)) {
            return false;
        }
        if (!Arrays.equals(this.coordinatorPublicKey, other.coordinatorPublicKey)) {
            return false;
        }
        if (this.fromView != other.fromView) {
            return false;
        }
        if (this.isShortForm != other.isShortForm) {
            return false;
        }
        if (this.networkPartitionDetectionEnabled != other.networkPartitionDetectionEnabled) {
            return false;
        }
        if (this.registrants == null ? other.registrants != null : !this.registrants.equals(other.registrants)) {
            return false;
        }
        if (this.senderId == null ? other.senderId != null : !this.senderId.equals(other.senderId)) {
            return false;
        }
        if (this.usePreferredCoordinators != other.usePreferredCoordinators) {
            return false;
        }
        return !(this.view == null ? other.view != null : !this.view.equals(other.view));
    }
}

