/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class LocatorStats {
    private static StatisticsType type;
    private static final String KNOWN_LOCATORS = "locators";
    private static final String REQUESTS_TO_LOCATOR = "locatorRequests";
    private static final String RESPONSES_FROM_LOCATOR = "locatorResponses";
    private static final String ENDPOINTS_KNOWN = "servers";
    private static final String REQUESTS_IN_PROGRESS = "requestsInProgress";
    private static final String REQUEST_TIME = "requestProcessingTime";
    private static final String RESPONSE_TIME = "responseProcessingTime";
    private static final String SERVER_LOAD_UPDATES = "serverLoadUpdates";
    private AtomicInteger known_locators = new AtomicInteger();
    private AtomicLong requests_to_locator = new AtomicLong();
    private AtomicLong requestTime = new AtomicLong();
    private AtomicLong responseTime = new AtomicLong();
    private AtomicLong responses_from_locator = new AtomicLong();
    private AtomicInteger endpoints_known = new AtomicInteger();
    private AtomicInteger requestsInProgress = new AtomicInteger();
    private AtomicLong serverLoadUpdates = new AtomicLong();
    private static final int _KNOWN_LOCATORS;
    private static final int _REQUESTS_TO_LOCATOR;
    private static final int _RESPONSES_FROM_LOCATOR;
    private static final int _ENDPOINTS_KNOWN;
    private static final int _REQUESTS_IN_PROGRESS;
    private static final int _REQUEST_TIME;
    private static final int _RESPONSE_TIME;
    private static final int _SERVER_LOAD_UPDATES;
    private Statistics _stats = null;

    public void hookupStats(StatisticsFactory f, String name) {
        if (this._stats == null) {
            this._stats = f.createAtomicStatistics(type, name);
            this.setLocatorCount(this.known_locators.get());
            this.setServerCount(this.endpoints_known.get());
            this.setLocatorRequests(this.requests_to_locator.get());
            this.setLocatorResponses(this.responses_from_locator.get());
            this.setServerLoadUpdates(this.serverLoadUpdates.get());
        }
    }

    public final void setServerCount(int sc) {
        if (this._stats == null) {
            this.endpoints_known.set(sc);
        } else {
            this._stats.setInt(_ENDPOINTS_KNOWN, sc);
        }
    }

    public final void setLocatorCount(int lc) {
        if (this._stats == null) {
            this.known_locators.set(lc);
        } else {
            this._stats.setInt(_KNOWN_LOCATORS, lc);
        }
    }

    public final void endLocatorRequest(long startTime) {
        long took = DistributionStats.getStatTime() - startTime;
        if (this._stats == null) {
            this.requests_to_locator.incrementAndGet();
            if (took > 0L) {
                this.requestTime.getAndAdd(took);
            }
        } else {
            this._stats.incLong(_REQUESTS_TO_LOCATOR, 1L);
            if (took > 0L) {
                this._stats.incLong(_REQUEST_TIME, took);
            }
        }
    }

    public final void endLocatorResponse(long startTime) {
        long took = DistributionStats.getStatTime() - startTime;
        if (this._stats == null) {
            this.responses_from_locator.incrementAndGet();
            if (took > 0L) {
                this.responseTime.getAndAdd(took);
            }
        } else {
            this._stats.incLong(_RESPONSES_FROM_LOCATOR, 1L);
            if (took > 0L) {
                this._stats.incLong(_RESPONSE_TIME, took);
            }
        }
    }

    public final void setLocatorRequests(long rl) {
        if (this._stats == null) {
            this.requests_to_locator.set(rl);
        } else {
            this._stats.setLong(_REQUESTS_TO_LOCATOR, rl);
        }
    }

    public final void setLocatorResponses(long rl) {
        if (this._stats == null) {
            this.responses_from_locator.set(rl);
        } else {
            this._stats.setLong(_RESPONSES_FROM_LOCATOR, rl);
        }
    }

    public final void setServerLoadUpdates(long v) {
        if (this._stats == null) {
            this.serverLoadUpdates.set(v);
        } else {
            this._stats.setLong(_SERVER_LOAD_UPDATES, v);
        }
    }

    public final void incServerLoadUpdates() {
        if (this._stats == null) {
            this.serverLoadUpdates.incrementAndGet();
        } else {
            this._stats.incLong(_SERVER_LOAD_UPDATES, 1L);
        }
    }

    public void incRequestInProgress(int threads) {
        if (this._stats != null) {
            this._stats.incInt(_REQUESTS_IN_PROGRESS, threads);
        } else {
            this.requestsInProgress.getAndAdd(threads);
        }
    }

    public void close() {
        if (this._stats != null) {
            this._stats.close();
        }
    }

    static {
        String statName = "LocatorStats";
        String statDescription = "Statistics on the gemfire locator.";
        String serverThreadsDesc = "The number of location requests currently being processed by the thread pool.";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType(statName, statDescription, new StatisticDescriptor[]{f.createIntGauge(KNOWN_LOCATORS, "Number of locators known to this locator", KNOWN_LOCATORS), f.createLongCounter(REQUESTS_TO_LOCATOR, "Number of requests this locator has received from clients", "requests"), f.createLongCounter(RESPONSES_FROM_LOCATOR, "Number of responses this locator has sent to clients", "responses"), f.createIntGauge(ENDPOINTS_KNOWN, "Number of servers this locator knows about", ENDPOINTS_KNOWN), f.createIntGauge(REQUESTS_IN_PROGRESS, serverThreadsDesc, "requests"), f.createLongCounter(REQUEST_TIME, "Time spent processing server location requests", "nanoseconds"), f.createLongCounter(RESPONSE_TIME, "Time spent sending location responses to clients", "nanoseconds"), f.createLongCounter(SERVER_LOAD_UPDATES, "Total number of times a server load update has been received.", "updates")});
        _REQUESTS_IN_PROGRESS = type.nameToId(REQUESTS_IN_PROGRESS);
        _KNOWN_LOCATORS = type.nameToId(KNOWN_LOCATORS);
        _REQUESTS_TO_LOCATOR = type.nameToId(REQUESTS_TO_LOCATOR);
        _RESPONSES_FROM_LOCATOR = type.nameToId(RESPONSES_FROM_LOCATOR);
        _ENDPOINTS_KNOWN = type.nameToId(ENDPOINTS_KNOWN);
        _REQUEST_TIME = type.nameToId(REQUEST_TIME);
        _RESPONSE_TIME = type.nameToId(RESPONSE_TIME);
        _SERVER_LOAD_UPDATES = type.nameToId(SERVER_LOAD_UPDATES);
    }
}

