/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.wan;

import java.util.List;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewayTransportFilter;

public interface GatewaySender {
    public static final boolean DEFAULT_MANUAL_START = false;
    public static final boolean DEFAULT_DISK_SYNCHRONOUS = true;
    public static final int DEFAULT_SOCKET_BUFFER_SIZE = 524288;
    public static final int DEFAULT_SOCKET_READ_TIMEOUT = Integer.getInteger("gemfire.cache.gatewaySender.default-socket-read-timeout", 0);
    public static final int MINIMUM_SOCKET_READ_TIMEOUT = 30000;
    public static final int QUEUE_OPLOG_SIZE = Integer.getInteger("gemfire.cache.gatewaySender.queueOpLogSize", 0x6400000);
    public static final boolean DEFAULT_PERSISTENCE_ENABLED = false;
    public static final boolean DEFAULT_BATCH_CONFLATION = false;
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final int DEFAULT_BATCH_TIME_INTERVAL = 1000;
    public static final int DEFAULT_ALERT_THRESHOLD = 0;
    public static final int DEFAULT_PARALLELISM_REPLICATED_REGION = Integer.getInteger("gemfire.cache.gatewaySender.defaultParallelismForReplicatedRegion", 113);
    public static final int DEFAULT_DISTRIBUTED_SYSTEM_ID = -1;
    public static final int DEFAULT_DISPATCHER_THREADS = 5;
    public static final boolean DEFAULT_FORWARD_EXPIRATION_DESTROY = false;
    public static final OrderPolicy DEFAULT_ORDER_POLICY = OrderPolicy.KEY;
    public static final int DEFAULT_MAXIMUM_QUEUE_MEMORY = 100;
    public static final long GATEWAY_SENDER_TIMEOUT = Integer.getInteger("gemfire.GATEWAY_SENDER_TIMEOUT", 30).intValue();
    public static final String GATEWAY_CONNECTION_READ_TIMEOUT_PROPERTY = "gemfire.GatewaySender.GATEWAY_CONNECTION_READ_TIMEOUT";
    public static final int GATEWAY_CONNECTION_IDLE_TIMEOUT = Integer.getInteger("gemfire.GatewaySender.GATEWAY_CONNECTION_IDLE_TIMEOUT", -1);
    public static final boolean REMOVE_FROM_QUEUE_ON_EXCEPTION = System.getProperty("gemfire.GatewaySender.REMOVE_FROM_QUEUE_ON_EXCEPTION") != null ? Boolean.getBoolean("gemfire.GatewaySender.REMOVE_FROM_QUEUE_ON_EXCEPTION") : true;
    public static final boolean EARLY_ACK = Boolean.getBoolean("gemfire.GatewaySender.EARLY_ACK");
    public static final boolean DEFAULT_IS_PARALLEL = false;
    public static final boolean DEFAULT_IS_FOR_INTERNAL_USE = false;
    public static final int CONNECTION_RETRY_INTERVAL = Integer.getInteger("gemfire.gateway-connection-retry-interval", 1000);

    public void start();

    public void stop();

    public void pause();

    public void resume();

    public void rebalance();

    public boolean isRunning();

    public boolean isPaused();

    public void addGatewayEventFilter(GatewayEventFilter var1);

    public void removeGatewayEventFilter(GatewayEventFilter var1);

    public GatewayEventSubstitutionFilter getGatewayEventSubstitutionFilter();

    public String getId();

    public int getRemoteDSId();

    public int getSocketBufferSize();

    public int getSocketReadTimeout();

    public String getDiskStoreName();

    public int getMaximumQueueMemory();

    public int getBatchSize();

    public int getBatchTimeInterval();

    public boolean isBatchConflationEnabled();

    public boolean isPersistenceEnabled();

    public int getAlertThreshold();

    public List<GatewayEventFilter> getGatewayEventFilters();

    public List<GatewayTransportFilter> getGatewayTransportFilters();

    public boolean isDiskSynchronous();

    public boolean isManualStart();

    public boolean isParallel();

    public int getDispatcherThreads();

    public OrderPolicy getOrderPolicy();

    public int getMaxParallelismForReplicatedRegion();

    public static enum OrderPolicy {
        THREAD,
        KEY,
        PARTITION;

    }
}

