/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.geode.cache.query.internal.index.IndexManager;

public class IndexElemArray
implements Iterable,
Collection {
    private Object[] elementData;
    private volatile byte size;
    private Object lock = new Object();

    public IndexElemArray(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Object[initialCapacity];
    }

    public IndexElemArray() {
        this(IndexManager.INDEX_ELEMARRAY_SIZE);
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity + 5;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Object[] newElementData = new Object[newCapacity];
            System.arraycopy(this.elementData, 0, newElementData, 0, this.elementData.length);
            this.elementData = newElementData;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        Object object = this.lock;
        synchronized (object) {
            if (o == null) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.elementData[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.size; ++i) {
                    if (!o.equals(this.elementData[i])) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        Object object = this.lock;
        synchronized (object) {
            this.RangeCheck(index);
            return this.elementData[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        Object object = this.lock;
        synchronized (object) {
            this.RangeCheck(index);
            Object oldValue = this.elementData[index];
            this.elementData[index] = element;
            return oldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object e) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureCapacity(this.size + 1);
            this.elementData[this.size] = e;
            this.size = (byte)(this.size + 1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Object object = this.lock;
        synchronized (object) {
            if (o == null) {
                for (int index = 0; index < this.size; ++index) {
                    if (this.elementData[index] != null) continue;
                    this.fastRemove(index);
                    return true;
                }
            } else {
                for (int index = 0; index < this.size; ++index) {
                    if (!o.equals(this.elementData[index])) continue;
                    this.fastRemove(index);
                    return true;
                }
            }
        }
        return false;
    }

    private void fastRemove(int index) {
        int len = this.elementData.length;
        Object[] newArray = new Object[len - 1];
        System.arraycopy(this.elementData, 0, newArray, 0, index);
        int numMoved = len - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, newArray, index, numMoved);
        }
        this.elementData = newArray;
        this.size = (byte)(this.size - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.size; ++i) {
                this.elementData[i] = null;
            }
            this.size = 0;
        }
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        Object object = this.lock;
        synchronized (object) {
            this.ensureCapacity(this.size + numNew);
            System.arraycopy(a, 0, this.elementData, this.size, numNew);
            this.size = (byte)(this.size + numNew);
        }
        return numNew != 0;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, (int)this.size);
    }

    @Override
    public Iterator iterator() {
        return new IndexArrayListIterator();
    }

    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException("toArray(Object[] a) method is not supported");
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException("containsAll() method is not supported");
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("removeAll() method is not supported");
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("retainAll() method is not supported");
    }

    public Object[] getElementData() {
        return this.elementData;
    }

    private class IndexArrayListIterator
    implements Iterator {
        private byte current;
        private Object currentEntry;
        private Object[] elements;
        private int len;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IndexArrayListIterator() {
            Object object = IndexElemArray.this.lock;
            synchronized (object) {
                this.elements = IndexElemArray.this.elementData;
                this.len = IndexElemArray.this.size;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current < this.len;
        }

        public Object next() {
            try {
                byte by = this.current;
                this.current = (byte)(by + 1);
                this.currentEntry = this.elements[by];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
            return this.currentEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() method is not supported");
        }
    }
}

