/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CompiledRegion
extends AbstractCompiledValue {
    private String regionPath;

    public CompiledRegion(String regionPath) {
        this.regionPath = regionPath;
    }

    @Override
    public int getType() {
        return 35;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws RegionNotFoundException {
        Region rgn;
        Cache cache = context.getCache();
        PartitionedRegion pr = context.getPartitionedRegion();
        if (pr != null && pr.getFullPath().equals(this.regionPath)) {
            rgn = context.getBucketRegion();
        } else if (pr != null) {
            BucketRegion br = context.getBucketRegion();
            int bucketID = br.getId();
            rgn = cache.getRegion(this.regionPath);
            if (rgn.getAttributes().getDataPolicy().withPartitioning()) {
                PartitionedRegion prLocal = (PartitionedRegion)rgn;
                rgn = prLocal.getDataStore().getLocalBucketById(bucketID);
            }
        } else {
            rgn = cache.getRegion(this.regionPath);
        }
        if (rgn == null) {
            if (cache.isClosed()) {
                throw new CacheClosedException();
            }
            throw new RegionNotFoundException(LocalizedStrings.CompiledRegion_REGION_NOT_FOUND_0.toLocalizedString(this.regionPath));
        }
        if (context.isCqQueryContext()) {
            return new QRegion(rgn, true, context);
        }
        return new QRegion(rgn, false, context);
    }

    @Override
    public void generateCanonicalizedExpression(StringBuffer clauseBuffer, ExecutionContext context) throws NameResolutionException {
        clauseBuffer.insert(0, this.regionPath);
    }

    @Override
    public void getRegionsInQuery(Set regionsInQuery, Object[] parameters) {
        regionsInQuery.add(this.regionPath);
    }
}

