/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.CqEntry;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.MapIndexable;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class CompiledIndexOperation
extends AbstractCompiledValue
implements MapIndexable {
    private CompiledValue receiver;
    private CompiledValue indexExpr;
    private boolean evalRegionAsEntry = false;

    public CompiledIndexOperation(CompiledValue receiver, CompiledValue indexExpr) {
        this.receiver = receiver;
        this.indexExpr = indexExpr;
    }

    public CompiledIndexOperation(CompiledValue receiver, CompiledValue indexExpr, boolean evalRegionAsEntry) {
        this.receiver = receiver;
        this.indexExpr = indexExpr;
        this.evalRegionAsEntry = evalRegionAsEntry;
    }

    @Override
    public List getChildren() {
        ArrayList<CompiledValue> list = new ArrayList<CompiledValue>();
        list.add(this.receiver);
        list.add(this.indexExpr);
        return list;
    }

    @Override
    public int getType() {
        return 24;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        context.addDependencies(this, this.receiver.computeDependencies(context));
        return context.addDependencies(this, this.indexExpr.computeDependencies(context));
    }

    @Override
    public Object evaluate(ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        Object rcvr = this.receiver.evaluate(context);
        Object index = this.indexExpr.evaluate(context);
        if (rcvr == null || rcvr == QueryService.UNDEFINED) {
            return QueryService.UNDEFINED;
        }
        if (context.isCqQueryContext() && (rcvr instanceof Region.Entry || rcvr instanceof CqEntry)) {
            try {
                Object re;
                if (rcvr instanceof Region.Entry) {
                    re = (Region.Entry)rcvr;
                    if (re.isDestroyed()) {
                        return QueryService.UNDEFINED;
                    }
                    rcvr = re.getValue();
                } else if (rcvr instanceof CqEntry) {
                    re = (CqEntry)rcvr;
                    rcvr = ((CqEntry)re).getValue();
                }
            }
            catch (EntryDestroyedException ede) {
                return QueryService.UNDEFINED;
            }
        }
        if (rcvr instanceof Map) {
            return ((Map)rcvr).get(index);
        }
        if ((rcvr instanceof List || rcvr.getClass().isArray() || rcvr instanceof String) && !(index instanceof Integer)) {
            throw new TypeMismatchException(LocalizedStrings.CompiledIndexOperation_INDEX_EXPRESSION_MUST_BE_AN_INTEGER_FOR_LISTS_OR_ARRAYS.toLocalizedString());
        }
        if (rcvr instanceof List) {
            return ((List)rcvr).get((Integer)index);
        }
        if (rcvr instanceof String) {
            return new Character(((String)rcvr).charAt((Integer)index));
        }
        if (rcvr.getClass().isArray()) {
            return Array.get(rcvr, (Integer)index);
        }
        if (rcvr instanceof QRegion) {
            Region.Entry entry = ((QRegion)rcvr).getEntry(index);
            if (entry == null) {
                return null;
            }
            return this.evalRegionAsEntry ? entry : entry.getValue();
        }
        throw new TypeMismatchException(LocalizedStrings.CompiledIndexOperation_INDEX_EXPRESSION_NOT_SUPPORTED_ON_OBJECTS_OF_TYPE_0.toLocalizedString(rcvr.getClass().getName()));
    }

    @Override
    public void generateCanonicalizedExpression(StringBuffer clauseBuffer, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        clauseBuffer.insert(0, ']');
        this.indexExpr.generateCanonicalizedExpression(clauseBuffer, context);
        clauseBuffer.insert(0, '[');
        this.receiver.generateCanonicalizedExpression(clauseBuffer, context);
    }

    @Override
    public CompiledValue getReceiver() {
        return this.receiver;
    }

    public CompiledValue getExpression() {
        return this.indexExpr;
    }

    @Override
    public CompiledValue getMapLookupKey() {
        return this.indexExpr;
    }

    @Override
    public CompiledValue getRecieverSansIndexArgs() {
        return this.receiver;
    }

    @Override
    public List<CompiledValue> getIndexingKeys() {
        ArrayList<CompiledValue> list = new ArrayList<CompiledValue>(1);
        list.add(this.indexExpr);
        return list;
    }
}

