/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.AbstractGroupOrRangeJunction;
import org.apache.geode.cache.query.internal.CompiledJunction;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.CompositeGroupJunction;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Filter;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.parse.OQLLexerTokenTypes;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;

public class AllGroupJunction
extends AbstractCompiledValue
implements Filter,
OQLLexerTokenTypes {
    private List abstractGroupOrRangeJunctions = null;
    private int operator = 0;
    private List iterOperands = null;

    AllGroupJunction(List abstractGroupOrRangeJunctions, int operator, List iterOperands) {
        this.operator = operator;
        this.abstractGroupOrRangeJunctions = abstractGroupOrRangeJunctions;
        if (operator != 90) {
            Support.Assert(iterOperands.size() == 0, "For OR Junction all operands need to be filterOperands");
        }
        this.iterOperands = iterOperands;
    }

    @Override
    public List getChildren() {
        ArrayList children = new ArrayList();
        children.addAll(this.abstractGroupOrRangeJunctions);
        children.addAll(this.iterOperands);
        return children;
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        Support.assertionFailed("Should not have come here");
        return null;
    }

    @Override
    public int getType() {
        return -8;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.operator == 90) {
            return this.evaluateAndJunction(context);
        }
        return this.evaluateOrJunction(context);
    }

    private SelectResults evaluateAndJunction(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        int len = this.abstractGroupOrRangeJunctions.size();
        Collection[] results = new SelectResults[len];
        List finalList = context.getCurrentIterators();
        LinkedList expansionList = new LinkedList(finalList);
        RuntimeIterator[][] itrsForResultFields = new RuntimeIterator[len][];
        CompiledValue gj = null;
        Iterator junctionItr = this.abstractGroupOrRangeJunctions.iterator();
        List grpItrs = null;
        int j = 0;
        RuntimeIterator tempItr = null;
        while (junctionItr.hasNext()) {
            gj = (CompiledValue)junctionItr.next();
            SelectResults filterResults = ((Filter)((Object)gj)).filterEvaluate(context, null);
            Support.Assert(filterResults != null, "FilterResults cannot be null here");
            if (filterResults.isEmpty()) {
                ObjectType type;
                if (finalList.size() > 1) {
                    type = QueryUtils.createStructTypeForRuntimeIterators(finalList);
                    return QueryUtils.createStructCollection(context, type);
                }
                type = ((RuntimeIterator)finalList.iterator().next()).getElementType();
                if (type instanceof StructType) {
                    return QueryUtils.createStructCollection(context, (StructTypeImpl)type);
                }
                return QueryUtils.createResultCollection(context, type);
            }
            results[j] = filterResults;
            grpItrs = gj instanceof CompositeGroupJunction ? QueryUtils.getDependentItrChainForIndpndntItrs(((CompositeGroupJunction)gj).getIndependentIteratorsOfCJ(), context) : context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(((AbstractGroupOrRangeJunction)gj).getIndependentIteratorForGroup()[0]);
            itrsForResultFields[j] = new RuntimeIterator[grpItrs.size()];
            Iterator grpItr = grpItrs.iterator();
            int k = 0;
            while (grpItr.hasNext()) {
                tempItr = (RuntimeIterator)grpItr.next();
                itrsForResultFields[j][k++] = tempItr;
                expansionList.remove(tempItr);
            }
            ++j;
        }
        SelectResults resultsSet = null;
        CompiledValue iterOperandsToSend = null;
        if (!this.iterOperands.isEmpty()) {
            int size = this.iterOperands.size();
            CompiledValue[] cv = new CompiledValue[size];
            for (int k = 0; k < size; ++k) {
                cv[k] = (CompiledValue)this.iterOperands.get(k);
            }
            iterOperandsToSend = cv.length == 1 ? cv[0] : new CompiledJunction(cv, this.operator);
        }
        QueryObserver observer = QueryObserverHolder.getInstance();
        observer.beforeCartesianOfGroupJunctionsInAnAllGroupJunctionOfType_AND(results);
        resultsSet = QueryUtils.cartesian((SelectResults[])results, itrsForResultFields, expansionList, finalList, context, iterOperandsToSend);
        observer.afterCartesianOfGroupJunctionsInAnAllGroupJunctionOfType_AND();
        Support.Assert(resultsSet != null, "ResultsSet obtained was NULL in AllGroupJunction");
        return resultsSet;
    }

    private SelectResults evaluateOrJunction(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        SelectResults[] grpResults = new SelectResults[1];
        List finalList = context.getCurrentIterators();
        RuntimeIterator[][] itrsForResultFields = new RuntimeIterator[1][];
        CompiledValue gj = null;
        Iterator junctionItr = this.abstractGroupOrRangeJunctions.iterator();
        List grpItrs = null;
        RuntimeIterator tempItr = null;
        SelectResults intermediateResults = null;
        while (junctionItr.hasNext()) {
            LinkedList expansionList = new LinkedList(finalList);
            gj = (CompiledValue)junctionItr.next();
            grpResults[0] = ((Filter)((Object)gj)).filterEvaluate(context, null);
            grpItrs = gj instanceof CompositeGroupJunction ? QueryUtils.getDependentItrChainForIndpndntItrs(((CompositeGroupJunction)gj).getIndependentIteratorsOfCJ(), context) : context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(((AbstractGroupOrRangeJunction)gj).getIndependentIteratorForGroup()[0]);
            itrsForResultFields[0] = new RuntimeIterator[grpItrs.size()];
            Iterator grpItr = grpItrs.iterator();
            int k = 0;
            while (grpItr.hasNext()) {
                tempItr = (RuntimeIterator)grpItr.next();
                itrsForResultFields[0][k++] = tempItr;
                expansionList.remove(tempItr);
            }
            SelectResults expandedResult = QueryUtils.cartesian(grpResults, itrsForResultFields, expansionList, finalList, context, null);
            intermediateResults = intermediateResults == null ? expandedResult : QueryUtils.union(expandedResult, intermediateResults, context);
        }
        return intermediateResults;
    }

    List getGroupOperands() {
        return Collections.unmodifiableList(this.abstractGroupOrRangeJunctions);
    }

    List getIterOperands() {
        return Collections.unmodifiableList(this.iterOperands);
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return 1;
    }
}

