/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SerializationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverHolder;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.util.BlobHelper;

public class RegisterDataSerializersOp {
    public static void execute(ExecutablePool pool, DataSerializer[] dataSerializers, EventID eventId) {
        RegisterDataSerializersOpImpl op = new RegisterDataSerializersOpImpl(dataSerializers, eventId);
        pool.execute(op);
    }

    public static void execute(ExecutablePool pool, InternalDataSerializer.SerializerAttributesHolder[] holders, EventID eventId) {
        RegisterDataSerializersOpImpl op = new RegisterDataSerializersOpImpl(holders, eventId);
        pool.execute(op);
    }

    private RegisterDataSerializersOp() {
    }

    private static class RegisterDataSerializersOpImpl
    extends AbstractOp {
        public RegisterDataSerializersOpImpl(DataSerializer[] dataSerializers, EventID eventId) {
            super(67, dataSerializers.length * 2 + 1);
            for (int i = 0; i < dataSerializers.length; ++i) {
                DataSerializer dataSerializer = dataSerializers[i];
                String className = dataSerializer.getClass().toString().substring(6);
                try {
                    this.getMessage().addBytesPart(BlobHelper.serializeToBlob(className));
                }
                catch (IOException ex) {
                    throw new SerializationException("failed serializing object", ex);
                }
                this.getMessage().addIntPart(dataSerializer.getId());
            }
            this.getMessage().addBytesPart(eventId.calcBytes());
            if (PoolImpl.IS_INSTANTIATOR_CALLBACK) {
                ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                bo.beforeSendingToServer(eventId);
            }
        }

        public RegisterDataSerializersOpImpl(InternalDataSerializer.SerializerAttributesHolder[] holders, EventID eventId) {
            super(67, holders.length * 2 + 1);
            for (int i = 0; i < holders.length; ++i) {
                try {
                    this.getMessage().addBytesPart(BlobHelper.serializeToBlob(holders[i].getClassName()));
                }
                catch (IOException ex) {
                    throw new SerializationException("failed serializing object", ex);
                }
                this.getMessage().addIntPart(holders[i].getId());
            }
            this.getMessage().addBytesPart(eventId.calcBytes());
            if (PoolImpl.IS_INSTANTIATOR_CALLBACK) {
                ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                bo.beforeSendingToServer(eventId);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "registerDataSerializers");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startRegisterDataSerializers();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endRegisterDataSerializersSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endRegisterDataSerializers(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }
    }
}

