/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.AllConnectionsInUseException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class PutOp {
    private static final Logger logger = LogService.getLogger();
    public static final byte HAS_OLD_VALUE_FLAG = 1;
    public static final byte OLD_VALUE_IS_OBJECT_FLAG = 2;
    public static final byte HAS_VERSION_TAG = 4;

    public static Object execute(ExecutablePool pool, LocalRegion region, Object key, Object value, byte[] deltaBytes, EntryEventImpl event, Operation operation, boolean requireOldValue, Object expectedOldValue, Object callbackArg, boolean prSingleHopEnabled) {
        ClientMetadataService cms;
        ServerLocation server;
        PutOpImpl op = new PutOpImpl(region, key, value, deltaBytes, event, operation, requireOldValue, expectedOldValue, callbackArg, false, prSingleHopEnabled);
        if (prSingleHopEnabled && (server = (cms = region.getCache().getClientMetadataService()).getBucketServerLocation(region, Operation.UPDATE, key, value, callbackArg)) != null) {
            try {
                PoolImpl poolImpl = (PoolImpl)pool;
                boolean onlyUseExistingCnx = poolImpl.getMaxConnections() != -1 && poolImpl.getConnectionCount() >= poolImpl.getMaxConnections();
                op.setAllowDuplicateMetadataRefresh(!onlyUseExistingCnx);
                return pool.executeOn(new ServerLocation(server.getHostName(), server.getPort()), op, true, onlyUseExistingCnx);
            }
            catch (AllConnectionsInUseException poolImpl) {
            }
            catch (ServerConnectivityException e) {
                if (e instanceof ServerOperationException) {
                    throw e;
                }
                cms.removeBucketServerLocation(server);
            }
        }
        return pool.execute(op);
    }

    public static Object execute(ExecutablePool pool, String regionName, Object key, Object value, byte[] deltaBytes, EntryEventImpl event, Operation operation, boolean requireOldValue, Object expectedOldValue, Object callbackArg, boolean prSingleHopEnabled, boolean isMetaRegionPutOp) {
        PutOpImpl op = new PutOpImpl(regionName, key, value, deltaBytes, event, operation, requireOldValue, expectedOldValue, callbackArg, false, prSingleHopEnabled);
        op.setMetaRegionPutOp(isMetaRegionPutOp);
        return pool.execute(op);
    }

    public static void execute(Connection con, ExecutablePool pool, String regionName, Object key, Object value, EntryEventImpl event, Object callbackArg, boolean prSingleHopEnabled) {
        PutOpImpl op = new PutOpImpl(regionName, key, value, null, event, Operation.CREATE, false, null, callbackArg, false, prSingleHopEnabled);
        pool.executeOn(con, (Op)op);
    }

    private PutOp() {
    }

    private static class PutOpImpl
    extends AbstractOp {
        private Object key;
        private LocalRegion region;
        private String regionName;
        private Object value;
        private boolean deltaSent = false;
        private EntryEventImpl event;
        private Object callbackArg;
        private boolean isMetaRegionPutOp;
        private boolean prSingleHopEnabled;
        private boolean requireOldValue;
        private Object expectedOldValue;

        public PutOpImpl(String regionName, Object key, Object value, byte[] deltaBytes, EntryEventImpl event, Operation op, boolean requireOldValue, Object expectedOldValue, Object callbackArg, boolean sendFullObj, boolean prSingleHopEnabled) {
            super(7, 7 + (callbackArg != null ? 1 : 0) + (expectedOldValue != null ? 1 : 0));
            boolean isDebugEnabled = logger.isDebugEnabled();
            if (isDebugEnabled) {
                logger.debug("PutOpImpl constructing(1) message for {}; operation={}", (Object)event.getEventId(), (Object)op);
            }
            this.key = key;
            this.callbackArg = callbackArg;
            this.event = event;
            this.value = value;
            this.regionName = regionName;
            this.prSingleHopEnabled = prSingleHopEnabled;
            this.requireOldValue = requireOldValue;
            this.expectedOldValue = expectedOldValue;
            this.getMessage().addStringPart(regionName);
            this.getMessage().addObjPart(op);
            int flags = 0;
            if (requireOldValue) {
                flags |= 1;
            }
            if (expectedOldValue != null) {
                flags |= 2;
            }
            this.getMessage().addIntPart(flags);
            if (expectedOldValue != null) {
                this.getMessage().addObjPart(expectedOldValue);
            }
            this.getMessage().addStringOrObjPart(key);
            if (!sendFullObj && deltaBytes != null && op == Operation.UPDATE) {
                this.getMessage().addObjPart(Boolean.TRUE);
                this.getMessage().addBytesPart(deltaBytes);
                this.deltaSent = true;
                if (isDebugEnabled) {
                    logger.debug("PutOp: Sending delta for key {}", this.key);
                }
            } else if (value instanceof CachedDeserializable) {
                CachedDeserializable cd = (CachedDeserializable)value;
                if (!cd.isSerialized()) {
                    this.getMessage().addObjPart(Boolean.FALSE);
                    this.getMessage().addObjPart(cd.getDeserializedForReading());
                } else {
                    this.getMessage().addObjPart(Boolean.FALSE);
                    Object cdValue = cd.getValue();
                    if (cdValue instanceof byte[]) {
                        this.getMessage().addRawPart((byte[])cdValue, true);
                    } else {
                        this.getMessage().addObjPart(cdValue);
                    }
                }
            } else {
                this.getMessage().addObjPart(Boolean.FALSE);
                this.getMessage().addObjPart(value);
            }
            this.getMessage().addBytesPart(event.getEventId().calcBytes());
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        public PutOpImpl(Region region, Object key, Object value, byte[] deltaBytes, EntryEventImpl event, Operation op, boolean requireOldValue, Object expectedOldValue, Object callbackArg, boolean sendFullObj, boolean prSingleHopEnabled) {
            super(7, 7 + (callbackArg != null ? 1 : 0) + (expectedOldValue != null ? 1 : 0));
            this.key = key;
            this.callbackArg = callbackArg;
            this.event = event;
            this.value = value;
            this.region = (LocalRegion)region;
            this.regionName = region.getFullPath();
            this.prSingleHopEnabled = prSingleHopEnabled;
            boolean isDebugEnabled = logger.isDebugEnabled();
            if (isDebugEnabled) {
                logger.debug("PutOpImpl constructing message with operation={}", (Object)op);
            }
            this.getMessage().addStringPart(region.getFullPath());
            this.getMessage().addObjPart(op);
            int flags = 0;
            if (requireOldValue) {
                flags |= 1;
            }
            if (expectedOldValue != null) {
                flags |= 2;
            }
            this.getMessage().addIntPart(flags);
            if (expectedOldValue != null) {
                this.getMessage().addObjPart(expectedOldValue);
            }
            this.getMessage().addStringOrObjPart(key);
            if (!sendFullObj && deltaBytes != null && op == Operation.UPDATE) {
                this.getMessage().addObjPart(Boolean.TRUE);
                this.getMessage().addBytesPart(deltaBytes);
                this.deltaSent = true;
                if (isDebugEnabled) {
                    logger.debug("PutOp: Sending delta for key {}", this.key);
                }
            } else if (value instanceof CachedDeserializable) {
                CachedDeserializable cd = (CachedDeserializable)value;
                if (!cd.isSerialized()) {
                    this.getMessage().addObjPart(Boolean.FALSE);
                    this.getMessage().addObjPart(cd.getDeserializedForReading());
                } else {
                    this.getMessage().addObjPart(Boolean.FALSE);
                    Object cdValue = cd.getValue();
                    if (cdValue instanceof byte[]) {
                        this.getMessage().addRawPart((byte[])cdValue, true);
                    } else {
                        this.getMessage().addObjPart(cdValue);
                    }
                }
            } else {
                this.getMessage().addObjPart(Boolean.FALSE);
                this.getMessage().addObjPart(value);
            }
            this.getMessage().addBytesPart(event.getEventId().calcBytes());
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new UnsupportedOperationException("processResponse should not be invoked in PutOp.  Use processResponse(Message, Connection)");
        }

        @Override
        protected Object processResponse(Message msg, Connection con) throws Exception {
            ClientMetadataService cms;
            byte myVersion;
            Part part;
            byte[] bytesReceived;
            this.processAck(msg, "put", con);
            if (this.prSingleHopEnabled && (bytesReceived = (part = msg.getPart(0)).getSerializedForm())[0] != 0 && bytesReceived.length == 2 && this.region != null && ((myVersion = (cms = this.region.getCache().getClientMetadataService()).getMetaDataVersion(this.region, Operation.UPDATE, this.key, this.value, this.callbackArg)) != bytesReceived[0] || this.isAllowDuplicateMetadataRefresh())) {
                cms.scheduleGetPRMetaData(this.region, false, bytesReceived[1]);
            }
            if (msg.getMessageType() == 6 && msg.getNumberOfParts() > 1) {
                int flags = msg.getPart(1).getInt();
                int partIdx = 2;
                Object oldValue = null;
                if ((flags & 1) != 0) {
                    oldValue = msg.getPart(partIdx++).getObject();
                    if ((flags & 2) != 0 && oldValue instanceof byte[]) {
                        ByteArrayInputStream in = new ByteArrayInputStream((byte[])oldValue);
                        DataInputStream din = new DataInputStream(in);
                        oldValue = DataSerializer.readObject(din);
                    }
                }
                if ((flags & 4) != 0) {
                    VersionTag tag = (VersionTag)msg.getPart(partIdx++).getObject();
                    tag.replaceNullIDs((InternalDistributedMember)con.getEndpoint().getMemberId());
                    this.event.setVersionTag(tag);
                }
                return oldValue;
            }
            return null;
        }

        private final void processAck(Message msg, String opName, Connection con) throws Exception {
            int msgType = msg.getMessageType();
            if (this.deltaSent && this.region != null) {
                this.region.getCachePerfStats().incDeltasSent();
            }
            if (msgType == 6) {
                return;
            }
            Part part = msg.getPart(0);
            if (msgType == 70) {
                if (logger.isDebugEnabled()) {
                    logger.debug("PutOp: Sending full value as delta failed on server...");
                }
                PutOpImpl op = new PutOpImpl(this.regionName, this.key, this.value, null, this.event, Operation.CREATE, this.requireOldValue, this.expectedOldValue, this.callbackArg, true, this.prSingleHopEnabled);
                op.attempt(con);
                if (this.region != null) {
                    this.region.getCachePerfStats().incDeltaFullValuesSent();
                }
            } else {
                if (msgType == 2) {
                    String s = ": While performing a remote " + opName;
                    throw new ServerOperationException(s, (Throwable)part.getObject());
                }
                if (this.isErrorResponse(msgType)) {
                    throw new ServerOperationException(part.getString());
                }
                throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
            }
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            if (!this.isMetaRegionPutOp) {
                super.sendMessage(cnx);
            } else {
                this.getMessage().send(false);
            }
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
            if (!this.isMetaRegionPutOp) {
                super.processSecureBytes(cnx, message);
            }
        }

        @Override
        protected boolean needsUserId() {
            boolean ret = this.isMetaRegionPutOp ? false : super.needsUserId();
            return ret;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 8;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startPut();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endPutSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endPut(start, this.hasTimedOut(), this.hasFailed());
        }

        public String toString() {
            return "PutOp:" + this.key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object attemptReadResponse(Connection cnx) throws Exception {
            Message msg = this.createResponseMessage();
            if (msg != null) {
                msg.setComms(cnx.getSocket(), cnx.getInputStream(), cnx.getOutputStream(), cnx.getCommBuffer(), cnx.getStats());
                if (msg instanceof ChunkedMessage) {
                    try {
                        Object object = this.processResponse(msg, cnx);
                        return object;
                    }
                    finally {
                        msg.unsetComms();
                        this.processSecureBytes(cnx, msg);
                    }
                }
                try {
                    msg.recv();
                }
                finally {
                    msg.unsetComms();
                    this.processSecureBytes(cnx, msg);
                }
                return this.processResponse(msg, cnx);
            }
            return null;
        }

        void setMetaRegionPutOp(boolean bool) {
            this.isMetaRegionPutOp = bool;
        }
    }
}

