/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.List;
import java.util.Set;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.ClientPartitionAdvisor;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.internal.cache.BucketServerLocation66;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class GetClientPRMetaDataOp {
    private static final Logger logger = LogService.getLogger();

    private GetClientPRMetaDataOp() {
    }

    public static void execute(ExecutablePool pool, String regionFullPath, ClientMetadataService cms) {
        GetClientPRMetaDataOpImpl op = new GetClientPRMetaDataOpImpl(regionFullPath, cms);
        if (logger.isDebugEnabled()) {
            logger.debug("GetClientPRMetaDataOp#execute : Sending GetClientPRMetaDataOp Message: {} to server using pool: {}", (Object)op.getMessage(), (Object)pool);
        }
        pool.execute(op);
    }

    static class GetClientPRMetaDataOpImpl
    extends AbstractOp {
        String regionFullPath = null;
        ClientMetadataService cms = null;

        public GetClientPRMetaDataOpImpl(String regionFullPath, ClientMetadataService cms) {
            super(71, 1);
            this.regionFullPath = regionFullPath;
            this.cms = cms;
            this.getMessage().addStringPart(regionFullPath);
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().clearMessageHasSecurePartFlag();
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            switch (msg.getMessageType()) {
                case 75: {
                    String errorMsg = msg.getPart(0).getString();
                    if (logger.isDebugEnabled()) {
                        logger.debug(errorMsg);
                    }
                    throw new ServerOperationException(errorMsg);
                }
                case 72: {
                    boolean isDebugEnabled = logger.isDebugEnabled();
                    if (isDebugEnabled) {
                        logger.debug("GetClientPRMetaDataOpImpl#processResponse: received message of type : {}" + MessageType.getString(msg.getMessageType()));
                    }
                    int numParts = msg.getNumberOfParts();
                    ClientPartitionAdvisor advisor = this.cms.getClientPartitionAdvisor(this.regionFullPath);
                    for (int i = 0; i < numParts; ++i) {
                        Object result = msg.getPart(i).getObject();
                        List locations = (List)result;
                        if (locations.isEmpty()) continue;
                        int bucketId = ((BucketServerLocation66)locations.get(0)).getBucketId();
                        if (isDebugEnabled) {
                            logger.debug("GetClientPRMetaDataOpImpl#processResponse: for bucketId : {} locations are {}", (Object)bucketId, (Object)locations);
                        }
                        advisor.updateBucketServerLocations(bucketId, locations, this.cms);
                        Set<ClientPartitionAdvisor> cpas = this.cms.getColocatedClientPartitionAdvisor(this.regionFullPath);
                        if (cpas == null || cpas.isEmpty()) continue;
                        for (ClientPartitionAdvisor colCPA : cpas) {
                            colCPA.updateBucketServerLocations(bucketId, locations, this.cms);
                        }
                    }
                    if (isDebugEnabled) {
                        logger.debug("GetClientPRMetaDataOpImpl#processResponse: received ClientPRMetadata from server successfully.");
                    }
                    this.cms.setMetadataStable(true);
                    return null;
                }
                case 2: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("GetClientPRMetaDataOpImpl#processResponse: received message of type EXCEPTION");
                    }
                    Part part = msg.getPart(0);
                    Object obj = part.getObject();
                    String s = "While performing  GetClientPRMetaDataOp " + ((Throwable)obj).getMessage();
                    throw new ServerOperationException(s, (Throwable)obj);
                }
            }
            throw new InternalGemFireError(LocalizedStrings.Op_UNKNOWN_MESSAGE_TYPE_0.toLocalizedString(msg.getMessageType()));
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGetClientPRMetadata();
        }

        protected String getOpName() {
            return "GetClientPRMetaDataOp";
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetClientPRMetadataSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGetClientPRMetadata(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }
    }
}

