/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.geode.GemFireException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.AutoConnectionSourceImpl;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.ExplicitConnectionSourceImpl;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.SingleHopClientExecutor;
import org.apache.geode.cache.client.internal.SingleHopOperationCallable;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalFunctionException;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.ServerFunctionExecutor;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ExecuteFunctionOp {
    private static final Logger logger = LogService.getLogger();
    public static final int ALL_MEMBERS_INDEX = 0;
    public static final int IGNORE_FAILED_MEMBERS_INDEX = 1;
    public static final int MAX_FE_THREADS = Integer.getInteger("DistributionManager.MAX_FE_THREADS", Math.max(Runtime.getRuntime().availableProcessors() * 4, 16));

    private ExecuteFunctionOp() {
    }

    public static void execute(PoolImpl pool, Function function, ServerFunctionExecutor executor, Object args, MemberMappedArgument memberMappedArg, boolean allServers, byte hasResult, ResultCollector rc, boolean isFnSerializationReqd, UserAttributes attributes, String[] groups) {
        ExecuteFunctionOpImpl op = new ExecuteFunctionOpImpl(function, args, memberMappedArg, hasResult, rc, isFnSerializationReqd, 0, groups, allServers, executor.isIgnoreDepartedMembers());
        if (allServers && groups.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("ExecuteFunctionOp#execute : Sending Function Execution Message:{} to all servers using pool: {}", (Object)op.getMessage(), (Object)pool);
            }
            List callableTasks = ExecuteFunctionOp.constructAndGetFunctionTasks(pool, function, args, memberMappedArg, hasResult, rc, isFnSerializationReqd, attributes);
            SingleHopClientExecutor.submitAll(callableTasks);
        } else {
            boolean reexecuteForServ = false;
            ExecuteFunctionOpImpl reexecOp = null;
            int retryAttempts = 0;
            boolean reexecute = false;
            int maxRetryAttempts = 0;
            if (function.isHA()) {
                maxRetryAttempts = pool.getRetryAttempts();
            }
            boolean isDebugEnabled = logger.isDebugEnabled();
            do {
                try {
                    if (reexecuteForServ) {
                        if (isDebugEnabled) {
                            logger.debug("ExecuteFunctionOp#execute.reexecuteForServ : Sending Function Execution Message:{} to server using pool: {} with groups:{} all members:{} ignoreFailedMembers:{}", (Object)op.getMessage(), (Object)pool, (Object)Arrays.toString(groups), (Object)allServers, (Object)executor.isIgnoreDepartedMembers());
                        }
                        reexecOp = new ExecuteFunctionOpImpl(function, args, memberMappedArg, hasResult, rc, isFnSerializationReqd, 1, groups, allServers, executor.isIgnoreDepartedMembers());
                        pool.execute(reexecOp, 0);
                    } else {
                        if (isDebugEnabled) {
                            logger.debug("ExecuteFunctionOp#execute : Sending Function Execution Message:{} to server using pool: {} with groups:{} all members:{} ignoreFailedMembers:{}", (Object)op.getMessage(), (Object)pool, (Object)Arrays.toString(groups), (Object)allServers, (Object)executor.isIgnoreDepartedMembers());
                        }
                        pool.execute(op, 0);
                    }
                    reexecute = false;
                    reexecuteForServ = false;
                }
                catch (InternalFunctionInvocationTargetException e) {
                    if (isDebugEnabled) {
                        logger.debug("ExecuteFunctionOp#execute : Received InternalFunctionInvocationTargetException. The failed node is {}", e.getFailedNodeSet());
                    }
                    reexecute = true;
                    rc.clearResults();
                }
                catch (ServerConnectivityException se) {
                    ++retryAttempts;
                    if (isDebugEnabled) {
                        logger.debug("ExecuteFunctionOp#execute : Received ServerConnectivityException. The exception is {} The retryAttempt is : {} maxRetryAttempts  {}", (Object)se, (Object)retryAttempts, (Object)maxRetryAttempts);
                    }
                    if (se instanceof ServerOperationException) {
                        throw se;
                    }
                    if (retryAttempts > maxRetryAttempts && maxRetryAttempts != -1) {
                        throw se;
                    }
                    reexecuteForServ = true;
                    rc.clearResults();
                }
            } while (reexecuteForServ);
            if (reexecute && function.isHA()) {
                ExecuteFunctionOp.reexecute(pool, function, executor, rc, hasResult, isFnSerializationReqd, maxRetryAttempts - 1, groups, allServers);
            }
        }
    }

    public static void execute(PoolImpl pool, String functionId, ServerFunctionExecutor executor, Object args, MemberMappedArgument memberMappedArg, boolean allServers, byte hasResult, ResultCollector rc, boolean isFnSerializationReqd, boolean isHA, boolean optimizeForWrite, UserAttributes properties, String[] groups) {
        ExecuteFunctionOpImpl op = new ExecuteFunctionOpImpl(functionId, args, memberMappedArg, hasResult, rc, isFnSerializationReqd, isHA, optimizeForWrite, 0, groups, allServers, executor.isIgnoreDepartedMembers());
        if (allServers && groups.length == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("ExecuteFunctionOp#execute : Sending Function Execution Message:{} to all servers using pool: {}", (Object)op.getMessage(), (Object)pool);
            }
            List callableTasks = ExecuteFunctionOp.constructAndGetFunctionTasks(pool, functionId, args, memberMappedArg, hasResult, rc, isFnSerializationReqd, isHA, optimizeForWrite, properties);
            SingleHopClientExecutor.submitAll(callableTasks);
        } else {
            boolean reexecuteForServ = false;
            ExecuteFunctionOpImpl reexecOp = null;
            int retryAttempts = 0;
            boolean reexecute = false;
            int maxRetryAttempts = 0;
            if (isHA) {
                maxRetryAttempts = pool.getRetryAttempts();
            }
            boolean isDebugEnabled = logger.isDebugEnabled();
            do {
                try {
                    if (reexecuteForServ) {
                        reexecOp = new ExecuteFunctionOpImpl(functionId, args, memberMappedArg, hasResult, rc, isFnSerializationReqd, isHA, optimizeForWrite, 1, groups, allServers, executor.isIgnoreDepartedMembers());
                        pool.execute(reexecOp, 0);
                    } else {
                        if (isDebugEnabled) {
                            logger.debug("ExecuteFunctionOp#execute : Sending Function Execution Message:{} to server using pool:{} with groups:{} all members:{} ignoreFailedMembers:{}", (Object)op.getMessage(), (Object)pool, (Object)Arrays.toString(groups), (Object)allServers, (Object)executor.isIgnoreDepartedMembers());
                        }
                        pool.execute(op, 0);
                    }
                    reexecute = false;
                    reexecuteForServ = false;
                }
                catch (InternalFunctionInvocationTargetException e) {
                    if (isDebugEnabled) {
                        logger.debug("ExecuteFunctionOp#execute : Received InternalFunctionInvocationTargetException. The failed node is {}", e.getFailedNodeSet());
                    }
                    reexecute = true;
                    rc.clearResults();
                }
                catch (ServerConnectivityException se) {
                    ++retryAttempts;
                    if (isDebugEnabled) {
                        logger.debug("ExecuteFunctionOp#execute : Received ServerConnectivityException. The exception is {} The retryAttempt is : {} maxRetryAttempts {}", (Object)se, (Object)retryAttempts, (Object)maxRetryAttempts);
                    }
                    if (se instanceof ServerOperationException) {
                        throw se;
                    }
                    if (retryAttempts > maxRetryAttempts && maxRetryAttempts != -1) {
                        throw se;
                    }
                    reexecuteForServ = true;
                    rc.clearResults();
                }
            } while (reexecuteForServ);
            if (reexecute && isHA) {
                ExecuteFunctionOp.reexecute(pool, functionId, executor, rc, hasResult, isFnSerializationReqd, maxRetryAttempts - 1, args, isHA, optimizeForWrite, groups, allServers);
            }
        }
    }

    public static void reexecute(ExecutablePool pool, Function function, ServerFunctionExecutor serverExecutor, ResultCollector resultCollector, byte hasResult, boolean isFnSerializationReqd, int maxRetryAttempts, String[] groups, boolean allMembers) {
        boolean reexecute = true;
        int retryAttempts = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        do {
            reexecute = false;
            ExecuteFunctionOpImpl reExecuteOp = new ExecuteFunctionOpImpl(function, serverExecutor.getArguments(), serverExecutor.getMemberMappedArgument(), hasResult, resultCollector, isFnSerializationReqd, 1, groups, allMembers, serverExecutor.isIgnoreDepartedMembers());
            if (isDebugEnabled) {
                logger.debug("ExecuteFunction#reexecute : Sending Function Execution Message:{} to Server using pool:{} with groups:{} all members:{} ignoreFailedMembers:{}", (Object)reExecuteOp.getMessage(), (Object)pool, (Object)Arrays.toString(groups), (Object)allMembers, (Object)serverExecutor.isIgnoreDepartedMembers());
            }
            try {
                pool.execute(reExecuteOp, 0);
            }
            catch (InternalFunctionInvocationTargetException e) {
                if (isDebugEnabled) {
                    logger.debug("ExecuteFunctionOp#reexecute : Recieved InternalFunctionInvocationTargetException. The failed nodes are {}", e.getFailedNodeSet());
                }
                reexecute = true;
                resultCollector.clearResults();
            }
            catch (ServerConnectivityException se) {
                if (isDebugEnabled) {
                    logger.debug("ExecuteFunctionOp#reexecute : Received ServerConnectivity Exception.");
                }
                if (se instanceof ServerOperationException) {
                    throw se;
                }
                if (++retryAttempts > maxRetryAttempts && maxRetryAttempts != -2) {
                    throw se;
                }
                reexecute = true;
                resultCollector.clearResults();
            }
        } while (reexecute);
    }

    public static void reexecute(ExecutablePool pool, String functionId, ServerFunctionExecutor serverExecutor, ResultCollector resultCollector, byte hasResult, boolean isFnSerializationReqd, int maxRetryAttempts, Object args, boolean isHA, boolean optimizeForWrite, String[] groups, boolean allMembers) {
        boolean reexecute = true;
        int retryAttempts = 0;
        boolean isDebugEnabled = logger.isDebugEnabled();
        do {
            reexecute = false;
            ExecuteFunctionOpImpl op = new ExecuteFunctionOpImpl(functionId, args, serverExecutor.getMemberMappedArgument(), hasResult, resultCollector, isFnSerializationReqd, isHA, optimizeForWrite, 1, groups, allMembers, serverExecutor.isIgnoreDepartedMembers());
            if (isDebugEnabled) {
                logger.debug("ExecuteFunction#reexecute : Sending Function Execution Message:{} to Server using pool:{} with groups:{} all members:{} ignoreFailedMembers:{}", (Object)op.getMessage(), (Object)pool, (Object)Arrays.toString(groups), (Object)allMembers, (Object)serverExecutor.isIgnoreDepartedMembers());
            }
            try {
                pool.execute(op, 0);
            }
            catch (InternalFunctionInvocationTargetException e) {
                if (isDebugEnabled) {
                    logger.debug("ExecuteFunctionOp#reexecute : Recieved InternalFunctionInvocationTargetException. The failed nodes are {}", e.getFailedNodeSet());
                }
                reexecute = true;
                resultCollector.clearResults();
            }
            catch (ServerConnectivityException se) {
                if (isDebugEnabled) {
                    logger.debug("ExecuteFunctionOp#reexecute : Received ServerConnectivity Exception.");
                }
                if (se instanceof ServerOperationException) {
                    throw se;
                }
                if (++retryAttempts > maxRetryAttempts && maxRetryAttempts != -2) {
                    throw se;
                }
                reexecute = true;
                resultCollector.clearResults();
            }
        } while (reexecute);
    }

    static List constructAndGetFunctionTasks(PoolImpl pool, Function function, Object args, MemberMappedArgument memberMappedArg, byte hasResult, ResultCollector rc, boolean isFnSerializationReqd, UserAttributes attributes) {
        ArrayList<SingleHopOperationCallable> tasks = new ArrayList<SingleHopOperationCallable>();
        ArrayList<ServerLocation> servers = null;
        servers = pool.getLocators() == null || pool.getLocators().isEmpty() ? ((ExplicitConnectionSourceImpl)pool.getConnectionSource()).getAllServers() : ((AutoConnectionSourceImpl)pool.getConnectionSource()).findAllServers();
        for (ServerLocation server : servers) {
            ExecuteFunctionOpImpl op = new ExecuteFunctionOpImpl(function, args, memberMappedArg, hasResult, rc, isFnSerializationReqd, 0, null, false, false);
            SingleHopOperationCallable task = new SingleHopOperationCallable(server, pool, op, attributes);
            tasks.add(task);
        }
        return tasks;
    }

    static List constructAndGetFunctionTasks(PoolImpl pool, String functionId, Object args, MemberMappedArgument memberMappedArg, byte hasResult, ResultCollector rc, boolean isFnSerializationReqd, boolean isHA, boolean optimizeForWrite, UserAttributes properties) {
        ArrayList<SingleHopOperationCallable> tasks = new ArrayList<SingleHopOperationCallable>();
        ArrayList<ServerLocation> servers = null;
        servers = pool.getLocators() == null || pool.getLocators().isEmpty() ? ((ExplicitConnectionSourceImpl)pool.getConnectionSource()).getAllServers() : ((AutoConnectionSourceImpl)pool.getConnectionSource()).findAllServers();
        for (ServerLocation server : servers) {
            ExecuteFunctionOpImpl op = new ExecuteFunctionOpImpl(functionId, args, memberMappedArg, hasResult, rc, isFnSerializationReqd, isHA, optimizeForWrite, 0, null, false, false);
            SingleHopOperationCallable task = new SingleHopOperationCallable(server, pool, op, properties);
            tasks.add(task);
        }
        return tasks;
    }

    static byte[] getByteArrayForFlags(boolean ... flags) {
        byte[] retVal = null;
        if (flags.length > 0) {
            retVal = new byte[flags.length];
            for (int i = 0; i < flags.length; ++i) {
                retVal[i] = flags[i] ? (byte)1 : 0;
            }
        }
        return retVal;
    }

    static class ExecuteFunctionOpImpl
    extends AbstractOp {
        private ResultCollector resultCollector;
        private String functionId;
        private Function function;
        private Object args;
        private MemberMappedArgument memberMappedArg;
        private byte hasResult;
        private boolean isFnSerializationReqd;
        private String[] groups;
        private byte[] flags;
        private static final int MSG_PARTS = 6;

        public ExecuteFunctionOpImpl(Function function, Object args, MemberMappedArgument memberMappedArg, byte hasResult, ResultCollector rc, boolean isFnSerializationReqd, byte isReexecute, String[] groups, boolean allMembers, boolean ignoreFailedMembers) {
            super(62, 6);
            byte fnState = AbstractExecution.getFunctionState(function.isHA(), function.hasResult(), function.optimizeForWrite());
            this.addBytes(isReexecute, fnState);
            if (isFnSerializationReqd) {
                this.getMessage().addStringOrObjPart(function);
            } else {
                this.getMessage().addStringOrObjPart(function.getId());
            }
            this.getMessage().addObjPart(args);
            this.getMessage().addObjPart(memberMappedArg);
            this.getMessage().addObjPart(groups);
            this.flags = ExecuteFunctionOp.getByteArrayForFlags(allMembers, ignoreFailedMembers);
            this.getMessage().addBytesPart(this.flags);
            this.resultCollector = rc;
            if (isReexecute == 1) {
                this.resultCollector.clearResults();
            }
            this.functionId = function.getId();
            this.function = function;
            this.args = args;
            this.memberMappedArg = memberMappedArg;
            this.hasResult = fnState;
            this.isFnSerializationReqd = isFnSerializationReqd;
            this.groups = groups;
        }

        public ExecuteFunctionOpImpl(String functionId, Object args2, MemberMappedArgument memberMappedArg, byte hasResult, ResultCollector rc, boolean isFnSerializationReqd, boolean isHA, boolean optimizeForWrite, byte isReexecute, String[] groups, boolean allMembers, boolean ignoreFailedMembers) {
            super(62, 6);
            byte fnState = AbstractExecution.getFunctionState(isHA, hasResult == 1, optimizeForWrite);
            this.addBytes(isReexecute, fnState);
            this.getMessage().addStringOrObjPart(functionId);
            this.getMessage().addObjPart(args2);
            this.getMessage().addObjPart(memberMappedArg);
            this.getMessage().addObjPart(groups);
            this.flags = ExecuteFunctionOp.getByteArrayForFlags(allMembers, ignoreFailedMembers);
            this.getMessage().addBytesPart(this.flags);
            this.resultCollector = rc;
            if (isReexecute == 1) {
                this.resultCollector.clearResults();
            }
            this.functionId = functionId;
            this.args = args2;
            this.memberMappedArg = memberMappedArg;
            this.hasResult = fnState;
            this.isFnSerializationReqd = isFnSerializationReqd;
            this.groups = groups;
        }

        public ExecuteFunctionOpImpl(ExecuteFunctionOpImpl op, byte isReexecute) {
            super(62, 6);
            this.resultCollector = op.resultCollector;
            this.function = op.function;
            this.functionId = op.functionId;
            this.hasResult = op.hasResult;
            this.args = op.args;
            this.memberMappedArg = op.memberMappedArg;
            this.isFnSerializationReqd = op.isFnSerializationReqd;
            this.groups = op.groups;
            this.flags = op.flags;
            this.addBytes(isReexecute, this.hasResult);
            if (this.isFnSerializationReqd) {
                this.getMessage().addStringOrObjPart(this.function);
            } else {
                this.getMessage().addStringOrObjPart(this.function.getId());
            }
            this.getMessage().addObjPart(this.args);
            this.getMessage().addObjPart(this.memberMappedArg);
            this.getMessage().addObjPart(this.groups);
            this.getMessage().addBytesPart(this.flags);
            if (isReexecute == 1) {
                this.resultCollector.clearResults();
            }
        }

        private void addBytes(byte isReexecute, byte fnStateOrHasResult) {
            if (GemFireCacheImpl.getClientFunctionTimeout() == 0) {
                if (isReexecute == 1) {
                    this.getMessage().addBytesPart(new byte[]{AbstractExecution.getReexecuteFunctionState(fnStateOrHasResult)});
                } else {
                    this.getMessage().addBytesPart(new byte[]{fnStateOrHasResult});
                }
            } else {
                byte[] bytes = new byte[5];
                bytes[0] = isReexecute == 1 ? AbstractExecution.getReexecuteFunctionState(fnStateOrHasResult) : fnStateOrHasResult;
                Part.encodeInt(GemFireCacheImpl.getClientFunctionTimeout(), bytes, 1);
                this.getMessage().addBytesPart(bytes);
            }
        }

        private boolean getIgnoreFailedMembers() {
            boolean ignoreFailedMembers = false;
            if (this.flags != null && this.flags.length > 1 && this.flags[1] == 1) {
                ignoreFailedMembers = true;
            }
            return ignoreFailedMembers;
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            ChunkedMessage executeFunctionResponseMsg = (ChunkedMessage)msg;
            try {
                executeFunctionResponseMsg.readHeader();
                switch (executeFunctionResponseMsg.getMessageType()) {
                    case 63: {
                        Object resultResponse;
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteFunctionOpImpl#processResponse: received message of type EXECUTE_FUNCTION_RESULT.");
                        }
                        GemFireException exception = null;
                        do {
                            executeFunctionResponseMsg.receiveChunk();
                            resultResponse = executeFunctionResponseMsg.getPart(0).getObject();
                            Object result = resultResponse instanceof ArrayList ? ((ArrayList)resultResponse).get(0) : resultResponse;
                            if (result instanceof FunctionException) {
                                FunctionException ex = (FunctionException)result;
                                if (ex instanceof InternalFunctionException || this.getIgnoreFailedMembers()) {
                                    Throwable cause = ex.getCause() == null ? ex : ex.getCause();
                                    DistributedMember memberID = (DistributedMember)((ArrayList)resultResponse).get(1);
                                    this.resultCollector.addResult(memberID, cause);
                                    FunctionStats.getFunctionStats(this.functionId).incResultsReceived();
                                    continue;
                                }
                                exception = ex;
                                continue;
                            }
                            if (result instanceof Throwable) {
                                String s = "While performing a remote " + this.getOpName();
                                exception = new ServerOperationException(s, (Throwable)result);
                                continue;
                            }
                            DistributedMember memberID = (DistributedMember)((ArrayList)resultResponse).get(1);
                            this.resultCollector.addResult(memberID, result);
                            FunctionStats.getFunctionStats(this.functionId).incResultsReceived();
                        } while (!executeFunctionResponseMsg.isLastChunk());
                        if (exception != null) {
                            throw exception;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteFunctionOpImpl#processResponse: received all the results from server successfully.");
                        }
                        resultResponse = null;
                        return resultResponse;
                    }
                    case 2: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteFunctionOpImpl#processResponse: received message of type EXCEPTION");
                        }
                        executeFunctionResponseMsg.receiveChunk();
                        Part part0 = executeFunctionResponseMsg.getPart(0);
                        Object obj = part0.getObject();
                        if (obj instanceof FunctionException) {
                            FunctionException ex = (FunctionException)obj;
                            throw ex;
                        }
                        String s = ": While performing a remote execute Function" + ((Throwable)obj).getMessage();
                        throw new ServerOperationException(s, (Throwable)obj);
                    }
                    case 64: {
                        if (logger.isDebugEnabled()) {
                            logger.debug("ExecuteFunctionOpImpl#processResponse: received message of type EXECUTE_FUNCTION_ERROR");
                        }
                        executeFunctionResponseMsg.receiveChunk();
                        String errorMessage = executeFunctionResponseMsg.getPart(0).getString();
                        throw new ServerOperationException(errorMessage);
                    }
                }
                throw new InternalGemFireError(LocalizedStrings.Op_UNKNOWN_MESSAGE_TYPE_0.toLocalizedString(executeFunctionResponseMsg.getMessageType()));
            }
            finally {
                executeFunctionResponseMsg.clear();
            }
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 64;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startExecuteFunction();
        }

        protected String getOpName() {
            return "executeFunction";
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunctionSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endExecuteFunction(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(1, Version.CURRENT);
        }
    }
}

