/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Properties;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.HandShake;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.NotAuthorizedException;

public class AuthenticateUserOp {
    public static Object executeOn(Connection con, ExecutablePool pool) {
        AuthenticateUserOpImpl op = new AuthenticateUserOpImpl(con, pool);
        return pool.executeOn(con, (Op)op);
    }

    public static Object executeOn(ServerLocation location, ExecutablePool pool, Properties securityProps) {
        AuthenticateUserOpImpl op = new AuthenticateUserOpImpl(pool, securityProps);
        return pool.executeOn(location, (Op)op);
    }

    private AuthenticateUserOp() {
    }

    static class AuthenticateUserOpImpl
    extends AbstractOp {
        private Properties securityProperties = null;
        private boolean needsServerLocation = false;

        public AuthenticateUserOpImpl(Connection con, ExecutablePool pool) {
            super(77, 1);
            byte[] credentialBytes = null;
            InternalDistributedMember server = new InternalDistributedMember(con.getSocket().getInetAddress(), con.getSocket().getPort(), false);
            InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
            String authInitMethod = ((DistributedSystem)sys).getProperties().getProperty("security-client-auth-init");
            Properties tmpSecurityProperties = ((DistributedSystem)sys).getSecurityProperties();
            Properties credentials = HandShake.getCredentials(authInitMethod, tmpSecurityProperties, server, false, (InternalLogWriter)((DistributedSystem)sys).getLogWriter(), (InternalLogWriter)((DistributedSystem)sys).getSecurityLogWriter());
            this.getMessage().setMessageHasSecurePartFlag();
            try (HeapDataOutputStream heapdos = new HeapDataOutputStream(Version.CURRENT);){
                DataSerializer.writeProperties(credentials, heapdos);
                credentialBytes = ((ConnectionImpl)con).getHandShake().encryptBytes(heapdos.toByteArray());
            }
            this.getMessage().addBytesPart(credentialBytes);
        }

        public AuthenticateUserOpImpl(ExecutablePool pool, Properties securityProps) {
            this(pool, securityProps, false);
        }

        public AuthenticateUserOpImpl(ExecutablePool pool, Properties securityProps, boolean needsServer) {
            super(77, 1);
            this.securityProperties = securityProps;
            this.needsServerLocation = needsServer;
            this.getMessage().setMessageHasSecurePartFlag();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
            byte[] secureBytes = null;
            hdos.writeLong(cnx.getConnectionID());
            if (this.securityProperties != null) {
                byte[] credentialBytes = null;
                InternalDistributedMember server = new InternalDistributedMember(cnx.getSocket().getInetAddress(), cnx.getSocket().getPort(), false);
                InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
                String authInitMethod = ((DistributedSystem)sys).getProperties().getProperty("security-client-auth-init");
                Properties credentials = HandShake.getCredentials(authInitMethod, this.securityProperties, server, false, (InternalLogWriter)((DistributedSystem)sys).getLogWriter(), (InternalLogWriter)((DistributedSystem)sys).getSecurityLogWriter());
                try (HeapDataOutputStream heapdos = new HeapDataOutputStream(Version.CURRENT);){
                    DataSerializer.writeProperties(credentials, heapdos);
                    credentialBytes = ((ConnectionImpl)cnx).getHandShake().encryptBytes(heapdos.toByteArray());
                }
                this.getMessage().addBytesPart(credentialBytes);
            }
            try {
                secureBytes = ((ConnectionImpl)cnx).getHandShake().encryptBytes(hdos.toByteArray());
            }
            finally {
                hdos.close();
            }
            this.getMessage().setSecurePart(secureBytes);
            this.getMessage().send(false);
        }

        @Override
        public Object attempt(Connection cnx) throws Exception {
            if (cnx.getServer().getRequiresCredentials()) {
                return super.attempt(cnx);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object attemptReadResponse(Connection cnx) throws Exception {
            Message msg = this.createResponseMessage();
            if (msg != null) {
                msg.setComms(cnx.getSocket(), cnx.getInputStream(), cnx.getOutputStream(), cnx.getCommBuffer(), cnx.getStats());
                if (msg instanceof ChunkedMessage) {
                    try {
                        Object object = this.processResponse(cnx, msg);
                        return object;
                    }
                    finally {
                        msg.unsetComms();
                        this.processSecureBytes(cnx, msg);
                    }
                }
                try {
                    msg.recv();
                }
                finally {
                    msg.unsetComms();
                    this.processSecureBytes(cnx, msg);
                }
                return this.processResponse(cnx, msg);
            }
            return null;
        }

        protected Object processResponse(Connection cnx, Message msg) throws Exception {
            byte[] bytes = null;
            Part part = msg.getPart(0);
            int msgType = msg.getMessageType();
            long userId = -1L;
            if (msgType == 1) {
                bytes = (byte[])part.getObject();
                if (bytes.length == 0) {
                    cnx.getServer().setRequiresCredentials(false);
                } else {
                    cnx.getServer().setRequiresCredentials(true);
                    byte[] decrypted = ((ConnectionImpl)cnx).getHandShake().decryptBytes(bytes);
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(decrypted));
                    userId = dis.readLong();
                }
                if (this.needsServerLocation) {
                    return new Object[]{cnx.getServer(), userId};
                }
                return userId;
            }
            if (msgType == 2) {
                Object result = part.getObject();
                String s = "While performing a remote authenticate";
                if (result instanceof AuthenticationFailedException) {
                    AuthenticationFailedException afe = (AuthenticationFailedException)result;
                    if ("REPLY_REFUSED".equals(afe.getMessage())) {
                        throw new AuthenticationFailedException(s, afe.getCause());
                    }
                    throw new AuthenticationFailedException(s, afe);
                }
                if (result instanceof AuthenticationRequiredException) {
                    throw new AuthenticationRequiredException(s, (AuthenticationRequiredException)result);
                }
                if (result instanceof NotAuthorizedException) {
                    throw new NotAuthorizedException(s, (NotAuthorizedException)result);
                }
                throw new ServerOperationException(s, (Throwable)result);
            }
            if (this.isErrorResponse(msgType)) {
                throw new ServerOperationException(part.getString());
            }
            throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 3;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGet();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGet(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            return null;
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }
    }
}

