/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.cache.RegionRoleException;
import org.apache.geode.distributed.Role;
import org.apache.geode.distributed.internal.membership.InternalRole;

public class RegionAccessException
extends RegionRoleException {
    private static final long serialVersionUID = 3142958723089038406L;
    private transient Set missingRoles = Collections.EMPTY_SET;

    public RegionAccessException(String s, String regionFullPath, Set missingRoles) {
        super(s, regionFullPath);
        this.missingRoles = missingRoles;
        if (this.missingRoles == null) {
            this.missingRoles = Collections.EMPTY_SET;
        }
    }

    public RegionAccessException(String s, String regionFullPath, Set missingRoles, Throwable ex) {
        super(s, regionFullPath, ex);
        this.missingRoles = missingRoles;
        if (this.missingRoles == null) {
            this.missingRoles = Collections.EMPTY_SET;
        }
    }

    public Set getMissingRoles() {
        return this.missingRoles;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        HashSet<String> roleNames = new HashSet<String>(this.missingRoles.size());
        Iterator iter = this.missingRoles.iterator();
        while (iter.hasNext()) {
            String name = ((Role)iter.next()).getName();
            roleNames.add(name);
        }
        out.writeObject(roleNames);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Set roleNames = (Set)in.readObject();
        HashSet<InternalRole> roles = new HashSet<InternalRole>(roleNames.size());
        for (String name : roleNames) {
            roles.add(InternalRole.getRole(name));
        }
        this.missingRoles = roles;
    }
}

