/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.snapshot.RegionSnapshotService;

public interface Region<K, V>
extends ConcurrentMap<K, V> {
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR = "/";

    public String getName();

    public String getFullPath();

    public <PK, PV> Region<PK, PV> getParentRegion();

    public RegionAttributes<K, V> getAttributes();

    public AttributesMutator<K, V> getAttributesMutator();

    public CacheStatistics getStatistics() throws StatisticsDisabledException;

    public void invalidateRegion() throws TimeoutException;

    public void invalidateRegion(Object var1) throws TimeoutException;

    public void localInvalidateRegion();

    public void localInvalidateRegion(Object var1);

    public void destroyRegion() throws CacheWriterException, TimeoutException;

    public void destroyRegion(Object var1) throws CacheWriterException, TimeoutException;

    public void localDestroyRegion();

    public void localDestroyRegion(Object var1);

    public void close();

    public RegionSnapshotService<K, V> getSnapshotService();

    public void saveSnapshot(OutputStream var1) throws IOException;

    public void loadSnapshot(InputStream var1) throws IOException, ClassNotFoundException, CacheWriterException, TimeoutException;

    public <SK, SV> Region<SK, SV> getSubregion(String var1);

    public <SK, SV> Region<SK, SV> createSubregion(String var1, RegionAttributes<SK, SV> var2) throws RegionExistsException, TimeoutException;

    public Set<Region<?, ?>> subregions(boolean var1);

    public Entry<K, V> getEntry(Object var1);

    @Override
    public V get(Object var1) throws CacheLoaderException, TimeoutException;

    public V get(Object var1, Object var2) throws TimeoutException, CacheLoaderException;

    @Override
    public V put(K var1, V var2) throws TimeoutException, CacheWriterException;

    public V put(K var1, V var2, Object var3) throws TimeoutException, CacheWriterException;

    public void create(K var1, V var2) throws TimeoutException, EntryExistsException, CacheWriterException;

    public void create(K var1, V var2, Object var3) throws TimeoutException, EntryExistsException, CacheWriterException;

    public void invalidate(Object var1) throws TimeoutException, EntryNotFoundException;

    public void invalidate(Object var1, Object var2) throws TimeoutException, EntryNotFoundException;

    public void localInvalidate(Object var1) throws EntryNotFoundException;

    public void localInvalidate(Object var1, Object var2) throws EntryNotFoundException;

    public V destroy(Object var1) throws TimeoutException, EntryNotFoundException, CacheWriterException;

    public V destroy(Object var1, Object var2) throws TimeoutException, EntryNotFoundException, CacheWriterException;

    public void localDestroy(Object var1) throws EntryNotFoundException;

    public void localDestroy(Object var1, Object var2) throws EntryNotFoundException;

    @Deprecated
    public Set<K> keys();

    @Override
    public Set<K> keySet();

    @Override
    public Collection<V> values();

    @Deprecated
    public Set<Entry<?, ?>> entries(boolean var1);

    public Set<Entry<?, ?>> entrySet(boolean var1);

    public Cache getCache();

    public RegionService getRegionService();

    public Object getUserAttribute();

    public void setUserAttribute(Object var1);

    public boolean isDestroyed();

    public boolean containsValueForKey(Object var1);

    @Override
    public boolean containsKey(Object var1);

    public Lock getRegionDistributedLock() throws IllegalStateException;

    public Lock getDistributedLock(Object var1) throws IllegalStateException;

    @Deprecated
    public void writeToDisk();

    public boolean existsValue(String var1) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException;

    public <E> SelectResults<E> query(String var1) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException;

    public Object selectValue(String var1) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException;

    @Deprecated
    public void forceRolling();

    public void becomeLockGrantor();

    public void localClear();

    @Override
    public void clear();

    @Override
    public boolean containsValue(Object var1);

    @Override
    public Set<Map.Entry<K, V>> entrySet();

    @Override
    public boolean isEmpty();

    @Override
    public void putAll(Map<? extends K, ? extends V> var1);

    public void putAll(Map<? extends K, ? extends V> var1, Object var2);

    public void removeAll(Collection<? extends K> var1);

    public void removeAll(Collection<? extends K> var1, Object var2);

    public Map<K, V> getAll(Collection<?> var1);

    public <T extends K> Map<T, V> getAll(Collection<T> var1, Object var2);

    @Override
    public V remove(Object var1);

    @Override
    public int size();

    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    public void registerInterest(K var1);

    public void registerInterest(K var1, InterestResultPolicy var2);

    public void registerInterestRegex(String var1);

    public void registerInterestRegex(String var1, InterestResultPolicy var2);

    public void unregisterInterest(K var1);

    public void unregisterInterestRegex(String var1);

    public List<K> getInterestList();

    public void registerInterest(K var1, boolean var2);

    public void registerInterest(K var1, boolean var2, boolean var3);

    public void registerInterest(K var1, InterestResultPolicy var2, boolean var3, boolean var4);

    public void registerInterest(K var1, InterestResultPolicy var2, boolean var3);

    public void registerInterestRegex(String var1, boolean var2);

    public void registerInterestRegex(String var1, boolean var2, boolean var3);

    public void registerInterestRegex(String var1, InterestResultPolicy var2, boolean var3);

    public void registerInterestRegex(String var1, InterestResultPolicy var2, boolean var3, boolean var4);

    public List<String> getInterestListRegex();

    public Set<K> keySetOnServer();

    public boolean containsKeyOnServer(Object var1);

    @Override
    public V putIfAbsent(K var1, V var2);

    @Override
    public boolean remove(Object var1, Object var2);

    @Override
    public boolean replace(K var1, V var2, V var3);

    @Override
    public V replace(K var1, V var2);

    public static interface Entry<K, V>
    extends Map.Entry<K, V> {
        @Override
        public K getKey();

        @Override
        public V getValue();

        public Region<K, V> getRegion();

        public boolean isLocal();

        public CacheStatistics getStatistics();

        public Object getUserAttribute();

        public Object setUserAttribute(Object var1);

        public boolean isDestroyed();

        @Override
        public V setValue(V var1);
    }
}

