/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.Serializable;
import java.util.Properties;
import org.apache.geode.cache.DiskWriteAttributes;
import org.apache.geode.internal.cache.DiskWriteAttributesImpl;
import org.apache.geode.internal.i18n.LocalizedStrings;

@Deprecated
public final class DiskWriteAttributesFactory
implements Serializable {
    private static final long serialVersionUID = -4077746249663727235L;
    private final Properties props = new Properties();

    public DiskWriteAttributesFactory() {
    }

    public DiskWriteAttributesFactory(DiskWriteAttributes dwa) {
        this.props.setProperty("bytes-threshold", String.valueOf(dwa.getBytesThreshold()));
        long maxOplogSizeInBytes = this.convertToBytes(dwa.getMaxOplogSize());
        this.props.setProperty("max-oplog-size", String.valueOf(maxOplogSizeInBytes));
        this.props.setProperty("roll-oplogs", String.valueOf(dwa.isRollOplogs()));
        this.props.setProperty("synchronous", String.valueOf(dwa.isSynchronous()));
        if (dwa.getTimeInterval() > -1L) {
            this.props.setProperty("time-interval", String.valueOf(dwa.getTimeInterval()));
        }
    }

    @Deprecated
    public void setSynchronous(boolean isSynchronous) {
        this.props.setProperty("synchronous", String.valueOf(isSynchronous));
    }

    @Deprecated
    public void setRollOplogs(boolean rollingEnabled) {
        this.props.setProperty("roll-oplogs", String.valueOf(rollingEnabled));
    }

    @Deprecated
    public void setCompactionThreshold(int compactionThreshold) {
        if (compactionThreshold < 0) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_POSITIVE_NUMBER_AND_THE_VALUE_GIVEN_1_IS_NOT_ACCEPTABLE.toLocalizedString("compaction-threshold", compactionThreshold));
        }
        if (compactionThreshold > 100) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesImpl_0_HAS_TO_BE_LESS_THAN_2_BUT_WAS_1.toLocalizedString("compaction-threshold", compactionThreshold, 100));
        }
        this.props.setProperty("compaction-threshold", String.valueOf(compactionThreshold));
    }

    @Deprecated
    public void setMaxOplogSizeInBytes(long maxOplogSize) {
        if (maxOplogSize < 0L) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesFactory_MAXIMUM_OPLOG_SIZE_SPECIFIED_HAS_TO_BE_A_NONNEGATIVE_NUMBER_AND_THE_VALUE_GIVEN_0_IS_NOT_ACCEPTABLE.toLocalizedString(maxOplogSize));
        }
        this.props.setProperty("max-oplog-size", String.valueOf(maxOplogSize));
    }

    @Deprecated
    public void setMaxOplogSize(int maxOplogSize) {
        if (maxOplogSize < 0) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesFactory_MAXIMUM_OPLOG_SIZE_SPECIFIED_HAS_TO_BE_A_NONNEGATIVE_NUMBER_AND_THE_VALUE_GIVEN_0_IS_NOT_ACCEPTABLE.toLocalizedString(maxOplogSize));
        }
        long maxOplogSizeInBytes = this.convertToBytes(maxOplogSize);
        this.props.setProperty("max-oplog-size", String.valueOf(maxOplogSizeInBytes));
    }

    private long convertToBytes(int megaBytes) {
        long bytes = megaBytes;
        bytes = bytes * 1024L * 1024L;
        return bytes;
    }

    @Deprecated
    public void setTimeInterval(long timeInterval) {
        if (timeInterval < 0L) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesFactory_TIME_INTERVAL_SPECIFIED_HAS_TO_BE_A_NONNEGATIVE_NUMBER_AND_THE_VALUE_GIVEN_0_IS_NOT_ACCEPTABLE.toLocalizedString(timeInterval));
        }
        this.props.setProperty("time-interval", String.valueOf(timeInterval));
    }

    @Deprecated
    public void setBytesThreshold(long bytesThreshold) {
        if (bytesThreshold < 0L) {
            throw new IllegalArgumentException(LocalizedStrings.DiskWriteAttributesFactory_QUEUE_SIZE_SPECIFIED_HAS_TO_BE_A_NONNEGATIVE_NUMBER_AND_THE_VALUE_GIVEN_0_IS_NOT_ACCEPTABLE.toLocalizedString(bytesThreshold));
        }
        this.props.setProperty("bytes-threshold", String.valueOf(bytesThreshold));
    }

    @Deprecated
    public DiskWriteAttributes create() {
        return new DiskWriteAttributesImpl(this.props);
    }
}

