/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin;

import java.io.ObjectStreamException;
import java.io.Serializable;

public class SystemMemberType
implements Serializable {
    private static final long serialVersionUID = 3284366994485749302L;
    public static final SystemMemberType MANAGER = new SystemMemberType("GemFireManager");
    public static final SystemMemberType APPLICATION = new SystemMemberType("Application");
    public static final SystemMemberType CACHE_VM;
    @Deprecated
    public static final SystemMemberType CACHE_SERVER;
    private final transient String name;
    public final int ordinal = nextOrdinal++;
    private static int nextOrdinal;
    private static final SystemMemberType[] VALUES;

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    private SystemMemberType(String name) {
        this.name = name;
    }

    public static SystemMemberType fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    public String getName() {
        return this.name;
    }

    public boolean isManager() {
        return this.equals(MANAGER);
    }

    public boolean isApplication() {
        return this.equals(APPLICATION);
    }

    @Deprecated
    public boolean isCacheServer() {
        return this.isCacheVm();
    }

    public boolean isCacheVm() {
        return this.equals(CACHE_VM);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof SystemMemberType)) {
            return false;
        }
        SystemMemberType that = (SystemMemberType)other;
        return this.ordinal == that.ordinal;
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + this.ordinal;
        return result;
    }

    static {
        CACHE_SERVER = CACHE_VM = new SystemMemberType("CacheVm");
        nextOrdinal = 0;
        VALUES = new SystemMemberType[]{MANAGER, APPLICATION, CACHE_VM};
    }
}

