/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields.internalhtmltable;

import com.vaadin.flow.component.HasElement;

public interface HasRowSpan
extends HasElement {
    public static final String ATTRIBUTE_ROWSPAN = "rowspan";

    default public void setRowSpan(int rowSpan) {
        if (rowSpan < 0) {
            throw new IllegalArgumentException("Rowspan must be a positive number");
        }
        this.getElement().setAttribute(ATTRIBUTE_ROWSPAN, String.valueOf(rowSpan));
    }

    default public int getRowSpan() {
        String rowspan = this.getElement().getAttribute(ATTRIBUTE_ROWSPAN);
        if (rowspan == null) {
            rowspan = "1";
        }
        return Integer.parseInt(rowspan);
    }

    default public void resetRowSpan() {
        this.getElement().removeAttribute(ATTRIBUTE_ROWSPAN);
    }
}

