/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentHasEnabled;
import org.vaadin.firitin.fluency.ui.FluentHasTooltip;

public class DynamicFileDownloader
extends Anchor
implements FluentComponent<DynamicFileDownloader>,
FluentHasEnabled<DynamicFileDownloader>,
FluentHasTooltip<DynamicFileDownloader> {
    private Button button;
    private DomListenerRegistration disableOnclick;
    StreamResource resource = new StreamResource("dummy", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(new byte[0]));
    FileNameGenerator fileNameGenerator = r -> "downloadedFile";
    private ContentTypeGenerator contentTypeGenerator = () -> "application/octet-stream";
    private SerializableConsumer<OutputStream> contentWriter;
    protected RequestHandler requestHandler;

    public void setDisableOnClick(boolean disableOnClick) {
        if (this.disableOnclick != null) {
            this.disableOnclick.remove();
        }
        if (disableOnClick) {
            this.getElement().executeJs("const el = this;\nthis.addEventListener(\"click\", e => {\n    setTimeout(() => el.removeAttribute(\"href\"), 0);\n});\n", new Serializable[0]);
            this.disableOnclick = this.getElement().addEventListener("click", (DomEventListener & Serializable)e -> this.setEnabled(false));
        }
    }

    public DynamicFileDownloader(ContentWriter writer) {
        this.add(new Component[]{new VButton(VaadinIcon.DOWNLOAD.create())});
        this.setWriter(writer);
    }

    public DynamicFileDownloader(String linkText, ContentWriter contentWriter) {
        this();
        this.setText(linkText);
        this.setWriter(contentWriter);
    }

    public DynamicFileDownloader(String linkText, String fileName, ContentWriter contentWriter) {
        this();
        this.setText(linkText);
        this.fileNameGenerator = r -> fileName;
        this.setWriter(contentWriter);
    }

    public DynamicFileDownloader(Component downloadComponent, String fileName, ContentWriter contentWriter) {
        this();
        this.add(new Component[]{downloadComponent});
        this.fileNameGenerator = r -> fileName;
        this.setWriter(contentWriter);
    }

    public DynamicFileDownloader(Component downloadComponent, ContentWriter contentWriter) {
        this();
        this.add(new Component[]{downloadComponent});
        this.setWriter(contentWriter);
    }

    private void setWriter(ContentWriter contentWriter) {
        this.contentWriter = (SerializableConsumer & Serializable)out -> {
            try {
                contentWriter.writeContent((OutputStream)out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public DynamicFileDownloader() {
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getElement().setAttribute("fakesr", (AbstractStreamResource)this.resource);
        final String identifier = this.resource.getId();
        this.getElement().executeJs("this.setAttribute(\"href\",\n        this.getAttribute(\"fakesr\").substring(0, this.getAttribute(\"fakesr\").indexOf(\"VAADIN\"))\n                + \"?v-r=dfd&id=%s\");\n".formatted(identifier), new Serializable[0]);
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            this.requestHandler = new RequestHandler(){

                public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
                    String id = request.getParameter("id");
                    if (id != null && id.equals(identifier)) {
                        response.setStatus(200);
                        String filename = DynamicFileDownloader.this.getFileName(session, request);
                        if (filename == null) {
                            filename = DynamicFileDownloader.this.fileNameGenerator.getFileName(request);
                        }
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                        response.setHeader("Content-Type", DynamicFileDownloader.this.contentTypeGenerator.getContentType());
                        try {
                            DynamicFileDownloader.this.contentWriter.accept((Object)response.getOutputStream());
                        }
                        catch (Exception e) {
                            try {
                                response.setStatus(500);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            DynamicFileDownloader.this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> DynamicFileDownloader.this.getEventBus().fireEvent((ComponentEvent)new DownloadFailedEvent(DynamicFileDownloader.this, e))));
                            e.printStackTrace();
                            return true;
                        }
                        DynamicFileDownloader.this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> DynamicFileDownloader.this.getEventBus().fireEvent((ComponentEvent)new DownloadFinishedEvent(DynamicFileDownloader.this, false))));
                        return true;
                    }
                    return false;
                }
            };
            ui.getSession().addRequestHandler(this.requestHandler);
            this.getElement().setAttribute("download", "");
        });
    }

    protected void onDetach(DetachEvent detachEvent) {
        detachEvent.getSession().removeRequestHandler(this.requestHandler);
        super.onDetach(detachEvent);
    }

    public Registration addDownloadFinishedListener(ComponentEventListener<DownloadFinishedEvent> listener) {
        return this.addListener(DownloadFinishedEvent.class, listener);
    }

    public Registration addDownloadFailedListener(ComponentEventListener<DownloadFailedEvent> listener) {
        return this.addListener(DownloadFailedEvent.class, listener);
    }

    public void setFileHandler(SerializableConsumer<OutputStream> contentWriter) {
        this.contentWriter = contentWriter;
    }

    public void setFileName(String fileName) {
        this.fileNameGenerator = r -> fileName;
    }

    @Deprecated
    protected String getFileName(VaadinSession session, VaadinRequest request) {
        return null;
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public DynamicFileDownloader asButton() {
        String text = this.getText();
        this.setText(null);
        this.button = new Button(text);
        this.add(new Component[]{this.button});
        return this;
    }

    public Button getButton() {
        if (this.button == null) {
            throw new IllegalStateException("asButton() is not called!");
        }
        return this.button;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator;
    }

    public DynamicFileDownloader withFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.setFileNameGenerator(fileNameGenerator);
        return this;
    }

    public void setContentTypeGenerator(ContentTypeGenerator contentTypeGenerator) {
        this.contentTypeGenerator = contentTypeGenerator;
    }

    public DynamicFileDownloader withContentTypeGenerator(ContentTypeGenerator contentTypeGenerator) {
        this.setContentTypeGenerator(contentTypeGenerator);
        return this;
    }

    public Tooltip setTooltipText(String text) {
        HasTooltip component = (HasTooltip)this.getChildren().findFirst().get();
        return component.setTooltipText(text);
    }

    public Tooltip getTooltip() {
        HasTooltip component = (HasTooltip)this.getChildren().findFirst().get();
        return component.getTooltip();
    }

    @FunctionalInterface
    public static interface FileNameGenerator {
        public String getFileName(VaadinRequest var1);
    }

    @FunctionalInterface
    public static interface ContentTypeGenerator {
        public String getContentType();
    }

    @FunctionalInterface
    public static interface ContentWriter {
        public void writeContent(OutputStream var1) throws IOException;
    }

    public static class DownloadFinishedEvent
    extends ComponentEvent<DynamicFileDownloader> {
        public DownloadFinishedEvent(DynamicFileDownloader source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }

    public static class DownloadFailedEvent
    extends ComponentEvent<DynamicFileDownloader> {
        private final Exception exception;

        public DownloadFailedEvent(DynamicFileDownloader source, Exception e) {
            super((Component)source, false);
            this.exception = e;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

