/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CustomLayout
extends Composite<Div> {
    Map<String, Component> slotToComponent = new HashMap<String, Component>();

    public CustomLayout() {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> this.attachComponents()));
    }

    private void attachComponents() {
        this.slotToComponent.forEach((slotId, c) -> this.getElement().executeJs("document.getElementById(\"" + slotId + "\").appendChild($0);", new Serializable[]{c.getElement()}));
        this.slotToComponent.clear();
    }

    public CustomLayout(String htmlTemplate) {
        this();
        this.setTemplate(htmlTemplate);
    }

    public void addComponent(String slotId, Component c) {
        this.getElement().appendVirtualChild(new Element[]{c.getElement()});
        this.slotToComponent.put(slotId, c);
    }

    public void remove(Component child) {
        child.getElement().executeJs("this.remove();", new Serializable[0]).then((SerializableConsumer & Serializable)j -> this.getElement().removeVirtualChild(new Element[]{child.getElement()}));
    }

    public void setTemplate(String htmlTemplate) {
        this.getElement().executeJs("this.innerHTML = $0", new Serializable[]{htmlTemplate});
    }
}

