/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.util.Asserts;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.StringTokenizer;

public final class Strings {
    private static final char[] DIGITS = "0123456789ABCDEF".toCharArray();
    private static final ThreadLocal ourUnsignedDecimalBuffer = new ThreadLocal(){

        protected Object initialValue() {
            return new byte[9];
        }

        public Object get() {
            byte[] result = (byte[])super.get();
            Arrays.fill(result, (byte)0);
            return result;
        }
    };

    public static String replace(String text, String oldSubstring, String newSubstring) {
        if (text.length() < oldSubstring.length()) {
            return text;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text.length()) {
            int i1 = text.indexOf(oldSubstring, i);
            if (i1 < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text.substring(i));
                break;
            }
            if (newText == null) {
                newText = new StringBuilder();
            }
            newText.append(text.substring(i, i1));
            newText.append(newSubstring);
            i = i1 + oldSubstring.length();
        }
        return newText != null ? newText.toString() : "";
    }

    public static String decapitalize(String original) {
        Asserts.notNull(original);
        StringBuilder result = new StringBuilder(original.length());
        StringTokenizer tokenizer = new StringTokenizer(original, " ");
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (result.length() == 0) {
                result.append(word);
                continue;
            }
            result.append(' ');
            if (word.equals("Microsoft") || word.equals("Visual") || word.equals("Studio")) {
                result.append(word);
                continue;
            }
            if (word.length() >= 2 && Character.isUpperCase(word.charAt(0)) && !Character.isUpperCase(word.charAt(1))) {
                result.append(word.toLowerCase());
                continue;
            }
            result.append(word);
        }
        return result.toString();
    }

    public static boolean startsWithIgnoreCase(String original, String prefix) {
        int prefixLength = prefix.length();
        if (original.length() < prefixLength) {
            return false;
        }
        int offset = 0;
        int prefixOffset = 0;
        while (--prefixLength >= 0) {
            if (Character.toLowerCase(original.charAt(offset++)) == Character.toLowerCase(prefix.charAt(prefixOffset++))) continue;
            return false;
        }
        return true;
    }

    public static String removeComments(String original) {
        boolean inComment = false;
        StringBuilder builder = new StringBuilder();
        int length = original.length();
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                if (inComment) break;
                builder.append(original.charAt(i));
                break;
            }
            String symbols = original.substring(i, i + 2);
            if ("/*".equals(symbols)) {
                if (!inComment) {
                    inComment = true;
                    ++i;
                    continue;
                }
            } else if ("*/".equals(symbols) && inComment) {
                inComment = false;
                ++i;
                continue;
            }
            if (inComment) continue;
            builder.append(original.charAt(i));
        }
        return builder.toString();
    }

    public static String toHex(byte v) {
        return Strings.toHex(v, 2);
    }

    public static String toHex(char v) {
        return Strings.toHex(v, 4);
    }

    public static String toHex(short v) {
        return Strings.toHex(v, 4);
    }

    public static String toHex(int v) {
        return Strings.toHex(v, 8);
    }

    public static String toHex(long v) {
        return Strings.toHex(v, 16);
    }

    public static String toHexCutLeadingZeros(long v) {
        int i;
        if (v == 0L) {
            return "0";
        }
        String result = Strings.toHex(v);
        for (i = 0; i < result.length() && result.charAt(i) == '0'; ++i) {
        }
        return result.substring(i);
    }

    public static String toHex(long v, int hexDigits) {
        char[] buffer = new char[hexDigits];
        long _v = v;
        for (int i = hexDigits - 1; i >= 0; --i) {
            buffer[i] = DIGITS[(int)_v & 0xF];
            _v >>= 4;
        }
        return new String(buffer);
    }

    public static String toUnsignedDecimal(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        byte[] val = (byte[])ourUnsignedDecimalBuffer.get();
        long x = value;
        for (int i = 0; i < 8; ++i) {
            val[val.length - i - 1] = (byte)x;
            x >>= 8;
        }
        return new BigInteger(val).toString();
    }

    public static byte[] getUTF8Bytes(String s) {
        Asserts.notNull(s);
        try {
            return s.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String notNull(String value) {
        return Strings.notNull(value, "");
    }

    public static String notNull(String value, String defaultValue) {
        Asserts.notNull(defaultValue);
        return value != null ? value : defaultValue;
    }

    public static String limit(String text, int maxLength) {
        Asserts.notNull(text);
        Asserts.assertTrue(maxLength > 0);
        return text.length() < maxLength ? text : text.substring(0, maxLength) + "...";
    }

    public static String normalizeSpaces(String text) {
        Asserts.notNull(text);
        int length = text.length();
        StringBuilder result = new StringBuilder(length);
        boolean wasSpace = false;
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch == '\n' || ch == ' ') {
                if (wasSpace) continue;
                result.append(' ');
                wasSpace = true;
                continue;
            }
            result.append(ch);
            wasSpace = false;
        }
        return result.toString();
    }

    public static String join(String[] lines) {
        Asserts.notNull(lines);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            result.append(line);
            result.append('\n');
        }
        return result.toString();
    }

    public static String getFirstToken(String str, String separatorCharacters) {
        Asserts.notNull(str);
        Asserts.notNull(separatorCharacters);
        if (str.isEmpty() || separatorCharacters.isEmpty()) {
            return str;
        }
        int separatorsLength = separatorCharacters.length();
        int strLength = str.length();
        for (int strIndex = 0; strIndex < strLength; ++strIndex) {
            char ch = str.charAt(strIndex);
            for (int separatorIndex = 0; separatorIndex < separatorsLength; ++separatorIndex) {
                if (ch != separatorCharacters.charAt(separatorIndex)) continue;
                return str.substring(0, strIndex);
            }
        }
        return str;
    }

    public static String getLastToken(String str, String separatorCharacters) {
        Asserts.notNull(str);
        Asserts.notNull(separatorCharacters);
        if (str.isEmpty() || separatorCharacters.isEmpty()) {
            return str;
        }
        int separatorsLength = separatorCharacters.length();
        for (int strIndex = str.length() - 1; strIndex >= 0; --strIndex) {
            char ch = str.charAt(strIndex);
            for (int separatorIndex = 0; separatorIndex < separatorsLength; ++separatorIndex) {
                if (ch != separatorCharacters.charAt(separatorIndex)) continue;
                return str.substring(strIndex + 1);
            }
        }
        return str;
    }

    public static String cutPrefix(String str, String prefix) {
        Asserts.notNull(str);
        Asserts.notNull(prefix);
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String cutPostfix(String str, String postfix) {
        Asserts.notNull(str);
        Asserts.notNull(postfix);
        if (str.endsWith(postfix)) {
            return str.substring(0, str.length() - postfix.length());
        }
        return str;
    }

    public static String fill(char ch, int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, ch);
        return new String(chars);
    }
}

