/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class Constants {
    public static final boolean IS_DOT_NET = "true".equals(System.getProperty("yourkit.dot.net", ""));
    public static final boolean IS_EAP = "true".equals(System.getProperty("yourkit.eap", ""));
    public static final String SNAPSHOT_FILE_EXTENSION = ".snapshot";
    public static final String HPROF_SNAPSHOT_FILE_EXTENSION = ".hprof";
    public static final String SNAPSHOT_INDEX_POSTFIX = ".index";
    public static final File USER_HOME = new File(System.getProperty("user.home"));
    public static final File SNAPSHOT_DIR = new File(USER_HOME, "Snapshots");
    public static final File SYSTEM_HOME = new File(USER_HOME, ".yjp");
    public static final File LICENSE_FILE = new File(SYSTEM_HOME, "yjp.license");
    public static final File CONFIG_DIR = new File(SYSTEM_HOME, "config");
    public static final File FILTERS_FOR_AGENT_FILE = new File(CONFIG_DIR, ".filters");
    public static final File WALLTIMESPEC_FOR_AGENT_FILE = new File(CONFIG_DIR, ".walltime");
    public static final File PREFERRED_SNAPSHOT_DIR_FILE = new File(CONFIG_DIR, ".snapshotdir");
    public static final File IGNORE_LIST_FOR_AGENT_FILE = new File(CONFIG_DIR, ".ignore2");
    public static final File STARTUP_OPTIONS_FOR_AGENT_FILE = new File(CONFIG_DIR, "startup-options.ini");
    public static final String OS = System.getProperty("os.name");
    public static final boolean OS_WINDOWS = OS.toLowerCase().startsWith("windows");
    public static final boolean OS_LINUX = OS.toLowerCase().startsWith("linux");
    public static final boolean OS_SOLARIS = OS.toLowerCase().startsWith("sunos");
    public static final boolean OS_MAC = OS.toLowerCase().startsWith("mac os x");
    public static final boolean OS_FREEBSD = OS.toLowerCase().startsWith("freebsd");
    public static final boolean OS_HPUX = OS.toLowerCase().startsWith("hp-ux");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final boolean JAVA_VERSION_6_OR_NEWER = JAVA_VERSION.compareTo("1.6") >= 0;
    public static final boolean JAVA_VERSION_7 = JAVA_VERSION.startsWith("1.7");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", OS_WINDOWS ? "\r\n" : "\n");
    public static final String PROP_JAVA_VERSION = "java.version";
    public static final String PROP_JAVA_VENDOR = "java.vendor";
    public static final String PROP_AGENT_VERSION = "yjp.agent.version";
    public static final boolean DEMO = "true".equals(System.getProperty("yjp.demo"));
    public static final String APP_SHORT_NAME = "YourKit Java Profiler";
    public static final String APP_FULL_NAME;
    public static final String APP_CODE = "J95";
    public static final String MESSAGE_DLG_TITLE;
    public static final String ERROR_DLG_TITLE;
    public static final String WARNING_DLG_TITLE;
    public static final String INTERNAL_ERROR_DLG_TITLE;
    public static final int[] DEFAULT_PORTS;
    public static int BUILD_NUMBER;
    public static Date BUILD_TIME_STAMP;
    public static final String PROP_JVM_NAME = "java.vm.name";
    public static final String PROP_JVM_VERSION = "java.vm.version";
    public static final String PROP_JVM_VENDOR = "java.vm.vendor";
    public static final String PROP_JVM_INPUT_ARGUMENTS = "yjp.input.arguments";
    public static final String PROP_JVM_CLASS_PATH = "java.class.path";
    public static final String PROP_JVM_LIBRARY_PATH = "java.library.path";
    public static final String PROP_JVM_BOOT_CLASS_PATH = "yjp.boot.class.path";
    public static final String PROP_CLR_VERSION = "yjp.clr.version";
    public static final String PROP_SILVERLIGHT_VERSION = "yjp.silverlight.version";
    public static final String PROP_CLR_COMMAND_LINE = "yjp.clr.command.line";
    public static final String PROP_OS_NAME = "os.name";
    public static final String PROP_OS_ARCH = "os.arch";
    public static final String PROP_OS_VERSION = "os.version";
    public static final String PROP_START_TIME_MS = "yjp.vm.starttime";
    public static final String PROP_COLLECTOR_NAME_PREFIX = "collector.name.";
    public static final String PROP_MEM_POOL_NAME_PREFIX = "mem.pool.name.";
    public static final String PROP_MEM_POOL_TYPE_PREFIX = "mem.pool.type.";
    public static final String PROP_MEM_POOL_COUNT = "mem.pool.count";
    public static final String PROP_MEM_POOL_TELE_USED_PREFIX = "tele.mem.pool.used.";
    public static final String PROP_MEM_POOL_TELE_COMMITED_PREFIX = "tele.mem.pool.commited.";
    public static final String PROP_MEM_POOL_TELEC_INIT_PREFIX = "telec.mem.pool.init.";
    public static final String PROP_MEM_POOL_TELEC_MAX_PREFIX = "telec.mem.pool.max.";
    public static final String PROP_CLOCK_TIME_SEC = "tele.clock_sec";
    public static final int AGENT_PROTOCOL_VERSION = 20101013;
    public static final int UI_PROTOCOL_VERSION = 20071015;
    public static final long SNAPSHOT_WITH_HEAP = 1L;
    public static final long SNAPSHOT_WITH_COUNTS = 8L;
    public static final long SNAPSHOT_HPROF = 16L;
    public static final long SNAPSHOT_CAUSE_SHUTDOWN = 32L;
    public static final long SNAPSHOT_CAUSE_PERIODIC = 64L;
    public static final long SNAPSHOT_CAUSE_ON_MEMORY_USAGE = 128L;
    public static final long SNAPSHOT_CAUSE_OOME = 256L;
    public static final long SNAPSHOT_OIDS_ARE_INDICES = 512L;
    public static final long SNAPSHOT_SUPPRESS_PROGRESS = 2048L;
    public static final int MARKER_TYPE_BIT_AGENT = 1;
    public static final int MARKER_TYPE_BIT_VS_PLUGIN = 2;
    public static final int MARKER_TYPE_BIT_NO_AGENT_CLR_V1 = 4;
    public static final int MARKER_TYPE_BIT_NO_AGENT_CLR_V2 = 8;
    public static final int MARKER_TYPE_BIT_NO_AGENT_CLR_V4_32BIT = 16;
    public static final int MARKER_TYPE_BIT_NO_AGENT_CLR_V4_64BIT = 32;
    public static final int MARKER_TYPE_BIT_IGNORED = 64;
    public static final int COLUMN_TYPE_INT = 0;
    public static final int COLUMN_TYPE_LONG = 1;
    public static final int COLUMN_TYPE_STRING = 2;
    public static final int COLUMN_TYPE_FOREIGN_KEY = 3;
    public static final String USER_TABLE_PREDEFINED_COLUMN_UPTIME_NS = "uptime_ns";
    public static final String USER_TABLE_PREDEFINED_COLUMN_UPTIME_NS_END = "uptime_ns.end";
    public static final String USER_TABLE_PREDEFINED_COLUMN_SPENT_CPU_TIME_NS = "spent_cpu_ns";
    public static final String USER_TABLE_PREDEFINED_COLUMN_THREAD = "thread";
    public static final String USER_TABLE_PREDEFINED_COLUMN_THREAD_END = "thread.end";
    public static final String USER_TABLE_PREDEFINED_COLUMN_STACKTRACE = "frame";
    public static final String USER_TABLE_PREDEFINED_COLUMN_STACKTRACE_END = "frame.end";
    public static final int MAX_TABLE_COUNT = 128;
    public static final int CORE_TABLE_COUNT = 19;
    public static final int FIRST_USER_TABLE = 32;

    static {
        MESSAGE_DLG_TITLE = APP_FULL_NAME = DEMO ? APP_SHORT_NAME : "YourKit Java Profiler 9.5.5";
        ERROR_DLG_TITLE = "Error - " + APP_FULL_NAME;
        WARNING_DLG_TITLE = "Warning - " + APP_FULL_NAME;
        INTERNAL_ERROR_DLG_TITLE = "Internal Error - " + APP_FULL_NAME;
        DEFAULT_PORTS = new int[]{10001, 10002, 10003, 10004, 10005, 10006, 10007, 10008, 10009, 10010};
        try {
            BUILD_NUMBER = Integer.parseInt("9538");
        }
        catch (Exception e) {
            BUILD_NUMBER = 0;
        }
        try {
            BUILD_TIME_STAMP = new SimpleDateFormat("yyyyMMddkkmm", Locale.US).parse("201103291939");
        }
        catch (Exception e) {
            BUILD_TIME_STAMP = new Date(0L);
        }
    }
}

