/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class OperationStats {
    private final long requests;
    private final Map<Integer, Long> responsesByCode;
    private final long inflight;
    private final long exceptions;
    private final long averageLatencyMillis;
    private final long minLatencyMillis;
    private final long maxLatencyMillis;
    private final long bytesSent;
    private final long bytesReceived;

    public OperationStats(long requests, Map<Integer, Long> responsesByCode, long exceptions, long inflight, long averageLatencyMillis, long minLatencyMillis, long maxLatencyMillis, long bytesSent, long bytesReceived) {
        this.requests = requests;
        this.responsesByCode = responsesByCode;
        this.exceptions = exceptions;
        this.inflight = inflight;
        this.averageLatencyMillis = averageLatencyMillis;
        this.minLatencyMillis = minLatencyMillis;
        this.maxLatencyMillis = maxLatencyMillis;
        this.bytesSent = bytesSent;
        this.bytesReceived = bytesReceived;
    }

    public OperationStats since(OperationStats initial) {
        return new OperationStats(this.requests - initial.requests, this.responsesByCode.entrySet().stream().collect(Collectors.toMap(entry -> (Integer)entry.getKey(), entry -> (Long)entry.getValue() - initial.responsesByCode.getOrDefault(entry.getKey(), 0L))), this.exceptions - initial.exceptions, this.inflight - initial.inflight, this.responsesByCode.size() == initial.responsesByCode.size() ? 0L : (this.averageLatencyMillis * (long)this.responsesByCode.size() - initial.averageLatencyMillis * (long)initial.responsesByCode.size()) / (long)(this.responsesByCode.size() - initial.responsesByCode.size()), this.minLatencyMillis, this.maxLatencyMillis, this.bytesSent - initial.bytesSent, this.bytesReceived - initial.bytesReceived);
    }

    public long requests() {
        return this.requests;
    }

    public long responses() {
        return this.requests - this.inflight - this.exceptions;
    }

    public long successes() {
        return this.responsesByCode.getOrDefault(200, 0L);
    }

    public Map<Integer, Long> responsesByCode() {
        return this.responsesByCode;
    }

    public long exceptions() {
        return this.exceptions;
    }

    public long inflight() {
        return this.inflight;
    }

    public long averageLatencyMillis() {
        return this.averageLatencyMillis;
    }

    public long minLatencyMillis() {
        return this.minLatencyMillis;
    }

    public long maxLatencyMillis() {
        return this.maxLatencyMillis;
    }

    public long bytesSent() {
        return this.bytesSent;
    }

    public long bytesReceived() {
        return this.bytesReceived;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationStats that = (OperationStats)o;
        return this.requests == that.requests && this.inflight == that.inflight && this.exceptions == that.exceptions && this.averageLatencyMillis == that.averageLatencyMillis && this.minLatencyMillis == that.minLatencyMillis && this.maxLatencyMillis == that.maxLatencyMillis && this.bytesSent == that.bytesSent && this.bytesReceived == that.bytesReceived && this.responsesByCode.equals(that.responsesByCode);
    }

    public int hashCode() {
        return Objects.hash(this.requests, this.responsesByCode, this.inflight, this.exceptions, this.averageLatencyMillis, this.minLatencyMillis, this.maxLatencyMillis, this.bytesSent, this.bytesReceived);
    }

    public String toString() {
        return "Stats{requests=" + this.requests + ", responsesByCode=" + this.responsesByCode + ", exceptions=" + this.exceptions + ", inflight=" + this.inflight + ", averageLatencyMillis=" + this.averageLatencyMillis + ", minLatencyMillis=" + this.minLatencyMillis + ", maxLatencyMillis=" + this.maxLatencyMillis + ", bytesSent=" + this.bytesSent + ", bytesReceived=" + this.bytesReceived + '}';
    }
}

