/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.feed.client;

import ai.vespa.feed.client.DocumentId;
import ai.vespa.feed.client.Helper;
import ai.vespa.feed.client.HttpResponse;
import ai.vespa.feed.client.MultiFeedException;
import ai.vespa.feed.client.OperationParameters;
import ai.vespa.feed.client.OperationStats;
import ai.vespa.feed.client.Result;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface FeedClient
extends Closeable {
    public CompletableFuture<Result> put(DocumentId var1, String var2, OperationParameters var3);

    public CompletableFuture<Result> update(DocumentId var1, String var2, OperationParameters var3);

    public CompletableFuture<Result> remove(DocumentId var1, OperationParameters var2);

    public static List<Result> await(List<CompletableFuture<Result>> promises) throws MultiFeedException {
        return Helper.await(promises);
    }

    @SafeVarargs
    public static List<Result> await(CompletableFuture<Result> ... promises) throws MultiFeedException {
        return Helper.await(promises);
    }

    public OperationStats stats();

    public CircuitBreaker.State circuitBreakerState();

    public void close(boolean var1);

    @Override
    default public void close() {
        this.close(true);
    }

    public static enum OperationType {
        PUT,
        UPDATE,
        REMOVE;

    }

    public static interface CircuitBreaker {
        public static final CircuitBreaker FUSED = () -> State.CLOSED;

        default public void success() {
        }

        default public void failure(HttpResponse response) {
        }

        default public void failure(Throwable cause) {
        }

        public State state();

        public static enum State {
            CLOSED,
            HALF_OPEN,
            OPEN;

        }
    }

    public static interface RetryStrategy {
        default public boolean retry(OperationType type) {
            return true;
        }

        default public int retries() {
            return 10;
        }
    }
}

