/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.codehaus.jackson.map.deser;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import shaded.parquet.org.codehaus.jackson.map.JsonDeserializer;
import shaded.parquet.org.codehaus.jackson.map.deser.DateDeserializer;
import shaded.parquet.org.codehaus.jackson.map.deser.FromStringDeserializer;
import shaded.parquet.org.codehaus.jackson.map.deser.StdDeserializer;
import shaded.parquet.org.codehaus.jackson.map.deser.TimestampDeserializer;
import shaded.parquet.org.codehaus.jackson.map.deser.UntypedObjectDeserializer;
import shaded.parquet.org.codehaus.jackson.map.type.TypeFactory;
import shaded.parquet.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StdDeserializers {
    final HashMap<JavaType, JsonDeserializer<Object>> _deserializers = new HashMap();

    private StdDeserializers() {
        this.add(new UntypedObjectDeserializer());
        StdDeserializer.StringDeserializer strDeser = new StdDeserializer.StringDeserializer();
        this.add(strDeser, String.class);
        this.add(strDeser, CharSequence.class);
        this.add(new StdDeserializer.ClassDeserializer());
        this.add(new StdDeserializer.BooleanDeserializer(Boolean.class, null));
        this.add(new StdDeserializer.ByteDeserializer(Byte.class, null));
        this.add(new StdDeserializer.ShortDeserializer(Short.class, null));
        this.add(new StdDeserializer.CharacterDeserializer(Character.class, null));
        this.add(new StdDeserializer.IntegerDeserializer(Integer.class, null));
        this.add(new StdDeserializer.LongDeserializer(Long.class, null));
        this.add(new StdDeserializer.FloatDeserializer(Float.class, null));
        this.add(new StdDeserializer.DoubleDeserializer(Double.class, null));
        this.add(new StdDeserializer.BooleanDeserializer(Boolean.TYPE, Boolean.FALSE));
        this.add(new StdDeserializer.ByteDeserializer(Byte.TYPE, (byte)0));
        this.add(new StdDeserializer.ShortDeserializer(Short.TYPE, (short)0));
        this.add(new StdDeserializer.CharacterDeserializer(Character.TYPE, Character.valueOf('\u0000')));
        this.add(new StdDeserializer.IntegerDeserializer(Integer.TYPE, 0));
        this.add(new StdDeserializer.LongDeserializer(Long.TYPE, 0L));
        this.add(new StdDeserializer.FloatDeserializer(Float.TYPE, Float.valueOf(0.0f)));
        this.add(new StdDeserializer.DoubleDeserializer(Double.TYPE, 0.0));
        this.add(new StdDeserializer.NumberDeserializer());
        this.add(new StdDeserializer.BigDecimalDeserializer());
        this.add(new StdDeserializer.BigIntegerDeserializer());
        this.add(new DateDeserializer());
        this.add(new StdDeserializer.SqlDateDeserializer());
        this.add(new TimestampDeserializer());
        this.add(new StdDeserializer.CalendarDeserializer());
        this.add(new StdDeserializer.CalendarDeserializer((Class<? extends Calendar>)GregorianCalendar.class), GregorianCalendar.class);
        for (FromStringDeserializer<?> deser : FromStringDeserializer.all()) {
            this.add(deser);
        }
        this.add(new StdDeserializer.StackTraceElementDeserializer());
        this.add(new StdDeserializer.TokenBufferDeserializer());
        this.add(new StdDeserializer.AtomicBooleanDeserializer());
    }

    public static HashMap<JavaType, JsonDeserializer<Object>> constructAll() {
        return new StdDeserializers()._deserializers;
    }

    private void add(StdDeserializer<?> stdDeser) {
        this.add(stdDeser, stdDeser.getValueClass());
    }

    private void add(StdDeserializer<?> stdDeser, Class<?> valueClass) {
        StdDeserializer<?> deser = stdDeser;
        this._deserializers.put(TypeFactory.defaultInstance().constructType(valueClass), deser);
    }
}

