/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.samskivert.util.StringUtil;
import com.threerings.NaryaLog;
import com.threerings.util.DefaultMap;
import com.threerings.util.RunningStats;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodProfiler {
    protected ThreadLocal<Stack> _stack = new ThreadLocal<Stack>(){

        @Override
        protected Stack initialValue() {
            return new Stack();
        }
    };
    protected final Map<String, RunningStats> _profiles = new MapMaker().makeComputingMap(DefaultMap.newInstanceCreator(RunningStats.class));

    public static void main(String[] args) throws InterruptedException {
        int testNum = 0;
        if (args.length > 0) {
            testNum = Integer.parseInt(args[0]);
        }
        switch (testNum) {
            case 0: {
                MethodProfiler test;
                MethodProfiler methodProfiler = test = new MethodProfiler();
                methodProfiler.getClass();
                TestThread t1 = methodProfiler.new TestThread("testm1", 100, 50L);
                MethodProfiler methodProfiler2 = test;
                methodProfiler2.getClass();
                TestThread t2 = methodProfiler2.new TestThread("testm2", 100, 50L);
                t1.start();
                t2.start();
                t1.join();
                t2.join();
                for (Map.Entry<String, Result> method : test.getResults().entrySet()) {
                    NaryaLog.log.info((Object)method.getKey(), new Object[]{"result", method.getValue()});
                }
                break;
            }
            case 1: {
                MethodProfiler.simpleSampleTest("Single", 100.0);
                break;
            }
            case 2: {
                MethodProfiler.simpleSampleTest("Triple", 100.0, 0.0, 200.0);
                break;
            }
            case 3: {
                MethodProfiler.simpleSampleTest("Multi", 0.0, 25.0, 50.0, 100.0, 125.0, 150.0, 175.0, 200.0, 112.5, 112.5, 112.5);
                break;
            }
            case 4: {
                MethodProfiler test4 = new MethodProfiler();
                test4.enter("L1a");
                test4.enter("L2a");
                test4.swap("L2b");
                test4.enter("L3a");
                test4.exit(null);
                test4.exit(null);
                test4.swap("L1b");
                test4.swap("L1c");
                test4.exit(null);
                for (Map.Entry<String, Result> result : test4.getResults().entrySet()) {
                    NaryaLog.log.info((Object)"Results", new Object[]{"name", result.getKey(), "value", result.getValue()});
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Result> getResults() {
        HashMap results = Maps.newHashMapWithExpectedSize((int)this._profiles.size());
        for (Map.Entry<String, RunningStats> entry : this._profiles.entrySet()) {
            RunningStats runningStats = entry.getValue();
            synchronized (runningStats) {
                results.put(entry.getKey(), MethodProfiler.toResult(entry.getValue()));
            }
        }
        return results;
    }

    public void enter(String methodName) {
        Method method = this._stack.get().push();
        method.name = methodName;
        method.entryTime = System.nanoTime();
    }

    public void exit(String methodName) {
        long nanos = System.nanoTime();
        Method method = this._stack.get().pop();
        if (method == null || methodName != null && !methodName.equals(method.name)) {
            return;
        }
        long elapsed = nanos - method.entryTime;
        this.recordTime(method.fullName(), (double)elapsed / 1000000.0);
        method.name = null;
        if (this._stack.get().size() == 0) {
            this._stack.remove();
        }
    }

    public void swap(String methodName) {
        this.exit(null);
        this.enter(methodName);
    }

    public void exitAndClear(String methodName) {
        Stack stack = this._stack.get();
        while (stack.size() > 1) {
            stack.pop();
        }
        if (stack.size() > 0) {
            this.exit(methodName);
        }
    }

    public void reset() {
        this._profiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordTime(String method, double elapsedMs) {
        RunningStats stats;
        RunningStats runningStats = stats = this._profiles.get(method);
        synchronized (runningStats) {
            stats.addSample(elapsedMs);
        }
    }

    protected static void simpleSampleTest(String name, double ... samples) {
        RunningStats stats = new RunningStats();
        for (double sample : samples) {
            stats.addSample(sample);
        }
        NaryaLog.log.info((Object)name, new Object[]{"results", MethodProfiler.toResult(stats)});
    }

    protected static Result toResult(RunningStats stats) {
        return new Result(stats.getNumSamples(), stats.getMean(), stats.getStandardDeviation());
    }

    protected static class Stack {
        protected int _size;
        protected Method[] _methods = new Method[]{new Method()};

        protected Stack() {
        }

        public Method push() {
            if (this._size == this._methods.length) {
                Method[] realloc = new Method[this._size + 1];
                System.arraycopy(this._methods, 0, realloc, 0, this._size);
                this._methods = realloc;
                this._methods[this._size] = new Method();
            }
            this._methods[this._size].name = null;
            this._methods[this._size].caller = this._size > 0 ? this._methods[this._size - 1] : null;
            return this._methods[this._size++];
        }

        public Method pop() {
            if (this._size == 0) {
                return null;
            }
            return this._methods[--this._size];
        }

        public int size() {
            return this._size;
        }
    }

    protected static class Method {
        public String name;
        public long entryTime;
        public Method caller;

        protected Method() {
        }

        public String fullName() {
            if (this.caller != null) {
                return this.caller.fullName() + "." + this.name;
            }
            return this.name;
        }
    }

    protected class TestThread
    extends Thread {
        protected int _methodCount;
        protected String _method;
        protected long _sleep;

        public TestThread(String method, int methodCount, long sleep) {
            this._method = method;
            this._methodCount = methodCount;
            this._sleep = sleep;
        }

        public void run() {
            try {
                for (int ii = 0; ii < this._methodCount; ++ii) {
                    MethodProfiler.this.enter(this._method);
                    Thread.sleep(this._sleep);
                    MethodProfiler.this.exit(this._method);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class Result {
        public final int numSamples;
        public final double averageTime;
        public final double standardDeviation;

        Result(int numSamples, double average, double stdDev) {
            this.numSamples = numSamples;
            this.averageTime = average;
            this.standardDeviation = stdDev;
        }

        public String toString() {
            return StringUtil.fieldsToString((Object)this);
        }
    }
}

