/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.samskivert.text.MessageUtil;
import com.samskivert.util.StringUtil;
import com.threerings.NaryaLog;
import com.threerings.util.MessageManager;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBundle {
    protected MessageManager _msgmgr;
    protected String _path;
    protected ResourceBundle _bundle;
    protected MessageBundle _parent;

    public static String taint(Object text) {
        return MessageUtil.taint((Object)text);
    }

    public static String compose(String key, Object arg) {
        return MessageUtil.compose((String)key, (Object[])new Object[]{arg});
    }

    public static String compose(String key, Object ... args) {
        return MessageUtil.compose((String)key, (Object[])args);
    }

    public static String compose(String key, String ... args) {
        return MessageUtil.compose((String)key, (String[])args);
    }

    public static String tcompose(String key, Object ... args) {
        return MessageUtil.tcompose((String)key, (Object[])args);
    }

    public static String tcompose(String key, Object arg) {
        return MessageUtil.tcompose((String)key, (Object[])new Object[]{arg});
    }

    public static String tcompose(String key, Object arg1, Object arg2) {
        return MessageUtil.tcompose((String)key, (Object[])new Object[]{arg1, arg2});
    }

    public static String tcompose(String key, String ... args) {
        return MessageUtil.tcompose((String)key, (String[])args);
    }

    public static String qualify(String bundle, String key) {
        return MessageUtil.qualify((String)bundle, (String)key);
    }

    public static String getBundle(String qualifiedKey) {
        return MessageUtil.getBundle((String)qualifiedKey);
    }

    public static String getUnqualifiedKey(String qualifiedKey) {
        return MessageUtil.getUnqualifiedKey((String)qualifiedKey);
    }

    public void init(MessageManager msgmgr, String path, ResourceBundle bundle, MessageBundle parent) {
        this._msgmgr = msgmgr;
        this._path = path;
        this._bundle = bundle;
        this._parent = parent;
    }

    public String get(String key) {
        if (MessageUtil.isTainted((String)key)) {
            return MessageUtil.untaint((String)key);
        }
        String msg = this.getResourceString(key);
        return msg != null ? msg : key;
    }

    public void getAll(String prefix, Collection<String> messages, boolean includeParent) {
        Enumeration<String> iter = this._bundle.getKeys();
        while (iter.hasMoreElements()) {
            String key = iter.nextElement();
            if (!key.startsWith(prefix)) continue;
            messages.add(this.get(key));
        }
        if (includeParent && this._parent != null) {
            this._parent.getAll(prefix, messages, includeParent);
        }
    }

    public void getAllKeys(String prefix, Collection<String> keys, boolean includeParent) {
        Enumeration<String> iter = this._bundle.getKeys();
        while (iter.hasMoreElements()) {
            String key = iter.nextElement();
            if (!key.startsWith(prefix)) continue;
            keys.add(key);
        }
        if (includeParent && this._parent != null) {
            this._parent.getAllKeys(prefix, keys, includeParent);
        }
    }

    public boolean exists(String key) {
        return this.getResourceString(key, false) != null;
    }

    public String getResourceString(String key) {
        return this.getResourceString(key, true);
    }

    public String getResourceString(String key, boolean reportMissing) {
        String value;
        try {
            if (this._bundle != null) {
                return this._bundle.getString(key);
            }
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (this._parent != null && (value = this._parent.getResourceString(key, false)) != null) {
            return value;
        }
        if (reportMissing) {
            NaryaLog.log.warning((Object)"Missing translation message", new Object[]{"bundle", this._path, "key", key, new Exception()});
        }
        return null;
    }

    public String get(String key, Object ... args) {
        if (key.startsWith("%")) {
            MessageBundle qbundle = this._msgmgr.getBundle(MessageBundle.getBundle(key));
            return qbundle.get(MessageBundle.getUnqualifiedKey(key), args);
        }
        String suffix = this.getSuffix(args);
        String msg = this.getResourceString(key + suffix, false);
        if (msg == null) {
            if (suffix != "") {
                msg = this.getResourceString(key, false);
            }
            if (msg == null) {
                NaryaLog.log.warning((Object)"Missing translation message", new Object[]{"bundle", this._path, "key", key, new Exception()});
                return key + StringUtil.toString((Object)args);
            }
        }
        return MessageFormat.format(MessageUtil.escape((String)msg), args);
    }

    public String get(String key, String ... args) {
        return this.get(key, (Object[])args);
    }

    public String getSuffix(Object[] args) {
        if (args.length > 0 && args[0] != null) {
            try {
                int count = args[0] instanceof Integer ? (Integer)args[0] : Integer.parseInt(args[0].toString());
                switch (count) {
                    case 0: {
                        return ".0";
                    }
                    case 1: {
                        return ".1";
                    }
                }
                return ".n";
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return "";
    }

    public String xlate(String compoundKey) {
        if (compoundKey.startsWith("%")) {
            MessageBundle qbundle = this._msgmgr.getBundle(MessageBundle.getBundle(compoundKey));
            return qbundle.xlate(MessageBundle.getUnqualifiedKey(compoundKey));
        }
        int tidx = compoundKey.indexOf(124);
        if (tidx == -1) {
            return this.get(compoundKey);
        }
        String key = compoundKey.substring(0, tidx);
        String argstr = compoundKey.substring(tidx + 1);
        String[] args = StringUtil.split((String)argstr, (String)"|");
        for (int ii = 0; ii < args.length; ++ii) {
            args[ii] = MessageUtil.isTainted((String)args[ii]) ? MessageUtil.unescape((String)MessageUtil.untaint((String)args[ii])) : this.xlate(MessageUtil.unescape((String)args[ii]));
        }
        return this.get(key, (Object[])args);
    }

    public String toString() {
        return "[bundle=" + this._bundle + ", path=" + this._path + "]";
    }
}

