/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.util;

import com.threerings.presents.Log;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SecureUtil {
    public static final int VERSION = 1;
    protected static final SecureRandom _rand = new SecureRandom();
    protected static final char SPLIT = '#';
    protected static final byte[] IV = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};
    protected static final IvParameterSpec IVPS = new IvParameterSpec(IV);

    public static Cipher getAESCipher(int mode, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec aesKey = new SecretKeySpec(key, "AES");
            cipher.init(mode, (Key)aesKey, IVPS);
            return cipher;
        }
        catch (GeneralSecurityException gse) {
            Log.log.warning((Object)"Failed to create cipher", new Object[]{gse});
            return null;
        }
    }

    public static Cipher getRSACipher(PrivateKey key) {
        return SecureUtil.getRSACipher(2, key);
    }

    public static Cipher getRSACipher(PublicKey key) {
        return SecureUtil.getRSACipher(1, key);
    }

    public static Cipher getRSACipher(int mode, Key key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(mode, key);
            return cipher;
        }
        catch (GeneralSecurityException gse) {
            Log.log.warning((Object)"Failed to create cipher", new Object[]{gse});
            return null;
        }
    }

    public static KeyPair genRSAKeyPair(int bits) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(bits);
            return kpg.genKeyPair();
        }
        catch (GeneralSecurityException gse) {
            Log.log.warning((Object)"Failed to create key pair", new Object[]{gse});
            return null;
        }
    }

    public static String RSAKeyToString(PublicKey key) {
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec spec = kf.getKeySpec(key, RSAPublicKeySpec.class);
            StringBuilder buf = new StringBuilder();
            buf.append(spec.getModulus().toString(16)).append('#').append(spec.getPublicExponent().toString(16));
            return buf.toString();
        }
        catch (GeneralSecurityException gse) {
            Log.log.warning((Object)"Failed to convert key to string", new Object[]{gse});
            return null;
        }
    }

    public static String RSAKeyToString(PrivateKey key) {
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            RSAPrivateKeySpec spec = kf.getKeySpec(key, RSAPrivateKeySpec.class);
            StringBuilder buf = new StringBuilder();
            buf.append(spec.getModulus().toString(16)).append('#').append(spec.getPrivateExponent().toString(16));
            return buf.toString();
        }
        catch (GeneralSecurityException gse) {
            Log.log.warning((Object)"Failed to convert key to string", new Object[]{gse});
            return null;
        }
    }

    public static PublicKey stringToRSAPublicKey(String str) {
        try {
            BigInteger mod = new BigInteger(str.substring(0, str.indexOf(35)), 16);
            BigInteger exp = new BigInteger(str.substring(str.indexOf(35) + 1), 16);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod, exp);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(keySpec);
        }
        catch (NumberFormatException nfe) {
            Log.log.warning((Object)"Failed to read key from string.", new Object[]{"str", str, nfe});
        }
        catch (GeneralSecurityException gse) {
            Log.log.warning((Object)"Failed to read key from string.", new Object[]{"str", str, gse});
        }
        return null;
    }

    public static PrivateKey stringToRSAPrivateKey(String str) {
        try {
            BigInteger mod = new BigInteger(str.substring(0, str.indexOf(35)), 16);
            BigInteger exp = new BigInteger(str.substring(str.indexOf(35) + 1), 16);
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(mod, exp);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(keySpec);
        }
        catch (NumberFormatException nfe) {
            Log.log.warning((Object)"Failed to read key from string.", new Object[]{"str", str, nfe});
        }
        catch (GeneralSecurityException gse) {
            Log.log.warning((Object)"Failed to read key from string.", new Object[]{"str", str, gse});
        }
        return null;
    }

    public static boolean ciphersSupported(PrivateKey key) {
        return SecureUtil.getRSACipher(key) != null && SecureUtil.getAESCipher(1, new byte[16]) != null;
    }

    public static boolean ciphersSupported(PublicKey key) {
        return SecureUtil.getRSACipher(key) != null && SecureUtil.getAESCipher(1, new byte[16]) != null;
    }

    public static byte[] createRandomKey(int length) {
        byte[] secret = new byte[length];
        _rand.nextBytes(secret);
        return secret;
    }

    public static byte[] encryptBytes(PublicKey key, byte[] secret, byte[] salt) {
        int ii;
        byte[] encrypt = new byte[secret.length + salt.length];
        for (ii = 0; ii < secret.length; ++ii) {
            encrypt[ii] = secret[ii];
        }
        for (ii = 0; ii < salt.length; ++ii) {
            encrypt[secret.length + ii] = salt[ii];
        }
        try {
            return SecureUtil.getRSACipher(key).doFinal(encrypt);
        }
        catch (GeneralSecurityException gse) {
            Log.log.warning((Object)"Failed to encrypt bytes", new Object[]{gse});
            return encrypt;
        }
    }

    public static byte[] decryptBytes(PrivateKey key, byte[] encrypted, byte[] salt) {
        try {
            byte[] decrypted = SecureUtil.getRSACipher(key).doFinal(encrypted);
            for (int ii = 0; ii < salt.length; ++ii) {
                if (decrypted[decrypted.length - salt.length + ii] == salt[ii]) continue;
                return null;
            }
            byte[] secret = new byte[decrypted.length - salt.length];
            for (int ii = 0; ii < secret.length; ++ii) {
                secret[ii] = decrypted[ii];
            }
            return secret;
        }
        catch (GeneralSecurityException gse) {
            Log.log.warning((Object)"Failed to decrypt bytes", new Object[]{gse});
            return null;
        }
    }

    public static byte[] xorBytes(byte[] data, byte[] key) {
        byte[] xored = new byte[data.length];
        for (int ii = 0; ii < data.length; ++ii) {
            xored[ii] = (byte)(data[ii] ^ key[ii % key.length]);
        }
        return xored;
    }
}

