/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.util;

import com.threerings.presents.client.InvocationService;
import com.threerings.presents.server.InvocationException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureResult<V>
implements Future<V>,
InvocationService.ResultListener {
    protected Sync _sync = new Sync();

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this._sync.innerCancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this._sync.innerIsCancelled();
    }

    @Override
    public boolean isDone() {
        return this._sync.innerIsDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this._sync.innerGet();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this._sync.innerGet(unit.toNanos(timeout));
    }

    @Override
    public void requestProcessed(Object result) {
        Object value = result;
        this._sync.innerSet(value);
    }

    @Override
    public void requestFailed(String cause) {
        this._sync.innerSetException(new InvocationException(cause));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Sync
    extends AbstractQueuedSynchronizer {
        protected V _result;
        protected Throwable _exception;
        protected static final int RUNNING = 1;
        protected static final int RAN = 2;
        protected static final int CANCELLED = 4;

        protected Sync() {
        }

        public boolean innerIsCancelled() {
            return this.getState() == 4;
        }

        public boolean innerIsDone() {
            return this.ranOrCancelled(this.getState());
        }

        public V innerGet() throws InterruptedException, ExecutionException {
            this.acquireSharedInterruptibly(0);
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this._exception != null) {
                throw new ExecutionException(this._exception);
            }
            return this._result;
        }

        public V innerGet(long nanosTimeout) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this._exception != null) {
                throw new ExecutionException(this._exception);
            }
            return this._result;
        }

        public void innerSet(V v) {
            int s;
            do {
                if ((s = this.getState()) == 2) {
                    return;
                }
                if (s != 4) continue;
                this.releaseShared(0);
                return;
            } while (!this.compareAndSetState(s, 2));
            this._result = v;
            this.releaseShared(0);
        }

        public void innerSetException(Throwable t) {
            int s;
            do {
                if ((s = this.getState()) == 2) {
                    return;
                }
                if (s != 4) continue;
                this.releaseShared(0);
                return;
            } while (!this.compareAndSetState(s, 2));
            this._exception = t;
            this._result = null;
            this.releaseShared(0);
        }

        public boolean innerCancel(boolean mayInterruptIfRunning) {
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return false;
            } while (!this.compareAndSetState(s, 4));
            this.releaseShared(0);
            return true;
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.innerIsDone() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            return true;
        }

        protected boolean ranOrCancelled(int state) {
            return (state & 6) != 0;
        }
    }
}

