/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.util;

import com.google.common.collect.Lists;
import com.threerings.io.UnreliableObjectInputStream;
import com.threerings.io.UnreliableObjectOutputStream;
import com.threerings.presents.net.Message;
import com.threerings.presents.net.Transport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DatagramSequencer {
    protected UnreliableObjectInputStream _uin;
    protected UnreliableObjectOutputStream _uout;
    protected int _lastNumber;
    protected int _lastReceived;
    protected int _missedCount;
    protected ArrayList<SendRecord> _sendrecs = Lists.newArrayList();

    public DatagramSequencer(UnreliableObjectInputStream uin, UnreliableObjectOutputStream uout) {
        this._uin = uin;
        this._uout = uout;
    }

    public synchronized void writeDatagram(Message datagram) throws IOException {
        this._uout.writeInt(++this._lastNumber);
        this._uout.writeInt(this._lastReceived);
        Set<Class<?>> mappedClasses = this._uout.getMappedClasses();
        mappedClasses.clear();
        Set<String> mappedInterns = this._uout.getMappedInterns();
        mappedInterns.clear();
        this._uout.writeObject(datagram);
        if (mappedClasses.isEmpty()) {
            mappedClasses = null;
        } else {
            this._uout.setMappedClasses(new HashSet());
        }
        if (mappedInterns.isEmpty()) {
            mappedInterns = null;
        } else {
            this._uout.setMappedInterns(new HashSet<String>());
        }
        this._sendrecs.add(new SendRecord(this._lastNumber, mappedClasses, mappedInterns));
    }

    public synchronized Message readDatagram() throws IOException, ClassNotFoundException {
        int number = this._uin.readInt();
        if (number <= this._lastReceived) {
            return null;
        }
        this._missedCount = number - this._lastReceived - 1;
        this._lastReceived = number;
        int received = this._uin.readInt();
        int remove = 0;
        int nn = this._sendrecs.size();
        for (int ii = 0; ii < nn; ++ii) {
            SendRecord sendrec = this._sendrecs.get(ii);
            if (sendrec.number > received) break;
            ++remove;
            if (sendrec.number != received) continue;
            if (sendrec.mappedClasses != null) {
                this._uout.noteClassMappingsReceived(sendrec.mappedClasses);
            }
            if (sendrec.mappedInterns == null) continue;
            this._uout.noteInternMappingsReceived(sendrec.mappedInterns);
        }
        if (remove > 0) {
            this._sendrecs.subList(0, remove).clear();
        }
        Message datagram = (Message)this._uin.readObject();
        datagram.setTransport(Transport.UNRELIABLE_ORDERED);
        return datagram;
    }

    public int getMissedCount() {
        return this._missedCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SendRecord {
        public int number;
        public Set<Class<?>> mappedClasses;
        public Set<String> mappedInterns;

        public SendRecord(int number, Set<Class<?>> mappedClasses, Set<String> mappedInterns) {
            this.number = number;
            this.mappedClasses = mappedClasses;
            this.mappedInterns = mappedInterns;
        }
    }
}

