/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.util;

import com.samskivert.util.MethodFinder;
import com.threerings.presents.Log;
import java.lang.reflect.Method;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    public static Method getMethod(String name, Object target, Map<String, Method> cache) {
        Class<?> tclass = target.getClass();
        String key = tclass.getName() + ":" + name;
        Method method = cache.get(key);
        if (method == null && (method = ClassUtil.findMethod(tclass, name)) != null) {
            cache.put(key, method);
        }
        return method;
    }

    public static Method getMethod(String name, Object target, Object[] args) {
        Class<?> tclass = target.getClass();
        Method meth = null;
        try {
            MethodFinder finder = new MethodFinder(tclass);
            meth = finder.findMethod(name, args);
        }
        catch (NoSuchMethodException nsme) {
            Log.log.info((Object)"No such method", new Object[]{"name", name, "tclass", tclass.getName(), "args", args, "error", nsme});
        }
        catch (SecurityException se) {
            Log.log.warning((Object)"Unable to look up method?", new Object[]{"tclass", tclass.getName(), "mname", name});
        }
        return meth;
    }

    public static Method findMethod(Class<?> clazz, String name) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }
}

