/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.tools.cpp;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.threerings.presents.dobj.DSet;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPPUtil {
    public static String getCPPType(Type ftype) {
        if (ftype.equals(DSet.Entry.class)) {
            return "Shared<Streamable>";
        }
        if (ftype instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)ftype).getActualTypeArguments();
            Type raw = ((ParameterizedType)ftype).getRawType();
            if (raw.equals(Comparable.class)) {
                return "Shared<Streamable>";
            }
            if (raw.equals(List.class)) {
                return "Shared< std::vector< " + CPPUtil.getCPPType(typeArguments[0]) + " > >";
            }
            if (raw.equals(DSet.class)) {
                ftype = raw;
            } else {
                throw new IllegalArgumentException("Don't know how to handle " + raw);
            }
        }
        if (ftype.equals(Boolean.class) || ftype.equals(Byte.class) || ftype.equals(Short.class) || ftype.equals(Integer.class) || ftype.equals(Long.class) || ftype.equals(Float.class) || ftype.equals(Double.class)) {
            throw new IllegalArgumentException("Presents can't handle boxed types in C++");
        }
        if (ftype.equals(String.class)) {
            return "Shared<utf8>";
        }
        if (ftype.equals(Boolean.TYPE)) {
            return "bool";
        }
        if (ftype.equals(Byte.TYPE)) {
            return "int8";
        }
        if (ftype.equals(Short.TYPE)) {
            return "int16";
        }
        if (ftype.equals(Integer.TYPE)) {
            return "int32";
        }
        if (ftype.equals(Long.TYPE)) {
            return "int64";
        }
        if (ftype.equals(Float.TYPE)) {
            return "float";
        }
        if (ftype.equals(Double.TYPE)) {
            return "double";
        }
        if (ftype.equals(Object.class) || ftype instanceof TypeVariable) {
            return "Shared<Streamable>";
        }
        return "Shared<" + CPPUtil.makeCPPName((Class)ftype) + ">";
    }

    public static String makeCPPName(Class<?> sclass) {
        return CPPUtil.makeCPPName(CPPUtil.makeNamespaces(sclass), sclass.getSimpleName());
    }

    public static String makeCPPName(List<String> namespaces, String className) {
        return Joiner.on((String)"::").join(namespaces) + "::" + className;
    }

    public static String makePath(Class<?> klass, String ext) {
        return CPPUtil.makePath(CPPUtil.makeNamespaces(klass), klass.getSimpleName(), ext);
    }

    public static String makePath(List<String> namespaces, String className, String ext) {
        return Joiner.on((String)File.separator).join(namespaces) + File.separator + className + ext;
    }

    public static String makePath(File root, Class<?> klass, String ext) {
        return new File(root, CPPUtil.makePath(klass, ext)).getAbsolutePath();
    }

    public static String makePath(File root, List<String> namespaces, String className, String ext) {
        return new File(root, CPPUtil.makePath(namespaces, className, ext)).getAbsolutePath();
    }

    public static List<String> makeNamespaces(String pack) {
        Iterable split = Splitter.on((String)".").split((CharSequence)pack);
        ArrayList segs = Lists.newArrayList((Iterable)split);
        if (segs.size() > 1 && ((String)segs.get(0)).equals("com") && ((String)segs.get(1)).equals("threerings")) {
            segs.remove(0);
            segs.remove(0);
        }
        return segs;
    }

    public static List<String> makeNamespaces(Class<?> sclass) {
        if (sclass.getPackage() == null) {
            return Collections.emptyList();
        }
        return CPPUtil.makeNamespaces(sclass.getPackage().getName());
    }

    public static String makeNamespace(Class<?> sclass) {
        return Joiner.on((String)"::").join(CPPUtil.makeNamespaces(sclass));
    }
}

