/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.samskivert.util.ResultListener;
import com.samskivert.util.Throttle;
import com.threerings.nio.conman.ConnectionManager;
import com.threerings.presents.Log;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.ObjectDestroyedEvent;
import com.threerings.presents.dobj.ProxySubscriber;
import com.threerings.presents.net.AuthRequest;
import com.threerings.presents.net.BootstrapData;
import com.threerings.presents.net.BootstrapNotification;
import com.threerings.presents.net.Credentials;
import com.threerings.presents.net.DownstreamMessage;
import com.threerings.presents.net.EventNotification;
import com.threerings.presents.net.FailureResponse;
import com.threerings.presents.net.ForwardEventRequest;
import com.threerings.presents.net.LogoffRequest;
import com.threerings.presents.net.Message;
import com.threerings.presents.net.ObjectResponse;
import com.threerings.presents.net.PingRequest;
import com.threerings.presents.net.PongResponse;
import com.threerings.presents.net.SubscribeRequest;
import com.threerings.presents.net.ThrottleUpdatedMessage;
import com.threerings.presents.net.TransmitDatagramsRequest;
import com.threerings.presents.net.UnsubscribeRequest;
import com.threerings.presents.net.UnsubscribeResponse;
import com.threerings.presents.net.UpdateThrottleMessage;
import com.threerings.presents.server.ClientLocal;
import com.threerings.presents.server.ClientManager;
import com.threerings.presents.server.ClientResolutionListener;
import com.threerings.presents.server.ClientResolver;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.presents.server.PresentsObjectAccess;
import com.threerings.presents.server.net.PresentsConnection;
import com.threerings.util.Name;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class PresentsSession
implements PresentsConnection.MessageHandler,
ClientResolutionListener {
    @Inject
    protected ClientManager _clmgr;
    @Inject
    protected ConnectionManager _conmgr;
    @Inject
    protected PresentsDObjectMgr _omgr;
    @Inject
    protected InvocationManager _invmgr;
    protected AuthRequest _areq;
    protected Object _authdata;
    protected Name _authname;
    protected PresentsConnection _conn;
    protected ClientObject _clobj;
    protected IntMap<ClientProxy> _subscrips = IntMaps.newHashIntMap();
    protected HashSet<Integer> _destroyedSubs = Sets.newHashSet();
    protected ClassLoader _loader;
    protected long _sessionStamp;
    protected long _networkStamp;
    protected int _connectTime;
    protected int _messagesPerSec = 10;
    protected Throttle _throttle = this.createIncomingMessageThrottle();
    protected List<Integer> _pendingThrottles = Lists.newArrayList();
    protected int _messagesIn;
    protected int _messagesOut;
    protected int _messagesDropped;
    protected static Map<Class<?>, MessageDispatcher> _disps = Maps.newHashMap();
    protected static final long DEFAULT_FLUSH_TIME = 420000L;
    protected static final boolean PING_DEBUG = Boolean.getBoolean("ping_debug");

    public Credentials getCredentials() {
        return this._areq.getCredentials();
    }

    public TimeZone getTimeZone() {
        return this._areq.getTimeZone();
    }

    public byte[] getSecret() {
        return this._areq == null ? null : this._areq.getSecret();
    }

    public boolean checkExpired(long now) {
        return this.getConnection() == null && now - this._networkStamp > this.getFlushTime();
    }

    public long getSessionStamp() {
        return this._sessionStamp;
    }

    public long getNetworkStamp() {
        return this._networkStamp;
    }

    public Name getAuthName() {
        return this._authname;
    }

    public InetAddress getInetAddress() {
        PresentsConnection conn = this.getConnection();
        return conn == null ? null : conn.getInetAddress();
    }

    public boolean getTransmitDatagrams() {
        PresentsConnection conn = this.getConnection();
        return conn != null && conn.getTransmitDatagrams();
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
        PresentsConnection conn = this.getConnection();
        if (conn != null) {
            conn.setClassLoader(loader);
        }
    }

    public void setIncomingMessageThrottle(int messagesPerSec) {
        this._messagesPerSec = messagesPerSec;
        if (this.getConnection() != null) {
            this.sendThrottleUpdate();
        }
    }

    public void setUsername(Name username, final UserChangeListener ucl) {
        ClientResolutionListener clr = new ClientResolutionListener(){

            public void clientResolved(final Name username, final ClientObject clobj) {
                if (PresentsSession.this._clobj == null) {
                    Log.log.warning((Object)"Client disappeared before we could complete the switch to a new client object", new Object[]{"ousername", clobj.username, "nusername", username});
                    PresentsSession.this._clmgr.releaseClientObject(username);
                    Exception error = new Exception("Early withdrawal");
                    this.resolutionFailed(username, error);
                    return;
                }
                PresentsSession.this.clientObjectWillChange(PresentsSession.this._clobj, clobj);
                if (ucl != null) {
                    ucl.changeReported(clobj, new ResultListener<Void>(){

                        public void requestCompleted(Void result) {
                            this.finishResolved(username, clobj);
                        }

                        public void requestFailed(Exception cause) {
                            this.finishResolved(username, clobj);
                        }
                    });
                } else {
                    this.finishResolved(username, clobj);
                }
            }

            protected void finishResolved(Name username, ClientObject clobj) {
                Object[] args = new Object[]{clobj.getOid()};
                PresentsSession.this._clobj.postMessage("!clobj_changed!", args);
                PresentsSession.this._clmgr.releaseClientObject(PresentsSession.this._clobj.username);
                PresentsSession.this._clobj = clobj;
                PresentsSession.this.clientObjectDidChange(PresentsSession.this._clobj);
                if (ucl != null) {
                    ucl.changeCompleted(PresentsSession.this._clobj);
                }
            }

            public void resolutionFailed(Name username, Exception reason) {
                Name oldName = PresentsSession.this._clobj == null ? null : PresentsSession.this._clobj.username;
                Log.log.warning((Object)"Unable to resolve new client object", new Object[]{"oldname", oldName, "newname", username, "reason", reason, reason});
                if (ucl != null) {
                    ucl.changeFailed(reason);
                }
            }
        };
        this._clmgr.resolveClientObject(username, clr);
    }

    public boolean updateUsername(Name username) {
        return this._clmgr.renameClientObject(this._clobj.username, username);
    }

    public ClientObject getClientObject() {
        return this._clobj;
    }

    public void endSession() {
        PresentsConnection conn = this.getConnection();
        if (conn != null) {
            this.setConnection(null);
            this._conmgr.closeConnection(conn);
        }
        if (this._clobj != null) {
            try {
                this.sessionDidEnd();
            }
            catch (Exception e) {
                Log.log.warning((Object)("Choked in sessionDidEnd " + this + "."), new Object[]{e});
            }
            this._clmgr.releaseClientObject(this._clobj.username);
            this._clmgr.clientSessionDidEnd(this);
        }
        this._clmgr.clearSession(this);
        this._clobj = null;
    }

    public void shutdown() {
        if (this.getConnection() != null) {
            long now = System.currentTimeMillis();
            this._connectTime = (int)((long)this._connectTime + (now - this._networkStamp) / 1000L);
        }
    }

    public void clientResolved(Name username, ClientObject clobj) {
        this._clobj = clobj;
        if (this.getConnection() == null) {
            Log.log.info((Object)("Session ended before client object could be resolved " + this + "."), new Object[0]);
            this.endSession();
            return;
        }
        clobj.getLocal(ClientLocal.class).secret = this.getSecret();
        this.sessionWillStart();
        this.sendBootstrap();
        this._clmgr.clientSessionDidStart(this);
    }

    public void resolutionFailed(Name username, Exception reason) {
        if (reason instanceof ClientResolver.ClientDisconnectedException) {
            Log.log.info((Object)"Client disconnected during resolution", new Object[]{"who", this.who()});
        } else {
            Log.log.warning((Object)"Unable to resolve client", new Object[]{"who", this.who(), reason});
        }
        this.endSession();
    }

    public void handleMessage(Message message) {
        MessageDispatcher disp;
        ++this._messagesIn;
        if (this._throttle == null) {
            return;
        }
        if (this._throttle.throttleOp(message.received)) {
            this.handleThrottleExceeded();
        }
        if ((disp = _disps.get(message.getClass())) == null) {
            Log.log.warning((Object)"No dispatcher for message", new Object[]{"msg", message});
            return;
        }
        disp.dispatch(this, message);
    }

    protected void clientObjectWillChange(ClientObject oldClobj, ClientObject newClobj) {
    }

    protected void clientObjectDidChange(ClientObject newClobj) {
    }

    protected void startSession(Name authname, AuthRequest req, PresentsConnection conn, Object authdata) {
        this._authname = authname;
        this._areq = req;
        this._authdata = authdata;
        this.setConnection(conn);
        this._clmgr.resolveClientObject(this._authname, this);
        this._sessionStamp = System.currentTimeMillis();
    }

    protected void resumeSession(AuthRequest req, PresentsConnection conn) {
        PresentsConnection oldconn = this.getConnection();
        if (oldconn != null && !oldconn.isClosed()) {
            Log.log.info((Object)"Closing stale connection", new Object[]{"old", oldconn, "new", conn});
            oldconn.close();
        }
        this._areq = req;
        this.setConnection(conn);
        if (this._clobj == null) {
            Log.log.info((Object)("Rapid-fire reconnect caused us to arrive in resumeSession() before the original session resolved its client object " + this + "."), new Object[0]);
            return;
        }
        this._omgr.postRunnable(new Runnable(){

            public void run() {
                PresentsSession.this.finishResumeSession();
            }
        });
    }

    protected void finishResumeSession() {
        if (this._clobj == null) {
            Log.log.info((Object)("Missing client object for resuming session " + this + "."), new Object[0]);
            this.endSession();
            return;
        }
        this._clobj.getLocal(ClientLocal.class).secret = this.getSecret();
        this.sessionWillResume();
        this.sendBootstrap();
        if (this._messagesPerSec != 10) {
            this.sendThrottleUpdate();
        }
        Log.log.info((Object)("Session resumed " + this + "."), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendThrottleUpdate() {
        List<Integer> list = this._pendingThrottles;
        synchronized (list) {
            this._pendingThrottles.add(this._messagesPerSec);
        }
        this.postMessage(new UpdateThrottleMessage(this._messagesPerSec), null);
    }

    protected void safeEndSession() {
        if (!this._omgr.isRunning()) {
            Log.log.info((Object)("Dropping end session request as we're shutting down " + this + "."), new Object[0]);
        } else {
            this._omgr.postRunnable(new Runnable(){

                public void run() {
                    PresentsSession.this.endSession();
                }
            });
        }
    }

    protected Throttle createIncomingMessageThrottle() {
        return new Throttle(110, 10000L);
    }

    protected void handleThrottleExceeded() {
        Log.log.warning((Object)"Client exceeded incoming message throttle, disconnecting", new Object[]{"client", this, "throttle", this._throttle});
        this.safeEndSession();
        this._throttle = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void unmapSubscrip(int oid) {
        ClientProxy rec;
        IntMap<ClientProxy> intMap = this._subscrips;
        synchronized (intMap) {
            rec = (ClientProxy)this._subscrips.remove(oid);
        }
        if (rec != null) {
            rec.unsubscribe();
        } else {
            boolean alreadyDestroyed = this._destroyedSubs.remove(oid);
            if (!alreadyDestroyed) {
                Log.log.warning((Object)"Missing subscription in unmap", new Object[]{"client", this, "oid", oid});
            }
        }
    }

    protected void clearSubscrips(boolean verbose) {
        for (ClientProxy rec : this._subscrips.values()) {
            if (verbose) {
                Log.log.info((Object)"Clearing subscription", new Object[]{"client", this, "obj", rec.object.getOid()});
            }
            rec.unsubscribe();
        }
        this._subscrips.clear();
    }

    protected void sessionWillStart() {
        this._clobj.setAccessController(PresentsObjectAccess.CLIENT);
    }

    protected void sessionWillResume() {
    }

    protected void sessionDidEnd() {
        this.clearSubscrips(false);
    }

    protected void subscribedToObject(DObject object) {
    }

    protected void unsubscribedFromObject(DObject object) {
    }

    protected void sendBootstrap() {
        BootstrapData data = this.createBootstrapData();
        this.populateBootstrapData(data);
        this.postMessage(new BootstrapNotification(data), null);
    }

    protected BootstrapData createBootstrapData() {
        return new BootstrapData();
    }

    protected void populateBootstrapData(BootstrapData data) {
        PresentsConnection conn = this.getConnection();
        if (conn == null) {
            Log.log.warning((Object)"Connection disappeared before we could send bootstrap response.", new Object[]{"client", this});
            return;
        }
        data.connectionId = conn.getConnectionId();
        data.clientOid = this._clobj.getOid();
        if (this._areq.getBootGroups() == null) {
            Log.log.warning((Object)("Client provided no invocation service boot groups? " + this), new Object[0]);
            data.services = Lists.newArrayList();
        } else {
            data.services = this._invmgr.getBootstrapServices(this._areq.getBootGroups());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wasUnmapped() {
        this.setConnection(null);
        this._throttle = this.createIncomingMessageThrottle();
        List<Integer> list = this._pendingThrottles;
        synchronized (list) {
            this._pendingThrottles.clear();
        }
        if (this._omgr.isRunning()) {
            this._omgr.postRunnable(new Runnable(){

                public void run() {
                    PresentsSession.this.sessionConnectionClosed();
                }
            });
        }
    }

    protected void sessionConnectionClosed() {
        this.clearSubscrips(false);
    }

    protected void connectionFailed(IOException fault) {
    }

    protected synchronized void setConnection(PresentsConnection conn) {
        long now = System.currentTimeMillis();
        if (this._conn != null && conn == null) {
            this._connectTime = (int)((long)this._connectTime + (now - this._networkStamp) / 1000L);
            this._messagesDropped = 0;
        }
        this._conn = conn;
        if (this._conn != null) {
            this._conn.setMessageHandler(this);
            if (this._loader != null) {
                this._conn.setClassLoader(this._loader);
            }
        }
        this._networkStamp = now;
    }

    protected synchronized PresentsConnection getConnection() {
        return this._conn;
    }

    protected final void safePostMessage(final DownstreamMessage msg) {
        this._omgr.postRunnable(new Runnable(){

            public void run() {
                PresentsSession.this.postMessage(msg, null);
            }
        });
    }

    protected boolean postMessage(DownstreamMessage msg, PresentsConnection expect) {
        PresentsConnection conn = this.getConnection();
        if (expect != null && conn != expect) {
            return false;
        }
        if (conn != null) {
            conn.postMessage(msg);
            ++this._messagesOut;
            return true;
        }
        if (++this._messagesDropped % 50 == 0) {
            Log.log.warning((Object)"Dropping many messages?", new Object[]{"client", this, "count", this._messagesDropped, "msg", msg});
        }
        if (this._subscrips.size() > 0) {
            this.clearSubscrips(this._messagesDropped > 10);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void throttleUpdated() {
        int messagesPerSec;
        List<Integer> list = this._pendingThrottles;
        synchronized (list) {
            if (this._pendingThrottles.size() == 0) {
                Log.log.warning((Object)"Received throttleUpdated but have no pending throttles", new Object[]{"client", this});
                return;
            }
            messagesPerSec = this._pendingThrottles.remove(0);
        }
        Log.log.info((Object)"Applying updated throttle", new Object[]{"client", this, "msgsPerSec", messagesPerSec});
        this._throttle.reinit(10 * messagesPerSec + 1, 10000L);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        this.toString(buf);
        return buf.append("]").toString();
    }

    protected String who() {
        return this._authname == null ? "null" : this._authname.getClass().getSimpleName() + "(" + this._authname + ")";
    }

    protected long getFlushTime() {
        return 420000L;
    }

    protected void toString(StringBuilder buf) {
        buf.append("who=").append(this.who());
        buf.append(", conn=").append(this.getConnection());
        buf.append(", in=").append(this._messagesIn);
        buf.append(", out=").append(this._messagesOut);
    }

    protected ClientProxy createProxySubscriber() {
        return new ClientProxy();
    }

    static {
        _disps.put(SubscribeRequest.class, new SubscribeDispatcher());
        _disps.put(UnsubscribeRequest.class, new UnsubscribeDispatcher());
        _disps.put(ForwardEventRequest.class, new ForwardEventDispatcher());
        _disps.put(PingRequest.class, new PingDispatcher());
        _disps.put(TransmitDatagramsRequest.class, new TransmitDatagramsDispatcher());
        _disps.put(ThrottleUpdatedMessage.class, new ThrottleUpdatedDispatcher());
        _disps.put(LogoffRequest.class, new LogoffDispatcher());
    }

    protected static class LogoffDispatcher
    implements MessageDispatcher {
        protected LogoffDispatcher() {
        }

        public void dispatch(PresentsSession client, Message msg) {
            Log.log.debug((Object)"Client requested logoff", new Object[]{"client", client});
            client.safeEndSession();
        }
    }

    protected static class ThrottleUpdatedDispatcher
    implements MessageDispatcher {
        protected ThrottleUpdatedDispatcher() {
        }

        public void dispatch(PresentsSession client, Message msg) {
            Log.log.debug((Object)"Client ACKed throttle update", new Object[]{"client", client});
            client.throttleUpdated();
        }
    }

    protected static class TransmitDatagramsDispatcher
    implements MessageDispatcher {
        protected TransmitDatagramsDispatcher() {
        }

        public void dispatch(PresentsSession client, Message msg) {
            Log.log.debug((Object)"Client requested datagram transmission", new Object[]{"client", client});
            client.getConnection().setTransmitDatagrams(true);
        }
    }

    protected static class PingDispatcher
    implements MessageDispatcher {
        protected PingDispatcher() {
        }

        public void dispatch(PresentsSession client, Message msg) {
            PingRequest req = (PingRequest)msg;
            if (PING_DEBUG) {
                Log.log.info((Object)"Got ping, ponging", new Object[]{"client", client.getAuthName()});
            }
            client.safePostMessage(new PongResponse(req.getUnpackStamp(), req.getTransport()));
        }
    }

    protected static class ForwardEventDispatcher
    implements MessageDispatcher {
        protected ForwardEventDispatcher() {
        }

        public void dispatch(PresentsSession client, Message msg) {
            ForwardEventRequest req = (ForwardEventRequest)msg;
            DEvent fevt = req.getEvent();
            ClientObject clobj = client.getClientObject();
            if (clobj == null) {
                Log.log.info((Object)("Dropping event that arrived after client disconnected " + fevt + "."), new Object[0]);
                return;
            }
            fevt.setSourceOid(clobj.getOid());
            client._omgr.postEvent(fevt);
        }
    }

    protected static class UnsubscribeDispatcher
    implements MessageDispatcher {
        protected UnsubscribeDispatcher() {
        }

        public void dispatch(PresentsSession client, Message msg) {
            UnsubscribeRequest req = (UnsubscribeRequest)msg;
            int oid = req.getOid();
            client.unmapSubscrip(oid);
            client.safePostMessage(new UnsubscribeResponse(oid));
        }
    }

    protected static class SubscribeDispatcher
    implements MessageDispatcher {
        protected SubscribeDispatcher() {
        }

        public void dispatch(PresentsSession client, Message msg) {
            SubscribeRequest req = (SubscribeRequest)msg;
            client._omgr.subscribeToObject(req.getOid(), client.createProxySubscriber());
        }
    }

    protected static interface MessageDispatcher {
        public void dispatch(PresentsSession var1, Message var2);
    }

    protected class ClientProxy
    implements ProxySubscriber {
        public DObject object;
        protected long _firstEventId;
        protected PresentsConnection _oconn;

        protected ClientProxy() {
            this._oconn = PresentsSession.this.getConnection();
        }

        public void unsubscribe() {
            this.object.removeSubscriber(this);
            PresentsSession.this.unsubscribedFromObject(this.object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void objectAvailable(DObject dobj) {
            if (PresentsSession.this.postMessage(new ObjectResponse<DObject>(dobj), this._oconn)) {
                ClientProxy orec;
                this._firstEventId = PresentsSession.this._omgr.getNextEventId(false);
                this.object = dobj;
                IntMap<ClientProxy> intMap = PresentsSession.this._subscrips;
                synchronized (intMap) {
                    orec = (ClientProxy)PresentsSession.this._subscrips.put(dobj.getOid(), (Object)this);
                }
                if (orec != null) {
                    Log.log.warning((Object)"Replacing existing subscription.", new Object[]{"oid", dobj.getOid(), "client", PresentsSession.this});
                    orec.unsubscribe();
                }
                PresentsSession.this.subscribedToObject(dobj);
            } else {
                dobj.removeSubscriber(this);
            }
        }

        public void requestFailed(int oid, ObjectAccessException cause) {
            PresentsSession.this.postMessage(new FailureResponse(oid, cause.getMessage()), this._oconn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventReceived(DEvent event) {
            if (event instanceof PresentsDObjectMgr.AccessObjectEvent) {
                Log.log.warning((Object)("Ignoring event that shouldn't be forwarded " + event + "."), new Object[]{new Exception()});
                return;
            }
            if (event.eventId < this._firstEventId) {
                return;
            }
            PresentsSession.this.postMessage(new EventNotification(event), this._oconn);
            if (event instanceof ObjectDestroyedEvent) {
                ClientProxy sub;
                int oid = this.object.getOid();
                IntMap<ClientProxy> intMap = PresentsSession.this._subscrips;
                synchronized (intMap) {
                    sub = (ClientProxy)PresentsSession.this._subscrips.remove(oid);
                    if (sub != null) {
                        PresentsSession.this._destroyedSubs.add(oid);
                    }
                }
                if (sub == this) {
                    this.unsubscribe();
                }
            }
        }

        public ClientObject getClientObject() {
            return PresentsSession.this.getClientObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface UserChangeListener {
        public void changeReported(ClientObject var1, ResultListener<Void> var2);

        public void changeCompleted(ClientObject var1);

        public void changeFailed(Exception var1);
    }
}

