/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.threerings.presents.Log;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.AccessController;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.InvocationRequestEvent;
import com.threerings.presents.dobj.MessageEvent;
import com.threerings.presents.dobj.NamedEvent;
import com.threerings.presents.dobj.ProxySubscriber;
import com.threerings.presents.dobj.Subscriber;

public class PresentsObjectAccess {
    public static AccessController DEFAULT = new AccessController(){

        @Override
        public boolean allowSubscribe(DObject object, Subscriber<?> subscriber) {
            return true;
        }

        @Override
        public boolean allowDispatch(DObject object, DEvent event) {
            if (event.getSourceOid() == -1) {
                return true;
            }
            return event instanceof MessageEvent || event instanceof InvocationRequestEvent;
        }
    };
    public static AccessController CLIENT = new AccessController(){

        @Override
        public boolean allowSubscribe(DObject object, Subscriber<?> sub) {
            ClientObject clobj;
            if (sub instanceof ProxySubscriber && (clobj = ((ProxySubscriber)sub).getClientObject()) != object) {
                Log.log.warning((Object)"Refusing ClientObject subscription request", new Object[]{"obj", ((ClientObject)object).who(), "sub", clobj.who()});
                return false;
            }
            return true;
        }

        @Override
        public boolean allowDispatch(DObject object, DEvent event) {
            if (event.getSourceOid() == -1) {
                return true;
            }
            return event instanceof NamedEvent && ((NamedEvent)event).getName().equals("receivers");
        }
    };
}

