/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.peer.server.persist;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.Query;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.util.StringUtil;
import com.threerings.presents.peer.server.persist.NodeRecord;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class NodeRepository
extends DepotRepository {
    @Inject
    public NodeRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public List<NodeRecord> loadNodes() {
        return this.loadNodes("");
    }

    public List<NodeRecord> loadNodes(String namespace) {
        Query query = this.from(NodeRecord.class).noCache();
        if (!StringUtil.isBlank((String)namespace)) {
            query = query.where(new SQLExpression[]{NodeRecord.NODE_NAME.like((Comparable)((Object)(namespace + "%")))});
        }
        return query.select();
    }

    public void updateNode(NodeRecord record) {
        record.lastUpdated = new Timestamp(System.currentTimeMillis());
        this.store(record);
    }

    public void heartbeatNode(String nodeName) {
        this.updatePartial(NodeRecord.getKey(nodeName), NodeRecord.LAST_UPDATED, new Timestamp(System.currentTimeMillis()), new Object[0]);
    }

    public void deleteNode(String nodeName) {
        this.delete(NodeRecord.getKey(nodeName));
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(NodeRecord.class);
    }
}

