/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.peer.server;

import com.google.inject.Inject;
import com.samskivert.util.Throttle;
import com.threerings.presents.Log;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.net.BootstrapData;
import com.threerings.presents.net.DownstreamMessage;
import com.threerings.presents.net.Message;
import com.threerings.presents.peer.data.NodeObject;
import com.threerings.presents.peer.net.PeerBootstrapData;
import com.threerings.presents.peer.server.PeerManager;
import com.threerings.presents.server.PresentsSession;
import com.threerings.presents.server.net.PresentsConnection;

public class PeerSession
extends PresentsSession {
    protected PeerManager _peermgr;
    protected PeerManager.Stats _stats;
    protected int _cloid;
    protected long _nextThrottleWarning;

    @Inject
    public PeerSession(PeerManager peermgr) {
        this._peermgr = peermgr;
    }

    public void setStats(PeerManager.Stats stats) {
        this._stats = stats;
    }

    public void handleMessage(Message message) {
        super.handleMessage(message);
        this._stats.notePeerMessageReceived(message);
    }

    protected BootstrapData createBootstrapData() {
        return new PeerBootstrapData();
    }

    protected void populateBootstrapData(BootstrapData data) {
        super.populateBootstrapData(data);
        PeerBootstrapData pdata = (PeerBootstrapData)data;
        pdata.nodeOid = this._peermgr.getNodeObject().getOid();
    }

    protected void sessionWillStart() {
        super.sessionWillStart();
        this._cloid = this._clobj.getOid();
        this._peermgr.peerStartedSession(this);
    }

    protected void sessionConnectionClosed() {
        super.sessionConnectionClosed();
        if (this._clobj != null) {
            Log.log.info((Object)("Lost connection to peer, ending session " + this + "."), new Object[0]);
            this.endSession();
        }
    }

    protected void sessionDidEnd() {
        super.sessionDidEnd();
        this._peermgr.peerEndedSession(this);
    }

    protected final boolean postMessage(DownstreamMessage msg, PresentsConnection expect) {
        if (!super.postMessage(msg, expect)) {
            return false;
        }
        this._stats.notePeerMessageSent(msg);
        return true;
    }

    protected void subscribedToObject(DObject object) {
        super.subscribedToObject(object);
        if (object instanceof NodeObject) {
            this._peermgr.clientSubscribedToNode(this._cloid);
        }
    }

    protected void unsubscribedFromObject(DObject object) {
        super.unsubscribedFromObject(object);
        if (object instanceof NodeObject) {
            this._peermgr.clientUnsubscribedFromNode(this._cloid);
        }
    }

    protected Throttle createIncomingMessageThrottle() {
        return new Throttle(100, 1000L);
    }

    protected void handleThrottleExceeded() {
        long now = System.currentTimeMillis();
        if (now >= this._nextThrottleWarning) {
            Log.log.warning((Object)("Peer sent more than 100 messages in one second " + this + "."), new Object[0]);
            this._nextThrottleWarning = now + 5000L;
        }
    }
}

