/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.peer.data;

import com.google.common.base.Objects;
import com.threerings.io.SimpleStreamableObject;
import com.threerings.io.Streamable;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.peer.data.ClientInfo;
import com.threerings.presents.peer.data.PeerMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeObject
extends DObject {
    public static final String NODE_NAME = "nodeName";
    public static final String BOOT_STAMP = "bootStamp";
    public static final String PEER_SERVICE = "peerService";
    public static final String CLIENTS = "clients";
    public static final String LOCKS = "locks";
    public static final String ACQUIRING_LOCK = "acquiringLock";
    public static final String RELEASING_LOCK = "releasingLock";
    public static final String CACHE_DATA = "cacheData";
    public String nodeName;
    public long bootStamp;
    public PeerMarshaller peerService;
    public DSet<ClientInfo> clients = new DSet();
    public DSet<Lock> locks = new DSet();
    public Lock acquiringLock;
    public Lock releasingLock;
    public CacheData cacheData;

    public void setNodeName(String value) {
        String ovalue = this.nodeName;
        this.requestAttributeChange(NODE_NAME, value, ovalue);
        this.nodeName = value;
    }

    public void setBootStamp(long value) {
        long ovalue = this.bootStamp;
        this.requestAttributeChange(BOOT_STAMP, value, ovalue);
        this.bootStamp = value;
    }

    public void setPeerService(PeerMarshaller value) {
        PeerMarshaller ovalue = this.peerService;
        this.requestAttributeChange(PEER_SERVICE, value, ovalue);
        this.peerService = value;
    }

    public void addToClients(ClientInfo elem) {
        this.requestEntryAdd(CLIENTS, this.clients, elem);
    }

    public void removeFromClients(Comparable<?> key) {
        this.requestEntryRemove(CLIENTS, this.clients, key);
    }

    public void updateClients(ClientInfo elem) {
        this.requestEntryUpdate(CLIENTS, this.clients, elem);
    }

    public void setClients(DSet<ClientInfo> value) {
        Object clone;
        this.requestAttributeChange(CLIENTS, value, this.clients);
        this.clients = clone = value == null ? null : value.clone();
    }

    public void addToLocks(Lock elem) {
        this.requestEntryAdd(LOCKS, this.locks, elem);
    }

    public void removeFromLocks(Comparable<?> key) {
        this.requestEntryRemove(LOCKS, this.locks, key);
    }

    public void updateLocks(Lock elem) {
        this.requestEntryUpdate(LOCKS, this.locks, elem);
    }

    public void setLocks(DSet<Lock> value) {
        Object clone;
        this.requestAttributeChange(LOCKS, value, this.locks);
        this.locks = clone = value == null ? null : value.clone();
    }

    public void setAcquiringLock(Lock value) {
        Lock ovalue = this.acquiringLock;
        this.requestAttributeChange(ACQUIRING_LOCK, value, ovalue);
        this.acquiringLock = value;
    }

    public void setReleasingLock(Lock value) {
        Lock ovalue = this.releasingLock;
        this.requestAttributeChange(RELEASING_LOCK, value, ovalue);
        this.releasingLock = value;
    }

    public void setCacheData(CacheData value) {
        CacheData ovalue = this.cacheData;
        this.requestAttributeChange(CACHE_DATA, value, ovalue);
        this.cacheData = value;
    }

    public static class CacheData
    extends SimpleStreamableObject {
        public final String cache;
        public final Streamable data;

        public CacheData(String cache, Streamable data) {
            this.cache = cache;
            this.data = data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Lock
    extends SimpleStreamableObject
    implements Comparable<Lock>,
    DSet.Entry {
        public final String type;
        public final Comparable<?> id;

        public Lock(String type, Comparable<?> id) {
            this.type = type;
            this.id = id;
        }

        @Override
        public int compareTo(Lock olock) {
            int v1 = this.type.compareTo(olock.type);
            if (v1 != 0 || this.id == null) {
                return v1;
            }
            return DSet.compare(this.id, olock.id);
        }

        @Override
        public Comparable<?> getKey() {
            return this;
        }

        public int hashCode() {
            return this.type.hashCode() + (this.id == null ? 0 : this.id.hashCode());
        }

        public boolean equals(Object other) {
            Lock olock = (Lock)other;
            return this.type.equals(olock.type) && Objects.equal(this.id, olock.id);
        }
    }
}

