/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.net;

import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.presents.net.AuthRequest;
import com.threerings.presents.net.Credentials;
import com.threerings.presents.net.PublicKeyCredentials;
import com.threerings.presents.net.SecureResponse;
import com.threerings.presents.util.SecureUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class AESAuthRequest
extends AuthRequest {
    protected transient byte[] _key;
    protected transient byte[] _contents;
    protected transient Credentials _clearCreds;

    public static AuthRequest createAuthRequest(Credentials creds, String version, String[] bootGroups, boolean requireSecureAuth) {
        return AESAuthRequest.createAuthRequest(creds, version, bootGroups, requireSecureAuth, null, null);
    }

    public static AuthRequest createAuthRequest(Credentials creds, String version, String[] bootGroups, boolean requireSecureAuth, PublicKeyCredentials pkcreds, SecureResponse resp) {
        byte[] secret;
        byte[] byArray = secret = resp == null ? null : resp.getCodeBytes(pkcreds);
        if (pkcreds == null || secret == null) {
            return new AuthRequest(requireSecureAuth ? null : creds, version, bootGroups);
        }
        return new AESAuthRequest(secret, creds, version, bootGroups);
    }

    public AESAuthRequest() {
    }

    public AESAuthRequest(byte[] key, Credentials creds, String version, String[] bootGroups) {
        super(null, version, bootGroups);
        this._clearCreds = creds;
        this._key = key;
    }

    public Credentials getCredentials() {
        return this._clearCreds;
    }

    public byte[] getSecret() {
        return this._key;
    }

    public String toString() {
        return "[type=AESAREQ, msgid=" + this.messageId + ", creds=" + this._clearCreds + ", version=" + this._version + "]";
    }

    public void decrypt(byte[] key) throws IOException, ClassNotFoundException {
        if (this._clearCreds != null) {
            return;
        }
        this._key = key;
        try {
            this._contents = SecureUtil.getAESCipher(2, this._key).doFinal(this._contents);
        }
        catch (GeneralSecurityException gse) {
            IOException ioe = new IOException("Failed to decrypt credentials");
            ioe.initCause(gse);
            throw ioe;
        }
        ByteArrayInputStream byteIn = new ByteArrayInputStream(this._contents);
        ObjectInputStream cipherIn = new ObjectInputStream(byteIn);
        this._clearCreds = (Credentials)cipherIn.readObject();
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(byteOut);
        oOut.writeObject(this._clearCreds);
        try {
            byte[] encrypted = SecureUtil.getAESCipher(1, this._key).doFinal(byteOut.toByteArray());
            out.writeInt(encrypted.length);
            out.write(encrypted);
        }
        catch (GeneralSecurityException gse) {
            IOException ioe = new IOException("Failed to encrypt credentials");
            ioe.initCause(gse);
            throw ioe;
        }
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._contents = new byte[in.readInt()];
        in.read(this._contents);
    }
}

